/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Antenna;
import com.agisoft.metashape.Calibration;
import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Vector3d;
import com.agisoft.metashape.Vignetting;

public class Sensor {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public Sensor(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(Sensor sensor) {
        return sensor == null ? 0L : sensor.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Sensor(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static long[] cArrayUnwrap(Sensor[] sensorArray) {
        long[] lArray = new long[sensorArray.length];
        for (int i = 0; i < sensorArray.length; ++i) {
            lArray[i] = Sensor.getCPtr(sensorArray[i]);
        }
        return lArray;
    }

    public static Sensor[] cArrayWrap(long[] lArray, boolean bl) {
        Sensor[] sensorArray = new Sensor[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            sensorArray[i] = new Sensor(lArray[i], bl);
        }
        return sensorArray;
    }

    public Sensor(Sensor sensor) {
        this(MetashapeJNI.new_Sensor(Sensor.getCPtr(sensor), sensor), true);
    }

    public int getKey() {
        return MetashapeJNI.Sensor_getKey(this.swigCPtr, this);
    }

    public Chunk getChunk() {
        long l = MetashapeJNI.Sensor_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Chunk(l, true);
    }

    public void setLabel(String string) {
        MetashapeJNI.Sensor_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Sensor_getLabel(this.swigCPtr, this);
    }

    public void setResolution(long l, long l2) {
        MetashapeJNI.Sensor_setResolution(this.swigCPtr, this, l, l2);
    }

    public long getWidth() {
        return MetashapeJNI.Sensor_getWidth(this.swigCPtr, this);
    }

    public long getHeight() {
        return MetashapeJNI.Sensor_getHeight(this.swigCPtr, this);
    }

    public void setCameraModel(Calibration.Type type) {
        MetashapeJNI.Sensor_setCameraModel(this.swigCPtr, this, type.ordinal());
    }

    public Calibration.Type getCameraModel() {
        return ((Calibration.Type[])Calibration.Type.class.getEnumConstants())[MetashapeJNI.Sensor_getCameraModel(this.swigCPtr, this)];
    }

    public void setCalibration(Calibration calibration) {
        MetashapeJNI.Sensor_setCalibration(this.swigCPtr, this, Calibration.getCPtr(calibration), calibration);
    }

    public Calibration getCalibration() {
        return new Calibration(MetashapeJNI.Sensor_getCalibration(this.swigCPtr, this), true);
    }

    public void setUserCalib(Calibration calibration) {
        MetashapeJNI.Sensor_setUserCalib(this.swigCPtr, this, calibration == null ? 0L : Calibration.getCPtr(calibration), calibration);
    }

    public Calibration getUserCalib() {
        long l = MetashapeJNI.Sensor_getUserCalib(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Calibration(l, true);
    }

    public void setFixed(boolean bl) {
        MetashapeJNI.Sensor_setFixed(this.swigCPtr, this, bl);
    }

    public boolean isFixed() {
        return MetashapeJNI.Sensor_isFixed(this.swigCPtr, this);
    }

    public void setPixelSize(double d, double d2) {
        MetashapeJNI.Sensor_setPixelSize(this.swigCPtr, this, d, d2);
    }

    public double getPixelWidth() {
        return MetashapeJNI.Sensor_getPixelWidth(this.swigCPtr, this);
    }

    public double getPixelHeight() {
        return MetashapeJNI.Sensor_getPixelHeight(this.swigCPtr, this);
    }

    public void setFocalLength(double d) {
        MetashapeJNI.Sensor_setFocalLength(this.swigCPtr, this, d);
    }

    public double getFocalLength() {
        return MetashapeJNI.Sensor_getFocalLength(this.swigCPtr, this);
    }

    public void setReference(Reference reference) {
        MetashapeJNI.Sensor_setReference(this.swigCPtr, this, Reference.getCPtr(reference), reference);
    }

    public Reference getReference() {
        return new Reference(MetashapeJNI.Sensor_getReference(this.swigCPtr, this), true);
    }

    public void setAntenna(Antenna antenna) {
        MetashapeJNI.Sensor_setAntenna(this.swigCPtr, this, Antenna.getCPtr(antenna), antenna);
    }

    public Antenna getAntenna() {
        return new Antenna(MetashapeJNI.Sensor_getAntenna(this.swigCPtr, this), true);
    }

    public void setVignetting(Vignetting[] vignettingArray) {
        MetashapeJNI.Sensor_setVignetting(this.swigCPtr, this, Vignetting.cArrayUnwrap(vignettingArray));
    }

    public Vignetting[] getVignetting() {
        return Vignetting.cArrayWrap(MetashapeJNI.Sensor_getVignetting(this.swigCPtr, this), true);
    }

    public static class Reference {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public Reference(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(Reference reference) {
            return reference == null ? 0L : reference.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_Sensor_Reference(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public Reference(Reference reference) {
            this(MetashapeJNI.new_Sensor_Reference(Reference.getCPtr(reference), reference), true);
        }

        public void setLocationEnabled(boolean bl) {
            MetashapeJNI.Sensor_Reference_setLocationEnabled(this.swigCPtr, this, bl);
        }

        public boolean isLocationEnabled() {
            return MetashapeJNI.Sensor_Reference_isLocationEnabled(this.swigCPtr, this);
        }

        public void setRotationEnabled(boolean bl) {
            MetashapeJNI.Sensor_Reference_setRotationEnabled(this.swigCPtr, this, bl);
        }

        public boolean isRotationEnabled() {
            return MetashapeJNI.Sensor_Reference_isRotationEnabled(this.swigCPtr, this);
        }

        public void setLocation(Vector3d vector3d) {
            MetashapeJNI.Sensor_Reference_setLocation(this.swigCPtr, this, vector3d == null ? 0L : Vector3d.getCPtr(vector3d), vector3d);
        }

        public Vector3d getLocation() {
            long l = MetashapeJNI.Sensor_Reference_getLocation(this.swigCPtr, this);
            if (l == 0L) {
                return null;
            }
            return new Vector3d(l, true);
        }

        public void setRotation(Vector3d vector3d) {
            MetashapeJNI.Sensor_Reference_setRotation(this.swigCPtr, this, vector3d == null ? 0L : Vector3d.getCPtr(vector3d), vector3d);
        }

        public Vector3d getRotation() {
            long l = MetashapeJNI.Sensor_Reference_getRotation(this.swigCPtr, this);
            if (l == 0L) {
                return null;
            }
            return new Vector3d(l, true);
        }

        public void setLocationAccuracy(Vector3d vector3d) {
            MetashapeJNI.Sensor_Reference_setLocationAccuracy(this.swigCPtr, this, vector3d == null ? 0L : Vector3d.getCPtr(vector3d), vector3d);
        }

        public Vector3d getLocationAccuracy() {
            long l = MetashapeJNI.Sensor_Reference_getLocationAccuracy(this.swigCPtr, this);
            if (l == 0L) {
                return null;
            }
            return new Vector3d(l, true);
        }

        public void setRotationAccuracy(Vector3d vector3d) {
            MetashapeJNI.Sensor_Reference_setRotationAccuracy(this.swigCPtr, this, vector3d == null ? 0L : Vector3d.getCPtr(vector3d), vector3d);
        }

        public Vector3d getRotationAccuracy() {
            long l = MetashapeJNI.Sensor_Reference_getRotationAccuracy(this.swigCPtr, this);
            if (l == 0L) {
                return null;
            }
            return new Vector3d(l, true);
        }
    }
}

