/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.ShapeGroup;
import com.agisoft.metashape.Vector3d;

public class Shape {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public Shape(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(Shape shape) {
        return shape == null ? 0L : shape.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Shape(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static long[] cArrayUnwrap(Shape[] shapeArray) {
        long[] lArray = new long[shapeArray.length];
        for (int i = 0; i < shapeArray.length; ++i) {
            lArray[i] = Shape.getCPtr(shapeArray[i]);
        }
        return lArray;
    }

    public static Shape[] cArrayWrap(long[] lArray, boolean bl) {
        Shape[] shapeArray = new Shape[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            shapeArray[i] = new Shape(lArray[i], bl);
        }
        return shapeArray;
    }

    public Shape(Shape shape) {
        this(MetashapeJNI.new_Shape(Shape.getCPtr(shape), shape), true);
    }

    public int getKey() {
        return MetashapeJNI.Shape_getKey(this.swigCPtr, this);
    }

    public void setType(Type type) {
        MetashapeJNI.Shape_setType(this.swigCPtr, this, type.ordinal());
    }

    public Type getType() {
        return ((Type[])Type.class.getEnumConstants())[MetashapeJNI.Shape_getType(this.swigCPtr, this)];
    }

    public void setBoundaryType(BoundaryType boundaryType) {
        MetashapeJNI.Shape_setBoundaryType(this.swigCPtr, this, boundaryType.ordinal());
    }

    public BoundaryType getBoundaryType() {
        return ((BoundaryType[])BoundaryType.class.getEnumConstants())[MetashapeJNI.Shape_getBoundaryType(this.swigCPtr, this)];
    }

    public void setLabel(String string) {
        MetashapeJNI.Shape_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Shape_getLabel(this.swigCPtr, this);
    }

    public void setSelected(boolean bl) {
        MetashapeJNI.Shape_setSelected(this.swigCPtr, this, bl);
    }

    public boolean isSelected() {
        return MetashapeJNI.Shape_isSelected(this.swigCPtr, this);
    }

    public void setGroup(ShapeGroup shapeGroup) {
        MetashapeJNI.Shape_setGroup(this.swigCPtr, this, ShapeGroup.getCPtr(shapeGroup), shapeGroup);
    }

    public ShapeGroup getGroup() {
        return new ShapeGroup(MetashapeJNI.Shape_getGroup(this.swigCPtr, this), true);
    }

    public void resize(long l) {
        MetashapeJNI.Shape_resize(this.swigCPtr, this, l);
    }

    public long getSize() {
        return MetashapeJNI.Shape_getSize(this.swigCPtr, this);
    }

    public void setVertex(long l, Vector3d vector3d) {
        MetashapeJNI.Shape_setVertex(this.swigCPtr, this, l, Vector3d.getCPtr(vector3d), vector3d);
    }

    public Vector3d getVertex(long l) {
        return new Vector3d(MetashapeJNI.Shape_getVertex(this.swigCPtr, this, l), true);
    }

    public void setZEnabled(boolean bl) {
        MetashapeJNI.Shape_setZEnabled(this.swigCPtr, this, bl);
    }

    public boolean isZEnabled() {
        return MetashapeJNI.Shape_isZEnabled(this.swigCPtr, this);
    }

    public static enum BoundaryType {
        NoBoundary,
        InnerBoundary,
        OuterBoundary;

    }

    public static enum Type {
        TypePoint,
        TypePolyline,
        TypePolygon;

    }
}

