from typing import Any

class Antenna:
	bias:  Vector
	"""GNSS bias.

	:type: Vector"""

	bias_acc:  Vector
	"""GNSS bias accuracy.

	:type: Vector"""

	bias_covariance:  Matrix
	"""GNSS bias covariance.

	:type: Matrix"""

	bias_fixed:  bool
	"""Fix GNSS bias flag.

	:type: bool"""

	bias_ref:  Vector
	"""GNSS bias reference.

	:type: Vector"""

	def copy (self, *args, **kwargs) -> Antenna:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Antenna"""
	...
	fixed:  bool
	"""Fix antenna location and rotation flags.

	:type: bool"""

	location:  Vector
	"""Antenna coordinates.

	:type: Vector"""

	location_acc:  Vector
	"""Antenna location accuracy.

	:type: Vector"""

	location_covariance:  Matrix
	"""Antenna location covariance.

	:type: Matrix"""

	location_fixed:  bool
	"""Fix antenna location flag.

	:type: bool"""

	location_ref:  Vector
	"""Antenna location reference.

	:type: Vector"""

	rotation:  Vector
	"""Antenna rotation angles.

	:type: Vector"""

	rotation_acc:  Vector
	"""Antenna rotation accuracy.

	:type: Vector"""

	rotation_covariance:  Matrix
	"""Antenna rotation covariance.

	:type: Matrix"""

	rotation_fixed:  bool
	"""Fix antenna rotation flag.

	:type: bool"""

	rotation_ref:  Vector
	"""Antenna rotation reference.

	:type: Vector"""


class Application:

	class ConsolePane:
		"""ConsolePane class provides access to the console pane"""
		def clear (self, *args, **kwargs):
			"""clear()

			Clear console pane."""
		...
		contents:  str
		"""Console pane contents.

		:type: str"""


	class ModelView:
		"""ModelView class provides access to the model view"""
		ModelViewConfidence: Any
		"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

		ModelViewElevation: Any
		"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""


		class ModelViewMode:
			"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""
			ModelViewConfidence: Any
			"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

			ModelViewElevation: Any
			"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

			ModelViewShaded: Any
			"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

			ModelViewSolid: Any
			"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

			ModelViewTextured: Any
			"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

			ModelViewWireframe: Any
			"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

			values: Any
			"""dict() -> new empty dictionary
			dict(mapping) -> new dictionary initialized from a mapping object's
			    (key, value) pairs
			dict(iterable) -> new dictionary initialized as if via:
			    d = {}
			    for k, v in iterable:
			        d[k] = v
			dict(**kwargs) -> new dictionary initialized with the name=value pairs
			    in the keyword argument list.  For example:  dict(one=1, two=2)"""

		ModelViewShaded: Any
		"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

		ModelViewSolid: Any
		"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

		ModelViewTextured: Any
		"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

		ModelViewWireframe: Any
		"""Model view mode in [ModelViewTextured, ModelViewShaded, ModelViewSolid, ModelViewWireframe, ModelViewElevation, ModelViewConfidence]"""

		PointCloudViewClassification: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		PointCloudViewColor: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		PointCloudViewConfidence: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		PointCloudViewDifference: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		PointCloudViewElevation: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		PointCloudViewIntensity: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""


		class PointCloudViewMode:
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""
			PointCloudViewClassification: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewColor: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewConfidence: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewDifference: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewElevation: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewIntensity: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewReturnNumber: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewScanAngle: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewSolid: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			PointCloudViewSourceId: Any
			"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

			values: Any
			"""dict() -> new empty dictionary
			dict(mapping) -> new dictionary initialized from a mapping object's
			    (key, value) pairs
			dict(iterable) -> new dictionary initialized as if via:
			    d = {}
			    for k, v in iterable:
			        d[k] = v
			dict(**kwargs) -> new dictionary initialized with the name=value pairs
			    in the keyword argument list.  For example:  dict(one=1, two=2)"""

		PointCloudViewReturnNumber: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		PointCloudViewScanAngle: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		PointCloudViewSolid: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		PointCloudViewSourceId: Any
		"""Point cloud view mode in [PointCloudViewSolid, PointCloudViewColor, PointCloudViewClassification, PointCloudViewIntensity, PointCloudViewElevation, PointCloudViewConfidence, PointCloudViewReturnNumber, PointCloudViewScanAngle, PointCloudViewSourceId, PointCloudViewDifference]"""

		TiePointsViewColor: Any
		"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""

		TiePointsViewElevation: Any
		"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""

		TiePointsViewImageCount: Any
		"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""


		class TiePointsViewMode:
			"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""
			TiePointsViewColor: Any
			"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""

			TiePointsViewElevation: Any
			"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""

			TiePointsViewImageCount: Any
			"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""

			TiePointsViewVariance: Any
			"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""

			values: Any
			"""dict() -> new empty dictionary
			dict(mapping) -> new dictionary initialized from a mapping object's
			    (key, value) pairs
			dict(iterable) -> new dictionary initialized as if via:
			    d = {}
			    for k, v in iterable:
			        d[k] = v
			dict(**kwargs) -> new dictionary initialized with the name=value pairs
			    in the keyword argument list.  For example:  dict(one=1, two=2)"""

		TiePointsViewVariance: Any
		"""Tie points view mode in [TiePointsViewColor, TiePointsViewElevation, TiePointsViewImageCount, TiePointsViewVariance]"""

		TiledModelViewElevation: Any
		"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""


		class TiledModelViewMode:
			"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""
			TiledModelViewElevation: Any
			"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""

			TiledModelViewSolid: Any
			"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""

			TiledModelViewTextured: Any
			"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""

			TiledModelViewWireframe: Any
			"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""

			values: Any
			"""dict() -> new empty dictionary
			dict(mapping) -> new dictionary initialized from a mapping object's
			    (key, value) pairs
			dict(iterable) -> new dictionary initialized as if via:
			    d = {}
			    for k, v in iterable:
			        d[k] = v
			dict(**kwargs) -> new dictionary initialized with the name=value pairs
			    in the keyword argument list.  For example:  dict(one=1, two=2)"""

		TiledModelViewSolid: Any
		"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""

		TiledModelViewTextured: Any
		"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""

		TiledModelViewWireframe: Any
		"""Tiled model view mode in [TiledModelViewTextured, TiledModelViewSolid, TiledModelViewWireframe, TiledModelViewElevation]"""

		def captureVideo (self, *args, **kwargs):
			"""captureVideo(path, width, height, [frame_rate], [transparent], [compressed], [hide_items])
			Capture video using camera track. Transparent capture can't be compressed.Method requires gui and inaccessible from python module. If script is passed as a program argument, --gui flag should be specified.

			:arg path: Output path.
			:type path: str:arg width: Video width.
			:type width: int
			:arg height: Video height.
			:type height: int
			:arg frame_rate: Video frame rate.
			:type frame_rate: int
			:arg transparent: Sets transparent background.
			:type transparent: bool
			:arg compressed: Enables video compression.
			:type compressed: bool
			:arg hide_items: Hides all items.
			:type hide_items: bool"""
		...
		def captureView (self, *args, **kwargs) -> Image:
			"""captureView([width], [height], [transparent], [hide_items])

			Capture image from model view.

			:arg width: Image width.
			:type width: int
			:arg height: Image height.
			:type height: int
			:arg transparent: Sets transparent background.
			:type transparent: bool
			:arg hide_items: Hides all items.
			:type hide_items: bool
			:return: Captured image.
			:rtype: Metashape.Image"""
		...
		model_view_mode:  Application.ModelView.ModelViewMode
		"""Model view mode.

		:type: Application.ModelView.ModelViewMode"""

		point_cloud_view_mode:  Application.ModelView.PointCloudViewMode
		"""Point cloud view mode.

		:type: Application.ModelView.PointCloudViewMode"""

		show_basemap:  bool
		"""Show or hide basemap.

		:type: bool"""

		show_cameras:  bool
		"""Show or hide cameras.

		:type: bool"""

		show_elevation:  bool
		"""Display digital elevation model.

		:type: bool"""

		show_laser_scans:  bool
		"""Show or hide laser scans.

		:type: bool"""

		show_markers:  bool
		"""Show or hide markers.

		:type: bool"""

		show_orthomosaic:  bool
		"""Display orthomosaic.

		:type: bool"""

		show_shapes:  bool
		"""Show or hide shapes.

		:type: bool"""

		show_trajectory:  bool
		"""Show or hide trajectory.

		:type: bool"""

		texture_view_mode:  Model.TextureType
		"""Texture view mode.

		:type: Model.TextureType"""

		tie_points_view_mode:  Application.ModelView.TiePointsViewMode
		"""Tie points view mode.

		:type: Application.ModelView.TiePointsViewMode"""

		tiled_model_view_mode:  Application.ModelView.TiledModelViewMode
		"""Tiled model view mode.

		:type: Application.ModelView.TiledModelViewMode"""

		view_mode:  DataSource
		"""View mode.

		:type: DataSource"""

		viewpoint:  Viewpoint
		"""Viewpoint in the model view.

		:type: Viewpoint"""


	class OrthoView:
		"""OrthoView class provides access to the ortho view"""
		def captureView (self, *args, **kwargs) -> Image:
			"""captureView([width], [height], [transparent], [hide_items])

			Capture image from ortho view.

			:arg width: Image width.
			:type width: int
			:arg height: Image height.
			:type height: int
			:arg transparent: Sets transparent background.
			:type transparent: bool
			:arg hide_items: Hides all items.
			:type hide_items: bool
			:return: Captured image.
			:rtype: Metashape.Image"""
		...
		center:  Vector
		"""Ortho view center coordinates.

		:type: Vector"""

		height:  int
		"""Ortho view window height.

		:type: int"""

		projection:  OrthoProjection
		"""Ortho view projection.

		:type: OrthoProjection"""

		scale:  float
		"""Ortho view scale in px/m.

		:type: float"""

		view_mode:  DataSource
		"""View mode.

		:type: DataSource"""

		width:  int
		"""Ortho view window width.

		:type: int"""


	class PhotoView:
		"""PhotoView class provides access to the photo view"""
		camera:  Camera
		"""Get currently opened camera.

		:type: Camera"""

		def captureView (self, *args, **kwargs) -> Image:
			"""captureView([width], [height], [transparent], [hide_items])

			Capture image from photo view.

			:arg width: Image width.
			:type width: int
			:arg height: Image height.
			:type height: int
			:arg transparent: Sets transparent background.
			:type transparent: bool
			:arg hide_items: Hides all items.
			:type hide_items: bool
			:return: Captured image.
			:rtype: Metashape.Image"""
		...
		center:  Vector
		"""Image coordinates at photo view center.

		:type: Vector"""

		def close (self, *args, **kwargs):
			"""close()

			Close active photo view."""
		...
		height:  int
		"""Photo view window height.

		:type: int"""

		def open (self, *args, **kwargs):
			"""open(camera, new_tab=False)

			Open camera in photo view.

			:arg camera: Camera to open.
			:type camera: Metashape.Camera
			:arg new_tab: Open camera in new tab.
			:type new_tab: bool"""
		...
		scale:  float
		"""Photo view scale in view px / image px

		:type: float"""

		show_markers:  bool
		"""Show or hide markers.

		:type: bool"""

		show_shapes:  bool
		"""Show or hide shapes.

		:type: bool"""

		width:  int
		"""Photo view window width.

		:type: int"""


	class PhotosPane:
		"""PhotosPane class provides access to the photos pane"""
		def resetFilter (self, *args, **kwargs):
			"""resetFilter()

			Reset photos pane filter."""
		...
		def setFilter (self, *args, **kwargs):
			"""setFilter(items)

			Set photos pane filter.

			:arg items: filter to apply.
			:type items: list[Metashape.Camera | Metashape.Marker]"""
		...

	class Settings:
		"""PySettings()

		Application settings"""
		language:  str
		"""User interface language.

		:type: str"""

		def load (self, *args, **kwargs):
			"""load()

			Load settings from disk."""
		...
		log_enable:  bool
		"""Enable writing log to file.

		:type: bool"""

		log_path:  str
		"""Log file path.

		:type: str"""

		network_enable:  bool
		"""Network processing enabled flag.

		:type: bool"""

		network_host:  str
		"""Network server host name.

		:type: str"""

		network_path:  str
		"""Network data root path.

		:type: str"""

		network_port:  int
		"""Network server control port.

		:type: int"""

		project_absolute_paths:  bool
		"""Store absolute image paths in project files.

		:type: bool"""

		project_compression:  int
		"""Project compression level.

		:type: int"""

		def save (self, *args, **kwargs):
			"""save()

			Save settings on disk."""
		...
		def setValue (self, *args, **kwargs):
			"""setValue(key, value)

			Set settings value.

			:arg key: Key.
			:type key: str
			:arg value: Value.
			:type value: object"""
		...
		def value (self, *args, **kwargs) -> object:
			"""value(key)

			Return settings value.

			:arg key: Key.
			:type key: str
			:return: Settings value.
			:rtype: object"""
		...
	activated:  bool
	"""Metashape activation status.

	:type: bool"""

	def addMenuItem (self, *args, **kwargs):
		"""addMenuItem(label, func, [shortcut], [icon])

		Create a new menu entry.

		:arg label: Menu item label.
		:type label: str
		:arg func: Function to be called.
		:type func: function
		:arg shortcut: Keyboard shortcut.
		:type shortcut: str
		:arg icon: Icon.
		:type icon: str"""
	...
	def addMenuSeparator (self, *args, **kwargs):
		"""addMenuSeparator(label)

		Add menu separator.

		:arg label: Menu label.
		:type label: str"""
	...
	console_pane:  Application.ConsolePane
	"""Console pane.

	:type: Application.ConsolePane"""

	cpu_enable:  bool
	"""Use CPU when GPU is active.

	:type: bool"""

	document:  Document
	"""Main application document object.

	:type: Document"""

	def enumGPUDevices (self, *args, **kwargs) -> list:
		"""enumGPUDevices()

		Enumerate installed GPU devices.

		:return: A list of devices.
		:rtype: list"""
	...
	def getBool (self, *args, **kwargs) -> bool:
		"""getBool(label='')

		Prompt user for the boolean value.

		:arg label: Optional text label for the dialog.
		:type label: str
		:return: Boolean value selected by the user.
		:rtype: bool"""
	...
	def getCoordinateSystem (self, *args, **kwargs) -> CoordinateSystem:
		"""getCoordinateSystem([label], [value])

		Prompt user for coordinate system.

		:arg label: Optional text label for the dialog.
		:type label: str
		:arg value: Default value.
		:type value: Metashape.CoordinateSystem
		:return: Selected coordinate system. If the dialog was cancelled, None is returned.
		:rtype: Metashape.CoordinateSystem"""
	...
	def getExistingDirectory (self, *args, **kwargs) -> str:
		"""getExistingDirectory([hint], [dir])

		Prompt user for the existing folder.

		:arg hint: Optional text label for the dialog.
		:type hint: str
		:arg dir: Optional default folder.
		:type dir: str
		:return: Path to the folder selected. If the input was cancelled, empty string is returned.
		:rtype: str"""
	...
	def getFloat (self, *args, **kwargs) -> float:
		"""getFloat(label='', value=0)

		Prompt user for the floating point value.

		:arg label: Optional text label for the dialog.
		:type label: str
		:arg value: Default value.
		:type value: float
		:return: Floating point value entered by the user.
		:rtype: float"""
	...
	def getInt (self, *args, **kwargs) -> int:
		"""getInt(label='', value=0)

		Prompt user for the integer value.

		:arg label: Optional text label for the dialog.
		:type label: str
		:arg value: Default value.
		:type value: int
		:return: Integer value entered by the user.
		:rtype: int"""
	...
	def getOpenFileName (self, *args, **kwargs) -> str:
		"""getOpenFileName([hint], [dir], [filter])

		Prompt user for the existing file.

		:arg hint: Optional text label for the dialog.
		:type hint: str
		:arg dir: Optional default folder.
		:type dir: str
		:arg filter: Optional file filter, e.g. "Text file (*.txt)" or "*.txt". Multiple filters are separated with ";;".
		:type filter: str
		:return: Path to the file selected. If the input was cancelled, empty string is returned.
		:rtype: str"""
	...
	def getOpenFileNames (self, *args, **kwargs) -> list:
		"""getOpenFileNames([hint], [dir], [filter])

		Prompt user for one or more existing files.

		:arg hint: Optional text label for the dialog.
		:type hint: str
		:arg dir: Optional default folder.
		:type dir: str
		:arg filter: Optional file filter, e.g. "Text file (*.txt)" or "*.txt". Multiple filters are separated with ";;".
		:type filter: str
		:return: List of file paths selected by the user. If the input was cancelled, empty list is returned.
		:rtype: list"""
	...
	def getSaveFileName (self, *args, **kwargs) -> str:
		"""getSaveFileName([hint], [dir], [filter])

		Prompt user for the file. The file does not have to exist.

		:arg hint: Optional text label for the dialog.
		:type hint: str
		:arg dir: Optional default folder.
		:type dir: str
		:arg filter: Optional file filter, e.g. "Text file (*.txt)" or "*.txt". Multiple filters are separated with ";;".
		:type filter: str
		:return: Path to the file selected. If the input was cancelled, empty string is returned.
		:rtype: str"""
	...
	def getString (self, *args, **kwargs) -> str:
		"""getString(label='', value='')

		Prompt user for the string value.

		:arg label: Optional text label for the dialog.
		:type label: str
		:arg value: Default value.
		:type value: str
		:return: String entered by the user.
		:rtype: str"""
	...
	gpu_mask:  int
	"""GPU device bit mask: 1 - use device, 0 - do not use (i.e. value 5 enables device number 0 and 2).

	:type: int"""

	def messageBox (self, *args, **kwargs):
		"""messageBox(message)

		Display message box to the user.

		:arg message: Text message to be displayed.
		:type message: str"""
	...
	model_view:  Application.ModelView
	"""Model view.

	:type: Application.ModelView"""

	ortho_view:  Application.OrthoView
	"""Ortho view.

	:type: Application.OrthoView"""

	photo_view:  Application.PhotoView
	"""Photo view.

	:type: Application.PhotoView"""

	photos_pane:  Application.PhotosPane
	"""Photos pane.

	:type: Application.PhotosPane"""

	def quit (self, *args, **kwargs):
		"""quit()

		Exit application."""
	...
	def releaseFreeMemory (self, *args, **kwargs):
		"""releaseFreeMemory()

		Call malloc_trim on Linux (does nothing on other OS)."""
	...
	def removeMenuItem (self, *args, **kwargs):
		"""removeMenuItem(label)

		Remove menu entry with given label (if exists). If there are multiple entries with given label - all of them will be removed.

		:arg label: Menu item label.
		:type label: str"""
	...
	settings:  Application.Settings
	"""Application settings.

	:type: Application.Settings"""

	title:  str
	"""Application name.

	:type: str"""

	def update (self, *args, **kwargs):
		"""update()

		Update user interface during long operations."""
	...
	version:  str
	"""Metashape version.

	:type: str"""


class AttachedGeometry:
	def GeometryCollection (self, *args, **kwargs) -> AttachedGeometry:
		"""GeometryCollection(geometries)

		Create a GeometryCollection geometry.

		:arg geometries: Child geometries.
		:type geometries: list[Metashape.AttachedGeometry]
		:return: A GeometryCollection geometry.
		:rtype: Metashape.AttachedGeometry"""
	...
	def LineString (self, *args, **kwargs) -> AttachedGeometry:
		"""LineString(coordinates)

		Create a LineString geometry.

		:arg coordinates: List of vertex coordinates.
		:type coordinates: list[int]
		:return: A LineString geometry.
		:rtype: Metashape.AttachedGeometry"""
	...
	def MultiLineString (self, *args, **kwargs) -> AttachedGeometry:
		"""MultiLineString(geometries)

		Create a MultiLineString geometry.

		:arg geometries: Child line strings.
		:type geometries: list[Metashape.AttachedGeometry]
		:return: A point geometry.
		:rtype: Metashape.AttachedGeometry"""
	...
	def MultiPoint (self, *args, **kwargs) -> AttachedGeometry:
		"""MultiPoint(geometries)

		Create a MultiPoint geometry.

		:arg geometries: Child points.
		:type geometries: list[Metashape.AttachedGeometry]
		:return: A point geometry.
		:rtype: Metashape.AttachedGeometry"""
	...
	def MultiPolygon (self, *args, **kwargs) -> AttachedGeometry:
		"""MultiPolygon(geometries)

		Create a MultiPolygon geometry.

		:arg geometries: Child polygons.
		:type geometries: list[Metashape.AttachedGeometry]
		:return: A point geometry.
		:rtype: Metashape.AttachedGeometry"""
	...
	def Point (self, *args, **kwargs) -> AttachedGeometry:
		"""Point(key)

		Create a Point geometry.

		:arg key: Point marker key.
		:type key: int
		:return: A point geometry.
		:rtype: Metashape.AttachedGeometry"""
	...
	def Polygon (self, *args, **kwargs) -> AttachedGeometry:
		"""Polygon(exterior_ring, [interior_rings])

		Create a Polygon geometry.

		:arg exterior_ring: Point coordinates.
		:type exterior_ring: list[int]
		:arg interior_rings: Point coordinates.
		:type interior_rings: list[int]
		:return: A Polygon geometry.
		:rtype: Metashape.AttachedGeometry"""
	...
	coordinates:  list[int]
	"""List of vertex keys.

	:type: list[int]"""

	geometries:  list[AttachedGeometry]
	"""List of child geometries.

	:type: list[AttachedGeometry]"""

	type:  Geometry.Type
	"""Geometry type.

	:type: Geometry.Type"""


class BBox:
	def copy (self, *args, **kwargs) -> BBox:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.BBox"""
	...
	max:  Vector
	"""Maximum bounding box extent.

	:type: Vector"""

	min:  Vector
	"""Minimum bounding box extent.

	:type: Vector"""

	size:  int
	"""Bounding box dimension.

	:type: int"""


class BlendingMode:
	AverageBlending: Any
	"""Blending mode in [AverageBlending, MosaicBlending, MinBlending, MaxBlending, DisabledBlending]"""

	DisabledBlending: Any
	"""Blending mode in [AverageBlending, MosaicBlending, MinBlending, MaxBlending, DisabledBlending]"""

	MaxBlending: Any
	"""Blending mode in [AverageBlending, MosaicBlending, MinBlending, MaxBlending, DisabledBlending]"""

	MinBlending: Any
	"""Blending mode in [AverageBlending, MosaicBlending, MinBlending, MaxBlending, DisabledBlending]"""

	MosaicBlending: Any
	"""Blending mode in [AverageBlending, MosaicBlending, MinBlending, MaxBlending, DisabledBlending]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Calibration:
	b1:  float
	"""Affinity.

	:type: float"""

	b2:  float
	"""Non-orthogonality.

	:type: float"""

	def copy (self, *args, **kwargs) -> Calibration:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Calibration"""
	...
	covariance_matrix:  Matrix
	"""Covariance matrix.

	:type: Matrix"""

	covariance_params:  list[str]
	"""Covariance matrix parameters.

	:type: list[str]"""

	cx:  float
	"""Principal point X coordinate.

	:type: float"""

	cy:  float
	"""Principal point Y coordinate.

	:type: float"""

	def error (self, *args, **kwargs) -> Vector:
		"""error(point, proj)

		Return projection error.

		:arg point: Coordinates of the point to be projected.
		:type point: Metashape.Vector
		:arg proj: Pixel coordinates of the point.
		:type proj: Metashape.Vector
		:return: 2D projection error.
		:rtype: Metashape.Vector"""
	...
	f:  float
	"""Focal length.

	:type: float"""

	height:  int
	"""Image height.

	:type: int"""

	k1:  float
	"""Radial distortion coefficient K1.

	:type: float"""

	k2:  float
	"""Radial distortion coefficient K2.

	:type: float"""

	k3:  float
	"""Radial distortion coefficient K3.

	:type: float"""

	k4:  float
	"""Radial distortion coefficient K4.

	:type: float"""

	def load (self, *args, **kwargs):
		"""load(path, format=CalibrationFormatXML)

		Loads calibration from file.

		:arg path: path to calibration file
		:type path: str
		:arg format: Calibration format.
		:type format: Metashape.CalibrationFormat"""
	...
	p1:  float
	"""Decentering distortion coefficient P1.

	:type: float"""

	p2:  float
	"""Decentering distortion coefficiant P2.

	:type: float"""

	p3:  float
	"""Decentering distortion coefficient P3.

	:type: float"""

	p4:  float
	"""Decentering distortion coefficiant P4.

	:type: float"""

	def project (self, *args, **kwargs) -> Vector:
		"""project(point)

		Return projected pixel coordinates of the point.

		:arg point: Coordinates of the point to be projected.
		:type point: Metashape.Vector
		:return: 2D projected point coordinates.
		:rtype: Metashape.Vector"""
	...
	rpc:  RPCModel
	"""RPC model.

	:type: RPCModel"""

	def save (self, *args, **kwargs):
		"""save(path, format=CalibrationFormatXML, [label], [pixel_size], [focal_length], cx = 0, cy = 0)

		Saves calibration to file.

		:arg path: path to calibration file
		:type path: str
		:arg format: Calibration format.
		:type format: Metashape.CalibrationFormat
		:arg label: Calibration label used in Australis, CalibCam and CalCam formats.
		:type label: str
		:arg pixel_size: Pixel size in mm used to convert normalized calibration coefficients to Australis and CalibCam coefficients.
		:type pixel_size: Metashape.Vector
		:arg focal_length: Focal length (Grid calibration format only).
		:type focal_length: float
		:arg cx: X principal point coordinate (Grid calibration format only).
		:type cx: float
		:arg cy: Y principal point coordinate (Grid calibration format only).
		:type cy: float"""
	...
	type:  Sensor.Type
	"""Camera model.

	:type: Sensor.Type"""

	def unproject (self, *args, **kwargs) -> Vector:
		"""unproject(point)

		Return direction corresponding to the image point.

		:arg point: Pixel coordinates of the point.
		:type point: Metashape.Vector
		:return: 3D vector in the camera coordinate system.
		:rtype: Metashape.Vector"""
	...
	width:  int
	"""Image width.

	:type: int"""


class CalibrationFormat:
	CalibrationFormatAustralis: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatAustralisV7: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatCalCam: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatCalibCam: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatGrid: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatInpho: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatOpenCV: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatPhotoModeler: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatPhotomod: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatPix4D: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatSTMap: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatUSGS: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	CalibrationFormatXML: Any
	"""Calibration format in [CalibrationFormatXML, CalibrationFormatAustralis, CalibrationFormatAustralisV7, CalibrationFormatPhotoModeler, CalibrationFormatCalibCam, CalibrationFormatCalCam, CalibrationFormatInpho, CalibrationFormatUSGS, CalibrationFormatPix4D, CalibrationFormatOpenCV, CalibrationFormatPhotomod, CalibrationFormatGrid, CalibrationFormatSTMap]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Camera:
	Keyframe: Any
	"""Camera type in [Regular, Keyframe]"""


	class Reference:
		"""Camera reference data."""
		accuracy:  Vector
		"""Camera location accuracy.

		:type: Vector"""

		enabled:  bool
		"""Location enabled flag.

		:type: bool"""

		location:  Vector
		"""Camera coordinates.

		:type: Vector"""

		location_accuracy:  Vector
		"""Camera location accuracy.

		:type: Vector"""

		location_enabled:  bool
		"""Location enabled flag.

		:type: bool"""

		rotation:  Vector
		"""Camera rotation angles.

		:type: Vector"""

		rotation_accuracy:  Vector
		"""Camera rotation accuracy.

		:type: Vector"""

		rotation_enabled:  bool
		"""Rotation enabled flag.

		:type: bool"""

	Regular: Any
	"""Camera type in [Regular, Keyframe]"""


	class Type:
		"""Camera type in [Regular, Keyframe]"""
		Keyframe: Any
		"""Camera type in [Regular, Keyframe]"""

		Regular: Any
		"""Camera type in [Regular, Keyframe]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	calibration:  Calibration
	"""Adjusted camera calibration including photo-invariant parameters.

	:type: Calibration"""

	center:  Vector
	"""Camera station coordinates for the photo in the chunk coordinate system.

	:type: Vector"""

	chunk:  Chunk
	"""Chunk the camera belongs to.

	:type: Chunk"""

	component:  Component
	"""Camera component.

	:type: Component"""

	enabled:  bool
	"""Enables/disables the photo.

	:type: bool"""

	def error (self, *args, **kwargs) -> Vector:
		"""error(point, proj)

		Returns projection error.

		:arg point: Coordinates of the point to be projected.
		:type point: Metashape.Vector
		:arg proj: Pixel coordinates of the point.
		:type proj: Metashape.Vector
		:return: 2D projection error.
		:rtype: Metashape.Vector"""
	...
	frames:  list[Camera]
	"""Camera frames.

	:type: list[Camera]"""

	group:  CameraGroup
	"""Camera group.

	:type: CameraGroup"""

	def image (self, *args, **kwargs) -> Image:
		"""image()

		Returns image data.

		:return: Image data.
		:rtype: Metashape.Image"""
	...
	key:  int
	"""Camera identifier.

	:type: int"""

	label:  str
	"""Camera label.

	:type: str"""

	layer_index:  int
	"""Camera layer index.

	:type: int"""

	location_covariance:  Matrix
	"""Camera location covariance.

	:type: Matrix"""

	mask:  Mask
	"""Camera mask.

	:type: Mask"""

	master:  Camera
	"""Master camera.

	:type: Camera"""

	meta:  MetaData
	"""Camera meta data.

	:type: MetaData"""

	def open (self, *args, **kwargs):
		"""open(path, [layer])

		Loads specified image file.

		:arg path: Path to the image file to be loaded.
		:type path: str
		:arg layer: Optional layer index in case of multipage files.
		:type layer: int"""
	...
	orientation:  int
	"""Image orientation (1 - normal, 6 - 90 degree, 3 - 180 degree, 8 - 270 degree).

	:type: int"""

	photo:  Photo
	"""Camera photo.

	:type: Photo"""

	planes:  list[Camera]
	"""Camera planes.

	:type: list[Camera]"""

	point_cloud:  PointCloud
	"""Laser scan for attached cameras.

	:type: PointCloud"""

	def project (self, *args, **kwargs) -> Vector:
		"""project(point)

		Returns coordinates of the point projection on the photo.

		:arg point: Coordinates of the point to be projected.
		:type point: Metashape.Vector
		:return: 2D point coordinates.
		:rtype: Metashape.Vector"""
	...
	reference:  Camera.Reference
	"""Camera reference data.

	:type: Camera.Reference"""

	rotation_covariance:  Matrix
	"""Camera rotation covariance.

	:type: Matrix"""

	selected:  bool
	"""Selects/deselects the photo.

	:type: bool"""

	sensor:  Sensor
	"""Camera sensor.

	:type: Sensor"""

	shutter:  Shutter
	"""Camera shutter.

	:type: Shutter"""

	thumbnail:  Thumbnail
	"""Camera thumbnail.

	:type: Thumbnail"""

	transform:  Matrix
	"""4x4 matrix describing photo location in the chunk coordinate system.

	:type: Matrix"""

	type:  Camera.Type
	"""Camera type.

	:type: Camera.Type"""

	def unproject (self, *args, **kwargs) -> Vector:
		"""unproject(point)

		Returns coordinates of the point which will have specified projected coordinates.

		:arg point: Projection coordinates.
		:type point: Metashape.Vector
		:return: 3D point coordinates.
		:rtype: Metashape.Vector"""
	...
	vignetting:  list[Vignetting]
	"""Vignetting for each band.

	:type: list[Vignetting]"""


class CameraGroup:
	Folder: Any
	"""Camera group type in [Folder, Station]"""

	Station: Any
	"""Camera group type in [Folder, Station]"""


	class Type:
		"""Camera group type in [Folder, Station]"""
		Folder: Any
		"""Camera group type in [Folder, Station]"""

		Station: Any
		"""Camera group type in [Folder, Station]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	key:  int
	"""Camera group identifier.

	:type: int"""

	label:  str
	"""Camera group label.

	:type: str"""

	selected:  bool
	"""Current selection state.

	:type: bool"""

	type:  CameraGroup.Type
	"""Camera group type.

	:type: CameraGroup.Type"""


class CameraTrack:
	chunk:  Chunk
	"""Chunk the camera track belongs to.

	:type: Chunk"""

	duration:  float
	"""Animation duration.

	:type: float"""

	field_of_view:  float
	"""Vertical field of view in degrees.

	:type: float"""

	def interpolate (self, *args, **kwargs) -> Matrix:
		"""interpolate(time)

		Get animation camera transform matrix.

		:arg time: Animation time point.
		:type time: float
		:return: Interpolated camera transformation matrix in chunk coordinate system.
		:rtype: Metashape.Matrix"""
	...
	key:  int
	"""Camera track identifier.

	:type: int"""

	keyframes:  list[Camera]
	"""Camera track keyframes.

	:type: list[Camera]"""

	label:  str
	"""Animation label.

	:type: str"""

	def load (self, *args, **kwargs):
		"""load(path, [projection])

		Load camera track from file.

		:arg path: Path to camera track file
		:type path: str
		:arg projection: Camera track coordinate system.
		:type projection: Metashape.CoordinateSystem"""
	...
	loop:  bool
	"""Loop track. 

	:type: bool"""

	meta:  MetaData
	"""Camera track meta data.

	:type: MetaData"""

	def save (self, *args, **kwargs):
		"""save(path, [file_format], [drone_name], [payload_name], [payload_position], [max_waypoints], [projection])

		Save camera track to file.

		:arg path: Path to camera track file
		:type path: str
		:arg file_format: File format. "deduce": - Deduce from extension, "path": Path, "earth": Google Earth KML, "pilot": DJI Pilot KML, "wpml": DJI WPML KMZ, "trinity": Asctec Trinity CSV, "autopilot": Asctec Autopilot CSV, "litchi": Litchi CSV
		:type file_format: str
		:arg drone_name: Drone model. "M300 RTK": - DJI Matrice 300 RTK, "M30": - DJI Matrice 30, "M30T": - DJI Matrice 30T, "M3E": - DJI Mavic 3E, "M3T": - DJI Mavic 3T
		:type drone_name: str
		:arg payload_name: Payload model. "P1 24mm": - DJI Zenmuse P1 (24 mm lens), "P1 35mm": - DJI Zenmuse P1 (35 mm lens), "P1 50mm": - DJI Zenmuse P1 (50 mm lens), "H20": - DJI Zenmuse H20, "H20T": - DJI Zenmuse H20T, "H20N": - DJI Zenmuse H20N, "L1": - DJI Zenmuse L1, "M30": - DJI M30, "M30T": - DJI M30T, "M3E": - DJI Mavic 3E Camera, "M3T": - DJI Mavic 3T Camera
		:type payload_name: str
		:arg payload_position: Payload position. For M300 RTK drone: "Front left", "Front right",  "Top". For other drones: "Main gimbal"
		:type payload_position: str
		:arg max_waypoints: Max waypoints per flight
		:type max_waypoints: int
		:arg projection: Camera track coordinate system.
		:type projection: Metashape.CoordinateSystem"""
	...
	selected:  bool
	"""Current selection state.

	:type: bool"""

	smooth:  bool
	"""Smooth path. 

	:type: bool"""


class CamerasFormat:
	CamerasFormatABC: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatAeroSys: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatBINGO: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatBlocksExchange: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatBoujou: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatBundler: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatCHAN: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatColmap: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatFBX: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatInpho: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatMA: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatNVM: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatOPK: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatORIMA: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatPATB: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatRZML: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatSummit: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatVisionMap: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	CamerasFormatXML: Any
	"""Camera orientation format in [CamerasFormatXML, CamerasFormatCHAN, CamerasFormatBoujou, CamerasFormatBundler, CamerasFormatOPK, CamerasFormatPATB, CamerasFormatBINGO, CamerasFormatORIMA, CamerasFormatAeroSys, CamerasFormatInpho, CamerasFormatSummit, CamerasFormatBlocksExchange, CamerasFormatRZML, CamerasFormatVisionMap, CamerasFormatABC, CamerasFormatFBX, CamerasFormatNVM, CamerasFormatMA, CamerasFormatColmap]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Chunk:
	def addCamera (self, *args, **kwargs) -> Camera:
		"""addCamera([sensor])

		Add new camera to the chunk.

		:arg sensor: Sensor to be assigned to this camera.
		:type sensor: Metashape.Sensor
		:return: Created camera.
		:rtype: Metashape.Camera"""
	...
	def addCameraGroup (self, *args, **kwargs) -> CameraGroup:
		"""addCameraGroup()

		Add new camera group to the chunk.

		:return: Created camera group.
		:rtype: Metashape.CameraGroup"""
	...
	def addCameraTrack (self, *args, **kwargs) -> CameraTrack:
		"""addCameraTrack()

		Add new camera track to the chunk.

		:return: Created camera track.
		:rtype: Metashape.CameraTrack"""
	...
	def addDepthMaps (self, *args, **kwargs) -> DepthMaps:
		"""addDepthMaps()

		Add new depth maps set to the chunk.

		:return: Created depth maps set.
		:rtype: Metashape.DepthMaps"""
	...
	def addElevation (self, *args, **kwargs) -> Elevation:
		"""addElevation()

		Add new elevation model to the chunk.

		:return: Created elevation model.
		:rtype: Metashape.Elevation"""
	...
	def addFrame (self, *args, **kwargs) -> Chunk:
		"""addFrame()

		Add new frame to the chunk.

		:return: Created frame.
		:rtype: Metashape.Chunk"""
	...
	def addFrames (self, *args, **kwargs):
		"""addFrames([chunk], [frames], copy_depth_maps=True, copy_point_cloud=True, copy_model=True, copy_tiled_model=True, copy_elevation=True, copy_orthomosaic=True, [progress])

		Add frames from specified chunk.

		:arg chunk: Chunk to copy frames from.
		:type chunk: int
		:arg frames: List of frame keys to copy.
		:type frames: list[int]
		:arg copy_depth_maps: Copy depth maps.
		:type copy_depth_maps: bool
		:arg copy_point_cloud: Copy point cloud.
		:type copy_point_cloud: bool
		:arg copy_model: Copy model.
		:type copy_model: bool
		:arg copy_tiled_model: Copy tiled model.
		:type copy_tiled_model: bool
		:arg copy_elevation: Copy DEM.
		:type copy_elevation: bool
		:arg copy_orthomosaic: Copy orthomosaic.
		:type copy_orthomosaic: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def addMarker (self, *args, **kwargs) -> Marker:
		"""addMarker([point], visibility=False)

		Add new marker to the chunk.

		:arg point: Point to initialize marker projections.
		:type point: Metashape.Vector
		:arg visibility: Enables visibility check during projection assignment.
		:type visibility: bool
		:return: Created marker.
		:rtype: Metashape.Marker"""
	...
	def addMarkerGroup (self, *args, **kwargs) -> MarkerGroup:
		"""addMarkerGroup()

		Add new marker group to the chunk.

		:return: Created marker group.
		:rtype: Metashape.MarkerGroup"""
	...
	def addModel (self, *args, **kwargs) -> Model:
		"""addModel()

		Add new model to the chunk.

		:return: Created model.
		:rtype: Metashape.Model"""
	...
	def addModelGroup (self, *args, **kwargs) -> ModelGroup:
		"""addModelGroup()

		Add new model group to the chunk.

		:return: Created model group.
		:rtype: Metashape.ModelGroup"""
	...
	def addOrthomosaic (self, *args, **kwargs) -> Orthomosaic:
		"""addOrthomosaic()

		Add new orthomosaic to the chunk.

		:return: Created orthomosaic.
		:rtype: Metashape.Orthomosaic"""
	...
	def addPhotos (self, *args, **kwargs):
		"""addPhotos([filenames], [filegroups], layout=UndefinedLayout, [group], strip_extensions=True, load_reference=True, load_xmp_calibration=True, load_xmp_orientation=True, load_xmp_accuracy=False, load_xmp_antenna=True, load_rpc_txt=False, [progress])

		Add a list of photos to the chunk.

		:arg filenames: List of files to add.
		:type filenames: list[str]
		:arg filegroups: List of file groups.
		:type filegroups: list[int]
		:arg layout: Image layout.
		:type layout: Metashape.Metashape.ImageLayout
		:arg group: Camera group key.
		:type group: int
		:arg strip_extensions: Strip file extensions from camera labels.
		:type strip_extensions: bool
		:arg load_reference: Load reference coordinates.
		:type load_reference: bool
		:arg load_xmp_calibration: Load calibration from XMP meta data.
		:type load_xmp_calibration: bool
		:arg load_xmp_orientation: Load orientation from XMP meta data.
		:type load_xmp_orientation: bool
		:arg load_xmp_accuracy: Load accuracy from XMP meta data.
		:type load_xmp_accuracy: bool
		:arg load_xmp_antenna: Load GNSS/INS offset from XMP meta data.
		:type load_xmp_antenna: bool
		:arg load_rpc_txt: Load satellite RPC data from auxiliary TXT files.
		:type load_rpc_txt: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def addPointCloud (self, *args, **kwargs) -> PointCloud:
		"""addPointCloud()

		Add new point cloud to the chunk.

		:return: Created point cloud.
		:rtype: Metashape.PointCloud"""
	...
	def addPointCloudGroup (self, *args, **kwargs) -> PointCloudGroup:
		"""addPointCloudGroup()

		Add new point cloud group to the chunk.

		:return: Created point cloud group.
		:rtype: Metashape.PointCloudGroup"""
	...
	def addScalebar (self, *args, **kwargs) -> Scalebar:
		"""addScalebar(point1, point2)

		Add new scale bar to the chunk.

		:arg point1: First endpoint.
		:type point1: Metashape.Marker | Metashape.Camera
		:arg point2: Second endpoint.
		:type point2: Metashape.Marker | Metashape.Camera
		:return: Created scale bar.
		:rtype: Metashape.Scalebar"""
	...
	def addScalebarGroup (self, *args, **kwargs) -> ScalebarGroup:
		"""addScalebarGroup()

		Add new scale bar group to the chunk.

		:return: Created scale bar group.
		:rtype: Metashape.ScalebarGroup"""
	...
	def addSensor (self, *args, **kwargs) -> Sensor:
		"""addSensor([source])

		Add new sensor to the chunk.

		:arg source: Sensor to copy parameters from.
		:type source: Metashape.Sensor
		:return: Created sensor.
		:rtype: Metashape.Sensor"""
	...
	def addTiledModel (self, *args, **kwargs) -> TiledModel:
		"""addTiledModel()

		Add new tiled model to the chunk.

		:return: Created tiled model.
		:rtype: Metashape.TiledModel"""
	...
	def addTrajectory (self, *args, **kwargs) -> Trajectory:
		"""addTrajectory()

		Add new trajectory to the chunk.

		:return: Created trajectory.
		:rtype: Metashape.Trajectory"""
	...
	def alignCameras (self, *args, **kwargs):
		"""alignCameras([cameras], [point_clouds], min_image=2, adaptive_fitting=False, reset_alignment=False, subdivide_task=True, align_laser_scans=False, [progress])

		Perform photo alignment for the chunk.

		:arg cameras: List of cameras to align.
		:type cameras: list[int]
		:arg point_clouds: List of point clouds to align.
		:type point_clouds: list[int]
		:arg min_image: Minimum number of point projections.
		:type min_image: int
		:arg adaptive_fitting: Enable adaptive fitting of distortion coefficients.
		:type adaptive_fitting: bool
		:arg reset_alignment: Reset current alignment.
		:type reset_alignment: bool
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg align_laser_scans: Align laser scans using geometric features.
		:type align_laser_scans: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def alignCamerasByReference (self, *args, **kwargs):
		"""alignCamerasByReference([cameras])

		Use photo reference metadata as alignment.

		:arg cameras: Optional list of cameras to process.
		:type cameras: list[Metashape.Camera]"""
	...
	def analyzeImages (self, *args, **kwargs):
		"""analyzeImages([cameras], filter_mask=False, [progress])

		Estimate image quality. Estimated value is stored in camera metadata with Image/Quality key.
		Cameras with quality less than 0.5 are considered blurred and we recommend to disable them.

		:arg cameras: List of cameras to be analyzed.
		:type cameras: list[int]
		:arg filter_mask: Constrain analyzed image region by mask.
		:type filter_mask: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildContours (self, *args, **kwargs):
		"""buildContours(source_data=ElevationData, interval=1, min_value=-1e+10, max_value=1e+10, prevent_intersections=True, [progress])

		Build contours for the chunk.

		:arg source_data: Source data for contour generation.
		:type source_data: Metashape.Metashape.DataSource
		:arg interval: Contour interval.
		:type interval: float
		:arg min_value: Minimum value of contour range.
		:type min_value: float
		:arg max_value: Maximum value of contour range.
		:type max_value: float
		:arg prevent_intersections: Prevent contour intersections.
		:type prevent_intersections: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildDem (self, *args, **kwargs):
		"""buildDem(source_data=PointCloudData, interpolation=EnabledInterpolation, [projection], [region], [classes], flip_x=False, flip_y=False, flip_z=False, resolution=0, subdivide_task=True, workitem_size_tiles=10, max_workgroup_size=100, replace_asset=False, [frames], [progress])

		Build elevation model for the chunk.

		:arg source_data: Selects between point cloud and tie points.
		:type source_data: Metashape.Metashape.DataSource
		:arg interpolation: Interpolation mode.
		:type interpolation: Metashape.Metashape.Interpolation
		:arg projection: Output projection.
		:type projection: Metashape.OrthoProjection
		:arg region: Region to be processed.
		:type region: Metashape.BBox
		:arg classes: List of point classes to be used for surface extraction.
		:type classes: list[int]
		:arg flip_x: Flip X axis direction.
		:type flip_x: bool
		:arg flip_y: Flip Y axis direction.
		:type flip_y: bool
		:arg flip_z: Flip Z axis direction.
		:type flip_z: bool
		:arg resolution: Output resolution in meters.
		:type resolution: float
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg workitem_size_tiles: Number of tiles in a workitem.
		:type workitem_size_tiles: int
		:arg max_workgroup_size: Maximum workgroup size.
		:type max_workgroup_size: int
		:arg replace_asset: Replace default asset with generated DEM.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildDepthMaps (self, *args, **kwargs):
		"""buildDepthMaps(downscale=4, filter_mode=MildFiltering, [cameras], reuse_depth=False, max_neighbors=16, subdivide_task=True, workitem_size_cameras=20, max_workgroup_size=100, [progress])

		Generate depth maps for the chunk.

		:arg downscale: Depth map quality (1 - Ultra high, 2 - High, 4 - Medium, 8 - Low, 16 - Lowest).
		:type downscale: int
		:arg filter_mode: Depth map filtering mode.
		:type filter_mode: Metashape.Metashape.FilterMode
		:arg cameras: List of cameras to process.
		:type cameras: list[int]
		:arg reuse_depth: Enable reuse depth maps option.
		:type reuse_depth: bool
		:arg max_neighbors: Maximum number of neighbor images to use for depth map generation.
		:type max_neighbors: int
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg workitem_size_cameras: Number of cameras in a workitem.
		:type workitem_size_cameras: int
		:arg max_workgroup_size: Maximum workgroup size.
		:type max_workgroup_size: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildModel (self, *args, **kwargs):
		"""buildModel(surface_type=Arbitrary, interpolation=EnabledInterpolation, face_count=HighFaceCount, face_count_custom=200000, source_data=DepthMapsData, [classes], vertex_colors=True, vertex_confidence=True, volumetric_masks=False, keep_depth=True, replace_asset=False, split_in_blocks=False, [blocks_crs], blocks_size=250, [blocks_origin], clip_to_boundary=False, export_blocks=False, build_texture=True, output_folder='', trimming_radius=10, [cameras], [frames], subdivide_task=True, workitem_size_cameras=20, max_workgroup_size=100, [progress])

		Generate model for the chunk frame.

		:arg surface_type: Type of object to be reconstructed.
		:type surface_type: Metashape.Metashape.SurfaceType
		:arg interpolation: Interpolation mode.
		:type interpolation: Metashape.Metashape.Interpolation
		:arg face_count: Target face count.
		:type face_count: Metashape.Metashape.FaceCount
		:arg face_count_custom: Custom face count.
		:type face_count_custom: int
		:arg source_data: Selects between point cloud, tie points, depth maps and laser scans.
		:type source_data: Metashape.Metashape.DataSource
		:arg classes: List of point classes to be used for surface extraction.
		:type classes: list[int]
		:arg vertex_colors: Enable vertex colors calculation.
		:type vertex_colors: bool
		:arg vertex_confidence: Enable vertex confidence calculation.
		:type vertex_confidence: bool
		:arg volumetric_masks: Enable strict volumetric masking.
		:type volumetric_masks: bool
		:arg keep_depth: Enable store depth maps option.
		:type keep_depth: bool
		:arg replace_asset: Replace default asset with generated model.
		:type replace_asset: bool
		:arg split_in_blocks: Split model in blocks.
		:type split_in_blocks: bool
		:arg blocks_crs: Blocks grid coordinate system.
		:type blocks_crs: Metashape.CoordinateSystem
		:arg blocks_size: Blocks size in coordinate system units.
		:type blocks_size: float
		:arg blocks_origin: Blocks grid origin.
		:type blocks_origin: Metashape.Vector
		:arg clip_to_boundary: Clip to boundary shapes.
		:type clip_to_boundary: bool
		:arg export_blocks: Export completed blocks.
		:type export_blocks: bool
		:arg build_texture: Generate preview textures.
		:type build_texture: bool
		:arg output_folder: Path to output folder.
		:type output_folder: str
		:arg trimming_radius: Trimming radius (no trimming if zero).
		:type trimming_radius: int
		:arg cameras: List of cameras to process.
		:type cameras: list[int]
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg workitem_size_cameras: Number of cameras in a workitem.
		:type workitem_size_cameras: int
		:arg max_workgroup_size: Maximum workgroup size.
		:type max_workgroup_size: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildOrthomosaic (self, *args, **kwargs):
		"""buildOrthomosaic(surface_data=ModelData, blending_mode=MosaicBlending, fill_holes=True, ghosting_filter=False, cull_faces=False, refine_seamlines=False, [projection], [region], resolution=0, resolution_x=0, resolution_y=0, flip_x=False, flip_y=False, flip_z=False, transfer_texture=False, use_occlusion_texture=False, use_point_cloud_intensity=False, subdivide_task=True, workitem_size_cameras=20, workitem_size_tiles=10, max_workgroup_size=100, replace_asset=False, [frames], [progress])

		Build orthomosaic for the chunk.

		:arg surface_data: Orthorectification surface.
		:type surface_data: Metashape.Metashape.DataSource
		:arg blending_mode: Orthophoto blending mode.
		:type blending_mode: Metashape.Metashape.BlendingMode
		:arg fill_holes: Enable hole filling.
		:type fill_holes: bool
		:arg ghosting_filter: Enable ghosting filter.
		:type ghosting_filter: bool
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:arg refine_seamlines: Refine seamlines based on image content.
		:type refine_seamlines: bool
		:arg projection: Output projection.
		:type projection: Metashape.OrthoProjection
		:arg region: Region to be processed.
		:type region: Metashape.BBox
		:arg resolution: Pixel size in meters.
		:type resolution: float
		:arg resolution_x: Pixel size in the X dimension in projected units.
		:type resolution_x: float
		:arg resolution_y: Pixel size in the Y dimension in projected units.
		:type resolution_y: float
		:arg flip_x: Flip X axis direction.
		:type flip_x: bool
		:arg flip_y: Flip Y axis direction.
		:type flip_y: bool
		:arg flip_z: Flip Z axis direction.
		:type flip_z: bool
		:arg transfer_texture: Transfer model texture to orthomosaic.
		:type transfer_texture: bool
		:arg use_occlusion_texture: Use model occlusion texture.
		:type use_occlusion_texture: bool
		:arg use_point_cloud_intensity: Use point cloud intensity as color source.
		:type use_point_cloud_intensity: bool
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg workitem_size_cameras: Number of cameras in a workitem.
		:type workitem_size_cameras: int
		:arg workitem_size_tiles: Number of tiles in a workitem.
		:type workitem_size_tiles: int
		:arg max_workgroup_size: Maximum workgroup size.
		:type max_workgroup_size: int
		:arg replace_asset: Replace default asset with generated orthomosaic.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildPanorama (self, *args, **kwargs):
		"""buildPanorama(blending_mode=MosaicBlending, ghosting_filter=False, [rotation], [region], width=0, height=0, [camera_groups], [frames], [progress])

		Generate spherical panoramas from camera stations.

		:arg blending_mode: Panorama blending mode.
		:type blending_mode: Metashape.Metashape.BlendingMode
		:arg ghosting_filter: Enable ghosting filter.
		:type ghosting_filter: bool
		:arg rotation: Panorama 3x3 orientation matrix.
		:type rotation: Metashape.Matrix
		:arg region: Region to be generated.
		:type region: Metashape.BBox
		:arg width: Width of output panorama.
		:type width: int
		:arg height: Height of output panorama.
		:type height: int
		:arg camera_groups: List of camera groups to process.
		:type camera_groups: list[int]
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildPointCloud (self, *args, **kwargs):
		"""buildPointCloud(source_data=DepthMapsData, point_colors=True, point_confidence=False, keep_depth=True, max_neighbors=100, uniform_sampling=True, points_spacing=0.1, [asset], subdivide_task=True, workitem_size_cameras=20, max_workgroup_size=100, replace_asset=False, [frames], [progress])

		Generate point cloud for the chunk.

		:arg source_data: Source data to extract points from.
		:type source_data: Metashape.Metashape.DataSource
		:arg point_colors: Enable point colors calculation.
		:type point_colors: bool
		:arg point_confidence: Enable point confidence calculation.
		:type point_confidence: bool
		:arg keep_depth: Enable store depth maps option.
		:type keep_depth: bool
		:arg max_neighbors: Maximum number of neighbor images to use for depth map filtering.
		:type max_neighbors: int
		:arg uniform_sampling: Enable uniform point sampling.
		:type uniform_sampling: bool
		:arg points_spacing: Desired point spacing (m).
		:type points_spacing: float
		:arg asset: Asset to process.
		:type asset: int
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg workitem_size_cameras: Number of cameras in a workitem.
		:type workitem_size_cameras: int
		:arg max_workgroup_size: Maximum workgroup size.
		:type max_workgroup_size: int
		:arg replace_asset: Replace default asset with generated point cloud.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildSeamlines (self, *args, **kwargs):
		"""buildSeamlines(epsilon=1.5, [progress])

		Generate shapes for orthomosaic seamlines.

		:arg epsilon: Contour simplificaion threshold.
		:type epsilon: float
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildTexture (self, *args, **kwargs):
		"""buildTexture(blending_mode=MosaicBlending, texture_size=8192, fill_holes=True, ghosting_filter=True, [cameras], texture_type=DiffuseMap, source_data=ImagesData, [source_asset], transfer_texture=True, workitem_size_cameras=20, max_workgroup_size=100, anti_aliasing=1, [progress])

		Generate texture for the chunk.

		:arg blending_mode: Texture blending mode.
		:type blending_mode: Metashape.Metashape.BlendingMode
		:arg texture_size: Texture page size.
		:type texture_size: int
		:arg fill_holes: Enable hole filling.
		:type fill_holes: bool
		:arg ghosting_filter: Enable ghosting filter.
		:type ghosting_filter: bool
		:arg cameras: A list of cameras to be used for texturing.
		:type cameras: list[int]
		:arg texture_type: Texture type.
		:type texture_type: Metashape.Model.TextureType
		:arg source_data: Source data to create texture from.
		:type source_data: Metashape.Metashape.DataSource
		:arg source_asset: Source asset.
		:type source_asset: int
		:arg transfer_texture: Transfer texture.
		:type transfer_texture: bool
		:arg workitem_size_cameras: Number of cameras in a workitem (block model only).
		:type workitem_size_cameras: int
		:arg max_workgroup_size: Maximum workgroup size (block model only).
		:type max_workgroup_size: int
		:arg anti_aliasing: Anti-aliasing coefficient for baking
		:type anti_aliasing: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildTiledModel (self, *args, **kwargs):
		"""buildTiledModel(pixel_size=0, tile_size=256, source_data=DepthMapsData, face_count=20000, ghosting_filter=False, transfer_texture=False, keep_depth=True, merge=False, [operand_chunk], [operand_frame], [operand_asset], [classes], subdivide_task=True, workitem_size_cameras=20, max_workgroup_size=100, replace_asset=False, [frames], [progress])

		Build tiled model for the chunk.

		:arg pixel_size: Target model resolution in meters.
		:type pixel_size: float
		:arg tile_size: Size of tiles in pixels.
		:type tile_size: int
		:arg source_data: Selects between point cloud and mesh.
		:type source_data: Metashape.Metashape.DataSource
		:arg face_count: Number of faces per megapixel of texture resolution.
		:type face_count: int
		:arg ghosting_filter: Enable ghosting filter.
		:type ghosting_filter: bool
		:arg transfer_texture: Transfer source model texture to tiled model.
		:type transfer_texture: bool
		:arg keep_depth: Enable store depth maps option.
		:type keep_depth: bool
		:arg merge: Merge tiled model flag.
		:type merge: bool
		:arg operand_chunk: Operand chunk key.
		:type operand_chunk: int
		:arg operand_frame: Operand frame key.
		:type operand_frame: int
		:arg operand_asset: Operand asset key.
		:type operand_asset: int
		:arg classes: List of point classes to be used for surface extraction.
		:type classes: list[int]
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg workitem_size_cameras: Number of cameras in a workitem.
		:type workitem_size_cameras: int
		:arg max_workgroup_size: Maximum workgroup size.
		:type max_workgroup_size: int
		:arg replace_asset: Replace default asset with generated tiled model.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def buildUV (self, *args, **kwargs):
		"""buildUV(mapping_mode=GenericMapping, page_count=1, texture_size=8192, pixel_size=0, [camera], [progress])

		Generate uv mapping for the model.

		:arg mapping_mode: Texture mapping mode.
		:type mapping_mode: Metashape.Metashape.MappingMode
		:arg page_count: Number of texture pages to generate.
		:type page_count: int
		:arg texture_size: Expected size of texture page at texture generation step.
		:type texture_size: int
		:arg pixel_size: Texture resolution in meters.
		:type pixel_size: float
		:arg camera: Camera to be used for texturing in CameraMapping mode.
		:type camera: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def calculatePointNormals (self, *args, **kwargs):
		"""calculatePointNormals(point_neighbors=28, [point_cloud], [progress])

		Calculate point cloud normals.

		:arg point_neighbors: Number of point neighbors to use for normal estimation.
		:type point_neighbors: int
		:arg point_cloud: Point cloud key to process.
		:type point_cloud: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def calibrateColors (self, *args, **kwargs):
		"""calibrateColors(source_data=ModelData, white_balance=False, [cameras], [progress])

		Perform radiometric calibration.

		:arg source_data: Source data for calibration.
		:type source_data: Metashape.Metashape.DataSource
		:arg white_balance: Calibrate white balance.
		:type white_balance: bool
		:arg cameras: List of cameras to calibrate.
		:type cameras: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def calibrateReflectance (self, *args, **kwargs):
		"""calibrateReflectance(use_reflectance_panels=True, use_sun_sensor=False, [progress])

		Calibrate reflectance factors based on calibration panels and/or sun sensor.

		:arg use_reflectance_panels: Use calibrated reflectance panels.
		:type use_reflectance_panels: bool
		:arg use_sun_sensor: Apply irradiance sensor measurements.
		:type use_sun_sensor: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	camera_crs:  CoordinateSystem
	"""Coordinate system used for camera reference data.

	:type: CoordinateSystem"""

	camera_groups:  list[CameraGroup]
	"""List of camera groups in the chunk.

	:type: list[CameraGroup]"""

	camera_location_accuracy:  Vector
	"""Expected accuracy of camera coordinates in meters.

	:type: Vector"""

	camera_rotation_accuracy:  Vector
	"""Expected accuracy of camera orientation angles in degrees.

	:type: Vector"""

	camera_track:  CameraTrack
	"""Camera track.

	:type: CameraTrack"""

	camera_tracks:  list[CameraTrack]
	"""List of camera tracks in the chunk.

	:type: list[CameraTrack]"""

	cameras:  list[Camera]
	"""List of Regular and Keyframe cameras in the chunk.

	:type: list[Camera]"""

	cir_transform:  CirTransform
	"""CIR calibration matrix.

	:type: CirTransform"""

	def cleanModel (self, *args, **kwargs):
		"""cleanModel(criterion=ComponentSize, level=0, [model], [progress])

		Remove model faces based on specified criterion.

		:arg criterion: Model filtering criterion.
		:type criterion: Metashape.Model.Criterion
		:arg level: Filtering threshold in percents.
		:type level: int
		:arg model: Model to filter.
		:type model: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def cleanTiePoints (self, *args, **kwargs):
		"""cleanTiePoints(criterion=ReprojectionError, threshold=0, [progress])

		Remove tie points based on specified criterion.

		:arg criterion: Tie points filtering criterion.
		:type criterion: Metashape.TiePoints.Criterion
		:arg threshold: Filtering threshold.
		:type threshold: float
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def colorizeModel (self, *args, **kwargs):
		"""colorizeModel(source_data=ImagesData, [model], [progress])

		Calculate vertex colors for the model.

		:arg source_data: Source data to extract colors from.
		:type source_data: Metashape.Metashape.DataSource
		:arg model: Key of model to colorize.
		:type model: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def colorizePointCloud (self, *args, **kwargs):
		"""colorizePointCloud(source_data=ImagesData, [point_cloud], replace_asset=False, [frames], workitem_size_cameras=20, max_workgroup_size=100, subdivide_task=True, [progress])

		Calculate point colors for the point cloud.

		:arg source_data: Source data to extract colors from.
		:type source_data: Metashape.Metashape.DataSource
		:arg point_cloud: Point cloud key to colorize.
		:type point_cloud: int
		:arg replace_asset: Replace source point cloud with colorized one.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg workitem_size_cameras: Number of cameras in a workitem.
		:type workitem_size_cameras: int
		:arg max_workgroup_size: Maximum workgroup size.
		:type max_workgroup_size: int
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	component:  Component
	"""Component.

	:type: Component"""

	components:  list[Component]
	"""List of components in the chunk.

	:type: list[Component]"""

	def convertImages (self, *args, **kwargs):
		"""convertImages(path='{filename}.{fileext}', use_initial_calibration=False, color_correction=False, merge_planes=False, update_gps_tags=False, [cameras], [image_compression], [progress])

		Convert images.

		:arg path: Path to output file.
		:type path: str
		:arg use_initial_calibration: Transform to initial calibration.
		:type use_initial_calibration: bool
		:arg color_correction: Apply color correction.
		:type color_correction: bool
		:arg merge_planes: Merge multispectral images.
		:type merge_planes: bool
		:arg update_gps_tags: Update GPS tags.
		:type update_gps_tags: bool
		:arg cameras: List of cameras to process.
		:type cameras: list[int]
		:arg image_compression: Image compression parameters.
		:type image_compression: Metashape.ImageCompression
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def copy (self, *args, **kwargs) -> Chunk:
		"""copy([frames], [items], keypoints=True, [cameras], [laser_scans], [progress])

		Make a copy of the chunk.

		:arg frames: Optional list of frames to be copied.
		:type frames: list[Metashape.Chunk]
		:arg items: A list of items to copy.
		:type items: list[Metashape.DataSource]
		:arg keypoints: Copy key points data.
		:type keypoints: bool
		:arg cameras: Optional list of cameras to be copied.
		:type cameras: list[Metashape.Camera]
		:arg laser_scans: Optional list of laser scans to be copied.
		:type laser_scans: list[Metashape.PointCloud]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Copy of the chunk.
		:rtype: Metashape.Chunk"""
	...
	crs:  CoordinateSystem
	"""Coordinate system used for reference data.

	:type: CoordinateSystem"""

	def decimateModel (self, *args, **kwargs):
		"""decimateModel(face_count=200000, [model], apply_to_selection=False, replace_asset=False, [frames], [progress])

		Decimate the model to the specified face count.

		:arg face_count: Target face count.
		:type face_count: int
		:arg model: Model to process.
		:type model: int
		:arg apply_to_selection: Apply to selection.
		:type apply_to_selection: bool
		:arg replace_asset: Replace source model with decimated model.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	depth_maps:  DepthMaps
	"""Default depth maps set for the current frame.

	:type: DepthMaps"""

	depth_maps_sets:  list[DepthMaps]
	"""List of depth maps sets for the current frame.

	:type: list[DepthMaps]"""

	def detectFiducials (self, *args, **kwargs):
		"""detectFiducials(generate_masks=False, mask_dark_pixels=True, generic_detector=True, right_angle_detector=False, v_shape_detector=False, frame_detector=False, fiducials_position_corners=True, fiducials_position_sides=True, [cameras], [frames], [progress])

		Detect fiducial marks on film cameras.

		:arg generate_masks: Generate background masks.
		:type generate_masks: bool
		:arg mask_dark_pixels: Mask out dark pixels near frame edge.
		:type mask_dark_pixels: bool
		:arg generic_detector: Use generic detector.
		:type generic_detector: bool
		:arg right_angle_detector: Use right angle detector.
		:type right_angle_detector: bool
		:arg v_shape_detector: Detect V-shape fiducials.
		:type v_shape_detector: bool
		:arg frame_detector: Detect frame.
		:type frame_detector: bool
		:arg fiducials_position_corners: Search corners for fiducials.
		:type fiducials_position_corners: bool
		:arg fiducials_position_sides: Search sides for fiducials.
		:type fiducials_position_sides: bool
		:arg cameras: List of cameras to process.
		:type cameras: list[int]
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def detectMarkers (self, *args, **kwargs):
		"""detectMarkers(target_type=CircularTarget12bit, tolerance=50, filter_mask=False, inverted=False, noparity=False, maximum_residual=5, minimum_size=0, minimum_dist=5, merge_markers=False, [cameras], [frames], [progress])

		Create markers from coded targets.

		:arg target_type: Type of targets.
		:type target_type: Metashape.Metashape.TargetType
		:arg tolerance: Detector tolerance (0 - 100).
		:type tolerance: int
		:arg filter_mask: Ignore masked image regions.
		:type filter_mask: bool
		:arg inverted: Detect markers on black background.
		:type inverted: bool
		:arg noparity: Disable parity checking.
		:type noparity: bool
		:arg maximum_residual: Maximum residual for non-coded targets in pixels.
		:type maximum_residual: float
		:arg minimum_size: Minimum target radius in pixels to be detected (CrossTarget type only).
		:type minimum_size: int
		:arg minimum_dist: Minimum distance between targets in pixels (CrossTarget type only).
		:type minimum_dist: int
		:arg merge_markers: Merge detected targets with existing markers.
		:type merge_markers: bool
		:arg cameras: List of cameras to process.
		:type cameras: list[int]
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def detectPowerlines (self, *args, **kwargs):
		"""detectPowerlines(min_altitude=1, n_points_per_line=100, max_quantization_error=0.01, use_model=True, [progress])

		Detect powerlines for the chunk.

		:arg min_altitude: Minimum altitude for reconstructed powerlines.
		:type min_altitude: float
		:arg n_points_per_line: Maximum number of vertices per detected line.
		:type n_points_per_line: int
		:arg max_quantization_error: Maximum allowed distance between polyline and smooth continuous curve.
		:type max_quantization_error: float
		:arg use_model: Use model for visibility checks.
		:type use_model: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	elevation:  Elevation
	"""Default elevation model for the current frame.

	:type: Elevation"""

	elevations:  list[Elevation]
	"""List of elevation models for the current frame.

	:type: list[Elevation]"""

	enabled:  bool
	"""Enables/disables the chunk.

	:type: bool"""

	euler_angles:  EulerAngles
	"""Euler angles triplet used for rotation reference.

	:type: EulerAngles"""

	def exportCameras (self, *args, **kwargs):
		"""exportCameras(path='', format=CamerasFormatXML, [crs], save_points=True, save_markers=False, save_invalid_matches=False, save_absolute_paths=False, save_images=True, save_masks=False, use_labels=False, use_initial_calibration=False, convert_to_pinhole=False, image_path='{filename}_{filenum}.jpg', image_orientation=0, [image_compression], binary=False, [cameras], bundler_save_list=True, bundler_path_list='list.txt', bingo_save_image=True, bingo_save_itera=True, bingo_save_geoin=True, bingo_save_gps=False, bingo_path_itera='itera.dat', bingo_path_image='image.dat', bingo_path_geoin='geoin.dat', bingo_path_gps='gps-imu.dat', chan_rotation_order=RotationOrderXYZ, [progress])

		Export point cloud and/or camera positions.

		:arg path: Path to output file.
		:type path: str
		:arg format: Export format.
		:type format: Metashape.Metashape.CamerasFormat
		:arg crs: Output coordinate system (except AgisoftXML format).
		:type crs: Metashape.CoordinateSystem
		:arg save_points: Enables/disables export of automatic tie points.
		:type save_points: bool
		:arg save_markers: Enables/disables export of manual matching points.
		:type save_markers: bool
		:arg save_invalid_matches: Enables/disables export of invalid image matches.
		:type save_invalid_matches: bool
		:arg save_absolute_paths: Save absolute image paths (BlocksExchange and RZML formats only).
		:type save_absolute_paths: bool
		:arg save_images: Enables/disables images export (Colmap format only).
		:type save_images: bool
		:arg save_masks: Enables/disables image masks export (Colmap format only).
		:type save_masks: bool
		:arg use_labels: Enables/disables label based item identifiers.
		:type use_labels: bool
		:arg use_initial_calibration: Transform image coordinates to initial calibration.
		:type use_initial_calibration: bool
		:arg convert_to_pinhole: Transform images to pinhole model without distortions.
		:type convert_to_pinhole: bool
		:arg image_path: Image name template
		:type image_path: str
		:arg image_orientation: Image coordinate system (0 - X right, 1 - X up, 2 - X left, 3 - X down).
		:type image_orientation: int
		:arg image_compression: Image compression parameters.
		:type image_compression: Metashape.ImageCompression
		:arg binary: Enables/disables binary encoding for selected format (Colmap and FBX formats only).
		:type binary: bool
		:arg cameras: List of cameras to export (except AgisoftXML format).
		:type cameras: list[int]
		:arg bundler_save_list: Enables/disables export of Bundler image list file.
		:type bundler_save_list: bool
		:arg bundler_path_list: Path to Bundler image list file.
		:type bundler_path_list: str
		:arg bingo_save_image: Enables/disables export of BINGO IMAGE COORDINATE file.
		:type bingo_save_image: bool
		:arg bingo_save_itera: Enables/disables export of BINGO ITERA file.
		:type bingo_save_itera: bool
		:arg bingo_save_geoin: Enables/disables export of BINGO GEO INPUT file.
		:type bingo_save_geoin: bool
		:arg bingo_save_gps: Enables/disables export of BINGO GPS/IMU data.
		:type bingo_save_gps: bool
		:arg bingo_path_itera: Path to BINGO ITERA file.
		:type bingo_path_itera: str
		:arg bingo_path_image: Path to BINGO IMAGE COORDINATE file.
		:type bingo_path_image: str
		:arg bingo_path_geoin: Path to BINGO GEO INPUT file.
		:type bingo_path_geoin: str
		:arg bingo_path_gps: Path to BINGO GPS/IMU file.
		:type bingo_path_gps: str
		:arg chan_rotation_order: Rotation order (CHAN format only).
		:type chan_rotation_order: Metashape.Metashape.RotationOrder
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportMarkers (self, *args, **kwargs):
		"""exportMarkers(path='', [crs], binary=False, [progress])

		Export markers.

		:arg path: Path to output file.
		:type path: str
		:arg crs: Output coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg binary: Enables/disables binary encoding for selected format (if applicable).
		:type binary: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportModel (self, *args, **kwargs):
		"""exportModel(path='', binary=True, precision=6, texture_format=ImageFormatJPEG, save_texture=True, save_uv=True, save_normals=True, save_colors=True, save_confidence=False, save_cameras=True, save_markers=True, save_udim=False, save_alpha=False, embed_texture=False, strip_extensions=False, raster_transform=RasterTransformNone, colors_rgb_8bit=True, gltf_y_up=True, comment='', save_comment=True, format=ModelFormatNone, [crs], [shift], clip_to_boundary=True, clip_to_region=False, clip_to_block=False, block_margin=0.5, save_metadata_xml=False, [model], [viewpoint], [progress])

		Export generated model for the chunk.

		:arg path: Path to output model.
		:type path: str
		:arg binary: Enables/disables binary encoding (if supported by format).
		:type binary: bool
		:arg precision: Number of digits after the decimal point (for text formats).
		:type precision: int
		:arg texture_format: Texture format.
		:type texture_format: Metashape.Metashape.ImageFormat
		:arg save_texture: Enables/disables texture export.
		:type save_texture: bool
		:arg save_uv: Enables/disables uv coordinates export.
		:type save_uv: bool
		:arg save_normals: Enables/disables export of vertex normals.
		:type save_normals: bool
		:arg save_colors: Enables/disables export of vertex colors.
		:type save_colors: bool
		:arg save_confidence: Enables/disables export of vertex confidence.
		:type save_confidence: bool
		:arg save_cameras: Enables/disables camera export.
		:type save_cameras: bool
		:arg save_markers: Enables/disables marker export.
		:type save_markers: bool
		:arg save_udim: Enables/disables UDIM texture layout.
		:type save_udim: bool
		:arg save_alpha: Enables/disables alpha channel export.
		:type save_alpha: bool
		:arg embed_texture: Embeds texture inside the model file (if supported by format).
		:type embed_texture: bool
		:arg strip_extensions: Strips camera label extensions during export.
		:type strip_extensions: bool
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.Metashape.RasterTransformType
		:arg colors_rgb_8bit: Convert colors to 8 bit RGB.
		:type colors_rgb_8bit: bool
		:arg gltf_y_up: Enables/disables y-up axes notation used in glTF.
		:type gltf_y_up: bool
		:arg comment: Optional comment (if supported by selected format).
		:type comment: str
		:arg save_comment: Enables/disables comment export.
		:type save_comment: bool
		:arg format: Export format.
		:type format: Metashape.Metashape.ModelFormat
		:arg crs: Output coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg shift: Optional shift to be applied to vertex coordinates.
		:type shift: Metashape.Vector
		:arg clip_to_boundary: Clip model to boundary shapes.
		:type clip_to_boundary: bool
		:arg clip_to_region: Clip model to chunk region.
		:type clip_to_region: bool
		:arg clip_to_block: Clip model to block region.
		:type clip_to_block: bool
		:arg block_margin: Block margin (m).
		:type block_margin: float
		:arg save_metadata_xml: Save metadata.xml file.
		:type save_metadata_xml: bool
		:arg model: Model key to export.
		:type model: int
		:arg viewpoint: Default view.
		:type viewpoint: Metashape.Viewpoint
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportOrthophotos (self, *args, **kwargs):
		"""exportOrthophotos(path='{filename}.tif', [cameras], raster_transform=RasterTransformNone, [projection], [region], resolution=0, resolution_x=0, resolution_y=0, save_kml=False, save_world=False, save_alpha=True, [image_compression], white_background=True, north_up=True, [progress])

		Export orthophotos for the chunk.

		:arg path: Path to output orthophoto.
		:type path: str
		:arg cameras: List of cameras to process.
		:type cameras: list[int]
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.Metashape.RasterTransformType
		:arg projection: Output projection.
		:type projection: Metashape.OrthoProjection
		:arg region: Region to be exported.
		:type region: Metashape.BBox
		:arg resolution: Output resolution in meters.
		:type resolution: float
		:arg resolution_x: Pixel size in the X dimension in projected units.
		:type resolution_x: float
		:arg resolution_y: Pixel size in the Y dimension in projected units.
		:type resolution_y: float
		:arg save_kml: Enable kml file generation.
		:type save_kml: bool
		:arg save_world: Enable world file generation.
		:type save_world: bool
		:arg save_alpha: Enable alpha channel generation.
		:type save_alpha: bool
		:arg image_compression: Image compression parameters.
		:type image_compression: Metashape.ImageCompression
		:arg white_background: Enable white background.
		:type white_background: bool
		:arg north_up: Use north-up orientation for export.
		:type north_up: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportPointCloud (self, *args, **kwargs):
		"""exportPointCloud(path='', source_data=PointCloudData, [point_clouds], binary=True, save_point_color=True, save_point_normal=True, save_point_intensity=True, save_point_classification=True, save_point_confidence=True, save_point_return_number=True, save_point_scan_angle=True, save_point_source_id=True, save_point_timestamp=True, save_point_index=True, raster_transform=RasterTransformNone, colors_rgb_8bit=True, comment='', save_comment=True, format=PointCloudFormatNone, image_format=ImageFormatJPEG, [crs], [shift], [region], clip_to_boundary=True, clip_to_region=False, block_width=1000, block_height=1000, split_in_blocks=False, [classes], save_images=False, compression=True, tileset_version='1.0', screen_space_error=16, folder_depth=5, [viewpoint], subdivide_task=True, [progress])

		Export point cloud.

		:arg path: Path to output file.
		:type path: str
		:arg source_data: Selects between point cloud and tie points. If not specified, uses point cloud if available.
		:type source_data: Metashape.Metashape.DataSource
		:arg point_clouds: Point cloud keys to export.
		:type point_clouds: list[int]
		:arg binary: Enables/disables binary encoding for selected format (if applicable).
		:type binary: bool
		:arg save_point_color: Enables/disables export of point color.
		:type save_point_color: bool
		:arg save_point_normal: Enables/disables export of point normal.
		:type save_point_normal: bool
		:arg save_point_intensity: Enables/disables export of point intensity.
		:type save_point_intensity: bool
		:arg save_point_classification: Enables/disables export of point classification.
		:type save_point_classification: bool
		:arg save_point_confidence: Enables/disables export of point confidence.
		:type save_point_confidence: bool
		:arg save_point_return_number: Enables/disables export of point return number.
		:type save_point_return_number: bool
		:arg save_point_scan_angle: Enables/disables export of point scan angle.
		:type save_point_scan_angle: bool
		:arg save_point_source_id: Enables/disables export of point source ID.
		:type save_point_source_id: bool
		:arg save_point_timestamp: Enables/disables export of point timestamp.
		:type save_point_timestamp: bool
		:arg save_point_index: Enables/disables export of point row and column indices.
		:type save_point_index: bool
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.Metashape.RasterTransformType
		:arg colors_rgb_8bit: Convert colors to 8 bit RGB.
		:type colors_rgb_8bit: bool
		:arg comment: Optional comment (if supported by selected format).
		:type comment: str
		:arg save_comment: Enable comment export.
		:type save_comment: bool
		:arg format: Export format.
		:type format: Metashape.Metashape.PointCloudFormat
		:arg image_format: Image data format.
		:type image_format: Metashape.Metashape.ImageFormat
		:arg crs: Output coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg shift: Optional shift to be applied to point coordinates.
		:type shift: Metashape.Vector
		:arg region: Region to be exported.
		:type region: Metashape.BBox
		:arg clip_to_boundary: Clip point cloud to boundary shapes.
		:type clip_to_boundary: bool
		:arg clip_to_region: Clip point cloud to chunk region.
		:type clip_to_region: bool
		:arg block_width: Block width in meters.
		:type block_width: float
		:arg block_height: Block height in meters.
		:type block_height: float
		:arg split_in_blocks: Enable tiled export.
		:type split_in_blocks: bool
		:arg classes: List of point classes to be exported.
		:type classes: list[int]
		:arg save_images: Enable image export.
		:type save_images: bool
		:arg compression: Enable compression (Cesium format only).
		:type compression: bool
		:arg tileset_version: Cesium 3D Tiles format version to export (1.0 or 1.1).
		:type tileset_version: str
		:arg screen_space_error: Target screen space error (Cesium format only).
		:type screen_space_error: float
		:arg folder_depth: Tileset subdivision depth (Cesium format only).
		:type folder_depth: int
		:arg viewpoint: Default view.
		:type viewpoint: Metashape.Viewpoint
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportRaster (self, *args, **kwargs):
		"""exportRaster(path='', format=RasterFormatTiles, image_format=ImageFormatNone, raster_transform=RasterTransformNone, [projection], [region], resolution=0, resolution_x=0, resolution_y=0, block_width=10000, block_height=10000, split_in_blocks=False, width=0, height=0, [world_transform], nodata_value=-32767, save_kml=False, save_world=False, save_scheme=False, save_alpha=True, image_description='', [image_compression], network_links=True, global_profile=False, min_zoom_level=-1, max_zoom_level=-1, white_background=True, clip_to_boundary=True, title='Orthomosaic', description='Generated by Agisoft Metashape', source_data=OrthomosaicData, [asset], north_up=True, tile_width=256, tile_height=256, [progress])

		Export DEM or orthomosaic to file.

		:arg path: Path to output orthomosaic.
		:type path: str
		:arg format: Export format.
		:type format: Metashape.Metashape.RasterFormat
		:arg image_format: Tile format.
		:type image_format: Metashape.Metashape.ImageFormat
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.Metashape.RasterTransformType
		:arg projection: Output projection.
		:type projection: Metashape.OrthoProjection
		:arg region: Region to be exported.
		:type region: Metashape.BBox
		:arg resolution: Output resolution in meters.
		:type resolution: float
		:arg resolution_x: Pixel size in the X dimension in projected units.
		:type resolution_x: float
		:arg resolution_y: Pixel size in the Y dimension in projected units.
		:type resolution_y: float
		:arg block_width: Raster block width in pixels.
		:type block_width: int
		:arg block_height: Raster block height in pixels.
		:type block_height: int
		:arg split_in_blocks: Split raster in blocks.
		:type split_in_blocks: bool
		:arg width: Raster width.
		:type width: int
		:arg height: Raster height.
		:type height: int
		:arg world_transform: 2x3 raster-to-world transformation matrix.
		:type world_transform: Metashape.Matrix
		:arg nodata_value: No-data value (DEM export only).
		:type nodata_value: float
		:arg save_kml: Enable kml file generation.
		:type save_kml: bool
		:arg save_world: Enable world file generation.
		:type save_world: bool
		:arg save_scheme: Enable tile scheme files generation.
		:type save_scheme: bool
		:arg save_alpha: Enable alpha channel generation.
		:type save_alpha: bool
		:arg image_description: Optional description to be added to image files.
		:type image_description: str
		:arg image_compression: Image compression parameters.
		:type image_compression: Metashape.ImageCompression
		:arg network_links: Enable network links generation for KMZ format.
		:type network_links: bool
		:arg global_profile: Use global profile (GeoPackage and TMS formats only).
		:type global_profile: bool
		:arg min_zoom_level: Minimum zoom level (GeoPackage, Google Map Tiles, MBTiles and World Wind Tiles formats only).
		:type min_zoom_level: int
		:arg max_zoom_level: Maximum zoom level (GeoPackage, Google Map Tiles, MBTiles and World Wind Tiles formats only).
		:type max_zoom_level: int
		:arg white_background: Enable white background.
		:type white_background: bool
		:arg clip_to_boundary: Clip raster to boundary shapes.
		:type clip_to_boundary: bool
		:arg title: Export title.
		:type title: str
		:arg description: Export description.
		:type description: str
		:arg source_data: Selects between DEM and orthomosaic.
		:type source_data: Metashape.Metashape.DataSource
		:arg asset: Asset key to export.
		:type asset: int
		:arg north_up: Use north-up orientation for export.
		:type north_up: bool
		:arg tile_width: Tile width in pixels.
		:type tile_width: int
		:arg tile_height: Tile height in pixels.
		:type tile_height: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportReference (self, *args, **kwargs):
		"""exportReference(path='', format=ReferenceFormatNone, items=ReferenceItemsCameras, columns='', delimiter='       ', precision=6, save_rotation=True, save_location_accuracy=False, save_rotation_accuracy=False, save_errors=True, save_estimated=True, save_variance=False, save_enabled=False, [progress])

		Export reference data to the specified file.

		:arg path: Path to the output file.
		:type path: str
		:arg format: Export format.
		:type format: Metashape.Metashape.ReferenceFormat
		:arg items: Items to export (CSV format only).
		:type items: Metashape.Metashape.ReferenceItems
		:arg columns: Column order in CSV format (n - label, o - enabled flag, x/y/z - coordinates, X/Y/Z - coordinate accuracy, a/b/c - rotation angles, A/B/C - rotation angle accuracy, u/v/w - estimated coordinates, U/V/W - coordinate errors, d/e/f - estimated orientation angles, D/E/F - orientation errors, p/q/r - estimated coordinates variance, i/j/k - estimated orientation angles variance, [] - group of multiple values, | - column separator within group).
		:type columns: str
		:arg delimiter: Column delimiter (CSV format only).
		:type delimiter: str
		:arg precision: Number of digits after the decimal point (CSV format only).
		:type precision: int
		:arg save_rotation: Save rotation angles (CSV format only).
		:type save_rotation: bool
		:arg save_location_accuracy: Save location accuracy (CSV format only).
		:type save_location_accuracy: bool
		:arg save_rotation_accuracy: Save rotation accuracy (CSV format only).
		:type save_rotation_accuracy: bool
		:arg save_errors: Save errors (CSV format only).
		:type save_errors: bool
		:arg save_estimated: Save estimated values (CSV format only).
		:type save_estimated: bool
		:arg save_variance: Save variance (CSV format only).
		:type save_variance: bool
		:arg save_enabled: Save enabled flag (CSV format only).
		:type save_enabled: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportReport (self, *args, **kwargs):
		"""exportReport(path='', title='', description='', font_size=12, page_numbers=True, include_system_info=True, [user_settings], logo_path='', [progress])

		Export processing report in PDF format.

		:arg path: Path to output report.
		:type path: str
		:arg title: Report title.
		:type title: str
		:arg description: Report description.
		:type description: str
		:arg font_size: Font size (pt).
		:type font_size: int
		:arg page_numbers: Enable page numbers.
		:type page_numbers: bool
		:arg include_system_info: Include system information.
		:type include_system_info: bool
		:arg user_settings: A list of user defined settings to include on the Processing Parameters page.
		:type user_settings: list[tuple[str, str]]
		:arg logo_path: Path to company logo file.
		:type logo_path: str
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportShapes (self, *args, **kwargs):
		"""exportShapes(path='', save_points=False, save_polylines=False, save_polygons=False, [groups], format=ShapesFormatNone, [crs], [shift], polygons_as_polylines=False, save_labels=True, save_attributes=True, save_elevation=True, [progress])

		Export shapes layer to file.

		:arg path: Path to shape file.
		:type path: str
		:arg save_points: Export points.
		:type save_points: bool
		:arg save_polylines: Export polylines.
		:type save_polylines: bool
		:arg save_polygons: Export polygons.
		:type save_polygons: bool
		:arg groups: A list of shape groups to export.
		:type groups: list[int]
		:arg format: Export format.
		:type format: Metashape.Metashape.ShapesFormat
		:arg crs: Output coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg shift: Optional shift to be applied to vertex coordinates.
		:type shift: Metashape.Vector
		:arg polygons_as_polylines: Save polygons as polylines.
		:type polygons_as_polylines: bool
		:arg save_labels: Export labels.
		:type save_labels: bool
		:arg save_attributes: Export attributes.
		:type save_attributes: bool
		:arg save_elevation: Export elevation values for 3D shapes.
		:type save_elevation: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportTexture (self, *args, **kwargs):
		"""exportTexture(path='', texture_type=DiffuseMap, raster_transform=RasterTransformNone, save_alpha=False, [progress])

		Export model texture to file.

		:arg path: Path to output file.
		:type path: str
		:arg texture_type: Texture type.
		:type texture_type: Metashape.Model.TextureType
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.Metashape.RasterTransformType
		:arg save_alpha: Enable alpha channel export.
		:type save_alpha: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def exportTiledModel (self, *args, **kwargs):
		"""exportTiledModel(path='', format=TiledModelFormatNone, model_format=ModelFormatCOLLADA, texture_format=ImageFormatJPEG, raster_transform=RasterTransformNone, [image_compression], [crs], clip_to_boundary=True, clip_to_region=False, [tiled_model], model_compression=True, zip_compression=True, tileset_version='1.0', use_tileset_transform=True, screen_space_error=16, folder_depth=5, [model_group], pixel_size=0, tile_size=256, face_count=20000, [progress])

		Export generated tiled model for the chunk.

		:arg path: Path to output model.
		:type path: str
		:arg format: Export format.
		:type format: Metashape.Metashape.TiledModelFormat
		:arg model_format: Model format for zip export.
		:type model_format: Metashape.Metashape.ModelFormat
		:arg texture_format: Texture format.
		:type texture_format: Metashape.Metashape.ImageFormat
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.Metashape.RasterTransformType
		:arg image_compression: Image compression parameters.
		:type image_compression: Metashape.ImageCompression
		:arg crs: Output coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg clip_to_boundary: Clip tiled model to boundary shapes.
		:type clip_to_boundary: bool
		:arg clip_to_region: Clip tiled model to chunk region.
		:type clip_to_region: bool
		:arg tiled_model: Tiled model key to export.
		:type tiled_model: int
		:arg model_compression: Enable mesh compression (Cesium format only).
		:type model_compression: bool
		:arg zip_compression: Enable zip compression (Cesium format only).
		:type zip_compression: bool
		:arg tileset_version: Cesium 3D Tiles format version to export (1.0 or 1.1).
		:type tileset_version: str
		:arg use_tileset_transform: Use tileset transform instead of individual tile transforms (Cesium format only).
		:type use_tileset_transform: bool
		:arg screen_space_error: Target screen space error (Cesium format only).
		:type screen_space_error: float
		:arg folder_depth: Tileset subdivision depth (Cesium format only).
		:type folder_depth: int
		:arg model_group: Block model key to export.
		:type model_group: int
		:arg pixel_size: Target model resolution in meters (block model export only).
		:type pixel_size: float
		:arg tile_size: Size of tiles in pixels (block model export only).
		:type tile_size: int
		:arg face_count: Number of faces per megapixel of texture resolution (block model export only).
		:type face_count: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def filterPointCloud (self, *args, **kwargs):
		"""filterPointCloud(point_spacing=0, [point_cloud], clip_to_region=False, replace_asset=False, [frames], [progress])

		Reduce point cloud points number.

		:arg point_spacing: Desired point spacing (m).
		:type point_spacing: float
		:arg point_cloud: Point cloud key to filter.
		:type point_cloud: int
		:arg clip_to_region: Clip point cloud to chunk region.
		:type clip_to_region: bool
		:arg replace_asset: Replace default asset with filtered point cloud.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def findCamera (self, *args, **kwargs) -> Camera:
		"""findCamera(key)

		Find camera by its key.

		:return: Found camera.
		:rtype: Metashape.Camera"""
	...
	def findCameraGroup (self, *args, **kwargs) -> CameraGroup:
		"""findCameraGroup(key)

		Find camera group by its key.

		:return: Found camera group.
		:rtype: Metashape.CameraGroup"""
	...
	def findCameraTrack (self, *args, **kwargs) -> CameraTrack:
		"""findCameraTrack(key)

		Find camera track by its key.

		:return: Found camera track.
		:rtype: Metashape.CameraTrack"""
	...
	def findDepthMaps (self, *args, **kwargs) -> DepthMaps:
		"""findDepthMaps(key)

		Find depth maps by its key.

		:return: Found depth maps.
		:rtype: Metashape.DepthMaps"""
	...
	def findElevation (self, *args, **kwargs) -> Elevation:
		"""findElevation(key)

		Find elevation model by its key.

		:return: Found elevation model.
		:rtype: Metashape.Elevation"""
	...
	def findFrame (self, *args, **kwargs) -> Chunk:
		"""findFrame(key)

		Find frame by its key.

		:return: Found frame.
		:rtype: Metashape.Chunk"""
	...
	def findMarker (self, *args, **kwargs) -> Marker:
		"""findMarker(key)

		Find marker by its key.

		:return: Found marker.
		:rtype: Metashape.Marker"""
	...
	def findMarkerGroup (self, *args, **kwargs) -> MarkerGroup:
		"""findMarkerGroup(key)

		Find marker group by its key.

		:return: Found marker group.
		:rtype: Metashape.MarkerGroup"""
	...
	def findModel (self, *args, **kwargs) -> Model:
		"""findModel(key)

		Find model by its key.

		:return: Found model.
		:rtype: Metashape.Model"""
	...
	def findModelGroup (self, *args, **kwargs) -> ModelGroup:
		"""findModelGroup(key)

		Find model group by its key.

		:arg key: Model group key.
		:type key: int
		:return: Found model group.
		:rtype: Metashape.ModelGroup"""
	...
	def findOrthomosaic (self, *args, **kwargs) -> Orthomosaic:
		"""findOrthomosaic(key)

		Find orthomosaic by its key.

		:return: Found orthomosaic.
		:rtype: Metashape.Orthomosaic"""
	...
	def findPointCloud (self, *args, **kwargs) -> PointCloud:
		"""findPointCloud(key)

		Find point cloud by its key.

		:return: Found point cloud.
		:rtype: Metashape.PointCloud"""
	...
	def findPointCloudGroup (self, *args, **kwargs) -> PointCloudGroup:
		"""findPointCloudGroup(key)

		Find point cloud group by its key.

		:arg key: Point cloud group key.
		:type key: int
		:return: Found point cloud group.
		:rtype: Metashape.PointCloudGroup"""
	...
	def findScalebar (self, *args, **kwargs) -> Scalebar:
		"""findScalebar(key)

		Find scalebar by its key.

		:return: Found scalebar.
		:rtype: Metashape.Scalebar"""
	...
	def findScalebarGroup (self, *args, **kwargs) -> ScalebarGroup:
		"""findScalebarGroup(key)

		Find scalebar group by its key.

		:return: Found scalebar group.
		:rtype: Metashape.ScalebarGroup"""
	...
	def findSensor (self, *args, **kwargs) -> Sensor:
		"""findSensor(key)

		Find sensor by its key.

		:return: Found sensor.
		:rtype: Metashape.Sensor"""
	...
	def findTiledModel (self, *args, **kwargs) -> TiledModel:
		"""findTiledModel(key)

		Find tiled model by its key.

		:return: Found tiled model.
		:rtype: Metashape.TiledModel"""
	...
	def findTrajectory (self, *args, **kwargs) -> Trajectory:
		"""findTrajectory(key)

		Find trajectory by its key.

		:return: Found trajectory.
		:rtype: Metashape.Trajectory"""
	...
	frame:  int
	"""Current frame index.

	:type: int"""

	frames:  list[Chunk]
	"""List of frames in the chunk.

	:type: list[Chunk]"""

	def generateMasks (self, *args, **kwargs):
		"""generateMasks(path='{filename}_mask.png', masking_mode=MaskingModeAlpha, mask_operation=MaskOperationReplacement, tolerance=10, [cameras], replace_asset=True, [frames], mask_defocus=False, fix_coverage=True, blur_threshold=3, depth_threshold=3.40282e+38, [progress])

		Generate masks for multiple cameras.

		:arg path: Mask file name template.
		:type path: str
		:arg masking_mode: Mask generation mode.
		:type masking_mode: Metashape.Metashape.MaskingMode
		:arg mask_operation: Mask operation.
		:type mask_operation: Metashape.Metashape.MaskOperation
		:arg tolerance: Background masking tolerance.
		:type tolerance: int
		:arg cameras: Optional list of cameras to be processed.
		:type cameras: list[int]
		:arg replace_asset: Update default set of masks with generated masks.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg mask_defocus: Mask defocus areas.
		:type mask_defocus: bool
		:arg fix_coverage: Extend masks to cover whole mesh (only if mask_defocus=True).
		:type fix_coverage: bool
		:arg blur_threshold: Allowed blur radius on a photo in pix (only if mask_defocus=True).
		:type blur_threshold: float
		:arg depth_threshold: Maximum depth of masked areas in meters (only if mask_defocus=False).
		:type depth_threshold: float
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def generatePrescriptionMap (self, *args, **kwargs):
		"""generatePrescriptionMap(class_count=4, cell_size=1, classification_method=JenksNaturalBreaksClassification, [boundary_shape_group], [breakpoints], [rates], [progress])

		Generate prescription map for orthomosaic.

		:arg class_count: Number of classes.
		:type class_count: int
		:arg cell_size: Step of prescription grid, meters.
		:type cell_size: float
		:arg classification_method: Index values classification method.
		:type classification_method: Metashape.Metashape.ClassificationMethod
		:arg boundary_shape_group: Boundary shape group.
		:type boundary_shape_group: int
		:arg breakpoints: Classification breakpoints.
		:type breakpoints: list[float]
		:arg rates: Fertilizer rate for each class.
		:type rates: list[float]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	image_brightness:  float
	"""Image brightness as percentage.

	:type: float"""

	image_contrast:  float
	"""Image contrast as percentage.

	:type: float"""

	def importCameras (self, *args, **kwargs):
		"""importCameras(path='', format=CamerasFormatXML, [crs], image_orientation=0, image_list='list.txt', load_image_list=False, [progress])

		Import camera positions.

		:arg path: Path to the file.
		:type path: str
		:arg format: File format.
		:type format: Metashape.Metashape.CamerasFormat
		:arg crs: Ground coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg image_orientation: Image coordinate system (0 - X right, 1 - X up, 2 - X left, 3 - X down).
		:type image_orientation: int
		:arg image_list: Path to image list file (Bundler format only).
		:type image_list: str
		:arg load_image_list: Enable Bundler image list import.
		:type load_image_list: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importDepthImages (self, *args, **kwargs):
		"""importDepthImages(format=PointCloudFormatNone, [filenames], [color_filenames], image_path='', multiplane=False, [progress])

		Import images with depth data.

		:arg format: Point cloud format.
		:type format: Metashape.Metashape.PointCloudFormat
		:arg filenames: List of files to import. Either smartphone depth photos or depth images with corresponding color images in color_filenames parameter.
		:type filenames: list[str]
		:arg color_filenames: List of corresponding color files, if present.
		:type color_filenames: list[str]
		:arg image_path: Path template to output pre-processed files.
		:type image_path: str
		:arg multiplane: Import as a multi-camera system
		:type multiplane: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importMarkers (self, *args, **kwargs):
		"""importMarkers(path='', [progress])

		Import markers.

		:arg path: Path to the file.
		:type path: str
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importModel (self, *args, **kwargs):
		"""importModel(path='', format=ModelFormatNone, [crs], [shift], decode_udim=True, replace_asset=False, [frame_paths], [progress])

		Import model from file.

		:arg path: Path to model.
		:type path: str
		:arg format: Model format.
		:type format: Metashape.Metashape.ModelFormat
		:arg crs: Model coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg shift: Optional shift to be applied to vertex coordinates.
		:type shift: Metashape.Vector
		:arg decode_udim: Load UDIM texture layout.
		:type decode_udim: bool
		:arg replace_asset: Replace default asset with imported model.
		:type replace_asset: bool
		:arg frame_paths: List of model paths to import in each frame of a multiframe chunk.
		:type frame_paths: list[str]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importPointCloud (self, *args, **kwargs):
		"""importPointCloud(path='', format=PointCloudFormatNone, [crs], [shift], precision=0, columns='xyz', delimiter=' ', group_delimiters=False, skip_rows=0, is_laser_scan=False, replace_asset=False, load_point_color=True, load_point_normal=True, load_point_intensity=True, load_point_classification=True, load_point_confidence=True, load_point_return_number=True, load_point_scan_angle=True, load_point_source_id=True, load_point_timestamp=True, load_point_index=True, load_images=True, generate_panorama=True, calculate_normals=True, point_neighbors=28, scanner_at_origin=False, ignore_scanner_origin=False, ignore_trajectory=False, [trajectory], [frame_paths], [progress])

		Import point cloud from file.

		:arg path: Path to point cloud.
		:type path: str
		:arg format: Point cloud format.
		:type format: Metashape.Metashape.PointCloudFormat
		:arg crs: Point cloud coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg shift: Optional shift to be applied to point coordinates.
		:type shift: Metashape.Vector
		:arg precision: Coordinate precision (m). For default precision use 0.
		:type precision: float
		:arg columns: Column order (x/y/z - coordinates, X/Y/Z - normal, r/g/b - color, i - intensity, t - time, c - classification, space - skip column).
		:type columns: str
		:arg delimiter: CSV delimiter.
		:type delimiter: str
		:arg group_delimiters: Combine consecutive delimiters in csv format.
		:type group_delimiters: bool
		:arg skip_rows: Number of rows to skip.
		:type skip_rows: int
		:arg is_laser_scan: Import point clouds as laser scans.
		:type is_laser_scan: bool
		:arg replace_asset: Replace default asset with imported point cloud.
		:type replace_asset: bool
		:arg load_point_color: Import point color.
		:type load_point_color: bool
		:arg load_point_normal: Import point normal.
		:type load_point_normal: bool
		:arg load_point_intensity: Import point intensity.
		:type load_point_intensity: bool
		:arg load_point_classification: Import point classification.
		:type load_point_classification: bool
		:arg load_point_confidence: Import point confidence.
		:type load_point_confidence: bool
		:arg load_point_return_number: Import point return number.
		:type load_point_return_number: bool
		:arg load_point_scan_angle: Import point scan angle.
		:type load_point_scan_angle: bool
		:arg load_point_source_id: Import point source ID.
		:type load_point_source_id: bool
		:arg load_point_timestamp: Import point timestamp.
		:type load_point_timestamp: bool
		:arg load_point_index: Import point row and column indices.
		:type load_point_index: bool
		:arg load_images: Import images embedded in laser scan.
		:type load_images: bool
		:arg generate_panorama: Generate panorama from point colors.
		:type generate_panorama: bool
		:arg calculate_normals: Calculate point normals.
		:type calculate_normals: bool
		:arg point_neighbors: Number of point neighbors to use for normal estimation.
		:type point_neighbors: int
		:arg scanner_at_origin: Use laser scan origin as scanner position for unstructured point clouds.
		:type scanner_at_origin: bool
		:arg ignore_scanner_origin: Do not use laser scan origin as scanner position for structured point clouds.
		:type ignore_scanner_origin: bool
		:arg ignore_trajectory: Do not attach trajectory to imported point cloud.
		:type ignore_trajectory: bool
		:arg trajectory: Trajectory key to attach.
		:type trajectory: int
		:arg frame_paths: List of point cloud paths to import in each frame of a multiframe chunk.
		:type frame_paths: list[str]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importRaster (self, *args, **kwargs):
		"""importRaster(path='', [crs], raster_type=ElevationData, nodata_value=-32767, has_nodata_value=False, replace_asset=False, [frames], [progress])

		Import DEM or orthomosaic from file.

		:arg path: Path to elevation model in GeoTIFF format.
		:type path: str
		:arg crs: Default coordinate system if not specified in GeoTIFF file.
		:type crs: Metashape.CoordinateSystem
		:arg raster_type: Type of raster layer to import.
		:type raster_type: Metashape.Metashape.DataSource
		:arg nodata_value: No-data value.
		:type nodata_value: float
		:arg has_nodata_value: No-data value valid flag.
		:type has_nodata_value: bool
		:arg replace_asset: Replace default raster with imported one.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importReference (self, *args, **kwargs):
		"""importReference(path='', format=ReferenceFormatCSV, columns='', delimiter='', group_delimiters=False, skip_rows=0, items=ReferenceItemsAll, [crs], rotation_angles=EulerAnglesUndefined, create_markers=False, ignore_labels=False, threshold=0.1, load_rotation=True, load_location_accuracy=False, load_rotation_accuracy=False, load_enabled=False, column_enabled=10, column_label=1, column_x=2, column_y=3, column_z=4, column_sx=8, column_sy=8, column_sz=8, column_a=5, column_b=6, column_c=7, column_sa=9, column_sb=9, column_sc=9, shutter_lag=0, [progress])

		Import reference data from the specified file.

		:arg path: Path to the file with reference data.
		:type path: str
		:arg format: File format.
		:type format: Metashape.Metashape.ReferenceFormat
		:arg columns: Column order in CSV format (n - label, o - enabled flag, x/y/z - coordinates, X/Y/Z - coordinate accuracy, a/b/c - rotation angles, A/B/C - rotation angle accuracy, [] - group of multiple values, | - column separator within group).
		:type columns: str
		:arg delimiter: Column delimiter (CSV format only).
		:type delimiter: str
		:arg group_delimiters: Combine consecutive delimiters (CSV format only).
		:type group_delimiters: bool
		:arg skip_rows: Number of rows to skip (CSV format only).
		:type skip_rows: int
		:arg items: Items to load reference for (CSV format only).
		:type items: Metashape.Metashape.ReferenceItems
		:arg crs: Reference data coordinate system (CSV format only).
		:type crs: Metashape.CoordinateSystem
		:arg rotation_angles: Euler angles triplet used for rotation reference (CSV format only).
		:type rotation_angles: Metashape.Metashape.EulerAngles
		:arg create_markers: Create markers for missing entries (CSV format only).
		:type create_markers: bool
		:arg ignore_labels: Matches reference data based on coordinates alone (CSV format only).
		:type ignore_labels: bool
		:arg threshold: Error threshold in meters used when ignore_labels is set (CSV format only).
		:type threshold: float
		:arg load_rotation: Load rotation angles (CSV format only).
		:type load_rotation: bool
		:arg load_location_accuracy: Load location accuracy (CSV format only).
		:type load_location_accuracy: bool
		:arg load_rotation_accuracy: Load rotation accuracy (CSV format only).
		:type load_rotation_accuracy: bool
		:arg load_enabled: Load enabled flag (CSV format only).
		:type load_enabled: bool
		:arg column_enabled: Enabled flag column (CSV format only).
		:type column_enabled: int
		:arg column_label: Label column (CSV format only).
		:type column_label: int
		:arg column_x: X coordinate column (CSV format only).
		:type column_x: int
		:arg column_y: Y coordinate column (CSV format only).
		:type column_y: int
		:arg column_z: Z coordinate column (CSV format only).
		:type column_z: int
		:arg column_sx: X coordinate accuracy column (CSV format only).
		:type column_sx: int
		:arg column_sy: Y coordinate accuracy column (CSV format only).
		:type column_sy: int
		:arg column_sz: Z coordinate accuracy column (CSV format only).
		:type column_sz: int
		:arg column_a: 1st rotation angle column (CSV format only).
		:type column_a: int
		:arg column_b: 2nd rotation angle column (CSV format only).
		:type column_b: int
		:arg column_c: 3rd rotation angle column (CSV format only).
		:type column_c: int
		:arg column_sa: 1st rotation angle accuracy column (CSV format only).
		:type column_sa: int
		:arg column_sb: 2nd rotation angle accuracy column (CSV format only).
		:type column_sb: int
		:arg column_sc: 3rd rotation angle accuracy column (CSV format only).
		:type column_sc: int
		:arg shutter_lag: Shutter lag in seconds (APM format only).
		:type shutter_lag: float
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importShapes (self, *args, **kwargs):
		"""importShapes(path='', replace=False, boundary_type=NoBoundary, format=ShapesFormatNone, columns='nxyzd', delimiter=',', group_delimiters=False, skip_rows=0, [crs], [progress])

		Import shapes layer from file.

		:arg path: Path to shape file.
		:type path: str
		:arg replace: Replace current shapes with new data.
		:type replace: bool
		:arg boundary_type: Boundary type to be applied to imported shapes.
		:type boundary_type: Metashape.Shape.BoundaryType
		:arg format: Shapes format.
		:type format: Metashape.Metashape.ShapesFormat
		:arg columns: Column order in csv format (n - label, x/y/z - coordinates, d - description, [] - group of multiple values, | - column separator within group).
		:type columns: str
		:arg delimiter: Column delimiter in csv format.
		:type delimiter: str
		:arg group_delimiters: Combine consequitive delimiters in csv format.
		:type group_delimiters: bool
		:arg skip_rows: Number of rows to skip in (csv format only).
		:type skip_rows: int
		:arg crs: Reference data coordinate system (csv format only).
		:type crs: Metashape.CoordinateSystem
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importTiledModel (self, *args, **kwargs):
		"""importTiledModel(path='', [progress])

		Import tiled model from file.

		:arg path: Path to tiled model.
		:type path: str
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importTrajectory (self, *args, **kwargs):
		"""importTrajectory(path='', format=TrajectoryFormatNone, columns='txyz', delimiter=' ', group_delimiters=False, skip_rows=0, [crs], [shift], replace_asset=False, [progress])

		Import trajectory from file.

		:arg path: Trajectory file path.
		:type path: str
		:arg format: Trajectory format.
		:type format: Metashape.Metashape.TrajectoryFormat
		:arg columns: Column order in csv format (t - time, x/y/z - coordinates, a/b/c - rotation angles, space - skip column).
		:type columns: str
		:arg delimiter: Column delimiter in csv format.
		:type delimiter: str
		:arg group_delimiters: Combine consecutive delimiters in csv format.
		:type group_delimiters: bool
		:arg skip_rows: Number of rows to skip in (csv format only).
		:type skip_rows: int
		:arg crs: Point cloud coordinate system.
		:type crs: Metashape.CoordinateSystem
		:arg shift: Optional shift to be applied to point coordinates.
		:type shift: Metashape.Vector
		:arg replace_asset: Replace default asset with imported trajectory.
		:type replace_asset: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def importVideo (self, *args, **kwargs):
		"""importVideo(path='', image_path='', frame_step=CustomFrameStep, custom_frame_step=1, time_start=0, time_end=-1, [progress])

		Import video frames from file.

		:arg path: Path to source video.
		:type path: str
		:arg image_path: Path to directory where to save frames with filename template. For example: /path/to/dir/frame{filenum}.png.
		:type image_path: str
		:arg frame_step: Frame step type.
		:type frame_step: Metashape.Metashape.FrameStep
		:arg custom_frame_step: Every custom_frame_step'th frame will be saved. Used for frame_step=CustomFrameStep.
		:type custom_frame_step: int
		:arg time_start: The starting point for importing video, seconds.
		:type time_start: float
		:arg time_end: The endpoint for importing video, seconds.
		:type time_end: float
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	key:  int
	"""Chunk identifier.

	:type: int"""

	label:  str
	"""Chunk label.

	:type: str"""

	def loadReferenceExif (self, *args, **kwargs):
		"""loadReferenceExif(load_rotation=False, load_accuracy=False)

		Import camera locations from EXIF meta data.

		:arg load_rotation: Load yaw, pitch and roll orientation angles.
		:type load_rotation: bool
		:arg load_accuracy: Load camera location accuracy.
		:type load_accuracy: bool"""
	...
	def loadReflectancePanelCalibration (self, *args, **kwargs):
		"""loadReflectancePanelCalibration(path, [cameras])

		Load reflectance panel calibration from CSV file.

		:arg path: Path to calibration file.
		:type path: str
		:arg cameras: List of cameras to process.
		:type cameras: list[Metashape.Camera]"""
	...
	def locateReflectancePanels (self, *args, **kwargs):
		"""locateReflectancePanels([progress])

		Locate reflectance panels based on QR-codes.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	marker_crs:  CoordinateSystem
	"""Coordinate system used for marker reference data.

	:type: CoordinateSystem"""

	marker_groups:  list[MarkerGroup]
	"""List of marker groups in the chunk.

	:type: list[MarkerGroup]"""

	marker_location_accuracy:  Vector
	"""Expected accuracy of marker coordinates in meters.

	:type: Vector"""

	marker_projection_accuracy:  float
	"""Expected accuracy of marker projections in pixels.

	:type: float"""

	markers:  list[Marker]
	"""List of Regular, Vertex and Fiducial markers in the chunk.

	:type: list[Marker]"""

	mask_sets:  list[Masks]
	"""List of mask sets for the current frame.

	:type: list[Masks]"""

	masks:  Masks
	"""Image masks.

	:type: Masks"""

	def matchPhotos (self, *args, **kwargs):
		"""matchPhotos(downscale=1, downscale_3d=1, generic_preselection=True, reference_preselection=True, reference_preselection_mode=ReferencePreselectionSource, filter_mask=False, mask_tiepoints=True, filter_stationary_points=True, keypoint_limit=40000, keypoint_limit_3d=100000, keypoint_limit_per_mpx=1000, tiepoint_limit=4000, keep_keypoints=False, [pairs], [cameras], guided_matching=False, reset_matches=False, subdivide_task=True, workitem_size_cameras=20, workitem_size_pairs=80, max_workgroup_size=100, laser_scans_vertical_axis=0, laser_scans_use_initial_orientation=False, match_laser_scans=False, [progress])

		Perform image matching for the chunk frame.

		:arg downscale: Image alignment accuracy (0 - Highest, 1 - High, 2 - Medium, 4 - Low, 8 - Lowest).
		:type downscale: int
		:arg downscale_3d: Laser scan alignment accuracy (1 - Highest, 2 - High, 4 - Medium, 8 - Low, 16 - Lowest).
		:type downscale_3d: int
		:arg generic_preselection: Enable generic preselection.
		:type generic_preselection: bool
		:arg reference_preselection: Enable reference preselection.
		:type reference_preselection: bool
		:arg reference_preselection_mode: Reference preselection mode.
		:type reference_preselection_mode: Metashape.Metashape.ReferencePreselectionMode
		:arg filter_mask: Filter points by mask.
		:type filter_mask: bool
		:arg mask_tiepoints: Apply mask filter to tie points.
		:type mask_tiepoints: bool
		:arg filter_stationary_points: Exclude tie points which are stationary across images.
		:type filter_stationary_points: bool
		:arg keypoint_limit: Key point limit.
		:type keypoint_limit: int
		:arg keypoint_limit_3d: Key point limit for laser scans.
		:type keypoint_limit_3d: int
		:arg keypoint_limit_per_mpx: Key point limit per megapixel.
		:type keypoint_limit_per_mpx: int
		:arg tiepoint_limit: Tie point limit.
		:type tiepoint_limit: int
		:arg keep_keypoints: Store keypoints in the project.
		:type keep_keypoints: bool
		:arg pairs: User defined list of camera pairs to match.
		:type pairs: list[tuple[int, int]]
		:arg cameras: List of cameras to match.
		:type cameras: list[int]
		:arg guided_matching: Enable guided image matching.
		:type guided_matching: bool
		:arg reset_matches: Reset current matches.
		:type reset_matches: bool
		:arg subdivide_task: Enable fine-level task subdivision.
		:type subdivide_task: bool
		:arg workitem_size_cameras: Number of cameras in a workitem.
		:type workitem_size_cameras: int
		:arg workitem_size_pairs: Number of image pairs in a workitem.
		:type workitem_size_pairs: int
		:arg max_workgroup_size: Maximum workgroup size.
		:type max_workgroup_size: int
		:arg laser_scans_vertical_axis: Common laser scans axis.
		:type laser_scans_vertical_axis: int
		:arg laser_scans_use_initial_orientation: Use initial laser scan orientation for keypoint matching.
		:type laser_scans_use_initial_orientation: bool
		:arg match_laser_scans: Match laser scans using geometric features.
		:type match_laser_scans: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def mergeComponents (self, *args, **kwargs):
		"""mergeComponents(components, [progress])

		Merge components.

		:arg components: List of components to merge.
		:type components: list[Metashape.Component]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	meta:  MetaData
	"""Chunk meta data.

	:type: MetaData"""

	model:  Model
	"""Default model for the current frame.

	:type: Model"""

	model_group:  ModelGroup
	"""Default model group for the current chunk.

	:type: ModelGroup"""

	model_groups:  list[ModelGroup]
	"""List of model groups in the chunk.

	:type: list[ModelGroup]"""

	models:  list[Model]
	"""List of models for the current frame.

	:type: list[Model]"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def optimizeCameras (self, *args, **kwargs):
		"""optimizeCameras(fit_f=True, fit_cx=True, fit_cy=True, fit_b1=False, fit_b2=False, fit_k1=True, fit_k2=True, fit_k3=True, fit_k4=False, fit_p1=True, fit_p2=True, fit_corrections=False, adaptive_fitting=False, tiepoint_covariance=False, [progress])

		Perform optimization of tie points / camera parameters.

		:arg fit_f: Enable optimization of focal length coefficient.
		:type fit_f: bool
		:arg fit_cx: Enable optimization of X principal point coordinates.
		:type fit_cx: bool
		:arg fit_cy: Enable optimization of Y principal point coordinates.
		:type fit_cy: bool
		:arg fit_b1: Enable optimization of aspect ratio.
		:type fit_b1: bool
		:arg fit_b2: Enable optimization of skew coefficient.
		:type fit_b2: bool
		:arg fit_k1: Enable optimization of k1 radial distortion coefficient.
		:type fit_k1: bool
		:arg fit_k2: Enable optimization of k2 radial distortion coefficient.
		:type fit_k2: bool
		:arg fit_k3: Enable optimization of k3 radial distortion coefficient.
		:type fit_k3: bool
		:arg fit_k4: Enable optimization of k3 radial distortion coefficient.
		:type fit_k4: bool
		:arg fit_p1: Enable optimization of p1 tangential distortion coefficient.
		:type fit_p1: bool
		:arg fit_p2: Enable optimization of p2 tangential distortion coefficient.
		:type fit_p2: bool
		:arg fit_corrections: Enable optimization of additional corrections.
		:type fit_corrections: bool
		:arg adaptive_fitting: Enable adaptive fitting of distortion coefficients.
		:type adaptive_fitting: bool
		:arg tiepoint_covariance: Estimate tie point covariance matrices.
		:type tiepoint_covariance: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	orthomosaic:  Orthomosaic
	"""Default orthomosaic for the current frame.

	:type: Orthomosaic"""

	orthomosaics:  list[Orthomosaic]
	"""List of orthomosaics for the current frame.

	:type: list[Orthomosaic]"""

	def pansharpenOrthomosaic (self, *args, **kwargs):
		"""pansharpenOrthomosaic([orthomosaic], channels=0, [pan_orthomosaic], pan_channels=0, clip_to_pan_data=False, replace_asset=False, [frames], [progress])

		Pansharpen orthomosaic.

		:arg orthomosaic: Orthomosaic to pansharpen.
		:type orthomosaic: int
		:arg channels: Orthomosaic channel mask (boolean flags, e.g. 0b0010 means only 1st channel is used and the rest ignored).
		:type channels: int
		:arg pan_orthomosaic: Detailed orthomosaic.
		:type pan_orthomosaic: int
		:arg pan_channels: Detailed orthomosaic channel mask (boolean flags, e.g. 0b0010 means only 1st channel is used and the rest ignored).
		:type pan_channels: int
		:arg clip_to_pan_data: Clip result to high resolution orthomosaic.
		:type clip_to_pan_data: bool
		:arg replace_asset: Replace source orthomosaic with pansharpened result.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	point_cloud:  PointCloud
	"""Default point cloud for the current frame.

	:type: PointCloud"""

	point_cloud_groups:  list[PointCloudGroup]
	"""List of point cloud groups in the chunk.

	:type: list[PointCloudGroup]"""

	point_clouds:  list[PointCloud]
	"""List of point clouds for the current frame.

	:type: list[PointCloud]"""

	primary_channel:  int
	"""Primary channel index (-1 for default).

	:type: int"""

	def publishData (self, *args, **kwargs):
		"""publishData(service=ServiceSketchfab, source_data=TiePointsData, raster_transform=RasterTransformNone, save_point_color=True, save_camera_track=True, title='', description='', tags='', owner='', token='', username='', password='', account='', hostname='', is_draft=False, is_private=False, is_protected=False, tile_size=256, min_zoom_level=-1, max_zoom_level=-1, [projection], resolution=0, project_id='', upload_images=False, [point_classes], [image_compression], [progress])

		Publish generated data online.

		:arg service: Service to upload on.
		:type service: Metashape.Metashape.ServiceType
		:arg source_data: Asset type to upload.
		:type source_data: Metashape.Metashape.DataSource
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.Metashape.RasterTransformType
		:arg save_point_color: Enables/disables export of point colors.
		:type save_point_color: bool
		:arg save_camera_track: Enables/disables export of camera track.
		:type save_camera_track: bool
		:arg title: Dataset title.
		:type title: str
		:arg description: Dataset description.
		:type description: str
		:arg tags: Dataset tags.
		:type tags: str
		:arg owner: Account owner (Cesium and Mapbox services).
		:type owner: str
		:arg token: Account token (Cesium, Mapbox, Nira (Key Secret), Picterra, Pointbox and Sketchfab services).
		:type token: str
		:arg username: Account username (4DMapper, Agisoft Cloud and Pointscene services).
		:type username: str
		:arg password: Account password (4DMapper, Agisoft Cloud, Pointscene and Sketchfab services).
		:type password: str
		:arg account: Account name (Nira (Key ID) service).
		:type account: str
		:arg hostname: Service hostname (4DMapper and Nira services).
		:type hostname: str
		:arg is_draft: Mark dataset as draft (Sketchfab service).
		:type is_draft: bool
		:arg is_private: Set dataset access to private (Pointbox and Sketchfab services).
		:type is_private: bool
		:arg is_protected: Set dataset access to protected (Pointbox service).
		:type is_protected: bool
		:arg tile_size: Tile size in pixels.
		:type tile_size: int
		:arg min_zoom_level: Minimum zoom level.
		:type min_zoom_level: int
		:arg max_zoom_level: Maximum zoom level.
		:type max_zoom_level: int
		:arg projection: Output projection.
		:type projection: Metashape.CoordinateSystem
		:arg resolution: Output resolution in meters.
		:type resolution: float
		:arg project_id: Id of a target project (from Agisoft Cloud project URL).
		:type project_id: str
		:arg upload_images: Attach photos to Nira publication.
		:type upload_images: bool
		:arg point_classes: List of point classes to be exported.
		:type point_classes: list[int]
		:arg image_compression: Image compression parameters.
		:type image_compression: Metashape.ImageCompression
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	raster_transform:  RasterTransform
	"""Raster transform.

	:type: RasterTransform"""

	def reduceOverlap (self, *args, **kwargs):
		"""reduceOverlap(overlap=3, use_selection=False, [progress])

		Disable redundant cameras.

		:arg overlap: Target number of cameras observing each point of the surface.
		:type overlap: int
		:arg use_selection: Focus on model selection.
		:type use_selection: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def refineMarkers (self, *args, **kwargs):
		"""refineMarkers([markers], [progress])

		Refine markers based on images content.

		:arg markers: Optional list of markers to be processed.
		:type markers: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def refineModel (self, *args, **kwargs):
		"""refineModel(downscale=4, iterations=10, smoothness=0.5, [model], replace_asset=False, [cameras], [frames], [progress])

		Refine polygonal model.

		:arg downscale: Refinement quality (1 - Ultra high, 2 - High, 4 - Medium, 8 - Low, 16 - Lowest).
		:type downscale: int
		:arg iterations: Number of refinement iterations.
		:type iterations: int
		:arg smoothness: Smoothing strength. Should be in range [0, 1].
		:type smoothness: float
		:arg model: Model to process.
		:type model: int
		:arg replace_asset: Replace default asset with refined model.
		:type replace_asset: bool
		:arg cameras: List of cameras to process.
		:type cameras: list[int]
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	region:  Region
	"""Reconstruction volume selection.

	:type: Region"""

	def remove (self, *args, **kwargs):
		"""remove(items)

		Remove items from the chunk.

		:arg items: A list of items to be removed.
		:type items: list[Metashape.Chunk | Metashape.Sensor | Metashape.Component | Metashape.CameraGroup | Metashape.MarkerGroup | Metashape.ScalebarGroup | Metashape.Camera | Metashape.Marker | Metashape.Scalebar | Metashape.CameraTrack | Metashape.DepthMaps | Metashape.PointCloud | Metashape.PointCloudGroup | Metashape.Model | Metashape.ModelGroup | Metashape.TiledModel | Metashape.Elevation | Metashape.Orthomosaic | Metashape.Trajectory]"""
	...
	def removeLighting (self, *args, **kwargs):
		"""removeLighting(color_mode=False, internal_blur=1.5, mesh_noise_suppression=1, ambient_occlusion_path='', ambient_occlusion_multiplier=1.5, [progress])

		Generate model for the chunk frame.

		:arg color_mode: Enable multi-color processing mode.
		:type color_mode: bool
		:arg internal_blur: Internal blur. Should be in range [0, 4].
		:type internal_blur: float
		:arg mesh_noise_suppression: Mesh normals noise suppression strength. Should be in range [0, 4].
		:type mesh_noise_suppression: float
		:arg ambient_occlusion_path: Path to ambient occlusion texture atlas. Can be empty.
		:type ambient_occlusion_path: str
		:arg ambient_occlusion_multiplier: Ambient occlusion multiplier. Should be in range [0.25, 4].
		:type ambient_occlusion_multiplier: float
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def renderPreview (self, *args, **kwargs) -> Image:
		"""renderPreview(width = 2048, height = 2048, [transform], point_size=1, [progress])

		Generate preview image for the chunk.

		:arg width: Preview image width.
		:type width: int
		:arg height: Preview image height.
		:type height: int
		:arg transform: 4x4 viewpoint transformation matrix.
		:type transform: Metashape.Matrix
		:arg point_size: Point size.
		:type point_size: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Preview image.
		:rtype: Metashape.Image"""
	...
	def resetRegion (self, *args, **kwargs):
		"""resetRegion()

		Reset reconstruction volume selector to default position."""
	...
	scalebar_accuracy:  float
	"""Expected scale bar accuracy in meters.

	:type: float"""

	scalebar_groups:  list[ScalebarGroup]
	"""List of scale bar groups in the chunk.

	:type: list[ScalebarGroup]"""

	scalebars:  list[Scalebar]
	"""List of scale bars in the chunk.

	:type: list[Scalebar]"""

	selected:  bool
	"""Selects/deselects the chunk.

	:type: bool"""

	sensors:  list[Sensor]
	"""List of sensors in the chunk.

	:type: list[Sensor]"""

	shapes:  Shapes
	"""Shapes for the current frame.

	:type: Shapes"""

	def smoothModel (self, *args, **kwargs):
		"""smoothModel(strength=3, apply_to_selection=False, fix_borders=True, preserve_edges=False, [model], replace_asset=False, [frames], [progress])

		Smooth model using Laplacian smoothing algorithm.

		:arg strength: Smoothing strength.
		:type strength: float
		:arg apply_to_selection: Apply to selected faces.
		:type apply_to_selection: bool
		:arg fix_borders: Fix borders.
		:type fix_borders: bool
		:arg preserve_edges: Preserve edges.
		:type preserve_edges: bool
		:arg model: Key of model to smooth.
		:type model: int
		:arg replace_asset: Replace default asset with smoothed model.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def smoothPointCloud (self, *args, **kwargs):
		"""smoothPointCloud(smoothing_radius=0, [point_cloud], [classes], apply_to_selection=False, clip_to_region=False, replace_asset=False, [frames], [progress])

		Smooth point cloud.

		:arg smoothing_radius: Desired smoothing radius (m).
		:type smoothing_radius: float
		:arg point_cloud: Key of point cloud to filter.
		:type point_cloud: int
		:arg classes: List of point classes to be smoothed.
		:type classes: list[int]
		:arg apply_to_selection: Smooth points within selection.
		:type apply_to_selection: bool
		:arg clip_to_region: Clip point cloud to chunk region.
		:type clip_to_region: bool
		:arg replace_asset: Replace default asset with smoothed point cloud.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def sortCameras (self, *args, **kwargs):
		"""sortCameras()

		Sorts cameras by their labels."""
	...
	def sortMarkers (self, *args, **kwargs):
		"""sortMarkers()

		Sorts markers by their labels."""
	...
	def sortScalebars (self, *args, **kwargs):
		"""sortScalebars()

		Sorts scalebars by their labels."""
	...
	def splitComponents (self, *args, **kwargs):
		"""splitComponents(items, [progress])

		Split components.

		:arg items: List of items to split.
		:type items: list[Metashape.Camera | Metashape.PointCloud]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def thinTiePoints (self, *args, **kwargs):
		"""thinTiePoints(point_limit=1000)

		Remove excessive tracks from the tie point cloud.

		:arg point_limit: Maximum number of points for each photo.
		:type point_limit: int"""
	...
	thumbnails:  Thumbnails
	"""Image thumbnails.

	:type: Thumbnails"""

	tie_points:  TiePoints
	"""Generated tie point cloud.

	:type: TiePoints"""

	tiepoint_accuracy:  float
	"""Expected tie point accuracy in pixels.

	:type: float"""

	tiled_model:  TiledModel
	"""Default tiled model for the current frame.

	:type: TiledModel"""

	tiled_models:  list[TiledModel]
	"""List of tiled models for the current frame.

	:type: list[TiledModel]"""

	def trackMarkers (self, *args, **kwargs):
		"""trackMarkers(first_frame=0, last_frame=0, [progress])

		Track marker projections through the frame sequence.

		:arg first_frame: Starting frame index.
		:type first_frame: int
		:arg last_frame: Ending frame index.
		:type last_frame: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	trajectories:  list[Trajectory]
	"""List of trajectories for the current frame.

	:type: list[Trajectory]"""

	trajectory:  Trajectory
	"""Default trajectory for the current frame.

	:type: Trajectory"""

	transform:  ChunkTransform
	"""4x4 matrix specifying chunk location in the world coordinate system.

	:type: ChunkTransform"""

	def transformRaster (self, *args, **kwargs):
		"""transformRaster(source_data=ElevationData, [asset], subtract=False, [operand_chunk], [operand_frame], [operand_asset], width=0, height=0, [world_transform], resolution=0, resolution_x=0, resolution_y=0, nodata_value=-32767, north_up=True, [region], [projection], clip_to_boundary=True, copy_orthophotos=True, replace_asset=False, [frames], [progress])

		Transform DEM or orthomosaic.

		:arg source_data: Selects between DEM and orthomosaic.
		:type source_data: Metashape.Metashape.DataSource
		:arg asset: Asset key to transform.
		:type asset: int
		:arg subtract: Subtraction flag.
		:type subtract: bool
		:arg operand_chunk: Operand chunk key.
		:type operand_chunk: int
		:arg operand_frame: Operand frame key.
		:type operand_frame: int
		:arg operand_asset: Operand asset key.
		:type operand_asset: int
		:arg width: Raster width.
		:type width: int
		:arg height: Raster height.
		:type height: int
		:arg world_transform: 2x3 raster-to-world transformation matrix.
		:type world_transform: Metashape.Matrix
		:arg resolution: Output resolution in meters.
		:type resolution: float
		:arg resolution_x: Pixel size in the X dimension in projected units.
		:type resolution_x: float
		:arg resolution_y: Pixel size in the Y dimension in projected units.
		:type resolution_y: float
		:arg nodata_value: No-data value (DEM export only).
		:type nodata_value: float
		:arg north_up: Use north-up orientation for export.
		:type north_up: bool
		:arg region: Region to be processed.
		:type region: Metashape.BBox
		:arg projection: Output projection.
		:type projection: Metashape.OrthoProjection
		:arg clip_to_boundary: Clip raster to boundary shapes.
		:type clip_to_boundary: bool
		:arg copy_orthophotos: Copy orthophotos (orthomosaic asset type only).
		:type copy_orthophotos: bool
		:arg replace_asset: Replace default raster with transformed one.
		:type replace_asset: bool
		:arg frames: List of frames to process.
		:type frames: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def triangulateTiePoints (self, *args, **kwargs):
		"""triangulateTiePoints(max_error=10, min_image=2, [progress])

		Rebuild tie point cloud for the chunk.

		:arg max_error: Reprojection error threshold.
		:type max_error: float
		:arg min_image: Minimum number of point projections.
		:type min_image: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def updateTransform (self, *args, **kwargs):
		"""updateTransform()

		Update chunk transformation based on reference data."""
	...
	world_crs:  CoordinateSystem
	"""Coordinate system used as world coordinate system.

	:type: CoordinateSystem"""


class ChunkTransform:
	def copy (self, *args, **kwargs) -> ChunkTransform:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.ChunkTransform"""
	...
	matrix:  Matrix
	"""Transformation matrix.

	:type: Matrix"""

	rotation:  Matrix
	"""Rotation component.

	:type: Matrix"""

	scale:  float
	"""Scale component.

	:type: float"""

	translation:  Vector
	"""Translation component.

	:type: Vector"""


class CirTransform:
	def calibrate (self, *args, **kwargs):
		"""calibrate()

		Calibrate CIR matrix based on orthomosaic histogram."""
	...
	coeffs:  Matrix
	"""Color matrix.

	:type: Matrix"""

	def copy (self, *args, **kwargs) -> CirTransform:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.CirTransform"""
	...
	def reset (self, *args, **kwargs):
		"""reset()

		Reset CIR calibration matrix."""
	...

class ClassificationMethod:
	EqualIntervalsClassification: Any
	"""Index values classification method in [EqualIntervalsClassification, JenksNaturalBreaksClassification]"""

	JenksNaturalBreaksClassification: Any
	"""Index values classification method in [EqualIntervalsClassification, JenksNaturalBreaksClassification]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class CloudClient:
	def abortProcessing (self, *args, **kwargs):
		"""abortProcessing(document)

		Cancel processing.

		:arg document: Project to cancel.
		:type document: Metashape.Document"""
	...
	client_id:  str
	"""Client software id (optional).

	:type: str"""

	client_secret:  str
	"""Client software secret (optional).

	:type: str"""

	def downloadProject (self, *args, **kwargs):
		"""downloadProject(document, [progress])

		Download project from the cloud.

		:arg document: Project to download.
		:type document: Metashape.Document
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def getProcessingStatus (self, *args, **kwargs) -> dict:
		"""getProcessingStatus(document)

		Get processing status.

		:arg document: Project being processed.
		:type document: Metashape.Document
		:return: Processing status.
		:rtype: dict"""
	...
	def getProjectList (self, *args, **kwargs) -> list:
		"""getProjectList()

		Get list of projects in the cloud.

		:return: List of projects.
		:rtype: list"""
	...
	password:  str
	"""Cloud account password.

	:type: str"""

	def processProject (self, *args, **kwargs):
		"""processProject(document, tasks)

		Start processing in the cloud.

		:arg document: Project to process.
		:type document: Metashape.Document
		:arg tasks: List of processing tasks to execute.
		:type tasks: list[Metashape.NetworkTask]"""
	...
	def uploadProject (self, *args, **kwargs):
		"""uploadProject(document, publish=False, [progress])

		Upload project to the cloud.

		:arg document: Project to upload.
		:type document: Metashape.Document
		:arg publish: Publish project for online visualization.
		:type publish: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	username:  str
	"""Cloud account username.

	:type: str"""


class Component:
	chunk:  Chunk
	"""Chunk the component belongs to.

	:type: Chunk"""

	key:  int
	"""Component identifier.

	:type: int"""

	label:  str
	"""Component label.

	:type: str"""

	partition:  list
	"""Component partition.

	:type: list"""

	region:  Region
	"""Reconstruction volume selection.

	:type: Region"""

	transform:  ChunkTransform
	"""4x4 matrix specifying chunk location in the world coordinate system.

	:type: ChunkTransform"""


class CoordinateSystem:
	def addGeoid (self, *args, **kwargs):
		"""addGeoid(path)

		Register geoid model.

		:arg path: Path to geoid file.
		:type path: str"""
	...
	authority:  str
	"""Authority identifier of the coordinate system.

	:type: str"""

	def copy (self, *args, **kwargs) -> CoordinateSystem:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.CoordinateSystem"""
	...
	def datumTransform (self, *args, **kwargs) -> Matrix:
		"""datumTransform(source, target)

		Coordinate transformation from source to target coordinate system datum.

		:arg source: Source coordinate system.
		:type source: Metashape.CoordinateSystem
		:arg target: Target coordinate system.
		:type target: Metashape.CoordinateSystem
		:return: 4x4 transformation matrix.
		:rtype: Metashape.Matrix"""
	...
	geoccs:  CoordinateSystem
	"""Base geocentric coordinate system.

	:type: CoordinateSystem"""

	geogcs:  CoordinateSystem
	"""Base geographic coordinate system.

	:type: CoordinateSystem"""

	geoid_height:  float
	"""Fixed geoid height to be used instead of interpolated values.

	:type: float"""

	def init (self, *args, **kwargs):
		"""init(crs)

		Initialize projection based on specified WKT definition or authority identifier.

		:arg crs: WKT definition of coordinate system or authority identifier.
		:type crs: str"""
	...
	def listBuiltinCRS (self, *args, **kwargs):
		"""listBuiltinCRS()

		Returns a list of builtin coordinate systems."""
	...
	def listGeoids (self, *args, **kwargs):
		"""listGeoids()

		Returns a list of loaded geoids."""
	...
	def localframe (self, *args, **kwargs) -> Matrix:
		"""localframe(point)

		Returns 4x4 transformation matrix to LSE coordinates at the given point.

		:arg point: Coordinates of the origin in the geocentric coordinates.
		:type point: Metashape.Vector
		:return: Transformation from geocentric coordinates to local coordinates.
		:rtype: Metashape.Matrix"""
	...
	name:  str
	"""Name of the coordinate system.

	:type: str"""

	proj4:  str
	"""Coordinate system definition in PROJ.4 format.

	:type: str"""

	def project (self, *args, **kwargs) -> Vector:
		"""project(point)

		Projects point from geocentric coordinates to projected geographic coordinate system.

		:arg point: 3D point in geocentric coordinates.
		:type point: Metashape.Vector
		:return: 3D point in projected coordinates.
		:rtype: Metashape.Vector"""
	...
	def setContext (self, *args, **kwargs):
		"""setContext(document)

		Set geoid lookup context.

		:arg document: Document to use for geoid lookup.
		:type document: Metashape.Document"""
	...
	towgs84:  list[float]
	"""TOWGS84 transformation parameters (dx, dy, dz, rx, ry, rz, scale).

	:type: list[float]"""

	def transform (self, *args, **kwargs) -> Vector:
		"""transform(point, source, target)

		Transform point coordinates between coordinate systems.

		:arg point: 2D or 3D point coordinates.
		:type point: Metashape.Vector
		:arg source: Source coordinate system.
		:type source: Metashape.CoordinateSystem
		:arg target: Target coordinate system.
		:type target: Metashape.CoordinateSystem
		:return: Transformed point coordinates.
		:rtype: Metashape.Vector"""
	...
	def transformationMatrix (self, *args, **kwargs) -> Matrix:
		"""transformationMatrix(point, source, target)

		Local approximation of coordinate transformation from source to target coordinate system at the given point.

		:arg point: 3D point coordinates.
		:type point: Metashape.Vector
		:arg source: Source coordinate system.
		:type source: Metashape.CoordinateSystem
		:arg target: Target coordinate system.
		:type target: Metashape.CoordinateSystem
		:return: 4x4 transformation matrix.
		:rtype: Metashape.Matrix"""
	...
	def unproject (self, *args, **kwargs) -> Vector:
		"""unproject(point)

		Unprojects point from projected coordinates to geocentric coordinates.

		:arg point: 3D point in projected coordinate system.
		:type point: Metashape.Vector
		:return: 3D point in geocentric coordinates.
		:rtype: Metashape.Vector"""
	...
	wkt:  str
	"""Coordinate system definition in WKT format.

	:type: str"""

	wkt2:  str
	"""Coordinate system definition in WKT format, version 2.

	:type: str"""


class DataSource:
	BlockModelData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	DepthMapsAndLaserScansData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	DepthMapsData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	ElevationData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	ImagesData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	LaserScansData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	MasksData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	ModelData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	OrthomosaicData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	PointCloudData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	TiePointsData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	TiledModelData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	TrajectoryData: Any
	"""Data source in [TiePointsData, PointCloudData, ModelData, TiledModelData, ElevationData, OrthomosaicData, DepthMapsData, ImagesData, TrajectoryData, LaserScansData, DepthMapsAndLaserScansData, MasksData, BlockModelData]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class DataType:
	DataType16f: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType16i: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType16u: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType32f: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType32i: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType32u: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType64f: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType64i: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType64u: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType8i: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataType8u: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	DataTypeUndefined: Any
	"""Data type in [DataTypeUndefined, DataType8i, DataType8u, DataType16i, DataType16u, DataType16f, DataType32i, DataType32u, DataType32f, DataType64i, DataType64u, DataType64f]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class DepthMap:
	calibration:  Calibration
	"""Depth map calibration.

	:type: Calibration"""

	def copy (self, *args, **kwargs) -> DepthMap:
		"""copy()

		Returns a copy of the depth map.

		:return: Copy of the depth map.
		:rtype: Metashape.DepthMap"""
	...
	def getCalibration (self, *args, **kwargs) -> Calibration:
		"""getCalibration(level=0)

		Returns calibration data.

		:arg level: Level index.
		:type level: int
		:return: Calibration data.
		:rtype: Metashape.Calibration"""
	...
	def image (self, *args, **kwargs) -> Image:
		"""image([level])

		Returns image data.

		:arg level: Level index.
		:type level: int
		:return: Image data.
		:rtype: Metashape.Image"""
	...
	def setCalibration (self, *args, **kwargs):
		"""setCalibration(calibration, level=0)

		:arg calibration: Calibration data.
		:type calibration: Metashape.Calibration
		:arg level: Level index.
		:type level: int"""
	...
	def setImage (self, *args, **kwargs):
		"""setImage(image, level=0)

		:arg image: Image object with depth map data.
		:type image: Metashape.Image
		:arg level: Level index.
		:type level: int"""
	...

class DepthMaps:
	def clear (self, *args, **kwargs):
		"""clear()

		Clears depth maps data."""
	...
	def copy (self, *args, **kwargs) -> DepthMaps:
		"""copy()

		Create a copy of the depth maps.

		:return: Copy of the depth maps.
		:rtype: Metashape.DepthMaps"""
	...
	def items (self, *args, **kwargs):
		"""items()

		List of items."""
	...
	key:  int
	"""Depth maps identifier.

	:type: int"""

	def keys (self, *args, **kwargs):
		"""keys()

		List of item keys."""
	...
	label:  str
	"""Depth maps label.

	:type: str"""

	meta:  MetaData
	"""Depth maps meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def values (self, *args, **kwargs):
		"""values()

		List of item values."""
	...

class Document:
	def addChunk (self, *args, **kwargs) -> Chunk:
		"""addChunk()

		Add new chunk to the document.

		:return: Created chunk.
		:rtype: Metashape.Chunk"""
	...
	def addGeoid (self, *args, **kwargs):
		"""addGeoid(path)

		Add geoid to the document.

		:arg path: Path to the geoid file.
		:type path: str"""
	...
	def alignChunks (self, *args, **kwargs):
		"""alignChunks([chunks], [reference], method=0, fit_scale=True, downscale=1, generic_preselection=False, filter_mask=False, mask_tiepoints=False, keypoint_limit=40000, [markers], [progress])

		Align specified set of chunks.

		:arg chunks: List of chunks to be aligned.
		:type chunks: list[int]
		:arg reference: Chunk to be used as a reference.
		:type reference: int
		:arg method: Alignment method (0 - point based, 1 - marker based, 2 - camera based).
		:type method: int
		:arg fit_scale: Fit chunk scale during alignment.
		:type fit_scale: bool
		:arg downscale: Alignment accuracy (0 - Highest, 1 - High, 2 - Medium, 4 - Low, 8 - Lowest).
		:type downscale: int
		:arg generic_preselection: Enables image pair preselection.
		:type generic_preselection: bool
		:arg filter_mask: Filter points by mask.
		:type filter_mask: bool
		:arg mask_tiepoints: Apply mask filter to tie points.
		:type mask_tiepoints: bool
		:arg keypoint_limit: Maximum number of points for each photo.
		:type keypoint_limit: int
		:arg markers: List of markers to be used for marker based alignment.
		:type markers: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def append (self, *args, **kwargs):
		"""append(document, [chunks], [progress])

		Append the specified Document object to the current document.

		:arg document: Document object to be appended.
		:type document: Metashape.Document
		:arg chunks: List of chunks to append.
		:type chunks: list[Metashape.Chunk]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	chunk:  Chunk
	"""Active chunk.

	:type: Chunk"""

	chunks:  list[Chunk]
	"""List of chunks in the document.

	:type: list[Chunk]"""

	def clear (self, *args, **kwargs):
		"""clear()

		Clear the contents of the Document object."""
	...
	def copy (self, *args, **kwargs) -> Document:
		"""copy()

		Return a copy of the document.

		:return: A copy of the document.
		:rtype: Metashape.Document"""
	...
	def findChunk (self, *args, **kwargs) -> Chunk:
		"""findChunk(key)

		Find chunk by its key.

		:return: Found chunk.
		:rtype: Metashape.Chunk"""
	...
	geoids:  list[Geoid]
	"""List of geoids in the document.

	:type: list[Geoid]"""

	def mergeChunks (self, *args, **kwargs):
		"""mergeChunks(copy_laser_scans=True, copy_masks=True, copy_depth_maps=False, copy_point_clouds=False, copy_models=False, copy_tiled_models=False, copy_elevations=False, copy_orthomosaics=False, merge_markers=False, merge_tiepoints=False, merge_assets=False, [chunks], [progress])

		Merge specified set of chunks.

		:arg copy_laser_scans: Copy laser scans.
		:type copy_laser_scans: bool
		:arg copy_masks: Copy masks.
		:type copy_masks: bool
		:arg copy_depth_maps: Copy depth maps.
		:type copy_depth_maps: bool
		:arg copy_point_clouds: Copy point clouds.
		:type copy_point_clouds: bool
		:arg copy_models: Copy models.
		:type copy_models: bool
		:arg copy_tiled_models: Copy tiled models.
		:type copy_tiled_models: bool
		:arg copy_elevations: Copy DEMs.
		:type copy_elevations: bool
		:arg copy_orthomosaics: Copy orthomosaics.
		:type copy_orthomosaics: bool
		:arg merge_markers: Merge markers.
		:type merge_markers: bool
		:arg merge_tiepoints: Merge tie points.
		:type merge_tiepoints: bool
		:arg merge_assets: Merge default assets.
		:type merge_assets: bool
		:arg chunks: List of chunks to process.
		:type chunks: list[int]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	meta:  MetaData
	"""Document meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def open (self, *args, **kwargs):
		"""open(path, read_only=False, ignore_lock=False, archive=True)

		Load document from the specified file.

		:arg path: Path to the file.
		:type path: str
		:arg read_only: Open document in read-only mode.
		:type read_only: bool
		:arg ignore_lock: Ignore lock state for project modifications.
		:type ignore_lock: bool
		:arg archive: Override project format when using non-standard file extension.
		:type archive: bool"""
	...
	path:  str
	"""Path to the document file.

	:type: str"""

	read_only:  bool
	"""Read only status.

	:type: bool"""

	def remove (self, *args, **kwargs):
		"""remove(items)

		Remove a set of items from the document.

		:arg items: A list of items to be removed.
		:type items: list[Metashape.Chunk | Metashape.Geoid]"""
	...
	def save (self, *args, **kwargs):
		"""save([path], [chunks], [version], archive=True)

		Save document to the specified file.

		:arg path: Optional path to the file.
		:type path: str
		:arg chunks: List of chunks to be saved.
		:type chunks: list[Metashape.Chunk]
		:arg version: Project version to save.
		:type version: str
		:arg archive: Override project format when using non-standard file extension.
		:type archive: bool"""
	...
	def sortChunks (self, *args, **kwargs):
		"""sortChunks()

		Sorts chunks by their labels."""
	...

class Elevation:

	class Patch:
		"""Elevation patch."""
		Breakline: Any
		"""DEM patch type in [Fill, Breakline]"""

		Constant: Any
		"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""

		Fill: Any
		"""DEM patch type in [Fill, Breakline]"""

		IDW: Any
		"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""


		class InterpolationType:
			"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""
			Constant: Any
			"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""

			IDW: Any
			"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""

			NaturalNeighbour: Any
			"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""

			Plane: Any
			"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""

			values: Any
			"""dict() -> new empty dictionary
			dict(mapping) -> new dictionary initialized from a mapping object's
			    (key, value) pairs
			dict(iterable) -> new dictionary initialized as if via:
			    d = {}
			    for k, v in iterable:
			        d[k] = v
			dict(**kwargs) -> new dictionary initialized with the name=value pairs
			    in the keyword argument list.  For example:  dict(one=1, two=2)"""

		NaturalNeighbour: Any
		"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""

		Plane: Any
		"""DEM fill patch interpolation method in [Constant, Plane, IDW, NaturalNeighbour]"""


		class Type:
			"""DEM patch type in [Fill, Breakline]"""
			Breakline: Any
			"""DEM patch type in [Fill, Breakline]"""

			Fill: Any
			"""DEM patch type in [Fill, Breakline]"""

			values: Any
			"""dict() -> new empty dictionary
			dict(mapping) -> new dictionary initialized from a mapping object's
			    (key, value) pairs
			dict(iterable) -> new dictionary initialized as if via:
			    d = {}
			    for k, v in iterable:
			        d[k] = v
			dict(**kwargs) -> new dictionary initialized with the name=value pairs
			    in the keyword argument list.  For example:  dict(one=1, two=2)"""

		def copy (self, *args, **kwargs) -> Elevation.Patch:
			"""copy()

			Returns a copy of the patch.

			:return: Copy of the patch.
			:rtype: Metashape.Elevation.Patch"""
		...
		exclude_nested_polygons:  bool
		"""Exclude nested polygons.

		:type: bool"""

		fill_elevation:  float
		"""Elevation value for Constant interpolation method.

		:type: float"""

		idw_power:  int
		"""Power parameter for IDW interpolation method.

		:type: int"""

		interpolation_type:  Elevation.Patch.InterpolationType
		"""Interpolation method.

		:type: Elevation.Patch.InterpolationType"""

		sample_edges:  bool
		"""Sample values from polygon edges (ignored for Constant interpolation method).

		:type: bool"""

		type:  Elevation.Patch.PatchType
		"""Patch type.

		:type: Elevation.Patch.PatchType"""


	class Patches:
		"""A set of elevation patches."""
		def items (self, *args, **kwargs):
			"""items()

			List of items."""
		...
		def keys (self, *args, **kwargs):
			"""keys()

			List of item keys."""
		...
		def remove (self, *args, **kwargs):
			"""remove(items)

			Remove patches from the elevation.

			:arg items: A list of items to be removed.
			:type items: list[Metashape.Shape] | Metashape.Shape"""
		...
		def values (self, *args, **kwargs):
			"""values()

			List of item values."""
		...
	def altitude (self, *args, **kwargs) -> float:
		"""altitude(point)

		Return elevation value at the specified point.

		:arg point: Point coordinates in the DEM coordinate system.
		:type point: Metashape.Vector
		:return: Elevation value.
		:rtype: float"""
	...
	def altitudeSlopeAspect (self, *args, **kwargs) -> tuple[float, float, float]:
		"""altitudeSlopeAspect(point)

		Return elevation, slope and aspect values at the specified point.

		:arg point: Point coordinates in the DEM coordinate system.
		:type point: Metashape.Vector
		:return: Elevation, slope and aspect values.
		:rtype: tuple[float, float, float]"""
	...
	bottom:  float
	"""Y coordinate of the bottom side.

	:type: float"""

	def clear (self, *args, **kwargs):
		"""clear()

		Clears digital elevation model data."""
	...
	def copy (self, *args, **kwargs) -> Elevation:
		"""copy()

		Create a copy of the digital elevation model.

		:return: Copy of the digital elevation model.
		:rtype: Metashape.Elevation"""
	...
	def coverageArea (self, *args, **kwargs) -> float:
		"""coverageArea()

		Calculate coverage area of the DEM in m^2. Only pixels with data are used.

		:return: Area covered by the DEM.
		:rtype: float"""
	...
	crs:  CoordinateSystem
	"""Coordinate system of elevation model.

	:type: CoordinateSystem"""

	height:  int
	"""Elevation model height.

	:type: int"""

	key:  int
	"""Elevation model identifier.

	:type: int"""

	label:  str
	"""Elevation model label.

	:type: str"""

	left:  float
	"""X coordinate of the left side.

	:type: float"""

	max:  float
	"""Maximum elevation value.

	:type: float"""

	meta:  MetaData
	"""Elevation model meta data.

	:type: MetaData"""

	min:  float
	"""Minimum elevation value.

	:type: float"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	palette:  dict
	"""Color palette.

	:type: dict"""

	palette_absolute_values:  bool
	"""Use palette keys as absolute elevation values.

	:type: bool"""

	patches:  Elevation.Patches
	"""Elevation patches.

	:type: Elevation.Patches"""

	def pickPoint (self, *args, **kwargs) -> Vector:
		"""pickPoint(origin, target)

		Returns ray intersection with the DEM (point on the ray nearest to some point).

		:arg origin: Ray origin in the DEM coordinate system.
		:type origin: Metashape.Vector
		:arg target: Point on the ray in the DEM coordinate system.
		:type target: Metashape.Vector
		:return: Coordinates of the intersection point in the DEM coordinate system.
		:rtype: Metashape.Vector"""
	...
	projection:  OrthoProjection
	"""Projection of elevation model.

	:type: OrthoProjection"""

	resolution:  float
	"""DEM resolution in meters.

	:type: float"""

	right:  float
	"""X coordinate of the right side.

	:type: float"""

	top:  float
	"""Y coordinate of the top side.

	:type: float"""

	def update (self, *args, **kwargs):
		"""update([progress])

		Apply edits to elevation.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	width:  int
	"""Elevation model width.

	:type: int"""


class EulerAngles:
	EulerAnglesANK: Any
	"""Euler angles in [EulerAnglesUndefined, EulerAnglesYPR, EulerAnglesOPK, EulerAnglesPOK, EulerAnglesANK]"""

	EulerAnglesOPK: Any
	"""Euler angles in [EulerAnglesUndefined, EulerAnglesYPR, EulerAnglesOPK, EulerAnglesPOK, EulerAnglesANK]"""

	EulerAnglesPOK: Any
	"""Euler angles in [EulerAnglesUndefined, EulerAnglesYPR, EulerAnglesOPK, EulerAnglesPOK, EulerAnglesANK]"""

	EulerAnglesUndefined: Any
	"""Euler angles in [EulerAnglesUndefined, EulerAnglesYPR, EulerAnglesOPK, EulerAnglesPOK, EulerAnglesANK]"""

	EulerAnglesYPR: Any
	"""Euler angles in [EulerAnglesUndefined, EulerAnglesYPR, EulerAnglesOPK, EulerAnglesPOK, EulerAnglesANK]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class FaceCount:
	CustomFaceCount: Any
	"""Face count in [LowFaceCount, MediumFaceCount, HighFaceCount, CustomFaceCount]"""

	HighFaceCount: Any
	"""Face count in [LowFaceCount, MediumFaceCount, HighFaceCount, CustomFaceCount]"""

	LowFaceCount: Any
	"""Face count in [LowFaceCount, MediumFaceCount, HighFaceCount, CustomFaceCount]"""

	MediumFaceCount: Any
	"""Face count in [LowFaceCount, MediumFaceCount, HighFaceCount, CustomFaceCount]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class FilterMode:
	AggressiveFiltering: Any
	"""Depth filtering mode in [NoFiltering, MildFiltering, ModerateFiltering, AggressiveFiltering]"""

	MildFiltering: Any
	"""Depth filtering mode in [NoFiltering, MildFiltering, ModerateFiltering, AggressiveFiltering]"""

	ModerateFiltering: Any
	"""Depth filtering mode in [NoFiltering, MildFiltering, ModerateFiltering, AggressiveFiltering]"""

	NoFiltering: Any
	"""Depth filtering mode in [NoFiltering, MildFiltering, ModerateFiltering, AggressiveFiltering]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class FrameStep:
	CustomFrameStep: Any
	"""Frame step size for video import in [CustomFrameStep, SmallFrameStep, MediumFrameStep, LargeFrameStep]"""

	LargeFrameStep: Any
	"""Frame step size for video import in [CustomFrameStep, SmallFrameStep, MediumFrameStep, LargeFrameStep]"""

	MediumFrameStep: Any
	"""Frame step size for video import in [CustomFrameStep, SmallFrameStep, MediumFrameStep, LargeFrameStep]"""

	SmallFrameStep: Any
	"""Frame step size for video import in [CustomFrameStep, SmallFrameStep, MediumFrameStep, LargeFrameStep]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Geoid:
	authority:  str
	"""Geoid authority.

	:type: str"""

	height:  int
	"""Geoid height.

	:type: int"""

	horz_crs:  CoordinateSystem
	"""Horizontal coordinate system.

	:type: CoordinateSystem"""

	name:  str
	"""Geoid name.

	:type: str"""

	path:  str
	"""Path to geoid file.

	:type: str"""

	vert_crs:  CoordinateSystem
	"""Vertical coordinate system.

	:type: CoordinateSystem"""

	width:  int
	"""Geoid width.

	:type: int"""


class Geometry:
	def GeometryCollection (self, *args, **kwargs) -> Geometry:
		"""GeometryCollection(geometries)

		Create a GeometryCollection geometry.

		:arg geometries: Child geometries.
		:type geometries: list[Metashape.Geometry]
		:return: A GeometryCollection geometry.
		:rtype: Metashape.Geometry"""
	...
	GeometryCollectionType: Any
	"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

	def LineString (self, *args, **kwargs) -> Geometry:
		"""LineString(coordinates)

		Create a LineString geometry.

		:arg coordinates: List of vertex coordinates.
		:type coordinates: list[Metashape.Vector]
		:return: A LineString geometry.
		:rtype: Metashape.Geometry"""
	...
	LineStringType: Any
	"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

	def MultiLineString (self, *args, **kwargs) -> Geometry:
		"""MultiLineString(geometries)

		Create a MultiLineString geometry.

		:arg geometries: Child line strings.
		:type geometries: list[Metashape.Geometry]
		:return: A point geometry.
		:rtype: Metashape.Geometry"""
	...
	MultiLineStringType: Any
	"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

	def MultiPoint (self, *args, **kwargs) -> Geometry:
		"""MultiPoint(geometries)

		Create a MultiPoint geometry.

		:arg geometries: Child points.
		:type geometries: list[Metashape.Geometry]
		:return: A point geometry.
		:rtype: Metashape.Geometry"""
	...
	MultiPointType: Any
	"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

	def MultiPolygon (self, *args, **kwargs) -> Geometry:
		"""MultiPolygon(geometries)

		Create a MultiPolygon geometry.

		:arg geometries: Child polygons.
		:type geometries: list[Metashape.Geometry]
		:return: A point geometry.
		:rtype: Metashape.Geometry"""
	...
	MultiPolygonType: Any
	"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

	def Point (self, *args, **kwargs) -> Geometry:
		"""Point(vector)

		Create a Point geometry.

		:arg vector: Point coordinates.
		:type vector: Metashape.Vector | list[float]
		:return: A point geometry.
		:rtype: Metashape.Geometry"""
	...
	PointType: Any
	"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

	def Polygon (self, *args, **kwargs) -> Geometry:
		"""Polygon(exterior_ring, [interior_rings])

		Create a Polygon geometry.

		:arg exterior_ring: Point coordinates.
		:type exterior_ring: list[Metashape.Vector]
		:arg interior_rings: Point coordinates.
		:type interior_rings: list[Metashape.Vector]
		:return: A Polygon geometry.
		:rtype: Metashape.Geometry"""
	...
	PolygonType: Any
	"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""


	class Type:
		"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""
		GeometryCollectionType: Any
		"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

		LineStringType: Any
		"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

		MultiLineStringType: Any
		"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

		MultiPointType: Any
		"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

		MultiPolygonType: Any
		"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

		PointType: Any
		"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

		PolygonType: Any
		"""Geometry type in [PointType, LineStringType, PolygonType, MultiPointType, MultiLineStringType, MultiPolygonType, GeometryCollectionType]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	coordinates:  list[Vector]
	"""List of vertex coordinates.

	:type: list[Vector]"""

	geometries:  list[Geometry]
	"""List of child geometries.

	:type: list[Geometry]"""

	is_3d:  bool
	"""Is 3D flag.

	:type: bool"""

	type:  Geometry.Type
	"""Geometry type.

	:type: Geometry.Type"""


class Image:
	channels:  str
	"""Channel mapping for the image.

	:type: str"""

	cn:  int
	"""Number of color channels.

	:type: int"""

	def convert (self, *args, **kwargs) -> Image:
		"""convert(channels, [datatype])

		Convert image to specified data type and channel layout.

		:arg channels: color channels to be loaded, e.g. 'RGB', 'RGBA', etc.
		:type channels: str
		:arg datatype: pixel data type in ['U8', 'U16', 'U32', 'F16', 'F32', 'F64']
		:type datatype: str
		:return: Converted image.
		:rtype: Metashape.Image"""
	...
	def copy (self, *args, **kwargs) -> Image:
		"""copy()

		Return a copy of the image.

		:return: copy of the image
		:rtype: Metashape.Image"""
	...
	data_type:  str
	"""Data type used to store pixel values.

	:type: str"""

	def fromstring (self, *args, **kwargs) -> Image:
		"""fromstring(data, width, height, channels, datatype='U8')

		Create image from byte array.

		:arg data: raw image data
		:type data: str
		:arg width: image width
		:type width: int
		:arg height: image height
		:type height: int
		:arg channels: color channel layout, e.g. 'RGB', 'RGBA', etc.
		:type channels: str
		:arg datatype: pixel data type in ['U8', 'U16', 'U32', 'F16', 'F32', 'F64']
		:type datatype: str
		:return: Created image.
		:rtype: Metashape.Image"""
	...
	def gaussianBlur (self, *args, **kwargs) -> Image:
		"""gaussianBlur(radius)

		Smooth image with a gaussian filter.

		:arg radius: smoothing radius.
		:type radius: float
		:return: Smoothed image.
		:rtype: Metashape.Image"""
	...
	height:  int
	"""Image height.

	:type: int"""

	def open (self, *args, **kwargs) -> Image:
		"""open(path, layer=0, datatype='U8', [channels], [x], [y], [w], [h])

		Load image from file.

		:arg path: path to the image file
		:type path: str
		:arg layer: image layer in case of multipage file
		:type layer: int
		:arg datatype: pixel data type in ['U8', 'U16', 'U32', 'F16', 'F32', 'F64']
		:type datatype: str
		:arg channels: color channels to be loaded, e.g. 'RGB', 'RGBA', etc.
		:type channels: str
		:arg x: x offset of image region.
		:type x: int
		:arg y: y offset of image region.
		:type y: int
		:arg w: width of image region.
		:type w: int
		:arg h: height of image region.
		:type h: int
		:return: Loaded image.
		:rtype: Metashape.Image"""
	...
	def resize (self, *args, **kwargs) -> Image:
		"""resize(width, height)

		Resize image to specified dimensions.

		:arg width: new image width
		:type width: int
		:arg height: new image height
		:type height: int
		:return: resized image
		:rtype: Metashape.Image"""
	...
	def save (self, *args, **kwargs):
		"""save(path, [compression])

		Save image to the file.

		:arg path: path to the image file
		:type path: str
		:arg compression: compression options
		:type compression: Metashape.ImageCompression"""
	...
	def tostring (self, *args, **kwargs) -> str:
		"""tostring()

		Convert image to byte array.

		:return: Raw image data.
		:rtype: str"""
	...
	def undistort (self, *args, **kwargs) -> Image:
		"""undistort(calib, center_principal_point = True, square_pixels = True)

		Undistort image using provided calibration.

		:arg calib: lens calibration
		:type calib: Metashape.Calibration
		:arg center_principal_point: moves principal point to the image center
		:type center_principal_point: bool
		:arg square_pixels: create image with square pixels
		:type square_pixels: bool
		:return: undistorted image
		:rtype: Metashape.Image"""
	...
	def uniformNoise (self, *args, **kwargs) -> Image:
		"""uniformNoise(amplitude)

		Add uniform noise with specified amplitude.

		:arg amplitude: noise amplitude.
		:type amplitude: float
		:return: Image with added noise.
		:rtype: Metashape.Image"""
	...
	def warp (self, *args, **kwargs) -> Image:
		"""warp(calib0, trans0, calib1, trans1)

		Warp image by rotating virtual viewpoint.

		:arg calib0: initial calibration
		:type calib0: Metashape.Calibration
		:arg trans0: initial camera orientation as 4x4 matrix
		:type trans0: Metashape.Matrix
		:arg calib1: final calibration
		:type calib1: Metashape.Calibration
		:arg trans1: final camera orientation as 4x4 matrix
		:type trans1: Metashape.Matrix
		:return: warped image
		:rtype: Metashape.Image"""
	...
	width:  int
	"""Image width.

	:type: int"""


class ImageCompression:

	class TiffCompression:
		"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""
		TiffCompressionDeflate: Any
		"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

		TiffCompressionJPEG: Any
		"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

		TiffCompressionLZW: Any
		"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

		TiffCompressionNone: Any
		"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

		TiffCompressionPackbits: Any
		"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

		TiffCompressionWebP: Any
		"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	TiffCompressionDeflate: Any
	"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

	TiffCompressionJPEG: Any
	"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

	TiffCompressionLZW: Any
	"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

	TiffCompressionNone: Any
	"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

	TiffCompressionPackbits: Any
	"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

	TiffCompressionWebP: Any
	"""Tiff compression in [TiffCompressionNone, TiffCompressionLZW, TiffCompressionJPEG, TiffCompressionPackbits, TiffCompressionDeflate, TiffCompressionWebP]"""

	def copy (self, *args, **kwargs) -> Viewpoint:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Viewpoint"""
	...
	jpeg_quality:  int
	"""JPEG quality.

	:type: int"""

	tiff_big:  bool
	"""Enable BigTIFF compression for TIFF files.

	:type: bool"""

	tiff_compression:  int
	"""Tiff compression.

	:type: int"""

	tiff_overviews:  bool
	"""Enable image pyramid deneration for TIFF files.

	:type: bool"""

	tiff_tiled:  bool
	"""Export tiled TIFF.

	:type: bool"""


class ImageFormat:
	ImageFormatARA: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatASCII: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatBIL: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatBMP: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatBZ2: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatCR2: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatDDS: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatEXR: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatJP2: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatJPEG: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatJXL: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatKTX: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatNone: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatPNG: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatPNM: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatSEQ: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatSGI: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatTGA: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatTIFF: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatWebP: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	ImageFormatXYZ: Any
	"""Image format in [ImageFormatNone, ImageFormatJPEG, ImageFormatTIFF, ImageFormatPNG, ImageFormatBMP, ImageFormatEXR, ImageFormatPNM, ImageFormatSGI, ImageFormatCR2, ImageFormatBZ2, ImageFormatSEQ, ImageFormatBIL, ImageFormatASCII, ImageFormatXYZ, ImageFormatARA, ImageFormatTGA, ImageFormatDDS, ImageFormatJP2, ImageFormatWebP, ImageFormatJXL, ImageFormatKTX]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class ImageLayout:
	FlatLayout: Any
	"""Image layout in [UndefinedLayout, FlatLayout, MultiframeLayout, MultiplaneLayout]"""

	MultiframeLayout: Any
	"""Image layout in [UndefinedLayout, FlatLayout, MultiframeLayout, MultiplaneLayout]"""

	MultiplaneLayout: Any
	"""Image layout in [UndefinedLayout, FlatLayout, MultiframeLayout, MultiplaneLayout]"""

	UndefinedLayout: Any
	"""Image layout in [UndefinedLayout, FlatLayout, MultiframeLayout, MultiplaneLayout]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Interpolation:
	DisabledInterpolation: Any
	"""Interpolation mode in [DisabledInterpolation, EnabledInterpolation, Extrapolated]"""

	EnabledInterpolation: Any
	"""Interpolation mode in [DisabledInterpolation, EnabledInterpolation, Extrapolated]"""

	Extrapolated: Any
	"""Interpolation mode in [DisabledInterpolation, EnabledInterpolation, Extrapolated]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class License:
	def activate (self, *args, **kwargs):
		"""activate(license_key)

		Activate software online using a license key.

		:arg key: Activation key.
		:type key: str"""
	...
	def activateOffline (self, *args, **kwargs) -> str:
		"""activateOffline(activation_params)

		Create a request for offline activation.

		:arg activation_params: The content of .actparam file.
		:type activation_params: str
		:return: The activation request which should be saved to .actreq file.
		:rtype: str"""
	...
	def borrowLicense (self, *args, **kwargs):
		"""borrowLicense(seconds)

		Borrow floating license for the specified number of seconds.

		:arg seconds: Borrow duration in seconds.
		:type seconds: int"""
	...
	borrowed:  bool
	"""License borrowed flag.

	:type: bool"""

	def deactivate (self, *args, **kwargs):
		"""deactivate()

		Deactivate software online."""
	...
	def deactivateOffline (self, *args, **kwargs) -> str:
		"""deactivateOffline()

		Create a request for offline deactivation.

		:return: The deactivation request which should be saved to .actreq file.
		:rtype: str"""
	...
	expiration:  int
	"""License expiration as a Unix timestamp in seconds.

	:type: int"""

	floating:  bool
	"""License floating flag.

	:type: bool"""

	def install (self, *args, **kwargs):
		"""install(activation_response)

		Install license from the activation response.

		:arg activation_response: The content of .actresp file.
		:type activation_response: str"""
	...
	rehostable:  bool
	"""License rehostable flag.

	:type: bool"""

	def returnLicense (self, *args, **kwargs):
		"""returnLicense()

		Return borrowed license to the license server."""
	...
	valid:  bool
	"""Metashape activation status.

	:type: bool"""


class MappingMode:
	AdaptiveOrthophotoMapping: Any
	"""UV mapping mode in [GenericMapping, OrthophotoMapping, AdaptiveOrthophotoMapping, SphericalMapping, CameraMapping]"""

	CameraMapping: Any
	"""UV mapping mode in [GenericMapping, OrthophotoMapping, AdaptiveOrthophotoMapping, SphericalMapping, CameraMapping]"""

	GenericMapping: Any
	"""UV mapping mode in [GenericMapping, OrthophotoMapping, AdaptiveOrthophotoMapping, SphericalMapping, CameraMapping]"""

	OrthophotoMapping: Any
	"""UV mapping mode in [GenericMapping, OrthophotoMapping, AdaptiveOrthophotoMapping, SphericalMapping, CameraMapping]"""

	SphericalMapping: Any
	"""UV mapping mode in [GenericMapping, OrthophotoMapping, AdaptiveOrthophotoMapping, SphericalMapping, CameraMapping]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Marker:
	Fiducial: Any
	"""Marker type in [Regular, Vertex, Fiducial]"""


	class Projection:
		"""Marker data()."""
		coord:  Vector
		"""Point coordinates in pixels.

		:type: Vector"""

		pinned:  bool
		"""Pinned flag.

		:type: bool"""

		valid:  bool
		"""Valid flag.

		:type: bool"""


	class Projections:
		"""Collection of projections specified for the marker"""
		def items (self, *args, **kwargs):
			"""items()

			List of items."""
		...
		def keys (self, *args, **kwargs):
			"""keys()

			List of item keys."""
		...
		def values (self, *args, **kwargs):
			"""values()

			List of item values."""
		...

	class Reference:
		"""Marker reference data."""
		accuracy:  Vector
		"""Marker location accuracy.

		:type: Vector"""

		enabled:  bool
		"""Enabled flag.

		:type: bool"""

		location:  Vector
		"""Marker coordinates.

		:type: Vector"""

	Regular: Any
	"""Marker type in [Regular, Vertex, Fiducial]"""


	class Type:
		"""Marker type in [Regular, Vertex, Fiducial]"""
		Fiducial: Any
		"""Marker type in [Regular, Vertex, Fiducial]"""

		Regular: Any
		"""Marker type in [Regular, Vertex, Fiducial]"""

		Vertex: Any
		"""Marker type in [Regular, Vertex, Fiducial]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	Vertex: Any
	"""Marker type in [Regular, Vertex, Fiducial]"""

	chunk:  Chunk
	"""Chunk the marker belongs to.

	:type: Chunk"""

	enabled:  bool
	"""Enables/disables the marker.

	:type: bool"""

	frames:  list[Marker]
	"""Marker frames.

	:type: list[Marker]"""

	group:  MarkerGroup
	"""Marker group.

	:type: MarkerGroup"""

	key:  int
	"""Marker identifier.

	:type: int"""

	label:  str
	"""Marker label.

	:type: str"""

	meta:  MetaData
	"""Marker meta data.

	:type: MetaData"""

	position:  Vector
	"""Marker position in the current frame.

	:type: Vector"""

	position_covariance:  Matrix
	"""Marker position covariance.

	:type: Matrix"""

	projections:  Marker.Projections
	"""List of marker projections.

	:type: Marker.Projections"""

	reference:  Marker.Reference
	"""Marker reference data.

	:type: Marker.Reference"""

	selected:  bool
	"""Selects/deselects the marker.

	:type: bool"""

	sensor:  Sensor
	"""Fiducial mark sensor.

	:type: Sensor"""

	type:  Marker.Type
	"""Marker type.

	:type: Marker.Type"""


class MarkerGroup:
	key:  int
	"""Marker group identifier.

	:type: int"""

	label:  str
	"""Marker group label.

	:type: str"""

	selected:  bool
	"""Current selection state.

	:type: bool"""


class Mask:
	def copy (self, *args, **kwargs) -> Mask:
		"""copy()

		Returns a copy of the mask.

		:return: Copy of the mask.
		:rtype: Metashape.Mask"""
	...
	def image (self, *args, **kwargs) -> Image:
		"""image()

		Returns image data.

		:return: Image data.
		:rtype: Metashape.Image"""
	...
	def invert (self, *args, **kwargs) -> Mask:
		"""invert()

		Create inverted copy of the mask.

		:return: Inverted copy of the mask.
		:rtype: Metashape.Mask"""
	...
	def load (self, *args, **kwargs):
		"""load(path, [layer])

		Loads mask from file.

		:arg path: Path to the image file to be loaded.
		:type path: str
		:arg layer: Optional layer index in case of multipage files.
		:type layer: int"""
	...
	def setImage (self, *args, **kwargs):
		"""setImage(image)

		:arg image: Image object with mask data.
		:type image: Metashape.Image"""
	...

class MaskOperation:
	MaskOperationDifference: Any
	"""Mask operation in [MaskOperationReplacement, MaskOperationUnion, MaskOperationIntersection, MaskOperationDifference]"""

	MaskOperationIntersection: Any
	"""Mask operation in [MaskOperationReplacement, MaskOperationUnion, MaskOperationIntersection, MaskOperationDifference]"""

	MaskOperationReplacement: Any
	"""Mask operation in [MaskOperationReplacement, MaskOperationUnion, MaskOperationIntersection, MaskOperationDifference]"""

	MaskOperationUnion: Any
	"""Mask operation in [MaskOperationReplacement, MaskOperationUnion, MaskOperationIntersection, MaskOperationDifference]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class MaskingMode:
	MaskingModeAI: Any
	"""Masking mode in [MaskingModeAlpha, MaskingModeFile, MaskingModeBackground, MaskingModeModel, MaskingModeAI]"""

	MaskingModeAlpha: Any
	"""Masking mode in [MaskingModeAlpha, MaskingModeFile, MaskingModeBackground, MaskingModeModel, MaskingModeAI]"""

	MaskingModeBackground: Any
	"""Masking mode in [MaskingModeAlpha, MaskingModeFile, MaskingModeBackground, MaskingModeModel, MaskingModeAI]"""

	MaskingModeFile: Any
	"""Masking mode in [MaskingModeAlpha, MaskingModeFile, MaskingModeBackground, MaskingModeModel, MaskingModeAI]"""

	MaskingModeModel: Any
	"""Masking mode in [MaskingModeAlpha, MaskingModeFile, MaskingModeBackground, MaskingModeModel, MaskingModeAI]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Masks:
	def clear (self, *args, **kwargs):
		"""clear()

		Clears masks data."""
	...
	def copy (self, *args, **kwargs) -> Masks:
		"""copy()

		Create a copy of the masks.

		:return: Copy of the masks.
		:rtype: Metashape.Masks"""
	...
	def items (self, *args, **kwargs):
		"""items()

		List of items."""
	...
	key:  int
	"""Masks identifier.

	:type: int"""

	def keys (self, *args, **kwargs):
		"""keys()

		List of item keys."""
	...
	label:  str
	"""Masks label.

	:type: str"""

	meta:  MetaData
	"""Masks meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def values (self, *args, **kwargs):
		"""values()

		List of item values."""
	...

class Matrix:
	def Diag (self, *args, **kwargs) -> Matrix:
		"""Diag(vector)

		Create a diagonal matrix.

		:arg vector: The vector of diagonal entries.
		:type vector: Metashape.Vector | list[float]
		:return: A diagonal matrix.
		:rtype: Metashape.Matrix"""
	...
	def Rotation (self, *args, **kwargs) -> Matrix:
		"""Rotation(matrix)

		Create a rotation matrix.

		:arg matrix: The 3x3 rotation matrix.
		:type matrix: Metashape.Matrix
		:return: 4x4 matrix representing rotation.
		:rtype: Metashape.Matrix"""
	...
	def Scale (self, *args, **kwargs) -> Matrix:
		"""Scale(scale)

		Create a scale matrix.

		:arg scale: The scale vector.
		:type scale: Metashape.Vector
		:return: A matrix representing scale.
		:rtype: Metashape.Matrix"""
	...
	def Translation (self, *args, **kwargs) -> Matrix:
		"""Translation(vector)

		Create a translation matrix.

		:arg vector: The translation vector.
		:type vector: Metashape.Vector
		:return: A matrix representing translation.
		:rtype: Metashape.Matrix"""
	...
	def col (self, *args, **kwargs) -> Vector:
		"""col(index)

		Returns column of the matrix.

		:return: matrix column.
		:rtype: Metashape.Vector"""
	...
	def copy (self, *args, **kwargs) -> Matrix:
		"""copy()

		Returns a copy of this matrix.

		:return: an instance of itself
		:rtype: Metashape.Matrix"""
	...
	def det (self, *args, **kwargs) -> float:
		"""det()

		Return the determinant of a matrix.

		:return: Return a the determinant of a matrix.
		:rtype: float"""
	...
	def inv (self, *args, **kwargs) -> Matrix:
		"""inv()

		Returns an inverted copy of the matrix.

		:return: inverted matrix.
		:rtype: Metashape.Matrix"""
	...
	def mulp (self, *args, **kwargs) -> Vector:
		"""mulp(point)

		Transforms a point in homogeneous coordinates.

		:arg point: The point to be transformed.
		:type point: Metashape.Vector
		:return: transformed point.
		:rtype: Metashape.Vector"""
	...
	def mulv (self, *args, **kwargs) -> Vector:
		"""mulv(vector)

		Transforms vector in homogeneous coordinates.

		:arg vector: The vector to be transformed.
		:type vector: Metashape.Vector
		:return: transformed vector.
		:rtype: Metashape.Vector"""
	...
	def rotation (self, *args, **kwargs) -> Matrix:
		"""rotation()

		Returns rotation component of the 4x4 matrix.

		:return: rotation component
		:rtype: Metashape.Matrix"""
	...
	def row (self, *args, **kwargs) -> Vector:
		"""row(index)

		Returns row of the matrix.

		:return: matrix row.
		:rtype: Metashape.Vector"""
	...
	def scale (self, *args, **kwargs) -> float:
		"""scale()

		Returns scale component of the 4x4 matrix.

		:return: scale component
		:rtype: float"""
	...
	size:  tuple
	"""Matrix dimensions.

	:type: tuple"""

	def svd (self, *args, **kwargs) -> tuple[Metashape.Matrix, Metashape.Vector, Metashape.Matrix]:
		"""svd()

		Returns singular value decomposition of the matrix.

		:return: u, s, v tuple where a = u * diag(s) * v
		:rtype: tuple[Metashape.Matrix, Metashape.Vector, Metashape.Matrix]"""
	...
	def t (self, *args, **kwargs) -> Matrix:
		"""t()

		Return a new, transposed matrix.

		:return: a transposed matrix
		:rtype: Metashape.Matrix"""
	...
	def translation (self, *args, **kwargs) -> Vector:
		"""translation()

		Returns translation component of the 4x4 matrix.

		:return: translation component
		:rtype: Metashape.Vector"""
	...
	def zero (self, *args, **kwargs):
		"""zero()

		Set all matrix elements to zero."""
	...

class MetaData:
	def copy (self, *args, **kwargs) -> MetaData:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.MetaData"""
	...
	def items (self, *args, **kwargs):
		"""items()

		List of items."""
	...
	def keys (self, *args, **kwargs):
		"""keys()

		List of item keys."""
	...
	def values (self, *args, **kwargs):
		"""values()

		List of item values."""
	...

class Model:
	ComponentSize: Any
	"""Model filter criterion in [ComponentSize, PolygonSize, VertexConfidence]"""


	class Criterion:
		"""Model filter criterion in [ComponentSize, PolygonSize, VertexConfidence]"""
		ComponentSize: Any
		"""Model filter criterion in [ComponentSize, PolygonSize, VertexConfidence]"""

		PolygonSize: Any
		"""Model filter criterion in [ComponentSize, PolygonSize, VertexConfidence]"""

		VertexConfidence: Any
		"""Model filter criterion in [ComponentSize, PolygonSize, VertexConfidence]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	DiffuseMap: Any
	"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""

	DisplacementMap: Any
	"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""


	class Face:
		"""Triangular face of the model"""
		hidden:  bool
		"""Face visibility flag.

		:type: bool"""

		selected:  bool
		"""Face selection flag.

		:type: bool"""

		tex_index:  int
		"""Texture page index.

		:type: int"""

		tex_vertices:  tuple[int, int, int]
		"""Texture vertex indices.

		:type: tuple[int, int, int]"""

		vertices:  tuple[int, int, int]
		"""Vertex indices.

		:type: tuple[int, int, int]"""


	class Faces:
		"""Collection of model faces"""
		def resize (self, *args, **kwargs):
			"""resize(count)

			Resize faces list.

			:arg count: new face count
			:type count: int"""
		...
	NormalMap: Any
	"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""

	OcclusionMap: Any
	"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""

	PolygonSize: Any
	"""Model filter criterion in [ComponentSize, PolygonSize, VertexConfidence]"""


	class Statistics:
		"""Model statistics"""
		components:  int
		"""Number of connected components.

		:type: int"""

		degenerate_faces:  int
		"""Number of degenerate faces.

		:type: int"""

		duplicate_faces:  int
		"""Number of duplicate faces.

		:type: int"""

		faces:  int
		"""Total number of faces.

		:type: int"""

		flipped_normals:  int
		"""Number of edges with flipped normals.

		:type: int"""

		free_vertices:  int
		"""Number of free vertices.

		:type: int"""

		invalid_vertices:  int
		"""Number of vertices with NaN coordinates.

		:type: int"""

		multiple_edges:  int
		"""Number of edges connecting more than 2 faces.

		:type: int"""

		open_edges:  int
		"""Number of open edges.

		:type: int"""

		out_of_range_indices:  int
		"""Number of out of range indices.

		:type: int"""

		similar_vertices:  int
		"""Number of similar vertices.

		:type: int"""

		vertices:  int
		"""Total number of vertices.

		:type: int"""

		zero_faces:  int
		"""Number of zero faces.

		:type: int"""


	class TexVertex:
		"""Texture vertex of the model"""
		coord:  Vector
		"""2D vertex coordinates.

		:type: Vector"""


	class TexVertices:
		"""Collection of model texture vertices"""
		def resize (self, *args, **kwargs):
			"""resize(count)

			Resize vertex list.

			:arg count: new vertex count
			:type count: int"""
		...

	class Texture:
		"""Model texture."""
		bands:  list[str]
		"""List of color bands.

		:type: list[str]"""

		data_type:  DataType
		"""Data type used to store color values.

		:type: DataType"""

		def image (self, *args, **kwargs) -> Image:
			"""image(page=0)

			Return texture image.

			:arg page: Texture index for multitextured models.
			:type page: int
			:return: Texture image.
			:rtype: Metashape.Image"""
		...
		label:  str
		"""Animation label.

		:type: str"""

		meta:  MetaData
		"""Camera track meta data.

		:type: MetaData"""

		model:  Model
		"""Model the texture belongs to.

		:type: Model"""

		def setImage (self, *args, **kwargs):
			"""setImage(image, page=0)

			Initialize texture from image data.

			:arg image: Texture image.
			:type image: Metashape.Image
			:arg page: Texture index for multitextured models.
			:type page: int"""
		...
		type:  Model.TextureType
		"""Texture type.

		:type: Model.TextureType"""


	class TextureType:
		"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""
		DiffuseMap: Any
		"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""

		DisplacementMap: Any
		"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""

		NormalMap: Any
		"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""

		OcclusionMap: Any
		"""Texture type in [DiffuseMap, NormalMap, OcclusionMap, DisplacementMap]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""


	class Vertex:
		"""Vertex of the model"""
		color: tuple
		"""Vertex color.

		:type: tuple of numbers"""

		confidence:  float
		"""Vertex confidence.

		:type: float"""

		coord:  Vector
		"""Vertex coordinates.

		:type: Vector"""

	VertexConfidence: Any
	"""Model filter criterion in [ComponentSize, PolygonSize, VertexConfidence]"""


	class Vertices:
		"""Collection of model vertices"""
		def resize (self, *args, **kwargs):
			"""resize(count)

			Resize vertex list.

			:arg count: new vertex count
			:type count: int"""
		...
	def addTexture (self, *args, **kwargs) -> Model.Texture:
		"""addTexture(type=Model.DiffuseMap)

		Add new texture to the model.

		:arg type: Texture type.
		:type type: Metashape.Model.TextureType
		:return: Created texture.
		:rtype: Metashape.Model.Texture"""
	...
	def area (self, *args, **kwargs) -> float:
		"""area()

		Return area of the model surface.

		:return: Model area.
		:rtype: float"""
	...
	bands:  list[str]
	"""List of color bands.

	:type: list[str]"""

	block_index:  tuple
	"""Model block index.

	:type: tuple"""

	block_region:  Region
	"""Model block region.

	:type: Region"""

	def cleanModel (self, *args, **kwargs):
		"""cleanModel(criterion, level, [progress])

		Remove model faces based on specified criterion.

		:arg criterion: Model filtering criterion.
		:type criterion: Metashape.Model.Criterion
		:arg level: Filtering threshold in percents.
		:type level: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def clear (self, *args, **kwargs):
		"""clear()

		Clears model data."""
	...
	def closeHoles (self, *args, **kwargs):
		"""closeHoles(level=30, apply_to_selection=False)

		Fill holes in the model surface.

		:arg level: Hole size threshold in percents.
		:type level: int
		:arg apply_to_selection: Close holes within selection
		:type apply_to_selection: bool"""
	...
	def copy (self, *args, **kwargs) -> Model:
		"""copy()

		Create a copy of the model.

		:return: Copy of the model.
		:rtype: Metashape.Model"""
	...
	def cropSelection (self, *args, **kwargs):
		"""cropSelection()

		Crop selected faces and free vertices from the mesh."""
	...
	crs:  CoordinateSystem | None
	"""Reference coordinate system.

	:type: CoordinateSystem | None"""

	data_type:  DataType
	"""Data type used to store color values.

	:type: DataType"""

	enabled:  bool
	"""Enables/disables the model.

	:type: bool"""

	faces:  Model.Faces
	"""Collection of model faces.

	:type: Model.Faces"""

	def fixTopology (self, *args, **kwargs):
		"""fixTopology()

		Remove polygons causing topological problems."""
	...
	def getActiveTexture (self, *args, **kwargs) -> Image:
		"""getActiveTexture(type=Model.DiffuseMap)

		Return active texture.

		:arg type: Texture type.
		:type type: Metashape.Model.TextureType
		:return: Texture image.
		:rtype: Metashape.Image"""
	...
	group:  ModelGroup
	"""Model group.

	:type: ModelGroup"""

	def invertSelection (self, *args, **kwargs):
		"""invertSelection()

		Invert selection."""
	...
	key:  int
	"""Model identifier.

	:type: int"""

	label:  str
	"""Model label.

	:type: str"""

	def loadTexture (self, *args, **kwargs):
		"""loadTexture(path)

		Load texture from the specified file.

		:arg path: Path to the image file.
		:type path: str"""
	...
	meta:  MetaData
	"""Model meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def pickPoint (self, *args, **kwargs) -> Vector:
		"""pickPoint(origin, target, endpoints=1)

		Return ray intersection with mesh.

		:arg origin: Ray origin.
		:type origin: Metashape.Vector
		:arg target: Point on the ray.
		:type target: Metashape.Vector
		:arg endpoints: Number of endpoints to check for (0 - line, 1 - ray, 2 - segment).
		:type endpoints: int
		:return: Coordinates of the intersection point.
		:rtype: Metashape.Vector"""
	...
	def remove (self, *args, **kwargs):
		"""remove(items)

		Remove textures from the model.

		:arg items: A list of textures to be removed.
		:type items: list[Metashape.Model.Texture]"""
	...
	def removeComponents (self, *args, **kwargs):
		"""removeComponents(size)

		Remove small connected components.

		:arg size: Threshold on the polygon count of the components to be removed.
		:type size: int"""
	...
	def removeSelection (self, *args, **kwargs):
		"""removeSelection()

		Remove selected faces and free vertices from the mesh."""
	...
	def removeTextures (self, *args, **kwargs):
		"""removeTextures()

		Remove textures."""
	...
	def removeUV (self, *args, **kwargs):
		"""removeUV()

		Remove UV mapping."""
	...
	def removeVertexColors (self, *args, **kwargs):
		"""removeVertexColors()

		Remove vertex colors."""
	...
	def removeVertexConfidence (self, *args, **kwargs):
		"""removeVertexConfidence()

		Remove confidence."""
	...
	def renderDepth (self, *args, **kwargs) -> Image:
		"""renderDepth(transform, calibration, cull_faces=True, add_alpha=True)

		Render model depth image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderImage (self, *args, **kwargs) -> Image:
		"""renderImage(transform, calibration, cull_faces=True, add_alpha=True, raster_transform=RasterTransformNone, matcap_image, smooth_normals=True, color)

		Render model image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.RasterTransformType
		:arg matcap_image: Matcap image used to shade model.
		:type matcap_image: Metashape.Image
		:arg smooth_normals: Enable normals smoothing.:type smooth_normals: bool
		:arg color: Solid view color.
		:type color: list[int]:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderMask (self, *args, **kwargs) -> Image:
		"""renderMask(transform, calibration, cull_faces=True)

		Render model mask image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderNormalMap (self, *args, **kwargs) -> Image:
		"""renderNormalMap(transform, calibration, cull_faces=True, add_alpha=True)

		Render image with model normals for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:arg smooth_normals: Enable normals smoothing.:type smooth_normals: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderPreview (self, *args, **kwargs) -> Image:
		"""renderPreview(width = 2048, height = 2048, [transform], [progress])

		Generate model preview image.

		:arg width: Preview image width.
		:type width: int
		:arg height: Preview image height.
		:type height: int
		:arg transform: 4x4 viewpoint transformation matrix.
		:type transform: Metashape.Matrix
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Preview image.
		:rtype: Metashape.Image"""
	...
	def saveTexture (self, *args, **kwargs):
		"""saveTexture(path)

		Save texture to the specified file.

		:arg path: Path to the image file.
		:type path: str"""
	...
	selected:  bool
	"""Selects/deselects the model.

	:type: bool"""

	def setActiveTexture (self, *args, **kwargs):
		"""setActiveTexture(texture, type=Model.DiffuseMap)

		Set active texture.

		:arg texture: Texture to set.
		:type texture: Metashape.Model.Texture
		:arg type: Texture type.
		:type type: Metashape.Model.TextureType"""
	...
	def setVertexColors (self, *args, **kwargs):
		"""setVertexColors(channels='RGB', datatype='U8')

		Clear vertex colors data and set layout.

		:arg channels: color channel layout, e.g. 'RGB', 'RGBA', etc.
		:type channels: str
		:arg datatype: pixel data type in ['U8', 'U16', 'U32', 'F16', 'F32', 'F64']
		:type datatype: str"""
	...
	def statistics (self, *args, **kwargs) -> Model.Statistics:
		"""statistics([progress])

		Return model statistics.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Model statistics.
		:rtype: Metashape.Model.Statistics"""
	...
	tex_vertices:  Model.TexVertices
	"""Collection of model texture vertices.

	:type: Model.TexVertices"""

	textures:  list[Model.Texture]
	"""List of model textures.

	:type: list[Model.Texture]"""

	transform:  Matrix
	"""4x4 model transformation matrix.

	:type: Matrix"""

	def transformVertices (self, *args, **kwargs):
		"""transformVertices(transform)

		Transform vertex coordinates.

		:arg transform: 4x4 transformation matrix.
		:type transform: Metashape.Matrix"""
	...
	vertices:  Model.Vertices
	"""Collection of model vertices.

	:type: Model.Vertices"""

	def volume (self, *args, **kwargs) -> float:
		"""volume()

		Return volume of the closed model surface.

		:return: Model volume.
		:rtype: float"""
	...

class ModelFormat:
	ModelFormat3DS: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatABC: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatCOLLADA: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatCTM: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatDXF: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatDXF_3DF: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatFBX: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatGLTF: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatKMZ: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatLandXML: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatNone: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatOBJ: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatOSGB: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatOSGT: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatPDF: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatPLY: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatSTL: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatTLS: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatU3D: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatVRML: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	ModelFormatX3D: Any
	"""Model format in [ModelFormatNone, ModelFormatOBJ, ModelFormat3DS, ModelFormatVRML, ModelFormatPLY, ModelFormatCOLLADA, ModelFormatU3D, ModelFormatPDF, ModelFormatDXF, ModelFormatFBX, ModelFormatKMZ, ModelFormatCTM, ModelFormatSTL, ModelFormatDXF_3DF, ModelFormatTLS, ModelFormatABC, ModelFormatOSGB, ModelFormatOSGT, ModelFormatGLTF, ModelFormatX3D, ModelFormatLandXML]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class ModelGroup:
	key:  int
	"""Model group identifier.

	:type: int"""

	label:  str
	"""Model group label.

	:type: str"""

	meta:  MetaData
	"""Model group meta data.

	:type: MetaData"""

	def renderPreview (self, *args, **kwargs) -> Image:
		"""renderPreview(width = 2048, height = 2048, [transform], [progress])

		Generate block model preview image.

		:arg width: Preview image width.
		:type width: int
		:arg height: Preview image height.
		:type height: int
		:arg transform: 4x4 viewpoint transformation matrix.
		:type transform: Metashape.Matrix
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Preview image.
		:rtype: Metashape.Image"""
	...
	selected:  bool
	"""Current selection state.

	:type: bool"""


class NetworkClient:
	def abortBatch (self, *args, **kwargs):
		"""abortBatch(batch_id)

		Abort batch.

		:arg batch_id: Batch id.
		:type batch_id: int"""
	...
	def abortWorker (self, *args, **kwargs):
		"""abortWorker(worker_id)

		Abort worker.

		:arg worker_id: Worker id.
		:type worker_id: int"""
	...
	def batchInfo (self, *args, **kwargs) -> dict:
		"""batchInfo(batch_id, revision=0)

		Get batch information.

		:arg batch_id: Batch id.
		:type batch_id: int
		:arg revision: First revision to get.
		:type revision: int
		:return: Batch information.
		:rtype: dict"""
	...
	def batchList (self, *args, **kwargs) -> dict:
		"""batchList(revision=0)

		Get list of batches.

		:arg revision: First revision to get.
		:type revision: int
		:return: List of batches.
		:rtype: dict"""
	...
	def connect (self, *args, **kwargs):
		"""connect(host, port=5840)

		Connect to the server.

		:arg host: Server hostname.
		:type host: str
		:arg port: Communication port.
		:type port: int"""
	...
	def createBatch (self, *args, **kwargs) -> int:
		"""createBatch(path, tasks, [meta])

		Create new batch.

		:arg path: Project path relative to root folder.
		:type path: str
		:arg tasks: List of processing tasks to execute.
		:type tasks: list[Metashape.NetworkTask]
		:arg meta: Batch metadata.
		:type meta: Metashape.MetaData
		:return: Batch id.
		:rtype: int"""
	...
	def disconnect (self, *args, **kwargs):
		"""disconnect()

		Disconnect from the server."""
	...
	def exportBatches (self, *args, **kwargs) -> str:
		"""exportBatches([batch_ids])

		Export current state of batches.

		:arg batch_ids: List of batch ids to export.
		:type batch_ids: list[int]
		:return: Batches data.
		:rtype: str"""
	...
	def findBatch (self, *args, **kwargs) -> int:
		"""findBatch(path)

		Get batch id based on project path.

		:arg path: Project path relative to root folder.
		:type path: str
		:return: Batch id.
		:rtype: int"""
	...
	def importBatches (self, *args, **kwargs):
		"""importBatches(data)

		Import batches from exported data.

		:arg data: Batches data.
		:type data: str"""
	...
	def quitWorker (self, *args, **kwargs):
		"""quitWorker(worker_id)

		Quit worker.

		:arg worker_id: Worker id.
		:type worker_id: int"""
	...
	def serverInfo (self, *args, **kwargs) -> dict:
		"""serverInfo(revision=0)

		Get server information.

		:arg revision: First revision to get.
		:type revision: int
		:return: Server information.
		:rtype: dict"""
	...
	def serverVersion (self, *args, **kwargs) -> dict:
		"""serverVersion()

		Get server version.

		:return: Server version.
		:rtype: dict"""
	...
	def setBatchPaused (self, *args, **kwargs):
		"""setBatchPaused(batch_id, paused=True)

		Set batch paused state.

		:arg batch_id: Batch id.
		:type batch_id: int
		:arg paused: Paused state.
		:type paused: bool"""
	...
	def setBatchPriority (self, *args, **kwargs):
		"""setBatchPriority(batch_id, priority)

		Set batch priority.

		:arg batch_id: Batch id.
		:type batch_id: int
		:arg priority: Batch priority (2 - Highest, 1 - High, 0 - Normal, -1 - Low, -2 - Lowest).
		:type priority: int"""
	...
	def setBatchWorkerLimit (self, *args, **kwargs):
		"""setBatchWorkerLimit(batch_id, worker_limit)

		Set worker limit of the batch.

		:arg batch_id: Batch id.
		:type batch_id: int
		:arg worker_limit: Worker limit of the batch (0 - unlimited).
		:type worker_limit: int"""
	...
	def setWorkerCapability (self, *args, **kwargs):
		"""setWorkerCapability(worker_id, capability)

		Set worker capability.

		:arg worker_id: Worker id.
		:type worker_id: int
		:arg capability: Worker capability (1 - CPU, 2 - GPU, 3 - Any).
		:type capability: int"""
	...
	def setWorkerCpuEnabled (self, *args, **kwargs):
		"""setWorkerCpuEnabled(worker_id, cpu_enabled)

		Set worker CPU enabled flag.

		:arg worker_id: Worker id.
		:type worker_id: int
		:arg cpu_enabled: CPU enabled flag.
		:type cpu_enabled: bool"""
	...
	def setWorkerGpuMask (self, *args, **kwargs):
		"""setWorkerGpuMask(worker_id, gpu_mask)

		Set worker GPU mask.

		:arg worker_id: Worker id.
		:type worker_id: int
		:arg gpu_mask: GPU device mask.
		:type gpu_mask: int"""
	...
	def setWorkerPaused (self, *args, **kwargs):
		"""setWorkerPaused(worker_id, paused=True)

		Set worker paused state.

		:arg worker_id: Worker id.
		:type worker_id: int
		:arg paused: Paused state.
		:type paused: bool"""
	...
	def setWorkerPriority (self, *args, **kwargs):
		"""setWorkerPriority(worker_id, priority)

		Set worker priority.

		:arg worker_id: Worker id.
		:type worker_id: int
		:arg priority: Worker priority (2 - Highest, 1 - High, 0 - Normal, -1 - Low, -2 - Lowest).
		:type priority: int"""
	...
	def workerInfo (self, *args, **kwargs) -> dict:
		"""workerInfo(worker_id, revision=0)

		Get worker information.

		:arg worker_id: Worker id.
		:type worker_id: int
		:arg revision: First revision to get.
		:type revision: int
		:return: Worker information.
		:rtype: dict"""
	...
	def workerList (self, *args, **kwargs) -> dict:
		"""workerList(revision=0)

		Get list of workers.

		:arg revision: First revision to get.
		:type revision: int
		:return: List of workers.
		:rtype: dict"""
	...

class NetworkTask:
	chunks:  list
	"""List of chunks.

	:type: list"""

	frames:  list
	"""List of frames.

	:type: list"""

	gpu_support:  bool
	"""GPU support flag.

	:type: bool"""

	name:  str
	"""Task name.

	:type: str"""

	params:  dict
	"""Task parameters.

	:type: dict"""


class OrthoProjection:
	Cylindrical: Any
	"""Projection type in [Planar, Cylindrical]"""

	Planar: Any
	"""Projection type in [Planar, Cylindrical]"""


	class Type:
		"""Projection type in [Planar, Cylindrical]"""
		Cylindrical: Any
		"""Projection type in [Planar, Cylindrical]"""

		Planar: Any
		"""Projection type in [Planar, Cylindrical]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	def copy (self, *args, **kwargs) -> OrthoProjection:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.OrthoProjection"""
	...
	crs:  CoordinateSystem
	"""Base coordinate system.

	:type: CoordinateSystem"""

	matrix:  Matrix
	"""Ortho transformation matrix.

	:type: Matrix"""

	radius:  float
	"""Cylindrical projection radius.

	:type: float"""

	def transform (self, *args, **kwargs) -> Vector:
		"""transform(point, source, target)

		Transform point coordinates between coordinate systems.

		:arg point: 2D or 3D point coordinates.
		:type point: Metashape.Vector
		:arg source: Source coordinate system.
		:type source: Metashape.OrthoProjection | Metashape.CoordinateSystem
		:arg target: Target coordinate system.
		:type target: Metashape.OrthoProjection | Metashape.CoordinateSystem
		:return: Transformed point coordinates.
		:rtype: Metashape.Vector"""
	...
	type:  OrthoProjection.Type
	"""Projection type.

	:type: OrthoProjection.Type"""


class Orthomosaic:

	class Patch:
		"""Orthomosaic patch."""
		def copy (self, *args, **kwargs) -> Orthomosaic.Patch:
			"""copy()

			Returns a copy of the patch.

			:return: Copy of the patch.
			:rtype: Metashape.Orthomosaic.Patch"""
		...
		excluded:  bool
		"""Excluded flag.

		:type: bool"""

		image_keys:  list[int]
		"""Image keys.

		:type: list[int]"""

		inpaint:  bool
		"""Inpaint flag.

		:type: bool"""


	class Patches:
		"""A set of orthomosaic patches."""
		def items (self, *args, **kwargs):
			"""items()

			List of items."""
		...
		def keys (self, *args, **kwargs):
			"""keys()

			List of item keys."""
		...
		def values (self, *args, **kwargs):
			"""values()

			List of item values."""
		...
	bands:  list[str]
	"""List of color bands.

	:type: list[str]"""

	bottom:  float
	"""Y coordinate of the bottom side.

	:type: float"""

	def camera (self, *args, **kwargs) -> Camera:
		"""camera(point)

		Get camera used in orthomosaic at the specified point.

		:arg point: Point coordinates in the orthomosaic coordinate system.
		:type point: Metashape.Vector
		:return: Camera used in orthomosaic.
		:rtype: Metashape.Camera"""
	...
	def clear (self, *args, **kwargs):
		"""clear()

		Clears orthomosaic data."""
	...
	def copy (self, *args, **kwargs) -> Orthomosaic:
		"""copy()

		Create a copy of the orthomosaic.

		:return: Copy of the orthomosaic.
		:rtype: Metashape.Orthomosaic"""
	...
	def coverageArea (self, *args, **kwargs) -> float:
		"""coverageArea()

		Calculate coverage area of the orthomosaic in m^2. Only pixels with data are used.

		:return: Area covered by the orthomosaic.
		:rtype: float"""
	...
	crs:  CoordinateSystem
	"""Coordinate system of orthomosaic.

	:type: CoordinateSystem"""

	data_type:  DataType
	"""Data type used to store color values.

	:type: DataType"""

	height:  int
	"""Orthomosaic height.

	:type: int"""

	key:  int
	"""Orthomosaic identifier.

	:type: int"""

	label:  str
	"""Orthomosaic label.

	:type: str"""

	left:  float
	"""X coordinate of the left side.

	:type: float"""

	meta:  MetaData
	"""Orthomosaic meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	patches:  Orthomosaic.Patches
	"""Orthomosaic patches.

	:type: Orthomosaic.Patches"""

	projection:  OrthoProjection
	"""Orthomosaic projection.

	:type: OrthoProjection"""

	def removeOrthophotos (self, *args, **kwargs):
		"""removeOrthophotos()

		Remove orthorectified images from orthomosaic."""
	...
	def renderPreview (self, *args, **kwargs) -> Image:
		"""renderPreview(width = 2048, height = 2048, [progress])

		Generate orthomosaic preview image.

		:arg width: Preview image width.
		:type width: int
		:arg height: Preview image height.
		:type height: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Preview image.
		:rtype: Metashape.Image"""
	...
	def reset (self, *args, **kwargs):
		"""reset([progress])

		Reset all edits to orthomosaic.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	resolution:  float
	"""Orthomosaic resolution in meters.

	:type: float"""

	right:  float
	"""X coordinate of the right side.

	:type: float"""

	top:  float
	"""Y coordinate of the top side.

	:type: float"""

	def update (self, *args, **kwargs):
		"""update([progress])

		Apply edits to orthomosaic.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	width:  int
	"""Orthomosaic width.

	:type: int"""


class Photo:
	def alpha (self, *args, **kwargs) -> Image:
		"""alpha()

		Returns alpha channel data.

		:return: Alpha channel data.
		:rtype: Metashape.Image"""
	...
	def copy (self, *args, **kwargs) -> Photo:
		"""copy()

		Returns a copy of the photo.

		:return: Copy of the photo.
		:rtype: Metashape.Photo"""
	...
	def image (self, *args, **kwargs) -> Image:
		"""image([channels], [datatype])

		Returns image data.

		:arg datatype: pixel data type in ['U8', 'U16', 'U32', 'F16', 'F32', 'F64']
		:type datatype: str
		:arg channels: color channels to be loaded, e.g. 'RGB', 'RGBA', etc.
		:type channels: str
		:return: Image data.
		:rtype: Metashape.Image"""
	...
	def imageMeta (self, *args, **kwargs) -> MetaData:
		"""imageMeta()

		Returns image meta data.

		:return: Image meta data.
		:rtype: Metashape.MetaData"""
	...
	layer:  int
	"""Layer index in the image file.

	:type: int"""

	meta:  MetaData
	"""Frame meta data.

	:type: MetaData"""

	def open (self, *args, **kwargs):
		"""open(path, layer=0)

		Loads specified image file.

		:arg path: Path to the image file to be loaded.
		:type path: str
		:arg layer: Layer index in case of multipage files.
		:type layer: int"""
	...
	path:  str
	"""Path to the image file.

	:type: str"""

	def thumbnail (self, *args, **kwargs) -> Thumbnail:
		"""thumbnail(width=192, height=192)

		Creates new thumbnail with specified dimensions.

		:return: Thumbnail data.
		:rtype: Metashape.Thumbnail"""
	...

class PointClass:
	BridgeDeck: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	Building: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	Car: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	Created: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	Ground: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	HighNoise: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	HighVegetation: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	LowPoint: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	LowVegetation: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	Manmade: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	MediumVegetation: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	ModelKeyPoint: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	OverlapPoints: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	Rail: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	RoadSurface: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	TransmissionTower: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	Unclassified: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	Water: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	WireConductor: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	WireConnector: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	WireGuard: Any
	"""Point class in [Created, Unclassified, Ground, LowVegetation, MediumVegetation, HighVegetation, Building, LowPoint, ModelKeyPoint, Water, Rail, RoadSurface, OverlapPoints, WireGuard, WireConductor, TransmissionTower, WireConnector, BridgeDeck, HighNoise, Car, Manmade]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class PointCloud:

	class Point:
		"""Point of the point cloud"""
		classification:  int
		"""Point classification.

		:type: int"""

		color:  tuple[int | float, ...]
		"""Point color.

		:type: tuple[int | float, ...]"""

		column_index:  int
		"""Point column index.

		:type: int"""

		confidence:  int
		"""Point confidence.

		:type: int"""

		intensity:  int
		"""Point intensity.

		:type: int"""

		normal:  Vector
		"""Point normal.

		:type: Vector"""

		position:  Vector
		"""Point coordinates.

		:type: Vector"""

		return_count:  int
		"""Point return count.

		:type: int"""

		return_index:  int
		"""Point return index.

		:type: int"""

		row_index:  int
		"""Point row index.

		:type: int"""

		scan_angle:  float
		"""Point scan angle.

		:type: float"""

		source_id:  int
		"""Point source id.

		:type: int"""

		timestamp:  float
		"""Point timestamp.

		:type: float"""


	class Points:
		"""List of point cloud points"""

	class Reader:
		"""Point cloud reader."""
		column_count:  int
		"""Column count.

		:type: int"""

		has_point_classification:  bool
		"""Has point classification.

		:type: bool"""

		has_point_color:  bool
		"""Has point color.

		:type: bool"""

		has_point_confidence:  bool
		"""Has point confidence.

		:type: bool"""

		has_point_index:  bool
		"""Has point row and column indices.

		:type: bool"""

		has_point_intensity:  bool
		"""Has point intensity.

		:type: bool"""

		has_point_normal:  bool
		"""Has point normal.

		:type: bool"""

		has_point_return_number:  bool
		"""Has point return number.

		:type: bool"""

		has_point_scan_angle:  bool
		"""Has point scan angle.

		:type: bool"""

		has_point_source_id:  bool
		"""Has point source id.

		:type: bool"""

		has_point_timestamp:  bool
		"""Has point timestamp.

		:type: bool"""

		def open (self, *args, **kwargs):
			"""open(point_cloud)

			Open point cloud for reading."""
		...
		def read (self, *args, **kwargs) -> PointCloud.Points:
			"""read(count)

			Read specified number of points from the point cloud starting from the current position.

			:arg count: Number of points to read.
			:type count: int
			:return: Points data.
			:rtype: Metashape.PointCloud.Points"""
		...
		def reset (self, *args, **kwargs):
			"""reset()

			Reset reading position to the first point in the cloud."""
		...
		row_count:  int
		"""Row count.

		:type: int"""

	def alignNormals (self, *args, **kwargs):
		"""alignNormals(direction, [point_classes], [progress])

		Align selected point normals with specified direction.

		:arg direction: Normal direction in the chunk coordinate system.
		:type direction: Metashape.Vector
		:arg point_classes: Classes of points to process.
		:type point_classes: Metashape.PointClass | list[Metashape.PointClass]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def assignClass (self, *args, **kwargs):
		"""assignClass(target=0, [source], [progress])

		Assign class to points.

		:arg target: Target class.
		:type target: Metashape.PointClass
		:arg source: Classes of points to be replaced.
		:type source: Metashape.PointClass | list[Metashape.PointClass]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def assignClassToSelection (self, *args, **kwargs):
		"""assignClassToSelection(target=0, [source], [progress])

		Assign class to selected points.

		:arg target: Target class.
		:type target: Metashape.PointClass
		:arg source: Classes of points to be replaced.
		:type source: Metashape.PointClass | list[Metashape.PointClass]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	bands:  list[str]
	"""List of color bands.

	:type: list[str]"""

	def classifyGroundPoints (self, *args, **kwargs):
		"""classifyGroundPoints(max_angle=10.0, max_distance=1.0, max_terrain_slope=10.0, cell_size=50.0, erosion_radius=0.0, [source_class], [return_number], keep_existing=False, [progress])

		Classify points into ground and non ground classes.

		:arg max_angle: Maximum angle (degrees).
		:type max_angle: float
		:arg max_distance: Maximum distance (meters).
		:type max_distance: float
		:arg max_terrain_slope: Maximum terrain slope angle (degrees).
		:type max_terrain_slope: float
		:arg cell_size: Cell size (meters).
		:type cell_size: float
		:arg erosion_radius: Erosion radius (meters).
		:type erosion_radius: float
		:arg source_class: Class of points to be re-classified.
		:type source_class: Metashape.PointClass
		:arg return_number: Point return number to use (0 - any return, 1 - first return, -1 - last return).
		:type return_number: int
		:arg keep_existing: Keep existing ground points.
		:type keep_existing: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def classifyOverlapPoints (self, *args, **kwargs):
		"""classifyOverlapPoints([progress])

		Classify overlap points.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def classifyPoints (self, *args, **kwargs):
		"""classifyPoints([source], [target], confidence=0.0, [progress])

		Multiclass classification of points.

		:arg source: Class of points to be re-classified.
		:type source: Metashape.PointClass
		:arg target: Target point classes for classification.
		:type target: list[Metashape.PointClass]
		:arg confidence: Required confidence level from 0.0 to 1.0.
		:type confidence: float
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def clear (self, *args, **kwargs):
		"""clear()

		Clears point cloud data."""
	...
	def compactPoints (self, *args, **kwargs):
		"""compactPoints([progress])

		Permanently removes deleted points from point cloud.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	component:  Component
	"""Point cloud component.

	:type: Component"""

	def copy (self, *args, **kwargs) -> PointCloud:
		"""copy()

		Create a copy of the point cloud.

		:return: Copy of the point cloud.
		:rtype: Metashape.PointCloud"""
	...
	def cropSelectedPoints (self, *args, **kwargs):
		"""cropSelectedPoints([point_classes], [progress])

		Crop selected points.

		:arg point_classes: Classes of points to be removed.
		:type point_classes: Metashape.PointClass | list[Metashape.PointClass]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	crs:  CoordinateSystem | None
	"""Reference coordinate system.

	:type: CoordinateSystem | None"""

	data_type:  DataType
	"""Data type used to store color values.

	:type: DataType"""

	enabled:  bool
	"""Enables/disables the point cloud.

	:type: bool"""

	def extent (self, *args, **kwargs) -> BBox:
		"""extent([transform])

		Get point cloud extent.

		:arg transform: Optional transformation to apply to point coordinates.
		:type transform: Metashape.Matrix
		:return: Point cloud extent.
		:rtype: Metashape.BBox"""
	...
	def generatePanorama (self, *args, **kwargs):
		"""generatePanorama(ignore_colors=False, [progress])

		Generate panorama for structured point cloud.

		:arg ignore_colors: Use intensity information instead of point colors.
		:type ignore_colors: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	group:  PointCloudGroup
	"""Point cloud group.

	:type: PointCloudGroup"""

	def invertNormals (self, *args, **kwargs):
		"""invertNormals([point_classes], [progress])

		Invert selected point normals.

		:arg point_classes: Classes of points to process.
		:type point_classes: Metashape.PointClass | list[Metashape.PointClass]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def invertSelection (self, *args, **kwargs):
		"""invertSelection()

		Invert selection."""
	...
	is_laser_scan:  bool
	"""Use point cloud as laser scan.

	:type: bool"""

	key:  int
	"""Point cloud identifier.

	:type: int"""

	label:  str
	"""Point cloud label.

	:type: str"""

	meta:  MetaData
	"""Point cloud meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def pickPoint (self, *args, **kwargs) -> Vector:
		"""pickPoint(origin, target, endpoints=1)

		Returns ray intersection with the point cloud (point on the ray nearest to some point).

		:arg origin: Ray origin in the chunk coordinate system.
		:type origin: Metashape.Vector
		:arg target: Point on the ray in the chunk coordinate system.
		:type target: Metashape.Vector
		:arg endpoints: Number of endpoints to check for (0 - line, 1 - ray, 2 - segment).
		:type endpoints: int
		:return: Coordinates of the intersection point.
		:rtype: Metashape.Vector"""
	...
	point_count:  int
	"""Number of points in point cloud.

	:type: int"""

	point_count_by_class:  dict
	"""Number of points in each class.

	:type: dict"""

	def removePoints (self, *args, **kwargs):
		"""removePoints(point_classes, [progress])

		Remove points.

		:arg point_classes: Classes of points to be removed.
		:type point_classes: Metashape.PointClass | list[Metashape.PointClass]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def removeSelectedPoints (self, *args, **kwargs):
		"""removeSelectedPoints([point_classes], [progress])

		Remove selected points.

		:arg point_classes: Classes of points to be removed.
		:type point_classes: Metashape.PointClass | list[Metashape.PointClass]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def renderDepth (self, *args, **kwargs) -> Image:
		"""renderDepth(transform, calibration, point_size=1, resolution=1, cull_points=False, add_alpha=True)

		Render point cloud depth image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg point_size: Point size.
		:type point_size: int
		:arg resolution: Level of detail resolution in screen pixels.
		:type resolution: float
		:arg cull_points: Enable normal based culling.
		:type cull_points: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderImage (self, *args, **kwargs) -> Image:
		"""renderImage(transform, calibration, point_size=1, resolution=1, cull_points=False, add_alpha=True, raster_transform=RasterTransformNone)

		Render point cloud image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg point_size: Point size.
		:type point_size: int
		:arg resolution: Level of detail resolution in screen pixels.
		:type resolution: float
		:arg cull_points: Enable normal based culling.
		:type cull_points: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.RasterTransformType
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderMask (self, *args, **kwargs) -> Image:
		"""renderMask(transform, calibration, point_size=1, resolution=1, cull_points=False)

		Render point cloud mask image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg point_size: Point size.
		:type point_size: int
		:arg resolution: Level of detail resolution in screen pixels.
		:type resolution: float
		:arg cull_points: Enable normal based culling.
		:type cull_points: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderNormalMap (self, *args, **kwargs) -> Image:
		"""renderNormalMap(transform, calibration, point_size=1, resolution=1, cull_points=False, add_alpha=True)

		Render image with point cloud normals for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg point_size: Point size.
		:type point_size: int
		:arg resolution: Level of detail resolution in screen pixels.
		:type resolution: float
		:arg cull_points: Enable normal based culling.
		:type cull_points: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderPreview (self, *args, **kwargs) -> Image:
		"""renderPreview(width = 2048, height = 2048, [transform], point_size=1, [progress])

		Generate point cloud preview image.

		:arg width: Preview image width.
		:type width: int
		:arg height: Preview image height.
		:type height: int
		:arg transform: 4x4 viewpoint transformation matrix.
		:type transform: Metashape.Matrix
		:arg point_size: Point size.
		:type point_size: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Preview image.
		:rtype: Metashape.Image"""
	...
	def resetFilters (self, *args, **kwargs):
		"""resetFilters()

		Reset filters."""
	...
	def restorePoints (self, *args, **kwargs):
		"""restorePoints([point_classes], [progress])

		Restore deleted points.

		:arg point_classes: Classes of points to be restored.
		:type point_classes: Metashape.PointClass | list[Metashape.PointClass]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def selectMaskedPoints (self, *args, **kwargs):
		"""selectMaskedPoints(cameras, softness=4, only_visible=False, [progress])

		Select points based on image masks.

		:arg cameras: A list of cameras to use for selection.
		:type cameras: list[Metashape.Camera]
		:arg softness: Mask edge softness.
		:type softness: float
		:arg only_visible: Select visible points only.
		:type only_visible: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def selectPointsByColor (self, *args, **kwargs):
		"""selectPointsByColor(color, tolerance=10, channels='RGB', [progress])

		Select points based on point colors.

		:arg color: Color to select.
		:type color: list[int]
		:arg tolerance: Color tolerance.
		:type tolerance: int
		:arg channels: Combination of color channels to compare in ['R', 'G', 'B', 'H', 'S', 'V'].
		:type channels: str
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def selectPointsByRegion (self, *args, **kwargs):
		"""selectPointsByRegion(region)

		Select points inside box region.

		:arg region: Box region to select in chunk coordinates
		:type region: Metashape.Region"""
	...
	def selectPointsByShapes (self, *args, **kwargs):
		"""selectPointsByShapes([shapes], [progress])

		Select points based on shapes.

		:arg shapes: A list of shapes to use for selection (selected shapes if not specified).
		:type shapes: list[Metashape.Shape]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	selected:  bool
	"""Selects/deselects the point cloud.

	:type: bool"""

	def setClassesFilter (self, *args, **kwargs):
		"""setClassesFilter(point_classes)

		Set filter by point classes.

		:arg point_classes: List of point classes.
		:type point_classes: Metashape.PointClass | list[Metashape.PointClass]"""
	...
	def setConfidenceFilter (self, *args, **kwargs):
		"""setConfidenceFilter(min_confidence, max_confidence)

		Set filter by confidence.

		:arg min_confidence: Minimum confidence value.
		:type min_confidence: int
		:arg max_confidence: Maximum confidence value.
		:type max_confidence: int"""
	...
	def setPointReturnsFilter (self, *args, **kwargs):
		"""setPointReturnsFilter(first_return=True, middle_return=True, last_return=True, single_return=True)

		Set filter by point return.

		:arg first_return: First return.
		:type first_return: bool
		:arg middle_return: Intermediate return.
		:type middle_return: bool
		:arg last_return: Last return.
		:type last_return: bool
		:arg single_return: Single return.
		:type single_return: bool"""
	...
	def setSelectionFilter (self, *args, **kwargs):
		"""setSelectionFilter()

		Set filter by selection."""
	...
	transform:  Matrix
	"""4x4 point cloud transformation matrix.

	:type: Matrix"""

	def updateStatistics (self, *args, **kwargs):
		"""updateStatistics([progress])

		Update point cloud statistics.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...

class PointCloudFormat:
	PointCloudFormatCL3: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatCOPC: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatCSV: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatCesium: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatDXF: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatE57: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatExpe: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatLAS: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatLAZ: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatNone: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatOBJ: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatOC3: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatPCD: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatPDF: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatPLY: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatPTS: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatPTX: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatPotree: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatSLPK: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatU3D: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	PointCloudFormatXYZ: Any
	"""Point cloud format in [PointCloudFormatNone, PointCloudFormatOBJ, PointCloudFormatPLY, PointCloudFormatXYZ, PointCloudFormatLAS, PointCloudFormatExpe, PointCloudFormatU3D, PointCloudFormatPDF, PointCloudFormatE57, PointCloudFormatOC3, PointCloudFormatPotree, PointCloudFormatLAZ, PointCloudFormatCL3, PointCloudFormatPTS, PointCloudFormatPTX, PointCloudFormatDXF, PointCloudFormatCesium, PointCloudFormatPCD, PointCloudFormatSLPK, PointCloudFormatCOPC, PointCloudFormatCSV]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class PointCloudGroup:
	crs:  CoordinateSystem | None
	"""Reference coordinate system.

	:type: CoordinateSystem | None"""

	fixed:  bool
	"""Fix relative laser scan positions within the group.

	:type: bool"""

	key:  int
	"""Asset group identifier.

	:type: int"""

	label:  str
	"""Point cloud group label.

	:type: str"""

	meta:  MetaData
	"""Asset group meta data.

	:type: MetaData"""

	selected:  bool
	"""Current selection state.

	:type: bool"""

	transform:  Matrix
	"""4x4 asset group transformation matrix.

	:type: Matrix"""


class Preselection:
	GenericPreselection: Any
	"""Image pair preselection in [NoPreselection, GenericPreselection, ReferencePreselection]"""

	NoPreselection: Any
	"""Image pair preselection in [NoPreselection, GenericPreselection, ReferencePreselection]"""

	ReferencePreselection: Any
	"""Image pair preselection in [NoPreselection, GenericPreselection, ReferencePreselection]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class RPCModel:
	def copy (self, *args, **kwargs) -> RPCModel:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.RPCModel"""
	...
	def error (self, *args, **kwargs) -> Vector:
		"""error(point, proj)

		Returns projection error.

		:arg point: Coordinates of the point to be projected.
		:type point: Metashape.Vector
		:arg proj: Pixel coordinates of the point.
		:type proj: Metashape.Vector
		:return: 2D projection error.
		:rtype: Metashape.Vector"""
	...
	image_offset:  Vector
	"""Image coordinate offset.

	:type: Vector"""

	image_scale:  Vector
	"""Image coordinate scale.

	:type: Vector"""

	line_den_coeff:  Vector
	"""Line denominator.

	:type: Vector"""

	line_num_coeff:  Vector
	"""Line numerator.

	:type: Vector"""

	def load (self, *args, **kwargs):
		"""load(path, [format])

		Load RPC model from file.

		:arg path: Path to RPC model file.
		:type path: str
		:arg format: RPC model file format in ['rpc', 'rpb', 'dimap']. Tiled DIMAP files are not supported.
		:type format: str"""
	...
	object_offset:  Vector
	"""Object coordinate offset.

	:type: Vector"""

	object_scale:  Vector
	"""Object coordinate scale.

	:type: Vector"""

	def project (self, *args, **kwargs) -> Vector:
		"""project(point)

		Returns projected pixel coordinates of the point.

		:arg point: Coordinates of the point to be projected.
		:type point: Metashape.Vector
		:return: 2D projected point coordinates.
		:rtype: Metashape.Vector"""
	...
	samp_den_coeff:  Vector
	"""Sample denominator.

	:type: Vector"""

	samp_num_coeff:  Vector
	"""Sample numerator.

	:type: Vector"""

	def save (self, *args, **kwargs):
		"""save(path, [format])

		Save RPC model to file.

		:arg path: Path to RPC model file.
		:type path: str
		:arg format: RPC model file format in ['rpc', 'rpb'].
		:type format: str"""
	...
	def unproject (self, *args, **kwargs) -> Vector:
		"""unproject(point)

		Returns direction corresponding to the image point.

		:arg point: Pixel coordinates of the point.
		:type point: Metashape.Vector
		:return: 3D vector in the camera coordinate system.
		:rtype: Metashape.Vector"""
	...

class RasterFormat:
	RasterFormatGeoPackage: Any
	"""Raster format in [RasterFormatNone, RasterFormatTiles, RasterFormatKMZ, RasterFormatXYZ, RasterFormatMBTiles, RasterFormatWW, RasterFormatTMS, RasterFormatGeoPackage]"""

	RasterFormatKMZ: Any
	"""Raster format in [RasterFormatNone, RasterFormatTiles, RasterFormatKMZ, RasterFormatXYZ, RasterFormatMBTiles, RasterFormatWW, RasterFormatTMS, RasterFormatGeoPackage]"""

	RasterFormatMBTiles: Any
	"""Raster format in [RasterFormatNone, RasterFormatTiles, RasterFormatKMZ, RasterFormatXYZ, RasterFormatMBTiles, RasterFormatWW, RasterFormatTMS, RasterFormatGeoPackage]"""

	RasterFormatNone: Any
	"""Raster format in [RasterFormatNone, RasterFormatTiles, RasterFormatKMZ, RasterFormatXYZ, RasterFormatMBTiles, RasterFormatWW, RasterFormatTMS, RasterFormatGeoPackage]"""

	RasterFormatTMS: Any
	"""Raster format in [RasterFormatNone, RasterFormatTiles, RasterFormatKMZ, RasterFormatXYZ, RasterFormatMBTiles, RasterFormatWW, RasterFormatTMS, RasterFormatGeoPackage]"""

	RasterFormatTiles: Any
	"""Raster format in [RasterFormatNone, RasterFormatTiles, RasterFormatKMZ, RasterFormatXYZ, RasterFormatMBTiles, RasterFormatWW, RasterFormatTMS, RasterFormatGeoPackage]"""

	RasterFormatWW: Any
	"""Raster format in [RasterFormatNone, RasterFormatTiles, RasterFormatKMZ, RasterFormatXYZ, RasterFormatMBTiles, RasterFormatWW, RasterFormatTMS, RasterFormatGeoPackage]"""

	RasterFormatXYZ: Any
	"""Raster format in [RasterFormatNone, RasterFormatTiles, RasterFormatKMZ, RasterFormatXYZ, RasterFormatMBTiles, RasterFormatWW, RasterFormatTMS, RasterFormatGeoPackage]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class RasterTransform:
	def calibrateRange (self, *args, **kwargs):
		"""calibrateRange()

		Auto detect range based on orthomosaic histogram."""
	...
	def copy (self, *args, **kwargs) -> RasterTransform:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.RasterTransform"""
	...
	enabled:  bool
	"""Enable flag.

	:type: bool"""

	false_color:  list
	"""False color channels.

	:type: list"""

	formula:  str
	"""Raster calculator expression.

	:type: str"""

	interpolation:  bool
	"""Interpolation enable flag.

	:type: bool"""

	palette:  dict
	"""Color palette.

	:type: dict"""

	range:  tuple
	"""Palette mapping range.

	:type: tuple"""

	def reset (self, *args, **kwargs):
		"""reset()

		Reset raster transform."""
	...

class RasterTransformType:
	RasterTransformNone: Any
	"""Raster transformation type in [RasterTransformNone, RasterTransformValue, RasterTransformPalette]"""

	RasterTransformPalette: Any
	"""Raster transformation type in [RasterTransformNone, RasterTransformValue, RasterTransformPalette]"""

	RasterTransformValue: Any
	"""Raster transformation type in [RasterTransformNone, RasterTransformValue, RasterTransformPalette]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class ReferenceFormat:
	ReferenceFormatAPM: Any
	"""Reference format in [ReferenceFormatNone, ReferenceFormatXML, ReferenceFormatTEL, ReferenceFormatCSV, ReferenceFormatMavinci, ReferenceFormatBramor, ReferenceFormatAPM]"""

	ReferenceFormatBramor: Any
	"""Reference format in [ReferenceFormatNone, ReferenceFormatXML, ReferenceFormatTEL, ReferenceFormatCSV, ReferenceFormatMavinci, ReferenceFormatBramor, ReferenceFormatAPM]"""

	ReferenceFormatCSV: Any
	"""Reference format in [ReferenceFormatNone, ReferenceFormatXML, ReferenceFormatTEL, ReferenceFormatCSV, ReferenceFormatMavinci, ReferenceFormatBramor, ReferenceFormatAPM]"""

	ReferenceFormatMavinci: Any
	"""Reference format in [ReferenceFormatNone, ReferenceFormatXML, ReferenceFormatTEL, ReferenceFormatCSV, ReferenceFormatMavinci, ReferenceFormatBramor, ReferenceFormatAPM]"""

	ReferenceFormatNone: Any
	"""Reference format in [ReferenceFormatNone, ReferenceFormatXML, ReferenceFormatTEL, ReferenceFormatCSV, ReferenceFormatMavinci, ReferenceFormatBramor, ReferenceFormatAPM]"""

	ReferenceFormatTEL: Any
	"""Reference format in [ReferenceFormatNone, ReferenceFormatXML, ReferenceFormatTEL, ReferenceFormatCSV, ReferenceFormatMavinci, ReferenceFormatBramor, ReferenceFormatAPM]"""

	ReferenceFormatXML: Any
	"""Reference format in [ReferenceFormatNone, ReferenceFormatXML, ReferenceFormatTEL, ReferenceFormatCSV, ReferenceFormatMavinci, ReferenceFormatBramor, ReferenceFormatAPM]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class ReferenceItems:
	ReferenceItemsAll: Any
	"""Reference items in [ReferenceItemsCameras, ReferenceItemsMarkers, ReferenceItemsScalebars, ReferenceItemsAll]"""

	ReferenceItemsCameras: Any
	"""Reference items in [ReferenceItemsCameras, ReferenceItemsMarkers, ReferenceItemsScalebars, ReferenceItemsAll]"""

	ReferenceItemsMarkers: Any
	"""Reference items in [ReferenceItemsCameras, ReferenceItemsMarkers, ReferenceItemsScalebars, ReferenceItemsAll]"""

	ReferenceItemsScalebars: Any
	"""Reference items in [ReferenceItemsCameras, ReferenceItemsMarkers, ReferenceItemsScalebars, ReferenceItemsAll]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class ReferencePreselectionMode:
	ReferencePreselectionEstimated: Any
	"""Reference preselection mode in [ReferencePreselectionSource, ReferencePreselectionEstimated, ReferencePreselectionSequential]"""

	ReferencePreselectionSequential: Any
	"""Reference preselection mode in [ReferencePreselectionSource, ReferencePreselectionEstimated, ReferencePreselectionSequential]"""

	ReferencePreselectionSource: Any
	"""Reference preselection mode in [ReferencePreselectionSource, ReferencePreselectionEstimated, ReferencePreselectionSequential]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Region:
	center:  Vector
	"""Region center coordinates.

	:type: Vector"""

	def copy (self, *args, **kwargs) -> Region:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Region"""
	...
	rot:  Matrix
	"""Region rotation matrix.

	:type: Matrix"""

	size:  Vector
	"""Region size.

	:type: Vector"""


class RotationOrder:
	RotationOrderXYZ: Any
	"""Rotation order in [RotationOrderXYZ, RotationOrderXZY, RotationOrderYXZ, RotationOrderYZX, RotationOrderZXY, RotationOrderZYX]"""

	RotationOrderXZY: Any
	"""Rotation order in [RotationOrderXYZ, RotationOrderXZY, RotationOrderYXZ, RotationOrderYZX, RotationOrderZXY, RotationOrderZYX]"""

	RotationOrderYXZ: Any
	"""Rotation order in [RotationOrderXYZ, RotationOrderXZY, RotationOrderYXZ, RotationOrderYZX, RotationOrderZXY, RotationOrderZYX]"""

	RotationOrderYZX: Any
	"""Rotation order in [RotationOrderXYZ, RotationOrderXZY, RotationOrderYXZ, RotationOrderYZX, RotationOrderZXY, RotationOrderZYX]"""

	RotationOrderZXY: Any
	"""Rotation order in [RotationOrderXYZ, RotationOrderXZY, RotationOrderYXZ, RotationOrderYZX, RotationOrderZXY, RotationOrderZYX]"""

	RotationOrderZYX: Any
	"""Rotation order in [RotationOrderXYZ, RotationOrderXZY, RotationOrderYXZ, RotationOrderYZX, RotationOrderZXY, RotationOrderZYX]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Scalebar:

	class Reference:
		"""Scale bar reference data"""
		accuracy:  float
		"""Scale bar length accuracy.

		:type: float"""

		distance:  float
		"""Scale bar length.

		:type: float"""

		enabled:  bool
		"""Enabled flag.

		:type: bool"""

	chunk:  Chunk
	"""Chunk the scalebar belongs to.

	:type: Chunk"""

	frames:  list[Scalebar]
	"""Scale bar frames.

	:type: list[Scalebar]"""

	group:  ScalebarGroup
	"""Scale bar group.

	:type: ScalebarGroup"""

	key:  int
	"""Scale bar identifier.

	:type: int"""

	label:  str
	"""Scale bar label.

	:type: str"""

	meta:  MetaData
	"""Scale bar meta data.

	:type: MetaData"""

	point0:  Marker | Camera
	"""Start of the scale bar.

	:type: Marker | Camera"""

	point1:  Marker | Camera
	"""End of the scale bar.

	:type: Marker | Camera"""

	reference:  Scalebar.Reference
	"""Scale bar reference data.

	:type: Scalebar.Reference"""

	selected:  bool
	"""Selects/deselects the scale bar.

	:type: bool"""


class ScalebarGroup:
	key:  int
	"""Scale bar group identifier.

	:type: int"""

	label:  str
	"""Scale bar group label.

	:type: str"""

	selected:  bool
	"""Current selection state.

	:type: bool"""


class Sensor:
	Cylindrical: Any
	"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""

	Fisheye: Any
	"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""

	Frame: Any
	"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""

	RPC: Any
	"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""


	class Reference:
		"""Sensor reference data."""
		accuracy:  Vector
		"""Sensor location accuracy.

		:type: Vector"""

		enabled:  bool
		"""Location enabled flag.

		:type: bool"""

		location:  Vector
		"""Sensor coordinates.

		:type: Vector"""

		location_accuracy:  Vector
		"""Sensor location accuracy.

		:type: Vector"""

		location_enabled:  bool
		"""Location enabled flag.

		:type: bool"""

		rotation:  Vector
		"""Sensor rotation angles.

		:type: Vector"""

		rotation_accuracy:  Vector
		"""Sensor rotation accuracy.

		:type: Vector"""

		rotation_enabled:  bool
		"""Rotation enabled flag.

		:type: bool"""

	Spherical: Any
	"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""


	class Type:
		"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""
		Cylindrical: Any
		"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""

		Fisheye: Any
		"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""

		Frame: Any
		"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""

		RPC: Any
		"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""

		Spherical: Any
		"""Sensor type in [Frame, Fisheye, Spherical, Cylindrical, RPC]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	antenna:  Antenna
	"""GPS antenna correction.

	:type: Antenna"""

	bands:  list[str]
	"""List of color bands.

	:type: list[str]"""

	black_level:  list[float]
	"""Black level for each band.

	:type: list[float]"""

	def calibrateFiducials (self, *args, **kwargs):
		"""calibrateFiducials(resolution=0.014)

		Fit fiducial coordinates to image measurements.

		:arg resolution: Scanning resolution in mm/pix.
		:type resolution: float"""
	...
	calibration:  Calibration
	"""Adjusted calibration of the photo.

	:type: Calibration"""

	chunk:  Chunk
	"""Chunk the sensor belongs to.

	:type: Chunk"""

	data_type:  DataType
	"""Data type used to store color values.

	:type: DataType"""

	fiducials:  list[Marker]
	"""Fiducial marks.

	:type: list[Marker]"""

	film_camera:  bool
	"""Film camera flag.

	:type: bool"""

	fixed:  bool
	"""Fix calibration flag.

	:type: bool"""

	fixed_calibration:  bool
	"""Fix calibration flag.

	:type: bool"""

	fixed_location:  bool
	"""Fix location flag.

	:type: bool"""

	fixed_params:  list[str]
	"""List of fixed calibration parameters.

	:type: list[str]"""

	fixed_rotation:  bool
	"""Fix rotation flag.

	:type: bool"""

	focal_length:  float
	"""Focal length in mm.

	:type: float"""

	height:  int
	"""Image height.

	:type: int"""

	key:  int
	"""Sensor identifier.

	:type: int"""

	label:  str
	"""Sensor label.

	:type: str"""

	layer_index:  int
	"""Sensor layer index.

	:type: int"""

	location:  Vector
	"""Sensor plane location.

	:type: Vector"""

	location_covariance:  Matrix
	"""Sensor plane location covariance.

	:type: Matrix"""

	def makeMaster (self, *args, **kwargs):
		"""makeMaster()

		Make this sensor master in the multi-camera system."""
	...
	master:  Sensor
	"""Master sensor.

	:type: Sensor"""

	meta:  MetaData
	"""Sensor meta data.

	:type: MetaData"""

	normalize_sensitivity:  bool
	"""Enable sensitivity normalization.

	:type: bool"""

	normalize_to_float:  bool
	"""Convert pixel values to floating point after normalization.

	:type: bool"""

	photo_params:  list[str]
	"""List of image-variant calibration parameters.

	:type: list[str]"""

	pixel_height:  float
	"""Pixel height in mm.

	:type: float"""

	pixel_size:  Vector
	"""Pixel size in mm.

	:type: Vector"""

	pixel_width:  float
	"""Pixel width in mm.

	:type: float"""

	planes:  list[Sensor]
	"""Sensor planes.

	:type: list[Sensor]"""

	reference:  Sensor.Reference
	"""Sensor reference data.

	:type: Sensor.Reference"""

	rolling_shutter:  Shutter.Model
	"""Enable rolling shutter compensation.

	:type: Shutter.Model"""

	rotation:  Matrix
	"""Sensor plane rotation.

	:type: Matrix"""

	rotation_covariance:  Matrix
	"""Sensor plane rotation covariance.

	:type: Matrix"""

	sensitivity:  list[float]
	"""Sensitivity for each band.

	:type: list[float]"""

	type:  Sensor.Type
	"""Sensor projection model.

	:type: Sensor.Type"""

	user_calib:  Calibration
	"""Custom calibration used as initial calibration during photo alignment.

	:type: Calibration"""

	vignetting:  list[Vignetting]
	"""Vignetting for each band.

	:type: list[Vignetting]"""

	width:  int
	"""Image width.

	:type: int"""


class ServiceType:
	Service4DMapper: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	ServiceAgisoftCloud: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	ServiceCesium: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	ServiceMapbox: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	ServiceNira: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	ServicePicterra: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	ServicePointbox: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	ServicePointscene: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	ServiceSketchfab: Any
	"""Service type in [ServiceSketchfab, ServiceMapbox, Service4DMapper, ServiceAgisoftCloud, ServicePointscene, ServicePointbox, ServicePicterra, ServiceCesium, ServiceNira]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Shape:

	class BoundaryType:
		"""Shape boundary type in [NoBoundary, OuterBoundary, InnerBoundary]"""
		InnerBoundary: Any
		"""Shape boundary type in [NoBoundary, OuterBoundary, InnerBoundary]"""

		NoBoundary: Any
		"""Shape boundary type in [NoBoundary, OuterBoundary, InnerBoundary]"""

		OuterBoundary: Any
		"""Shape boundary type in [NoBoundary, OuterBoundary, InnerBoundary]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	InnerBoundary: Any
	"""Shape boundary type in [NoBoundary, OuterBoundary, InnerBoundary]"""

	NoBoundary: Any
	"""Shape boundary type in [NoBoundary, OuterBoundary, InnerBoundary]"""

	OuterBoundary: Any
	"""Shape boundary type in [NoBoundary, OuterBoundary, InnerBoundary]"""


	class Vertices:
		"""Collection of shape vertices"""
	def area (self, *args, **kwargs) -> float:
		"""area()

		Return area of the shape on DEM.

		:return: Shape area.
		:rtype: float"""
	...
	def areaFitted (self, *args, **kwargs) -> float:
		"""areaFitted()

		Return 2D area of the shape projected onto the best fitting plane.

		:return: Shape area.
		:rtype: float"""
	...
	attributes:  MetaData
	"""Shape attributes.

	:type: MetaData"""

	boundary_type:  Shape.BoundaryType
	"""Shape boundary type.

	:type: Shape.BoundaryType"""

	geometry:  Geometry | AttachedGeometry
	"""Shape geometry.

	:type: Geometry | AttachedGeometry"""

	group:  ShapeGroup
	"""Shape group.

	:type: ShapeGroup"""

	is_attached:  bool
	"""Attached flag.

	:type: bool"""

	key:  int
	"""Shape identifier.

	:type: int"""

	label:  str
	"""Shape label.

	:type: str"""

	def perimeter2D (self, *args, **kwargs) -> float:
		"""perimeter2D()

		Return perimeter of the shape on DEM.

		:return: Shape perimeter.
		:rtype: float"""
	...
	def perimeter3D (self, *args, **kwargs) -> float:
		"""perimeter3D()

		Return perimeter of the shape.

		:return: Shape perimeter.
		:rtype: float"""
	...
	selected:  bool
	"""Selects/deselects the shape.

	:type: bool"""

	def volume (self, *args, **kwargs) -> dict:
		"""volume(level='bestfit')

		Return volume of the shape measured on DEM above and below best fit, mean level or custom level plane.

		:arg level: Plane level: 'bestfit', 'mean' or custom value.
		:type level: float
		:return: Shape volumes.
		:rtype: dict"""
	...

class ShapeGroup:
	color:  tuple[int, int, int, int]
	"""Shape group color.

	:type: tuple[int, int, int, int]"""

	enabled:  bool
	"""Enable flag.

	:type: bool"""

	key:  int
	"""Shape group identifier.

	:type: int"""

	label:  str
	"""Shape group label.

	:type: str"""

	meta:  MetaData
	"""Shape group meta data.

	:type: MetaData"""

	selected:  bool
	"""Current selection state.

	:type: bool"""

	show_labels:  bool
	"""Shape labels visibility flag.

	:type: bool"""


class Shapes:
	def addGroup (self, *args, **kwargs) -> ShapeGroup:
		"""addGroup()

		Add new shape group to the set of shapes.

		:return: Created shape group.
		:rtype: Metashape.ShapeGroup"""
	...
	def addShape (self, *args, **kwargs) -> Shape:
		"""addShape()

		Add new shape to the set of shapes.

		:return: Created shape.
		:rtype: Metashape.Shape"""
	...
	crs:  CoordinateSystem
	"""Shapes coordinate system.

	:type: CoordinateSystem"""

	group:  ShapeGroup
	"""Default shape group.

	:type: ShapeGroup"""

	groups:  list[ShapeGroup]
	"""List of shape groups.

	:type: list[ShapeGroup]"""

	def items (self, *args, **kwargs):
		"""items()

		List of items."""
	...
	meta:  MetaData
	"""Shapes meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	projection:  OrthoProjection
	"""Shapes projection.

	:type: OrthoProjection"""

	def remove (self, *args, **kwargs):
		"""remove(items)

		Remove items from the shape layer.

		:arg items: A list of items to be removed.
		:type items: list[Metashape.Shape | Metashape.ShapeGroup]"""
	...
	shapes:  list[Shape]
	"""List of shapes.

	:type: list[Shape]"""

	def updateAltitudes (self, *args, **kwargs):
		"""updateAltitudes(items, [progress])

		Update altitudes for items.

		:arg items: A list of items to be updated.
		:type items: list[Metashape.Shape | Metashape.ShapeGroup]
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...

class ShapesFormat:
	ShapesFormatCSV: Any
	"""Shapes format in [ShapesFormatNone, ShapesFormatSHP, ShapesFormatKML, ShapesFormatDXF, ShapesFormatGeoJSON, ShapesFormatGeoPackage, ShapesFormatCSV]"""

	ShapesFormatDXF: Any
	"""Shapes format in [ShapesFormatNone, ShapesFormatSHP, ShapesFormatKML, ShapesFormatDXF, ShapesFormatGeoJSON, ShapesFormatGeoPackage, ShapesFormatCSV]"""

	ShapesFormatGeoJSON: Any
	"""Shapes format in [ShapesFormatNone, ShapesFormatSHP, ShapesFormatKML, ShapesFormatDXF, ShapesFormatGeoJSON, ShapesFormatGeoPackage, ShapesFormatCSV]"""

	ShapesFormatGeoPackage: Any
	"""Shapes format in [ShapesFormatNone, ShapesFormatSHP, ShapesFormatKML, ShapesFormatDXF, ShapesFormatGeoJSON, ShapesFormatGeoPackage, ShapesFormatCSV]"""

	ShapesFormatKML: Any
	"""Shapes format in [ShapesFormatNone, ShapesFormatSHP, ShapesFormatKML, ShapesFormatDXF, ShapesFormatGeoJSON, ShapesFormatGeoPackage, ShapesFormatCSV]"""

	ShapesFormatNone: Any
	"""Shapes format in [ShapesFormatNone, ShapesFormatSHP, ShapesFormatKML, ShapesFormatDXF, ShapesFormatGeoJSON, ShapesFormatGeoPackage, ShapesFormatCSV]"""

	ShapesFormatSHP: Any
	"""Shapes format in [ShapesFormatNone, ShapesFormatSHP, ShapesFormatKML, ShapesFormatDXF, ShapesFormatGeoJSON, ShapesFormatGeoPackage, ShapesFormatCSV]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Shutter:
	Disabled: Any
	"""Rolling shutter model in [Disabled, Regularized, Full]"""

	Full: Any
	"""Rolling shutter model in [Disabled, Regularized, Full]"""


	class Model:
		"""Rolling shutter model in [Disabled, Regularized, Full]"""
		Disabled: Any
		"""Rolling shutter model in [Disabled, Regularized, Full]"""

		Full: Any
		"""Rolling shutter model in [Disabled, Regularized, Full]"""

		Regularized: Any
		"""Rolling shutter model in [Disabled, Regularized, Full]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	Regularized: Any
	"""Rolling shutter model in [Disabled, Regularized, Full]"""

	def copy (self, *args, **kwargs) -> Shutter:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Shutter"""
	...
	rotation:  Matrix
	"""Rotation matrix of the rolling shutter model.

	:type: Matrix"""

	translation:  Vector
	"""Translation vector of the rolling shutter model.

	:type: Vector"""


class SurfaceType:
	Arbitrary: Any
	"""Surface type in [Arbitrary, HeightField]"""

	HeightField: Any
	"""Surface type in [Arbitrary, HeightField]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Target:
	code:  int
	"""Target code.

	:type: int"""

	coord:  Vector
	"""Target location.

	:type: Vector"""

	def copy (self, *args, **kwargs) -> Target:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Target"""
	...
	radius:  float
	"""Target radius.

	:type: float"""


class TargetType:
	AprilTag16h5: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	AprilTag25h9: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	AprilTag36h10: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	AprilTag36h11: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	AprilTagCircle21h7: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	AprilTagStandard41h12: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	AprilTagStandard52h13: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	CircularTarget: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	CircularTarget12bit: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	CircularTarget14bit: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	CircularTarget16bit: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	CircularTarget20bit: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	CrossTarget: Any
	"""Target type in [CircularTarget12bit, CircularTarget14bit, CircularTarget16bit, CircularTarget20bit, CircularTarget, CrossTarget, AprilTag16h5, AprilTag25h9, AprilTag36h10, AprilTag36h11, AprilTagCircle21h7, AprilTagStandard41h12, AprilTagStandard52h13]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Tasks:

	class AddFrames:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		chunk:  int
		"""Chunk to copy frames from.

		:type: int"""

		copy_depth_maps:  bool
		"""Copy depth maps.

		:type: bool"""

		copy_elevation:  bool
		"""Copy DEM.

		:type: bool"""

		copy_model:  bool
		"""Copy model.

		:type: bool"""

		copy_orthomosaic:  bool
		"""Copy orthomosaic.

		:type: bool"""

		copy_point_cloud:  bool
		"""Copy point cloud.

		:type: bool"""

		copy_tiled_model:  bool
		"""Copy tiled model.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frame keys to copy.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class AddPhotos:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		filegroups:  list[int]
		"""List of file groups.

		:type: list[int]"""

		filenames:  list[str]
		"""List of files to add.

		:type: list[str]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		group:  int
		"""Camera group key.

		:type: int"""

		layout:  ImageLayout
		"""Image layout.

		:type: ImageLayout"""

		load_reference:  bool
		"""Load reference coordinates.

		:type: bool"""

		load_rpc_txt:  bool
		"""Load satellite RPC data from auxiliary TXT files.

		:type: bool"""

		load_xmp_accuracy:  bool
		"""Load accuracy from XMP meta data.

		:type: bool"""

		load_xmp_antenna:  bool
		"""Load GNSS/INS offset from XMP meta data.

		:type: bool"""

		load_xmp_calibration:  bool
		"""Load calibration from XMP meta data.

		:type: bool"""

		load_xmp_orientation:  bool
		"""Load orientation from XMP meta data.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		strip_extensions:  bool
		"""Strip file extensions from camera labels.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class AlignCameras:
		"""Task class containing processing parameters."""
		adaptive_fitting:  bool
		"""Enable adaptive fitting of distortion coefficients.

		:type: bool"""

		align_laser_scans:  bool
		"""Align laser scans using geometric features.

		:type: bool"""

		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to align.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		min_image:  int
		"""Minimum number of point projections.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		point_clouds:  list[int]
		"""List of point clouds to align.

		:type: list[int]"""

		reset_alignment:  bool
		"""Reset current alignment.

		:type: bool"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class AlignChunks:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		chunks:  list[int]
		"""List of chunks to be aligned.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		downscale:  int
		"""Alignment accuracy (0 - Highest, 1 - High, 2 - Medium, 4 - Low, 8 - Lowest).

		:type: int"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		filter_mask:  bool
		"""Filter points by mask.

		:type: bool"""

		fit_scale:  bool
		"""Fit chunk scale during alignment.

		:type: bool"""

		generic_preselection:  bool
		"""Enables image pair preselection.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		keypoint_limit:  int
		"""Maximum number of points for each photo.

		:type: int"""

		markers:  list[int]
		"""List of markers to be used for marker based alignment.

		:type: list[int]"""

		mask_tiepoints:  bool
		"""Apply mask filter to tie points.

		:type: bool"""

		def method (self, *args, **kwargs):
			"""Alignment method (0 - point based, 1 - marker based, 2 - camera based).

			:type: int"""
		...
		name:  str
		"""Task name.

		:type: str"""

		reference:  int
		"""Chunk to be used as a reference.

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class AnalyzeImages:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to be analyzed.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		filter_mask:  bool
		"""Constrain analyzed image region by mask.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class BuildContours:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		interval:  float
		"""Contour interval.

		:type: float"""

		max_value:  float
		"""Maximum value of contour range.

		:type: float"""

		min_value:  float
		"""Minimum value of contour range.

		:type: float"""

		name:  str
		"""Task name.

		:type: str"""

		prevent_intersections:  bool
		"""Prevent contour intersections.

		:type: bool"""

		source_data:  DataSource
		"""Source data for contour generation.

		:type: DataSource"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class BuildDem:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		classes:  list[int]
		"""List of point classes to be used for surface extraction.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		flip_x:  bool
		"""Flip X axis direction.

		:type: bool"""

		flip_y:  bool
		"""Flip Y axis direction.

		:type: bool"""

		flip_z:  bool
		"""Flip Z axis direction.

		:type: bool"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		interpolation:  Interpolation
		"""Interpolation mode.

		:type: Interpolation"""

		max_workgroup_size:  int
		"""Maximum workgroup size.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		projection:  OrthoProjection
		"""Output projection.

		:type: OrthoProjection"""

		region:  BBox
		"""Region to be processed.

		:type: BBox"""

		replace_asset:  bool
		"""Replace default asset with generated DEM.

		:type: bool"""

		resolution:  float
		"""Output resolution in meters.

		:type: float"""

		source_data:  DataSource
		"""Selects between point cloud and tie points.

		:type: DataSource"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_tiles:  int
		"""Number of tiles in a workitem.

		:type: int"""


	class BuildDepthMaps:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		downscale:  int
		"""Depth map quality (1 - Ultra high, 2 - High, 4 - Medium, 8 - Low, 16 - Lowest).

		:type: int"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		filter_mode:  FilterMode
		"""Depth map filtering mode.

		:type: FilterMode"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		max_neighbors:  int
		"""Maximum number of neighbor images to use for depth map generation.

		:type: int"""

		max_workgroup_size:  int
		"""Maximum workgroup size.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		reuse_depth:  bool
		"""Enable reuse depth maps option.

		:type: bool"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_cameras:  int
		"""Number of cameras in a workitem.

		:type: int"""


	class BuildModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		blocks_crs:  CoordinateSystem
		"""Blocks grid coordinate system.

		:type: CoordinateSystem"""

		blocks_origin:  Vector
		"""Blocks grid origin.

		:type: Vector"""

		blocks_size:  float
		"""Blocks size in coordinate system units.

		:type: float"""

		build_texture:  bool
		"""Generate preview textures.

		:type: bool"""

		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		classes:  list[int]
		"""List of point classes to be used for surface extraction.

		:type: list[int]"""

		clip_to_boundary:  bool
		"""Clip to boundary shapes.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		export_blocks:  bool
		"""Export completed blocks.

		:type: bool"""

		face_count:  FaceCount
		"""Target face count.

		:type: FaceCount"""

		face_count_custom:  int
		"""Custom face count.

		:type: int"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		interpolation:  Interpolation
		"""Interpolation mode.

		:type: Interpolation"""

		keep_depth:  bool
		"""Enable store depth maps option.

		:type: bool"""

		max_workgroup_size:  int
		"""Maximum workgroup size.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		output_folder:  str
		"""Path to output folder.

		:type: str"""

		replace_asset:  bool
		"""Replace default asset with generated model.

		:type: bool"""

		source_data:  DataSource
		"""Selects between point cloud, tie points, depth maps and laser scans.

		:type: DataSource"""

		split_in_blocks:  bool
		"""Split model in blocks.

		:type: bool"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		surface_type:  SurfaceType
		"""Type of object to be reconstructed.

		:type: SurfaceType"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		trimming_radius:  int
		"""Trimming radius (no trimming if zero).

		:type: int"""

		vertex_colors:  bool
		"""Enable vertex colors calculation.

		:type: bool"""

		vertex_confidence:  bool
		"""Enable vertex confidence calculation.

		:type: bool"""

		volumetric_masks:  bool
		"""Enable strict volumetric masking.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_cameras:  int
		"""Number of cameras in a workitem.

		:type: int"""


	class BuildOrthomosaic:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		blending_mode:  BlendingMode
		"""Orthophoto blending mode.

		:type: BlendingMode"""

		cull_faces:  bool
		"""Enable back-face culling.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		fill_holes:  bool
		"""Enable hole filling.

		:type: bool"""

		flip_x:  bool
		"""Flip X axis direction.

		:type: bool"""

		flip_y:  bool
		"""Flip Y axis direction.

		:type: bool"""

		flip_z:  bool
		"""Flip Z axis direction.

		:type: bool"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		ghosting_filter:  bool
		"""Enable ghosting filter.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		max_workgroup_size:  int
		"""Maximum workgroup size.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		projection:  OrthoProjection
		"""Output projection.

		:type: OrthoProjection"""

		refine_seamlines:  bool
		"""Refine seamlines based on image content.

		:type: bool"""

		region:  BBox
		"""Region to be processed.

		:type: BBox"""

		replace_asset:  bool
		"""Replace default asset with generated orthomosaic.

		:type: bool"""

		resolution:  float
		"""Pixel size in meters.

		:type: float"""

		resolution_x:  float
		"""Pixel size in the X dimension in projected units.

		:type: float"""

		resolution_y:  float
		"""Pixel size in the Y dimension in projected units.

		:type: float"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		surface_data:  DataSource
		"""Orthorectification surface.

		:type: DataSource"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		transfer_texture:  bool
		"""Transfer model texture to orthomosaic.

		:type: bool"""

		use_occlusion_texture:  bool
		"""Use model occlusion texture.

		:type: bool"""

		use_point_cloud_intensity:  bool
		"""Use point cloud intensity as color source.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_cameras:  int
		"""Number of cameras in a workitem.

		:type: int"""

		workitem_size_tiles:  int
		"""Number of tiles in a workitem.

		:type: int"""


	class BuildPanorama:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		blending_mode:  BlendingMode
		"""Panorama blending mode.

		:type: BlendingMode"""

		camera_groups:  list[int]
		"""List of camera groups to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		ghosting_filter:  bool
		"""Enable ghosting filter.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		height:  int
		"""Height of output panorama.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		region:  BBox
		"""Region to be generated.

		:type: BBox"""

		rotation:  Matrix
		"""Panorama 3x3 orientation matrix.

		:type: Matrix"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		width:  int
		"""Width of output panorama.

		:type: int"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class BuildPointCloud:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		asset:  int
		"""Asset to process.

		:type: int"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		keep_depth:  bool
		"""Enable store depth maps option.

		:type: bool"""

		max_neighbors:  int
		"""Maximum number of neighbor images to use for depth map filtering.

		:type: int"""

		max_workgroup_size:  int
		"""Maximum workgroup size.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		point_colors:  bool
		"""Enable point colors calculation.

		:type: bool"""

		point_confidence:  bool
		"""Enable point confidence calculation.

		:type: bool"""

		points_spacing:  float
		"""Desired point spacing (m).

		:type: float"""

		replace_asset:  bool
		"""Replace default asset with generated point cloud.

		:type: bool"""

		source_data:  DataSource
		"""Source data to extract points from.

		:type: DataSource"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		uniform_sampling:  bool
		"""Enable uniform point sampling.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_cameras:  int
		"""Number of cameras in a workitem.

		:type: int"""


	class BuildSeamlines:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		epsilon:  float
		"""Contour simplificaion threshold.

		:type: float"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class BuildTexture:
		"""Task class containing processing parameters."""
		anti_aliasing:  int
		"""Anti-aliasing coefficient for baking

		:type: int"""

		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		blending_mode:  BlendingMode
		"""Texture blending mode.

		:type: BlendingMode"""

		cameras:  list[int]
		"""A list of cameras to be used for texturing.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		fill_holes:  bool
		"""Enable hole filling.

		:type: bool"""

		ghosting_filter:  bool
		"""Enable ghosting filter.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		max_workgroup_size:  int
		"""Maximum workgroup size (block model only).

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		source_asset:  int
		"""Source asset.

		:type: int"""

		source_data:  DataSource
		"""Source data to create texture from.

		:type: DataSource"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		texture_size:  int
		"""Texture page size.

		:type: int"""

		texture_type:  Model.TextureType
		"""Texture type.

		:type: Model.TextureType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		transfer_texture:  bool
		"""Transfer texture.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_cameras:  int
		"""Number of cameras in a workitem (block model only).

		:type: int"""


	class BuildTiledModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		classes:  list[int]
		"""List of point classes to be used for surface extraction.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		face_count:  int
		"""Number of faces per megapixel of texture resolution.

		:type: int"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		ghosting_filter:  bool
		"""Enable ghosting filter.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		keep_depth:  bool
		"""Enable store depth maps option.

		:type: bool"""

		max_workgroup_size:  int
		"""Maximum workgroup size.

		:type: int"""

		merge:  bool
		"""Merge tiled model flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		operand_asset:  int
		"""Operand asset key.

		:type: int"""

		operand_chunk:  int
		"""Operand chunk key.

		:type: int"""

		operand_frame:  int
		"""Operand frame key.

		:type: int"""

		pixel_size:  float
		"""Target model resolution in meters.

		:type: float"""

		replace_asset:  bool
		"""Replace default asset with generated tiled model.

		:type: bool"""

		source_data:  DataSource
		"""Selects between point cloud and mesh.

		:type: DataSource"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		tile_size:  int
		"""Size of tiles in pixels.

		:type: int"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		transfer_texture:  bool
		"""Transfer source model texture to tiled model.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_cameras:  int
		"""Number of cameras in a workitem.

		:type: int"""


	class BuildUV:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		camera:  int
		"""Camera to be used for texturing in CameraMapping mode.

		:type: int"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		mapping_mode:  MappingMode
		"""Texture mapping mode.

		:type: MappingMode"""

		name:  str
		"""Task name.

		:type: str"""

		page_count:  int
		"""Number of texture pages to generate.

		:type: int"""

		pixel_size:  float
		"""Texture resolution in meters.

		:type: float"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		texture_size:  int
		"""Expected size of texture page at texture generation step.

		:type: int"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class CalculatePointNormals:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		point_cloud:  int
		"""Point cloud key to process.

		:type: int"""

		point_neighbors:  int
		"""Number of point neighbors to use for normal estimation.

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class CalibrateCamera:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		border:  int
		"""Border size to ignore.

		:type: int"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		fit_b1:  bool
		"""Enable optimization of aspect ratio.

		:type: bool"""

		fit_b2:  bool
		"""Enable optimization of skew coefficient.

		:type: bool"""

		fit_cxcy:  bool
		"""Enable optimization of principal point coordinates.

		:type: bool"""

		fit_f:  bool
		"""Enable optimization of focal length coefficient.

		:type: bool"""

		fit_k1:  bool
		"""Enable optimization of k1 radial distortion coefficient.

		:type: bool"""

		fit_k2:  bool
		"""Enable optimization of k2 radial distortion coefficient.

		:type: bool"""

		fit_k3:  bool
		"""Enable optimization of k3 radial distortion coefficient.

		:type: bool"""

		fit_k4:  bool
		"""Enable optimization of k4 radial distortion coefficient.

		:type: bool"""

		fit_p1:  bool
		"""Enable optimization of p1 tangential distortion coefficient.

		:type: bool"""

		fit_p2:  bool
		"""Enable optimization of p2 tangential distortion coefficient.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class CalibrateColors:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to calibrate.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		source_data:  DataSource
		"""Source data for calibration.

		:type: DataSource"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		white_balance:  bool
		"""Calibrate white balance.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class CalibrateReflectance:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		use_reflectance_panels:  bool
		"""Use calibrated reflectance panels.

		:type: bool"""

		use_sun_sensor:  bool
		"""Apply irradiance sensor measurements.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

	ChunkTarget: Any
	"""Task target type in [DocumentTarget, ChunkTarget, FrameTarget]"""


	class ClassifyGroundPoints:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cell_size:  float
		"""Cell size (meters).

		:type: float"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		erosion_radius:  float
		"""Erosion radius (meters).

		:type: float"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		keep_existing:  bool
		"""Keep existing ground points.

		:type: bool"""

		max_angle:  float
		"""Maximum angle (degrees).

		:type: float"""

		max_distance:  float
		"""Maximum distance (meters).

		:type: float"""

		max_terrain_slope:  float
		"""Maximum terrain slope angle (degrees).

		:type: float"""

		name:  str
		"""Task name.

		:type: str"""

		point_cloud:  int
		"""Point cloud key to classify.

		:type: int"""

		return_number:  int
		"""Point return number to use (0 - any return, 1 - first return, -1 - last return).

		:type: int"""

		source_class:  int
		"""Class of points to be re-classified.

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ClassifyOverlapPoints:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		point_cloud:  int
		"""Point cloud key to classify.

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ClassifyPoints:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		confidence:  float
		"""Required confidence level.

		:type: float"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		point_cloud:  int
		"""Point cloud key to classify.

		:type: int"""

		source_class:  int
		"""Class of points to be re-classified.

		:type: int"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		target_classes:  list[int]
		"""Target point classes for classification.

		:type: list[int]"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class CleanModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		criterion:  Model.Criterion
		"""Model filtering criterion.

		:type: Model.Criterion"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		level:  int
		"""Filtering threshold in percents.

		:type: int"""

		model:  int
		"""Model to filter.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class CleanTiePoints:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		criterion:  TiePoints.Criterion
		"""Tie points filtering criterion.

		:type: TiePoints.Criterion"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		threshold:  float
		"""Filtering threshold.

		:type: float"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class CloseHoles:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		apply_to_selection:  bool
		"""Close holes within selection.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		level:  int
		"""Hole size threshold in percents.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ColorizeModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		model:  int
		"""Key of model to colorize.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		source_data:  DataSource
		"""Source data to extract colors from.

		:type: DataSource"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ColorizePointCloud:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		max_workgroup_size:  int
		"""Maximum workgroup size.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		point_cloud:  int
		"""Point cloud key to colorize.

		:type: int"""

		replace_asset:  bool
		"""Replace source point cloud with colorized one.

		:type: bool"""

		source_data:  DataSource
		"""Source data to extract colors from.

		:type: DataSource"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_cameras:  int
		"""Number of cameras in a workitem.

		:type: int"""


	class CompactPointCloud:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		point_cloud:  int
		"""Point cloud key to process.

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ConvertImages:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		color_correction:  bool
		"""Apply color correction.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		image_compression:  ImageCompression
		"""Image compression parameters.

		:type: ImageCompression"""

		merge_planes:  bool
		"""Merge multispectral images.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to output file.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		update_gps_tags:  bool
		"""Update GPS tags.

		:type: bool"""

		use_initial_calibration:  bool
		"""Transform to initial calibration.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class DecimateModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		apply_to_selection:  bool
		"""Apply to selection.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		face_count:  int
		"""Target face count.

		:type: int"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		model:  int
		"""Model to process.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		replace_asset:  bool
		"""Replace source model with decimated model.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class DetectFiducials:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		fiducials_position_corners:  bool
		"""Search corners for fiducials.

		:type: bool"""

		fiducials_position_sides:  bool
		"""Search sides for fiducials.

		:type: bool"""

		frame_detector:  bool
		"""Detect frame.

		:type: bool"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		generate_masks:  bool
		"""Generate background masks.

		:type: bool"""

		generic_detector:  bool
		"""Use generic detector.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		mask_dark_pixels:  bool
		"""Mask out dark pixels near frame edge.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		right_angle_detector:  bool
		"""Use right angle detector.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		v_shape_detector:  bool
		"""Detect V-shape fiducials.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class DetectMarkers:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		filter_mask:  bool
		"""Ignore masked image regions.

		:type: bool"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		inverted:  bool
		"""Detect markers on black background.

		:type: bool"""

		maximum_residual:  float
		"""Maximum residual for non-coded targets in pixels.

		:type: float"""

		merge_markers:  bool
		"""Merge detected targets with existing markers.

		:type: bool"""

		minimum_dist:  int
		"""Minimum distance between targets in pixels (CrossTarget type only).

		:type: int"""

		minimum_size:  int
		"""Minimum target radius in pixels to be detected (CrossTarget type only).

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		noparity:  bool
		"""Disable parity checking.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		target_type:  TargetType
		"""Type of targets.

		:type: TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		tolerance:  int
		"""Detector tolerance (0 - 100).

		:type: int"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class DetectPowerlines:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		max_quantization_error:  float
		"""Maximum allowed distance between polyline and smooth continuous curve.

		:type: float"""

		min_altitude:  float
		"""Minimum altitude for reconstructed powerlines.

		:type: float"""

		n_points_per_line:  int
		"""Maximum number of vertices per detected line.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		use_model:  bool
		"""Use model for visibility checks.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

	DocumentTarget: Any
	"""Task target type in [DocumentTarget, ChunkTarget, FrameTarget]"""


	class DuplicateAsset:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		asset_key:  int
		"""Asset key.

		:type: int"""

		asset_type:  DataSource
		"""Asset type.

		:type: DataSource"""

		clip_to_boundary:  bool
		"""Clip to boundary shapes.

		:type: bool"""

		clip_to_region:  bool
		"""Clip to chunk region.

		:type: bool"""

		copy_orthophotos:  bool
		"""Copy orthophotos (orthomosaic asset type only).

		:type: bool"""

		copy_patches:  bool
		"""Copy patches.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class DuplicateChunk:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of camera keys to copy.

		:type: list[int]"""

		chunk:  int
		"""Chunk to copy.

		:type: int"""

		copy_depth_maps:  bool
		"""Copy depth maps.

		:type: bool"""

		copy_elevations:  bool
		"""Copy DEMs.

		:type: bool"""

		copy_keypoints:  bool
		"""Copy keypoints.

		:type: bool"""

		copy_laser_scans:  bool
		"""Copy laser scans.

		:type: bool"""

		copy_masks:  bool
		"""Copy masks.

		:type: bool"""

		copy_models:  bool
		"""Copy models.

		:type: bool"""

		copy_orthomosaics:  bool
		"""Copy orthomosaics.

		:type: bool"""

		copy_point_clouds:  bool
		"""Copy point clouds.

		:type: bool"""

		copy_tiled_models:  bool
		"""Copy tiled models.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frame keys to copy.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		label:  str
		"""New chunk label.

		:type: str"""

		laser_scans:  list[int]
		"""List of laser scan keys to copy.

		:type: list[int]"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportCameras:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		binary:  bool
		"""Enables/disables binary encoding for selected format (Colmap and FBX formats only).

		:type: bool"""

		bingo_path_geoin:  str
		"""Path to BINGO GEO INPUT file.

		:type: str"""

		bingo_path_gps:  str
		"""Path to BINGO GPS/IMU file.

		:type: str"""

		bingo_path_image:  str
		"""Path to BINGO IMAGE COORDINATE file.

		:type: str"""

		bingo_path_itera:  str
		"""Path to BINGO ITERA file.

		:type: str"""

		bingo_save_geoin:  bool
		"""Enables/disables export of BINGO GEO INPUT file.

		:type: bool"""

		bingo_save_gps:  bool
		"""Enables/disables export of BINGO GPS/IMU data.

		:type: bool"""

		bingo_save_image:  bool
		"""Enables/disables export of BINGO IMAGE COORDINATE file.

		:type: bool"""

		bingo_save_itera:  bool
		"""Enables/disables export of BINGO ITERA file.

		:type: bool"""

		bundler_path_list:  str
		"""Path to Bundler image list file.

		:type: str"""

		bundler_save_list:  bool
		"""Enables/disables export of Bundler image list file.

		:type: bool"""

		cameras:  list[int]
		"""List of cameras to export (except AgisoftXML format).

		:type: list[int]"""

		chan_rotation_order:  RotationOrder
		"""Rotation order (CHAN format only).

		:type: RotationOrder"""

		convert_to_pinhole:  bool
		"""Transform images to pinhole model without distortions.

		:type: bool"""

		crs:  CoordinateSystem
		"""Output coordinate system (except AgisoftXML format).

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  CamerasFormat
		"""Export format.

		:type: CamerasFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		image_compression:  ImageCompression
		"""Image compression parameters.

		:type: ImageCompression"""

		image_orientation:  int
		"""Image coordinate system (0 - X right, 1 - X up, 2 - X left, 3 - X down).

		:type: int"""

		image_path:  str
		"""Image name template

		:type: str"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to output file.

		:type: str"""

		save_absolute_paths:  bool
		"""Save absolute image paths (BlocksExchange and RZML formats only).

		:type: bool"""

		save_images:  bool
		"""Enables/disables images export (Colmap format only).

		:type: bool"""

		save_invalid_matches:  bool
		"""Enables/disables export of invalid image matches.

		:type: bool"""

		save_markers:  bool
		"""Enables/disables export of manual matching points.

		:type: bool"""

		save_masks:  bool
		"""Enables/disables image masks export (Colmap format only).

		:type: bool"""

		save_points:  bool
		"""Enables/disables export of automatic tie points.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		use_initial_calibration:  bool
		"""Transform image coordinates to initial calibration.

		:type: bool"""

		use_labels:  bool
		"""Enables/disables label based item identifiers.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportMarkers:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		binary:  bool
		"""Enables/disables binary encoding for selected format (if applicable).

		:type: bool"""

		crs:  CoordinateSystem
		"""Output coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to output file.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportMasks:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		masks:  int
		"""Masks key to export.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to output file.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		binary:  bool
		"""Enables/disables binary encoding (if supported by format).

		:type: bool"""

		block_margin:  float
		"""Block margin (m).

		:type: float"""

		clip_to_block:  bool
		"""Clip model to block region.

		:type: bool"""

		clip_to_boundary:  bool
		"""Clip model to boundary shapes.

		:type: bool"""

		clip_to_region:  bool
		"""Clip model to chunk region.

		:type: bool"""

		colors_rgb_8bit:  bool
		"""Convert colors to 8 bit RGB.

		:type: bool"""

		comment:  str
		"""Optional comment (if supported by selected format).

		:type: str"""

		crs:  CoordinateSystem
		"""Output coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		embed_texture:  bool
		"""Embeds texture inside the model file (if supported by format).

		:type: bool"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  ModelFormat
		"""Export format.

		:type: ModelFormat"""

		gltf_y_up:  bool
		"""Enables/disables y-up axes notation used in glTF.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		model:  int
		"""Model key to export.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to output model.

		:type: str"""

		precision:  int
		"""Number of digits after the decimal point (for text formats).

		:type: int"""

		raster_transform:  RasterTransformType
		"""Raster band transformation.

		:type: RasterTransformType"""

		save_alpha:  bool
		"""Enables/disables alpha channel export.

		:type: bool"""

		save_cameras:  bool
		"""Enables/disables camera export.

		:type: bool"""

		save_colors:  bool
		"""Enables/disables export of vertex colors.

		:type: bool"""

		save_comment:  bool
		"""Enables/disables comment export.

		:type: bool"""

		save_confidence:  bool
		"""Enables/disables export of vertex confidence.

		:type: bool"""

		save_markers:  bool
		"""Enables/disables marker export.

		:type: bool"""

		save_metadata_xml:  bool
		"""Save metadata.xml file.

		:type: bool"""

		save_normals:  bool
		"""Enables/disables export of vertex normals.

		:type: bool"""

		save_texture:  bool
		"""Enables/disables texture export.

		:type: bool"""

		save_udim:  bool
		"""Enables/disables UDIM texture layout.

		:type: bool"""

		save_uv:  bool
		"""Enables/disables uv coordinates export.

		:type: bool"""

		shift:  Vector
		"""Optional shift to be applied to vertex coordinates.

		:type: Vector"""

		strip_extensions:  bool
		"""Strips camera label extensions during export.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		texture_format:  ImageFormat
		"""Texture format.

		:type: ImageFormat"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		viewpoint:  Viewpoint
		"""Default view.

		:type: Viewpoint"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportOrthophotos:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		image_compression:  ImageCompression
		"""Image compression parameters.

		:type: ImageCompression"""

		name:  str
		"""Task name.

		:type: str"""

		north_up:  bool
		"""Use north-up orientation for export.

		:type: bool"""

		path:  str
		"""Path to output orthophoto.

		:type: str"""

		projection:  OrthoProjection
		"""Output projection.

		:type: OrthoProjection"""

		raster_transform:  RasterTransformType
		"""Raster band transformation.

		:type: RasterTransformType"""

		region:  BBox
		"""Region to be exported.

		:type: BBox"""

		resolution:  float
		"""Output resolution in meters.

		:type: float"""

		resolution_x:  float
		"""Pixel size in the X dimension in projected units.

		:type: float"""

		resolution_y:  float
		"""Pixel size in the Y dimension in projected units.

		:type: float"""

		save_alpha:  bool
		"""Enable alpha channel generation.

		:type: bool"""

		save_kml:  bool
		"""Enable kml file generation.

		:type: bool"""

		save_world:  bool
		"""Enable world file generation.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		white_background:  bool
		"""Enable white background.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportPointCloud:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		binary:  bool
		"""Enables/disables binary encoding for selected format (if applicable).

		:type: bool"""

		block_height:  float
		"""Block height in meters.

		:type: float"""

		block_width:  float
		"""Block width in meters.

		:type: float"""

		classes:  list[int]
		"""List of point classes to be exported.

		:type: list[int]"""

		clip_to_boundary:  bool
		"""Clip point cloud to boundary shapes.

		:type: bool"""

		clip_to_region:  bool
		"""Clip point cloud to chunk region.

		:type: bool"""

		colors_rgb_8bit:  bool
		"""Convert colors to 8 bit RGB.

		:type: bool"""

		comment:  str
		"""Optional comment (if supported by selected format).

		:type: str"""

		compression:  bool
		"""Enable compression (Cesium format only).

		:type: bool"""

		crs:  CoordinateSystem
		"""Output coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		folder_depth:  int
		"""Tileset subdivision depth (Cesium format only).

		:type: int"""

		format:  PointCloudFormat
		"""Export format.

		:type: PointCloudFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		image_format:  ImageFormat
		"""Image data format.

		:type: ImageFormat"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to output file.

		:type: str"""

		point_clouds:  list[int]
		"""Point cloud keys to export.

		:type: list[int]"""

		raster_transform:  RasterTransformType
		"""Raster band transformation.

		:type: RasterTransformType"""

		region:  BBox
		"""Region to be exported.

		:type: BBox"""

		save_comment:  bool
		"""Enable comment export.

		:type: bool"""

		save_images:  bool
		"""Enable image export.

		:type: bool"""

		save_point_classification:  bool
		"""Enables/disables export of point classification.

		:type: bool"""

		save_point_color:  bool
		"""Enables/disables export of point color.

		:type: bool"""

		save_point_confidence:  bool
		"""Enables/disables export of point confidence.

		:type: bool"""

		save_point_index:  bool
		"""Enables/disables export of point row and column indices.

		:type: bool"""

		save_point_intensity:  bool
		"""Enables/disables export of point intensity.

		:type: bool"""

		save_point_normal:  bool
		"""Enables/disables export of point normal.

		:type: bool"""

		save_point_return_number:  bool
		"""Enables/disables export of point return number.

		:type: bool"""

		save_point_scan_angle:  bool
		"""Enables/disables export of point scan angle.

		:type: bool"""

		save_point_source_id:  bool
		"""Enables/disables export of point source ID.

		:type: bool"""

		save_point_timestamp:  bool
		"""Enables/disables export of point timestamp.

		:type: bool"""

		screen_space_error:  float
		"""Target screen space error (Cesium format only).

		:type: float"""

		shift:  Vector
		"""Optional shift to be applied to point coordinates.

		:type: Vector"""

		source_data:  DataSource
		"""Selects between point cloud and tie points. If not specified, uses point cloud if available.

		:type: DataSource"""

		split_in_blocks:  bool
		"""Enable tiled export.

		:type: bool"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		tileset_version:  str
		"""Cesium 3D Tiles format version to export (1.0 or 1.1).

		:type: str"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		viewpoint:  Viewpoint
		"""Default view.

		:type: Viewpoint"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportRaster:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		asset:  int
		"""Asset key to export.

		:type: int"""

		block_height:  int
		"""Raster block height in pixels.

		:type: int"""

		block_width:  int
		"""Raster block width in pixels.

		:type: int"""

		clip_to_boundary:  bool
		"""Clip raster to boundary shapes.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		description:  str
		"""Export description.

		:type: str"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  RasterFormat
		"""Export format.

		:type: RasterFormat"""

		global_profile:  bool
		"""Use global profile (GeoPackage and TMS formats only).

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		height:  int
		"""Raster height.

		:type: int"""

		image_compression:  ImageCompression
		"""Image compression parameters.

		:type: ImageCompression"""

		image_description:  str
		"""Optional description to be added to image files.

		:type: str"""

		image_format:  ImageFormat
		"""Tile format.

		:type: ImageFormat"""

		max_zoom_level:  int
		"""Maximum zoom level (GeoPackage, Google Map Tiles, MBTiles and World Wind Tiles formats only).

		:type: int"""

		min_zoom_level:  int
		"""Minimum zoom level (GeoPackage, Google Map Tiles, MBTiles and World Wind Tiles formats only).

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		network_links:  bool
		"""Enable network links generation for KMZ format.

		:type: bool"""

		nodata_value:  float
		"""No-data value (DEM export only).

		:type: float"""

		north_up:  bool
		"""Use north-up orientation for export.

		:type: bool"""

		path:  str
		"""Path to output orthomosaic.

		:type: str"""

		projection:  OrthoProjection
		"""Output projection.

		:type: OrthoProjection"""

		raster_transform:  RasterTransformType
		"""Raster band transformation.

		:type: RasterTransformType"""

		region:  BBox
		"""Region to be exported.

		:type: BBox"""

		resolution:  float
		"""Output resolution in meters.

		:type: float"""

		resolution_x:  float
		"""Pixel size in the X dimension in projected units.

		:type: float"""

		resolution_y:  float
		"""Pixel size in the Y dimension in projected units.

		:type: float"""

		save_alpha:  bool
		"""Enable alpha channel generation.

		:type: bool"""

		save_kml:  bool
		"""Enable kml file generation.

		:type: bool"""

		save_scheme:  bool
		"""Enable tile scheme files generation.

		:type: bool"""

		save_world:  bool
		"""Enable world file generation.

		:type: bool"""

		source_data:  DataSource
		"""Selects between DEM and orthomosaic.

		:type: DataSource"""

		split_in_blocks:  bool
		"""Split raster in blocks.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		tile_height:  int
		"""Tile height in pixels.

		:type: int"""

		tile_width:  int
		"""Tile width in pixels.

		:type: int"""

		title:  str
		"""Export title.

		:type: str"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		white_background:  bool
		"""Enable white background.

		:type: bool"""

		width:  int
		"""Raster width.

		:type: int"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

		world_transform:  Matrix
		"""2x3 raster-to-world transformation matrix.

		:type: Matrix"""


	class ExportReference:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		columns:  str
		"""Column order in CSV format (n - label, o - enabled flag, x/y/z - coordinates, X/Y/Z - coordinate accuracy, a/b/c - rotation angles, A/B/C - rotation angle accuracy, u/v/w - estimated coordinates, U/V/W - coordinate errors, d/e/f - estimated orientation angles, D/E/F - orientation errors, p/q/r - estimated coordinates variance, i/j/k - estimated orientation angles variance, [] - group of multiple values, | - column separator within group).

		:type: str"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		delimiter:  str
		"""Column delimiter (CSV format only).

		:type: str"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  ReferenceFormat
		"""Export format.

		:type: ReferenceFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		items:  ReferenceItems
		"""Items to export (CSV format only).

		:type: ReferenceItems"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to the output file.

		:type: str"""

		precision:  int
		"""Number of digits after the decimal point (CSV format only).

		:type: int"""

		save_enabled:  bool
		"""Save enabled flag (CSV format only).

		:type: bool"""

		save_errors:  bool
		"""Save errors (CSV format only).

		:type: bool"""

		save_estimated:  bool
		"""Save estimated values (CSV format only).

		:type: bool"""

		save_location_accuracy:  bool
		"""Save location accuracy (CSV format only).

		:type: bool"""

		save_rotation:  bool
		"""Save rotation angles (CSV format only).

		:type: bool"""

		save_rotation_accuracy:  bool
		"""Save rotation accuracy (CSV format only).

		:type: bool"""

		save_variance:  bool
		"""Save variance (CSV format only).

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportReport:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		description:  str
		"""Report description.

		:type: str"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		font_size:  int
		"""Font size (pt).

		:type: int"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		include_system_info:  bool
		"""Include system information.

		:type: bool"""

		logo_path:  str
		"""Path to company logo file.

		:type: str"""

		name:  str
		"""Task name.

		:type: str"""

		page_numbers:  bool
		"""Enable page numbers.

		:type: bool"""

		path:  str
		"""Path to output report.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		title:  str
		"""Report title.

		:type: str"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		user_settings:  list[tuple[str, str]]
		"""A list of user defined settings to include on the Processing Parameters page.

		:type: list[tuple[str, str]]"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportShapes:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		crs:  CoordinateSystem
		"""Output coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  ShapesFormat
		"""Export format.

		:type: ShapesFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		groups:  list[int]
		"""A list of shape groups to export.

		:type: list[int]"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to shape file.

		:type: str"""

		polygons_as_polylines:  bool
		"""Save polygons as polylines.

		:type: bool"""

		save_attributes:  bool
		"""Export attributes.

		:type: bool"""

		save_elevation:  bool
		"""Export elevation values for 3D shapes.

		:type: bool"""

		save_labels:  bool
		"""Export labels.

		:type: bool"""

		save_points:  bool
		"""Export points.

		:type: bool"""

		save_polygons:  bool
		"""Export polygons.

		:type: bool"""

		save_polylines:  bool
		"""Export polylines.

		:type: bool"""

		shift:  Vector
		"""Optional shift to be applied to vertex coordinates.

		:type: Vector"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportTexture:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to output file.

		:type: str"""

		raster_transform:  RasterTransformType
		"""Raster band transformation.

		:type: RasterTransformType"""

		save_alpha:  bool
		"""Enable alpha channel export.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		texture_type:  Model.TextureType
		"""Texture type.

		:type: Model.TextureType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ExportTiledModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		clip_to_boundary:  bool
		"""Clip tiled model to boundary shapes.

		:type: bool"""

		clip_to_region:  bool
		"""Clip tiled model to chunk region.

		:type: bool"""

		crs:  CoordinateSystem
		"""Output coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		face_count:  int
		"""Number of faces per megapixel of texture resolution (block model export only).

		:type: int"""

		folder_depth:  int
		"""Tileset subdivision depth (Cesium format only).

		:type: int"""

		format:  TiledModelFormat
		"""Export format.

		:type: TiledModelFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		image_compression:  ImageCompression
		"""Image compression parameters.

		:type: ImageCompression"""

		model_compression:  bool
		"""Enable mesh compression (Cesium format only).

		:type: bool"""

		model_format:  ModelFormat
		"""Model format for zip export.

		:type: ModelFormat"""

		model_group:  int
		"""Block model key to export.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to output model.

		:type: str"""

		pixel_size:  float
		"""Target model resolution in meters (block model export only).

		:type: float"""

		raster_transform:  RasterTransformType
		"""Raster band transformation.

		:type: RasterTransformType"""

		screen_space_error:  float
		"""Target screen space error (Cesium format only).

		:type: float"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		texture_format:  ImageFormat
		"""Texture format.

		:type: ImageFormat"""

		tile_size:  int
		"""Size of tiles in pixels (block model export only).

		:type: int"""

		tiled_model:  int
		"""Tiled model key to export.

		:type: int"""

		tileset_version:  str
		"""Cesium 3D Tiles format version to export (1.0 or 1.1).

		:type: str"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		use_tileset_transform:  bool
		"""Use tileset transform instead of individual tile transforms (Cesium format only).

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

		zip_compression:  bool
		"""Enable zip compression (Cesium format only).

		:type: bool"""


	class FilterPointCloud:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		clip_to_region:  bool
		"""Clip point cloud to chunk region.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		point_cloud:  int
		"""Point cloud key to filter.

		:type: int"""

		point_spacing:  float
		"""Desired point spacing (m).

		:type: float"""

		replace_asset:  bool
		"""Replace default asset with filtered point cloud.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""

	FrameTarget: Any
	"""Task target type in [DocumentTarget, ChunkTarget, FrameTarget]"""


	class GenerateMasks:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		blur_threshold:  float
		"""Allowed blur radius on a photo in pix (only if mask_defocus=True).

		:type: float"""

		cameras:  list[int]
		"""Optional list of cameras to be processed.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		depth_threshold:  float
		"""Maximum depth of masked areas in meters (only if mask_defocus=False).

		:type: float"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		fix_coverage:  bool
		"""Extend masks to cover whole mesh (only if mask_defocus=True).

		:type: bool"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		mask_defocus:  bool
		"""Mask defocus areas.

		:type: bool"""

		mask_operation:  MaskOperation
		"""Mask operation.

		:type: MaskOperation"""

		masking_mode:  MaskingMode
		"""Mask generation mode.

		:type: MaskingMode"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Mask file name template.

		:type: str"""

		replace_asset:  bool
		"""Update default set of masks with generated masks.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		tolerance:  int
		"""Background masking tolerance.

		:type: int"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class GeneratePrescriptionMap:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		boundary_shape_group:  int
		"""Boundary shape group.

		:type: int"""

		breakpoints:  list[float]
		"""Classification breakpoints.

		:type: list[float]"""

		cell_size:  float
		"""Step of prescription grid, meters.

		:type: float"""

		class_count:  int
		"""Number of classes.

		:type: int"""

		def classification_method (self, *args, **kwargs):
			"""Index values classification method.

			:type: Metashape.Metashape.ClassificationMethod"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		rates:  list[float]
		"""Fertilizer rate for each class.

		:type: list[float]"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportCameras:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		crs:  CoordinateSystem
		"""Ground coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  CamerasFormat
		"""File format.

		:type: CamerasFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		image_list:  str
		"""Path to image list file (Bundler format only).

		:type: str"""

		image_orientation:  int
		"""Image coordinate system (0 - X right, 1 - X up, 2 - X left, 3 - X down).

		:type: int"""

		load_image_list:  bool
		"""Enable Bundler image list import.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to the file.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportDepthImages:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		color_filenames:  list[str]
		"""List of corresponding color files, if present.

		:type: list[str]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		filenames:  list[str]
		"""List of files to import. Either smartphone depth photos or depth images with corresponding color images in color_filenames parameter.

		:type: list[str]"""

		format:  PointCloudFormat
		"""Point cloud format.

		:type: PointCloudFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		image_path:  str
		"""Path template to output pre-processed files.

		:type: str"""

		multiplane:  bool
		"""Import as a multi-camera system

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportMarkers:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to the file.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		crs:  CoordinateSystem
		"""Model coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		decode_udim:  bool
		"""Load UDIM texture layout.

		:type: bool"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  ModelFormat
		"""Model format.

		:type: ModelFormat"""

		frame_paths:  list[str]
		"""List of model paths to import in each frame of a multiframe chunk.

		:type: list[str]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to model.

		:type: str"""

		replace_asset:  bool
		"""Replace default asset with imported model.

		:type: bool"""

		shift:  Vector
		"""Optional shift to be applied to vertex coordinates.

		:type: Vector"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportPointCloud:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		calculate_normals:  bool
		"""Calculate point normals.

		:type: bool"""

		columns:  str
		"""Column order (x/y/z - coordinates, X/Y/Z - normal, r/g/b - color, i - intensity, t - time, c - classification, space - skip column).

		:type: str"""

		crs:  CoordinateSystem
		"""Point cloud coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		delimiter:  str
		"""CSV delimiter.

		:type: str"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  PointCloudFormat
		"""Point cloud format.

		:type: PointCloudFormat"""

		frame_paths:  list[str]
		"""List of point cloud paths to import in each frame of a multiframe chunk.

		:type: list[str]"""

		generate_panorama:  bool
		"""Generate panorama from point colors.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		group_delimiters:  bool
		"""Combine consecutive delimiters in csv format.

		:type: bool"""

		ignore_scanner_origin:  bool
		"""Do not use laser scan origin as scanner position for structured point clouds.

		:type: bool"""

		ignore_trajectory:  bool
		"""Do not attach trajectory to imported point cloud.

		:type: bool"""

		is_laser_scan:  bool
		"""Import point clouds as laser scans.

		:type: bool"""

		load_images:  bool
		"""Import images embedded in laser scan.

		:type: bool"""

		load_point_classification:  bool
		"""Import point classification.

		:type: bool"""

		load_point_color:  bool
		"""Import point color.

		:type: bool"""

		load_point_confidence:  bool
		"""Import point confidence.

		:type: bool"""

		load_point_index:  bool
		"""Import point row and column indices.

		:type: bool"""

		load_point_intensity:  bool
		"""Import point intensity.

		:type: bool"""

		load_point_normal:  bool
		"""Import point normal.

		:type: bool"""

		load_point_return_number:  bool
		"""Import point return number.

		:type: bool"""

		load_point_scan_angle:  bool
		"""Import point scan angle.

		:type: bool"""

		load_point_source_id:  bool
		"""Import point source ID.

		:type: bool"""

		load_point_timestamp:  bool
		"""Import point timestamp.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to point cloud.

		:type: str"""

		point_neighbors:  int
		"""Number of point neighbors to use for normal estimation.

		:type: int"""

		precision:  float
		"""Coordinate precision (m). For default precision use 0.

		:type: float"""

		replace_asset:  bool
		"""Replace default asset with imported point cloud.

		:type: bool"""

		scanner_at_origin:  bool
		"""Use laser scan origin as scanner position for unstructured point clouds.

		:type: bool"""

		shift:  Vector
		"""Optional shift to be applied to point coordinates.

		:type: Vector"""

		skip_rows:  int
		"""Number of rows to skip.

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		trajectory:  int
		"""Trajectory key to attach.

		:type: int"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportRaster:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		crs:  CoordinateSystem
		"""Default coordinate system if not specified in GeoTIFF file.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		has_nodata_value:  bool
		"""No-data value valid flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		nodata_value:  float
		"""No-data value.

		:type: float"""

		path:  str
		"""Path to elevation model in GeoTIFF format.

		:type: str"""

		raster_type:  DataSource
		"""Type of raster layer to import.

		:type: DataSource"""

		replace_asset:  bool
		"""Replace default raster with imported one.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportReference:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		column_a:  int
		"""1st rotation angle column (CSV format only).

		:type: int"""

		column_b:  int
		"""2nd rotation angle column (CSV format only).

		:type: int"""

		column_c:  int
		"""3rd rotation angle column (CSV format only).

		:type: int"""

		column_enabled:  int
		"""Enabled flag column (CSV format only).

		:type: int"""

		column_label:  int
		"""Label column (CSV format only).

		:type: int"""

		column_sa:  int
		"""1st rotation angle accuracy column (CSV format only).

		:type: int"""

		column_sb:  int
		"""2nd rotation angle accuracy column (CSV format only).

		:type: int"""

		column_sc:  int
		"""3rd rotation angle accuracy column (CSV format only).

		:type: int"""

		column_sx:  int
		"""X coordinate accuracy column (CSV format only).

		:type: int"""

		column_sy:  int
		"""Y coordinate accuracy column (CSV format only).

		:type: int"""

		column_sz:  int
		"""Z coordinate accuracy column (CSV format only).

		:type: int"""

		column_x:  int
		"""X coordinate column (CSV format only).

		:type: int"""

		column_y:  int
		"""Y coordinate column (CSV format only).

		:type: int"""

		column_z:  int
		"""Z coordinate column (CSV format only).

		:type: int"""

		columns:  str
		"""Column order in CSV format (n - label, o - enabled flag, x/y/z - coordinates, X/Y/Z - coordinate accuracy, a/b/c - rotation angles, A/B/C - rotation angle accuracy, [] - group of multiple values, | - column separator within group).

		:type: str"""

		create_markers:  bool
		"""Create markers for missing entries (CSV format only).

		:type: bool"""

		crs:  CoordinateSystem
		"""Reference data coordinate system (CSV format only).

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		delimiter:  str
		"""Column delimiter (CSV format only).

		:type: str"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  ReferenceFormat
		"""File format.

		:type: ReferenceFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		group_delimiters:  bool
		"""Combine consecutive delimiters (CSV format only).

		:type: bool"""

		ignore_labels:  bool
		"""Matches reference data based on coordinates alone (CSV format only).

		:type: bool"""

		items:  ReferenceItems
		"""Items to load reference for (CSV format only).

		:type: ReferenceItems"""

		load_enabled:  bool
		"""Load enabled flag (CSV format only).

		:type: bool"""

		load_location_accuracy:  bool
		"""Load location accuracy (CSV format only).

		:type: bool"""

		load_rotation:  bool
		"""Load rotation angles (CSV format only).

		:type: bool"""

		load_rotation_accuracy:  bool
		"""Load rotation accuracy (CSV format only).

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to the file with reference data.

		:type: str"""

		rotation_angles:  EulerAngles
		"""Euler angles triplet used for rotation reference (CSV format only).

		:type: EulerAngles"""

		shutter_lag:  float
		"""Shutter lag in seconds (APM format only).

		:type: float"""

		skip_rows:  int
		"""Number of rows to skip (CSV format only).

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		threshold:  float
		"""Error threshold in meters used when ignore_labels is set (CSV format only).

		:type: float"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportShapes:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		boundary_type:  Shape.BoundaryType
		"""Boundary type to be applied to imported shapes.

		:type: Shape.BoundaryType"""

		columns:  str
		"""Column order in csv format (n - label, x/y/z - coordinates, d - description, [] - group of multiple values, | - column separator within group).

		:type: str"""

		crs:  CoordinateSystem
		"""Reference data coordinate system (csv format only).

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		delimiter:  str
		"""Column delimiter in csv format.

		:type: str"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  ShapesFormat
		"""Shapes format.

		:type: ShapesFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		group_delimiters:  bool
		"""Combine consequitive delimiters in csv format.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to shape file.

		:type: str"""

		replace:  bool
		"""Replace current shapes with new data.

		:type: bool"""

		skip_rows:  int
		"""Number of rows to skip in (csv format only).

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportTiledModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to tiled model.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportTrajectory:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		columns:  str
		"""Column order in csv format (t - time, x/y/z - coordinates, a/b/c - rotation angles, space - skip column).

		:type: str"""

		crs:  CoordinateSystem
		"""Point cloud coordinate system.

		:type: CoordinateSystem"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		delimiter:  str
		"""Column delimiter in csv format.

		:type: str"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		format:  TrajectoryFormat
		"""Trajectory format.

		:type: TrajectoryFormat"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		group_delimiters:  bool
		"""Combine consecutive delimiters in csv format.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Trajectory file path.

		:type: str"""

		replace_asset:  bool
		"""Replace default asset with imported trajectory.

		:type: bool"""

		shift:  Vector
		"""Optional shift to be applied to point coordinates.

		:type: Vector"""

		skip_rows:  int
		"""Number of rows to skip in (csv format only).

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ImportVideo:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		custom_frame_step:  int
		"""Every custom_frame_step'th frame will be saved. Used for frame_step=CustomFrameStep.

		:type: int"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frame_step:  FrameStep
		"""Frame step type.

		:type: FrameStep"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		image_path:  str
		"""Path to directory where to save frames with filename template. For example: /path/to/dir/frame{filenum}.png.

		:type: str"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to source video.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		time_end:  float
		"""The endpoint for importing video, seconds.

		:type: float"""

		time_start:  float
		"""The starting point for importing video, seconds.

		:type: float"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class InvertMasks:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class LoadProject:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		archive:  bool
		"""Override project format when using non-standard file extension.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to project file.

		:type: str"""

		read_only:  bool
		"""Open project in read only mode.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class MatchPhotos:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to match.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		downscale:  int
		"""Image alignment accuracy (0 - Highest, 1 - High, 2 - Medium, 4 - Low, 8 - Lowest).

		:type: int"""

		downscale_3d:  int
		"""Laser scan alignment accuracy (1 - Highest, 2 - High, 4 - Medium, 8 - Low, 16 - Lowest).

		:type: int"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		filter_mask:  bool
		"""Filter points by mask.

		:type: bool"""

		filter_stationary_points:  bool
		"""Exclude tie points which are stationary across images.

		:type: bool"""

		generic_preselection:  bool
		"""Enable generic preselection.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		guided_matching:  bool
		"""Enable guided image matching.

		:type: bool"""

		keep_keypoints:  bool
		"""Store keypoints in the project.

		:type: bool"""

		keypoint_limit:  int
		"""Key point limit.

		:type: int"""

		keypoint_limit_3d:  int
		"""Key point limit for laser scans.

		:type: int"""

		keypoint_limit_per_mpx:  int
		"""Key point limit per megapixel.

		:type: int"""

		laser_scans_use_initial_orientation:  bool
		"""Use initial laser scan orientation for keypoint matching.

		:type: bool"""

		laser_scans_vertical_axis:  int
		"""Common laser scans axis.

		:type: int"""

		mask_tiepoints:  bool
		"""Apply mask filter to tie points.

		:type: bool"""

		match_laser_scans:  bool
		"""Match laser scans using geometric features.

		:type: bool"""

		max_workgroup_size:  int
		"""Maximum workgroup size.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		pairs:  list[tuple[int, int]]
		"""User defined list of camera pairs to match.

		:type: list[tuple[int, int]]"""

		reference_preselection:  bool
		"""Enable reference preselection.

		:type: bool"""

		reference_preselection_mode:  ReferencePreselectionMode
		"""Reference preselection mode.

		:type: ReferencePreselectionMode"""

		reset_matches:  bool
		"""Reset current matches.

		:type: bool"""

		subdivide_task:  bool
		"""Enable fine-level task subdivision.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		tiepoint_limit:  int
		"""Tie point limit.

		:type: int"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""

		workitem_size_cameras:  int
		"""Number of cameras in a workitem.

		:type: int"""

		workitem_size_pairs:  int
		"""Number of image pairs in a workitem.

		:type: int"""


	class MergeAssets:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		apply_boresight_offset:  bool
		"""Apply boresight offset when merging point clouds.

		:type: bool"""

		apply_trajectory_mask:  bool
		"""Apply trajectory mask when merging point clouds.

		:type: bool"""

		assets:  list[int]
		"""List of assets to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		merge_orthophotos:  bool
		"""Merge orthophotos when merging orthomosaics.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		source_data:  DataSource
		"""Asset type.

		:type: DataSource"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class MergeChunks:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		chunks:  list[int]
		"""List of chunks to process.

		:type: list[int]"""

		copy_depth_maps:  bool
		"""Copy depth maps.

		:type: bool"""

		copy_elevations:  bool
		"""Copy DEMs.

		:type: bool"""

		copy_laser_scans:  bool
		"""Copy laser scans.

		:type: bool"""

		copy_masks:  bool
		"""Copy masks.

		:type: bool"""

		copy_models:  bool
		"""Copy models.

		:type: bool"""

		copy_orthomosaics:  bool
		"""Copy orthomosaics.

		:type: bool"""

		copy_point_clouds:  bool
		"""Copy point clouds.

		:type: bool"""

		copy_tiled_models:  bool
		"""Copy tiled models.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		merge_assets:  bool
		"""Merge default assets.

		:type: bool"""

		merge_markers:  bool
		"""Merge markers.

		:type: bool"""

		merge_tiepoints:  bool
		"""Merge tie points.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class OptimizeCameras:
		"""Task class containing processing parameters."""
		adaptive_fitting:  bool
		"""Enable adaptive fitting of distortion coefficients.

		:type: bool"""

		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		fit_b1:  bool
		"""Enable optimization of aspect ratio.

		:type: bool"""

		fit_b2:  bool
		"""Enable optimization of skew coefficient.

		:type: bool"""

		fit_corrections:  bool
		"""Enable optimization of additional corrections.

		:type: bool"""

		fit_cx:  bool
		"""Enable optimization of X principal point coordinates.

		:type: bool"""

		fit_cy:  bool
		"""Enable optimization of Y principal point coordinates.

		:type: bool"""

		fit_f:  bool
		"""Enable optimization of focal length coefficient.

		:type: bool"""

		fit_k1:  bool
		"""Enable optimization of k1 radial distortion coefficient.

		:type: bool"""

		fit_k2:  bool
		"""Enable optimization of k2 radial distortion coefficient.

		:type: bool"""

		fit_k3:  bool
		"""Enable optimization of k3 radial distortion coefficient.

		:type: bool"""

		fit_k4:  bool
		"""Enable optimization of k3 radial distortion coefficient.

		:type: bool"""

		fit_p1:  bool
		"""Enable optimization of p1 tangential distortion coefficient.

		:type: bool"""

		fit_p2:  bool
		"""Enable optimization of p2 tangential distortion coefficient.

		:type: bool"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		tiepoint_covariance:  bool
		"""Estimate tie point covariance matrices.

		:type: bool"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class PansharpenOrthomosaic:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		channels:  int
		"""Orthomosaic channel mask (boolean flags, e.g. 0b0010 means only 1st channel is used and the rest ignored).

		:type: int"""

		clip_to_pan_data:  bool
		"""Clip result to high resolution orthomosaic.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		orthomosaic:  int
		"""Orthomosaic to pansharpen.

		:type: int"""

		pan_channels:  int
		"""Detailed orthomosaic channel mask (boolean flags, e.g. 0b0010 means only 1st channel is used and the rest ignored).

		:type: int"""

		pan_orthomosaic:  int
		"""Detailed orthomosaic.

		:type: int"""

		replace_asset:  bool
		"""Replace source orthomosaic with pansharpened result.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class PlanMission:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		attach_viewpoints:  bool
		"""Generate additional viewpoints to increase coverage.

		:type: bool"""

		capture_distance:  float
		"""Image capture distance (m).

		:type: float"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		group_attached_viewpoints:  bool
		"""Ignore minimum waypoint spacing for additional viewpoints.

		:type: bool"""

		home_point:  int
		"""Home point shape key.

		:type: int"""

		horizontal_zigzags:  bool
		"""Cover surface with horizontal zigzags instead of vertical.

		:type: bool"""

		interesting_zone:  int
		"""Interesting zone shape layer key.

		:type: int"""

		max_pitch:  int
		"""Maximum camera pitch angle.

		:type: int"""

		min_altitude:  float
		"""Minimum altitude (m).

		:type: float"""

		min_pitch:  int
		"""Minimum camera pitch angle.

		:type: int"""

		min_waypoint_spacing:  float
		"""Minimum waypoint spacing (m).

		:type: float"""

		name:  str
		"""Task name.

		:type: str"""

		overlap:  int
		"""Overlap percent.

		:type: int"""

		powerlines:  int
		"""Powerlines shape layer key.

		:type: int"""

		restricted_zone:  int
		"""Restricted zone shape layer key.

		:type: int"""

		safety_distance:  float
		"""Safety distance (m).

		:type: float"""

		safety_zone:  int
		"""Safety zone shape layer key.

		:type: int"""

		sensor:  int
		"""Sensor key.

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		use_selection:  bool
		"""Focus on model selection.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class PublishData:
		"""Task class containing processing parameters."""
		account:  str
		"""Account name (Nira (Key ID) service).

		:type: str"""

		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		description:  str
		"""Dataset description.

		:type: str"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		hostname:  str
		"""Service hostname (4DMapper and Nira services).

		:type: str"""

		image_compression:  ImageCompression
		"""Image compression parameters.

		:type: ImageCompression"""

		is_draft:  bool
		"""Mark dataset as draft (Sketchfab service).

		:type: bool"""

		is_private:  bool
		"""Set dataset access to private (Pointbox and Sketchfab services).

		:type: bool"""

		is_protected:  bool
		"""Set dataset access to protected (Pointbox service).

		:type: bool"""

		max_zoom_level:  int
		"""Maximum zoom level.

		:type: int"""

		min_zoom_level:  int
		"""Minimum zoom level.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		owner:  str
		"""Account owner (Cesium and Mapbox services).

		:type: str"""

		password:  str
		"""Account password (4DMapper, Agisoft Cloud, Pointscene and Sketchfab services).

		:type: str"""

		point_classes:  list[int]
		"""List of point classes to be exported.

		:type: list[int]"""

		project_id:  str
		"""Id of a target project (from Agisoft Cloud project URL).

		:type: str"""

		projection:  CoordinateSystem
		"""Output projection.

		:type: CoordinateSystem"""

		raster_transform:  RasterTransformType
		"""Raster band transformation.

		:type: RasterTransformType"""

		resolution:  float
		"""Output resolution in meters.

		:type: float"""

		save_camera_track:  bool
		"""Enables/disables export of camera track.

		:type: bool"""

		save_point_color:  bool
		"""Enables/disables export of point colors.

		:type: bool"""

		service:  ServiceType
		"""Service to upload on.

		:type: ServiceType"""

		source_data:  DataSource
		"""Asset type to upload.

		:type: DataSource"""

		tags:  str
		"""Dataset tags.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		tile_size:  int
		"""Tile size in pixels.

		:type: int"""

		title:  str
		"""Dataset title.

		:type: str"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		token:  str
		"""Account token (Cesium, Mapbox, Nira (Key Secret), Picterra, Pointbox and Sketchfab services).

		:type: str"""

		upload_images:  bool
		"""Attach photos to Nira publication.

		:type: bool"""

		username:  str
		"""Account username (4DMapper, Agisoft Cloud and Pointscene services).

		:type: str"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ReduceOverlap:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		overlap:  int
		"""Target number of cameras observing each point of the surface.

		:type: int"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		use_selection:  bool
		"""Focus on model selection.

		:type: bool"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class RefineModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		downscale:  int
		"""Refinement quality (1 - Ultra high, 2 - High, 4 - Medium, 8 - Low, 16 - Lowest).

		:type: int"""

		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		iterations:  int
		"""Number of refinement iterations.

		:type: int"""

		model:  int
		"""Model to process.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		replace_asset:  bool
		"""Replace default asset with refined model.

		:type: bool"""

		smoothness:  float
		"""Smoothing strength. Should be in range [0, 1].

		:type: float"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class RemoveLighting:
		"""Task class containing processing parameters."""
		ambient_occlusion_multiplier:  float
		"""Ambient occlusion multiplier. Should be in range [0.25, 4].

		:type: float"""

		ambient_occlusion_path:  str
		"""Path to ambient occlusion texture atlas. Can be empty.

		:type: str"""

		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		color_mode:  bool
		"""Enable multi-color processing mode.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		internal_blur:  float
		"""Internal blur. Should be in range [0, 4].

		:type: float"""

		mesh_noise_suppression:  float
		"""Mesh normals noise suppression strength. Should be in range [0, 4].

		:type: float"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class RenderDepthMaps:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path_depth:  str
		"""Path to depth map.

		:type: str"""

		path_diffuse:  str
		"""Path to diffuse map.

		:type: str"""

		path_normals:  str
		"""Path to normal map.

		:type: str"""

		save_depth:  bool
		"""Enable export of depth map.

		:type: bool"""

		save_diffuse:  bool
		"""Enable export of diffuse map.

		:type: bool"""

		save_normals:  bool
		"""Enable export of normal map.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class ResetMasks:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		cameras:  list[int]
		"""List of cameras to process.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class RunScript:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		args:  str
		"""Script arguments.

		:type: str"""

		code:  str
		"""Script code.

		:type: str"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Script path.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class SaveProject:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		archive:  bool
		"""Override project format when using non-standard file extension.

		:type: bool"""

		chunks:  list[int]
		"""List of chunks to be saved.

		:type: list[int]"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		path:  str
		"""Path to project.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		version:  str
		"""Project version to save.

		:type: str"""

		workitem_count:  int
		"""Work item count.

		:type: int"""


	class SmoothModel:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		apply_to_selection:  bool
		"""Apply to selected faces.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		fix_borders:  bool
		"""Fix borders.

		:type: bool"""

		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		model:  int
		"""Key of model to smooth.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		preserve_edges:  bool
		"""Preserve edges.

		:type: bool"""

		replace_asset:  bool
		"""Replace default asset with smoothed model.

		:type: bool"""

		strength:  float
		"""Smoothing strength.

		:type: float"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class SmoothPointCloud:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		apply_to_selection:  bool
		"""Smooth points within selection.

		:type: bool"""

		classes:  list[int]
		"""List of point classes to be smoothed.

		:type: list[int]"""

		clip_to_region:  bool
		"""Clip point cloud to chunk region.

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		name:  str
		"""Task name.

		:type: str"""

		point_cloud:  int
		"""Key of point cloud to filter.

		:type: int"""

		replace_asset:  bool
		"""Replace default asset with smoothed point cloud.

		:type: bool"""

		smoothing_radius:  float
		"""Desired smoothing radius (m).

		:type: float"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class TargetType:
		"""Task target type in [DocumentTarget, ChunkTarget, FrameTarget]"""
		ChunkTarget: Any
		"""Task target type in [DocumentTarget, ChunkTarget, FrameTarget]"""

		DocumentTarget: Any
		"""Task target type in [DocumentTarget, ChunkTarget, FrameTarget]"""

		FrameTarget: Any
		"""Task target type in [DocumentTarget, ChunkTarget, FrameTarget]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""


	class TrackMarkers:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		first_frame:  int
		"""Starting frame index.

		:type: int"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		last_frame:  int
		"""Ending frame index.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""


	class TransformRaster:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		asset:  int
		"""Asset key to transform.

		:type: int"""

		clip_to_boundary:  bool
		"""Clip raster to boundary shapes.

		:type: bool"""

		copy_orthophotos:  bool
		"""Copy orthophotos (orthomosaic asset type only).

		:type: bool"""

		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		frames:  list[int]
		"""List of frames to process.

		:type: list[int]"""

		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		height:  int
		"""Raster height.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		nodata_value:  float
		"""No-data value (DEM export only).

		:type: float"""

		north_up:  bool
		"""Use north-up orientation for export.

		:type: bool"""

		operand_asset:  int
		"""Operand asset key.

		:type: int"""

		operand_chunk:  int
		"""Operand chunk key.

		:type: int"""

		operand_frame:  int
		"""Operand frame key.

		:type: int"""

		projection:  OrthoProjection
		"""Output projection.

		:type: OrthoProjection"""

		region:  BBox
		"""Region to be processed.

		:type: BBox"""

		replace_asset:  bool
		"""Replace default raster with transformed one.

		:type: bool"""

		resolution:  float
		"""Output resolution in meters.

		:type: float"""

		resolution_x:  float
		"""Pixel size in the X dimension in projected units.

		:type: float"""

		resolution_y:  float
		"""Pixel size in the Y dimension in projected units.

		:type: float"""

		source_data:  DataSource
		"""Selects between DEM and orthomosaic.

		:type: DataSource"""

		subtract:  bool
		"""Subtraction flag.

		:type: bool"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		width:  int
		"""Raster width.

		:type: int"""

		workitem_count:  int
		"""Work item count.

		:type: int"""

		world_transform:  Matrix
		"""2x3 raster-to-world transformation matrix.

		:type: Matrix"""


	class TriangulateTiePoints:
		"""Task class containing processing parameters."""
		def apply (self, *args, **kwargs):
			"""apply(object, [workitem], [progress])

			Apply task to specified object.

			:arg object: Chunk or Document object to be processed.
			:type object: Metashape.Chunk | Metashape.Document
			:arg workitem: Workitem index.
			:type workitem: int
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		def decode (self, *args, **kwargs):
			"""decode(dict)

			Initialize task parameters with a dictionary."""
		...
		def decodeJSON (self, *args, **kwargs):
			"""decodeJSON(json)

			Initialize task parameters from a JSON string."""
		...
		def encode (self, *args, **kwargs):
			"""encode()

			Create a dictionary with task parameters."""
		...
		def encodeJSON (self, *args, **kwargs):
			"""encodeJSON()

			Create a JSON string with task parameters."""
		...
		gpu_support:  bool
		"""GPU support flag.

		:type: bool"""

		max_error:  float
		"""Reprojection error threshold.

		:type: float"""

		min_image:  int
		"""Minimum number of point projections.

		:type: int"""

		name:  str
		"""Task name.

		:type: str"""

		target:  Tasks.TargetType
		"""Task target.

		:type: Tasks.TargetType"""

		def toNetworkTask (self, *args, **kwargs):
			"""toNetworkTask([objects])

			Convert task to :class:`Metashape.NetworkTask` to be applied to specified objects.

			:arg objects: Objects to be processed.
			:type objects: Metashape.Document | Metashape.Chunk | list[Metashape.Chunk]"""
		...
		workitem_count:  int
		"""Work item count.

		:type: int"""

	def createTask (self, *args, **kwargs) -> object:
		"""createTask(name)

		Create task object by its name.

		:arg name: Task name.
		:type name: str
		:return: Task object.
		:rtype: object"""
	...

class Thumbnail:
	def copy (self, *args, **kwargs) -> Thumbnail:
		"""copy()

		Returns a copy of thumbnail.

		:return: Copy of thumbnail.
		:rtype: Metashape.Thumbnail"""
	...
	def image (self, *args, **kwargs) -> Image:
		"""image()

		Returns image data.

		:return: Image data.
		:rtype: Metashape.Image"""
	...
	def load (self, *args, **kwargs):
		"""load(path, [layer])

		Loads thumbnail from file.

		:arg path: Path to the image file to be loaded.
		:type path: str
		:arg layer: Optional layer index in case of multipage files.
		:type layer: int"""
	...
	def setImage (self, *args, **kwargs):
		"""setImage(image)

		:arg image: Image object with thumbnail data.
		:type image: Metashape.Image"""
	...

class Thumbnails:
	def items (self, *args, **kwargs):
		"""items()

		List of items."""
	...
	def keys (self, *args, **kwargs):
		"""keys()

		List of item keys."""
	...
	meta:  MetaData
	"""Thumbnails meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def values (self, *args, **kwargs):
		"""values()

		List of item values."""
	...

class TiePoints:

	class Cameras:
		"""Collection of :class:`Metashape.TiePoints.Projections` objects indexed by corresponding cameras"""

	class Criterion:
		"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""
		ImageCount: Any
		"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

		ProjectionAccuracy: Any
		"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

		ReconstructionUncertainty: Any
		"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

		ReprojectionError: Any
		"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""


	class Filter:
		"""Tie point cloud filter

		The following example selects all tie points from the active chunk that have reprojection
		error higher than defined threshold:

		>>> chunk = Metashape.app.document.chunk # active chunk
		>>> threshold = 0.5
		>>> f = Metashape.TiePoints.Filter()
		>>> f.init(chunk, criterion = Metashape.TiePoints.Filter.ReprojectionError)
		>>> f.selectPoints(threshold)"""

		class Criterion:
			"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""
			ImageCount: Any
			"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

			ProjectionAccuracy: Any
			"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

			ReconstructionUncertainty: Any
			"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

			ReprojectionError: Any
			"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

			values: Any
			"""dict() -> new empty dictionary
			dict(mapping) -> new dictionary initialized from a mapping object's
			    (key, value) pairs
			dict(iterable) -> new dictionary initialized as if via:
			    d = {}
			    for k, v in iterable:
			        d[k] = v
			dict(**kwargs) -> new dictionary initialized with the name=value pairs
			    in the keyword argument list.  For example:  dict(one=1, two=2)"""

		ImageCount: Any
		"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

		ProjectionAccuracy: Any
		"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

		ReconstructionUncertainty: Any
		"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

		ReprojectionError: Any
		"""Point filtering criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

		def init (self, *args, **kwargs):
			"""init(points, criterion, progress)

			Initialize tie points filter based on specified criterion.

			:arg points: Tie points to filter.
			:type points: Metashape.TiePoints | Metashape.Chunk
			:arg criterion: Point filter criterion.
			:type criterion: Metashape.TiePoints.Filter.Criterion
			:arg progress: Progress callback.
			:type progress: Callable[[float], None]"""
		...
		max_value:  int | float
		"""Maximum value.

		:type: int | float"""

		min_value:  int | float
		"""Minimum value.

		:type: int | float"""

		def removePoints (self, *args, **kwargs):
			"""removePoints(threshold)

			Remove points based on specified threshold.

			:arg threshold: Criterion threshold.
			:type threshold: float"""
		...
		def resetSelection (self, *args, **kwargs):
			"""resetSelection()

			Reset previously made selection."""
		...
		def selectPoints (self, *args, **kwargs):
			"""selectPoints(threshold)

			Select points based on specified threshold.

			:arg threshold: Criterion threshold.
			:type threshold: float"""
		...
		values:  list[int] | list[float]
		"""List of values.

		:type: list[int] | list[float]"""

	ImageCount: Any
	"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""


	class Point:
		"""3D point in the tie point cloud"""
		coord:  Vector
		"""Point coordinates.

		:type: Vector"""

		cov:  Matrix
		"""Point coordinates covariance matrix.

		:type: Matrix"""

		selected:  bool
		"""Point selection flag.

		:type: bool"""

		track_id:  int
		"""Track index.

		:type: int"""

		valid:  bool
		"""Point valid flag.

		:type: bool"""


	class Points:
		"""Collection of 3D points in the tie point cloud"""
		def copy (self, *args, **kwargs) -> TiePoints.Points:
			"""copy()

			Returns a copy of points buffer.

			:return: Copy of points buffer.
			:rtype: Metashape.TiePoints.Points"""
		...
		def resize (self, *args, **kwargs):
			"""resize(count)

			Resize points list.

			:arg count: new point count
			:type count: int"""
		...

	class Projection:
		"""Projection of the 3D point on the photo"""
		coord:  Vector
		"""2D projection coordinates.

		:type: Vector"""

		size:  float
		"""Point size.

		:type: float"""

		track_id:  int
		"""Track index.

		:type: int"""

	ProjectionAccuracy: Any
	"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""


	class Projections:
		"""Collection of :class:`Metashape.TiePoints.Projection` for the camera"""
		def copy (self, *args, **kwargs) -> TiePoints.Projections:
			"""copy()

			Returns a copy of projections buffer.

			:return: Copy of projections buffer.
			:rtype: Metashape.TiePoints.Projections"""
		...
		def resize (self, *args, **kwargs):
			"""resize(count)

			Resize projections list.

			:arg count: new projections count
			:type count: int"""
		...
	ReconstructionUncertainty: Any
	"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""

	ReprojectionError: Any
	"""Tie points filter criterion in [ReprojectionError, ReconstructionUncertainty, ImageCount, ProjectionAccuracy]"""


	class Track:
		"""Track in the tie point cloud"""
		color:  tuple[int | float, ...]
		"""Track color.

		:type: tuple[int | float, ...]"""


	class Tracks:
		"""Collection of tracks in the tie point cloud"""
		def copy (self, *args, **kwargs) -> TiePoints.Tracks:
			"""copy()

			Returns a copy of tracks buffer.

			:return: Copy of tracks buffer.
			:rtype: Metashape.TiePoints.Tracks"""
		...
		def resize (self, *args, **kwargs):
			"""resize(count)

			Resize track list.

			:arg count: new track count
			:type count: int"""
		...
	bands:  list[str]
	"""List of color bands.

	:type: list[str]"""

	def cleanup (self, *args, **kwargs):
		"""cleanup([progress])

		Remove points with insufficient number of projections.

		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def copy (self, *args, **kwargs) -> TiePoints:
		"""copy(keypoints=True)

		Returns a copy of the tie point cloud.

		:arg keypoints: copy key points data.
		:type keypoints: bool
		:return: Copy of the tie point cloud.
		:rtype: Metashape.TiePoints"""
	...
	def cropSelectedPoints (self, *args, **kwargs):
		"""cropSelectedPoints()

		Crop selected points."""
	...
	def cropSelectedTracks (self, *args, **kwargs):
		"""cropSelectedTracks()

		Crop selected tie points."""
	...
	data_type:  DataType
	"""Data type used to store color values.

	:type: DataType"""

	def export (self, *args, **kwargs):
		"""export(path, format='obj', [projection])

		Export tie points.

		:arg path: Path to output file.
		:type path: str
		:arg format: Export format in ['obj', 'ply'].
		:type format: str
		:arg projection: Sets output projection.
		:type projection: Metashape.Matrix | Metashape.CoordinateSystem"""
	...
	def invertSelection (self, *args, **kwargs):
		"""invertSelection()

		Invert selection."""
	...
	meta:  MetaData
	"""Tie points meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def pickPoint (self, *args, **kwargs) -> Vector:
		"""pickPoint(origin, target, endpoints=1)

		Returns ray intersection with the tie point cloud (point on the ray nearest to some point).

		:arg origin: Ray origin.
		:type origin: Metashape.Vector
		:arg target: Point on the ray.
		:type target: Metashape.Vector
		:arg endpoints: Number of endpoints to check for (0 - line, 1 - ray, 2 - segment).
		:type endpoints: int
		:return: Coordinates of the intersection point.
		:rtype: Metashape.Vector"""
	...
	points:  TiePoints.Points
	"""List of points.

	:type: TiePoints.Points"""

	projections:  TiePoints.Projections
	"""Point projections for each photo.

	:type: TiePoints.Projections"""

	def removeKeypoints (self, *args, **kwargs):
		"""removeKeypoints()

		Remove keypoints from tie point cloud."""
	...
	def removeSelectedPoints (self, *args, **kwargs):
		"""removeSelectedPoints()

		Remove selected points."""
	...
	def removeSelectedTracks (self, *args, **kwargs):
		"""removeSelectedTracks()

		Remove selected tie points."""
	...
	def renderDepth (self, *args, **kwargs) -> Image:
		"""renderDepth(transform, calibration, point_size=1, cull_points=False, add_alpha=True)

		Render tie points depth image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg point_size: Point size.
		:type point_size: int
		:arg cull_points: Enable normal based culling.
		:type cull_points: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderImage (self, *args, **kwargs) -> Image:
		"""renderImage(transform, calibration, point_size=1, cull_points=False, add_alpha=True, raster_transform=RasterTransformNone)

		Render tie points image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg point_size: Point size.
		:type point_size: int
		:arg cull_points: Enable normal based culling.
		:type cull_points: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.RasterTransformType
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderMask (self, *args, **kwargs) -> Image:
		"""renderMask(transform, calibration, point_size=1, cull_points=False)

		Render tie points mask image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg point_size: Point size.
		:type point_size: int
		:arg cull_points: Enable normal based culling.
		:type cull_points: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderNormalMap (self, *args, **kwargs) -> Image:
		"""renderNormalMap(transform, calibration, point_size=1, cull_points=False, add_alpha=True)

		Render image with tie points normals for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg point_size: Point size.
		:type point_size: int
		:arg cull_points: Enable normal based culling.
		:type cull_points: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderPreview (self, *args, **kwargs) -> Image:
		"""renderPreview(width = 2048, height = 2048, [transform], point_size=1, [progress])

		Generate tie points preview image.

		:arg width: Preview image width.
		:type width: int
		:arg height: Preview image height.
		:type height: int
		:arg transform: 4x4 viewpoint transformation matrix.
		:type transform: Metashape.Matrix
		:arg point_size: Point size.
		:type point_size: int
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Preview image.
		:rtype: Metashape.Image"""
	...
	tracks:  TiePoints.Tracks
	"""List of tracks.

	:type: TiePoints.Tracks"""


class TiledModel:

	class FaceCount:
		"""Tiled model face count in [LowFaceCount, MediumFaceCount, HighFaceCount]"""
		HighFaceCount: Any
		"""Tiled model face count in [LowFaceCount, MediumFaceCount, HighFaceCount]"""

		LowFaceCount: Any
		"""Tiled model face count in [LowFaceCount, MediumFaceCount, HighFaceCount]"""

		MediumFaceCount: Any
		"""Tiled model face count in [LowFaceCount, MediumFaceCount, HighFaceCount]"""

		values: Any
		"""dict() -> new empty dictionary
		dict(mapping) -> new dictionary initialized from a mapping object's
		    (key, value) pairs
		dict(iterable) -> new dictionary initialized as if via:
		    d = {}
		    for k, v in iterable:
		        d[k] = v
		dict(**kwargs) -> new dictionary initialized with the name=value pairs
		    in the keyword argument list.  For example:  dict(one=1, two=2)"""

	HighFaceCount: Any
	"""Tiled model face count in [LowFaceCount, MediumFaceCount, HighFaceCount]"""

	LowFaceCount: Any
	"""Tiled model face count in [LowFaceCount, MediumFaceCount, HighFaceCount]"""

	MediumFaceCount: Any
	"""Tiled model face count in [LowFaceCount, MediumFaceCount, HighFaceCount]"""

	bands:  list[str]
	"""List of color bands.

	:type: list[str]"""

	def clear (self, *args, **kwargs):
		"""clear()

		Clears tiled model data."""
	...
	def copy (self, *args, **kwargs) -> TiledModel:
		"""copy()

		Create a copy of the tiled model.

		:return: Copy of the tiled model.
		:rtype: Metashape.TiledModel"""
	...
	crs:  CoordinateSystem | None
	"""Reference coordinate system.

	:type: CoordinateSystem | None"""

	data_type:  DataType
	"""Data type used to store color values.

	:type: DataType"""

	key:  int
	"""Tiled model identifier.

	:type: int"""

	label:  str
	"""Tiled model label.

	:type: str"""

	meta:  MetaData
	"""Tiled model meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	def pickPoint (self, *args, **kwargs) -> Vector:
		"""pickPoint(origin, target, endpoints=1)

		Returns ray intersection with the tiled model.

		:arg origin: Ray origin.
		:type origin: Metashape.Vector
		:arg target: Point on the ray.
		:type target: Metashape.Vector
		:arg endpoints: Number of endpoints to check for (0 - line, 1 - ray, 2 - segment).
		:type endpoints: int
		:return: Coordinates of the intersection point.
		:rtype: Metashape.Vector"""
	...
	def renderDepth (self, *args, **kwargs) -> Image:
		"""renderDepth(transform, calibration, resolution=1, cull_faces=True, add_alpha=True)

		Render tiled model depth image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg resolution: Level of detail resolution in screen pixels.
		:type resolution: float
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderImage (self, *args, **kwargs) -> Image:
		"""renderImage(transform, calibration, resolution=1, cull_faces=True, add_alpha=True, raster_transform=RasterTransformNone, matcap_image, smooth_normals=True, color)

		Render tiled model image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg resolution: Level of detail resolution in screen pixels.
		:type resolution: float
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:arg raster_transform: Raster band transformation.
		:type raster_transform: Metashape.RasterTransformType
		:arg matcap_image: Matcap image used to shade model.
		:type matcap_image: Metashape.Image
		:arg smooth_normals: Enable normals smoothing.:type smooth_normals: bool
		:arg color: Solid view color.
		:type color: list[int]:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderMask (self, *args, **kwargs) -> Image:
		"""renderMask(transform, calibration, resolution=1, cull_faces=True)

		Render tiled model mask image for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg resolution: Level of detail resolution in screen pixels.
		:type resolution: float
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderNormalMap (self, *args, **kwargs) -> Image:
		"""renderNormalMap(transform, calibration, resolution=1, cull_faces=True, add_alpha=True)

		Render image with tiled model normals for specified viewpoint.

		:arg transform: Camera location.
		:type transform: Metashape.Matrix
		:arg calibration: Camera calibration.
		:type calibration: Metashape.Calibration
		:arg resolution: Level of detail resolution in screen pixels.
		:type resolution: float
		:arg cull_faces: Enable back-face culling.
		:type cull_faces: bool
		:arg add_alpha: Generate image with alpha channel.
		:type add_alpha: bool
		:arg smooth_normals: Enable normals smoothing.:type smooth_normals: bool
		:return: Rendered image.
		:rtype: Metashape.Image"""
	...
	def renderPreview (self, *args, **kwargs) -> Image:
		"""renderPreview(width = 2048, height = 2048, [transform], [progress])

		Generate tiled model preview image.

		:arg width: Preview image width.
		:type width: int
		:arg height: Preview image height.
		:type height: int
		:arg transform: 4x4 viewpoint transformation matrix.
		:type transform: Metashape.Matrix
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]
		:return: Preview image.
		:rtype: Metashape.Image"""
	...
	resolution:  float
	"""Tiled model resolution in m/pix.

	:type: float"""

	transform:  Matrix
	"""4x4 tiled model transformation matrix.

	:type: Matrix"""


class TiledModelFormat:
	TiledModelFormat3MX: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	TiledModelFormatCesium: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	TiledModelFormatLOD: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	TiledModelFormatNone: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	TiledModelFormatOSGB: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	TiledModelFormatOSGT: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	TiledModelFormatSLPK: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	TiledModelFormatTLS: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	TiledModelFormatZIP: Any
	"""Tiled model format in [TiledModelFormatNone, TiledModelFormatTLS, TiledModelFormatLOD, TiledModelFormatZIP, TiledModelFormatCesium, TiledModelFormatSLPK, TiledModelFormatOSGB, TiledModelFormatOSGT, TiledModelFormat3MX]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Trajectory:

	class Position:
		"""Trajectory position"""
		location:  Vector
		"""Position coordinates.

		:type: Vector"""

		masked:  bool
		"""Position mask flag.

		:type: bool"""

		rotation:  Vector
		"""Rotation vector.

		:type: Vector"""

		selected:  bool
		"""Position selection flag.

		:type: bool"""

		time:  float
		"""Position timestamp.

		:type: float"""


	class Positions:
		"""Collection of trajectory positions"""
		def copy (self, *args, **kwargs) -> Trajectory.Positions:
			"""copy()

			Returns a copy of position list.

			:return: Copy of position list.
			:rtype: Metashape.Trajectory.Positions"""
		...
		def resize (self, *args, **kwargs):
			"""resize(count)

			Resize position list.

			:arg count: new position count
			:type count: int"""
		...
	def addTimeOffset (self, *args, **kwargs):
		"""addTimeOffset(offset)

		Add time offset to trajectory positions.

		:arg offset: Time offset to add, in seconds.
		:type offset: float"""
	...
	antenna:  Antenna
	"""GPS antenna correction.

	:type: Antenna"""

	def clear (self, *args, **kwargs):
		"""clear()

		Clear trajectory data."""
	...
	def copy (self, *args, **kwargs) -> Trajectory:
		"""copy()

		Create a copy of the trajectory.

		:return: Copy of the trajectory.
		:rtype: Metashape.Trajectory"""
	...
	def createMask (self, *args, **kwargs):
		"""createMask(heading_threshold=10, min_duration=5, min_distance=20, crop_with_data=False, trim_ends=True, [progress])

		Create automatic trajectory mask.

		:arg heading_threshold: Maximum difference of heading in segment, in degrees.
		:type heading_threshold: float
		:arg min_duration: Minimal time duration of segment, in seconds.
		:type min_duration: float
		:arg min_distance: Minimal distance of segment, in meters.
		:type min_distance: float
		:arg crop_with_data: Enable segment cropping with corresponding point clouds.
		:type crop_with_data: bool
		:arg trim_ends: Enable segment ends trimming.
		:type trim_ends: bool
		:arg progress: Progress callback.
		:type progress: Callable[[float], None]"""
	...
	def cropMaskBySelection (self, *args, **kwargs):
		"""cropMaskBySelection()

		Crop trajectory mask by selection."""
	...
	crs:  CoordinateSystem | None
	"""Reference coordinate system.

	:type: CoordinateSystem | None"""

	extent:  BBox
	"""Trajectory extent in local trajectory coordinate system.

	:type: BBox"""

	def interpolate (self, *args, **kwargs) -> Trajectory.Position:
		"""interpolate(time, max_interval=0)

		Interpolate trajectory at specified time moment.

		:arg time: Time to interpolate at.
		:type time: float
		:arg max_interval: Maximum sampling interval allowed for interpolation (unlimited if 0).
		:type max_interval: float
		:return: Interpolated trajectory position.
		:rtype: Metashape.Trajectory.Position"""
	...
	def invertSelection (self, *args, **kwargs):
		"""invertSelection()

		Invert selection."""
	...
	key:  int
	"""Trajectory identifier.

	:type: int"""

	label:  str
	"""Trajectory label.

	:type: str"""

	def maskSelectedPositions (self, *args, **kwargs):
		"""maskSelectedPositions()

		Mask selected trajectory positions."""
	...
	meta:  MetaData
	"""Trajectory meta data.

	:type: MetaData"""

	modified:  bool
	"""Modified flag.

	:type: bool"""

	position_count:  int
	"""Number of positions in trajectory.

	:type: int"""

	positions:  Trajectory.Positions
	"""List of trajectory positions.

	:type: Trajectory.Positions"""

	def resetMask (self, *args, **kwargs):
		"""resetMask()

		Reset trajectory mask."""
	...
	sampling_interval:  float
	"""Trajectory sampling interval.

	:type: float"""

	selected:  bool
	"""Selects/deselects the trajectory.

	:type: bool"""

	transform:  Matrix
	"""4x4 trajectory transformation matrix.

	:type: Matrix"""

	def unmaskSelectedPositions (self, *args, **kwargs):
		"""unmaskSelectedPositions()

		Unmask selected trajectory positions."""
	...

class TrajectoryFormat:
	TrajectoryFormatCSV: Any
	"""Trajectory format in [TrajectoryFormatNone, TrajectoryFormatCSV, TrajectoryFormatSBET, TrajectoryFormatSOL, TrajectoryFormatTRJ]"""

	TrajectoryFormatNone: Any
	"""Trajectory format in [TrajectoryFormatNone, TrajectoryFormatCSV, TrajectoryFormatSBET, TrajectoryFormatSOL, TrajectoryFormatTRJ]"""

	TrajectoryFormatSBET: Any
	"""Trajectory format in [TrajectoryFormatNone, TrajectoryFormatCSV, TrajectoryFormatSBET, TrajectoryFormatSOL, TrajectoryFormatTRJ]"""

	TrajectoryFormatSOL: Any
	"""Trajectory format in [TrajectoryFormatNone, TrajectoryFormatCSV, TrajectoryFormatSBET, TrajectoryFormatSOL, TrajectoryFormatTRJ]"""

	TrajectoryFormatTRJ: Any
	"""Trajectory format in [TrajectoryFormatNone, TrajectoryFormatCSV, TrajectoryFormatSBET, TrajectoryFormatSOL, TrajectoryFormatTRJ]"""

	values: Any
	"""dict() -> new empty dictionary
	dict(mapping) -> new dictionary initialized from a mapping object's
	    (key, value) pairs
	dict(iterable) -> new dictionary initialized as if via:
	    d = {}
	    for k, v in iterable:
	        d[k] = v
	dict(**kwargs) -> new dictionary initialized with the name=value pairs
	    in the keyword argument list.  For example:  dict(one=1, two=2)"""


class Utils:
	def createChessboardImage (self, *args, **kwargs) -> Image:
		"""createChessboardImage(calib, cell_size=150, max_tilt=30)

		Synthesizes photo of a chessboard.

		:arg calib: Camera calibration.
		:type calib: Metashape.Calibration
		:arg cell_size: Chessboard cell size.
		:type cell_size: float
		:arg max_tilt: Maximum camera tilt in degrees.
		:type max_tilt: float
		:return: Resulting image.
		:rtype: Metashape.Image"""
	...
	def createDifferenceMask (self, *args, **kwargs) -> Image:
		"""createDifferenceMask(image, background, tolerance=10, fit_colors=True)

		Creates mask from a pair of images or an image and specified color.

		:arg image: Image to be masked.
		:type image: Metashape.Image
		:arg background: Background image or color value.
		:type background: Metashape.Image | tuple[int, ...]
		:arg tolerance: Tolerance value.
		:type tolerance: int
		:arg fit_colors: Enables white balance correction.
		:type fit_colors: bool
		:return: Resulting mask.
		:rtype: Metashape.Image"""
	...
	def createMarkers (self, *args, **kwargs):
		"""createMarkers(chunk, projections)

		Creates markers from a list of non coded projections.

		:arg chunk: Chunk to create markers in.
		:type chunk: Metashape.Chunk
		:arg projections: List of marker projections.
		:type projections: list[tuple[Metashape.Camera, Metashape.Target]]"""
	...
	def detectTargets (self, *args, **kwargs) -> list[Metashape.Target]:
		"""detectTargets(image, type=TargetCircular12bit, tolerance=50, inverted=False, noparity=False, [minimum_size], [minimum_dist])

		Detect targets on the image.

		:arg image: Image to process.
		:type image: Metashape.Image
		:arg type: Type of targets.
		:type type: Metashape.TargetType
		:arg tolerance: Detector tolerance (0 - 100).
		:type tolerance: int
		:arg inverted: Detect markers on black background.
		:type inverted: bool
		:arg noparity: Disable parity checking.
		:type noparity: bool
		:arg minimum_size: Minimum target radius in pixels to be detected (CrossTarget type only).
		:type minimum_size: int
		:arg minimum_dist: Minimum distance between targets in pixels (CrossTarget type only).
		:type minimum_dist: int
		:return: List of detected targets.
		:rtype: list[Metashape.Target]"""
	...
	def dmat2euler (self, *args, **kwargs) -> Vector:
		"""dmat2euler(R, dR, euler_angles=EulerAnglesYPR)

		Calculate tangent euler rotation vector from tangent rotation matrix.

		:arg R: Rotation matrix.
		:type R: Metashape.Matrix
		:arg dR: Tangent rotation matrix.
		:type dR: Metashape.Matrix
		:arg euler_angles: Euler angles to use.
		:type euler_angles: Metashape.EulerAngles
		:return: Tangent rotation angles in degrees.
		:rtype: Metashape.Vector"""
	...
	def estimateImageQuality (self, *args, **kwargs) -> float:
		"""estimateImageQuality(image, [mask])

		Estimate image sharpness.

		:arg image: Image to be analyzed.
		:type image: Metashape.Image
		:arg mask: Mask of the analyzed image region.
		:type mask: Metashape.Image
		:return: Quality metric.
		:rtype: float"""
	...
	def euler2mat (self, *args, **kwargs) -> Matrix:
		"""euler2mat(rotation, euler_angles=EulerAnglesYPR)

		Calculate camera to world rotation matrix from euler rotation angles.

		:arg rotation: Rotation vector.
		:type rotation: Metashape.Vector
		:arg euler_angles: Euler angles to use.
		:type euler_angles: Metashape.EulerAngles
		:return: Rotation matrix.
		:rtype: Metashape.Matrix"""
	...
	def mat2euler (self, *args, **kwargs) -> Vector:
		"""mat2euler(R, euler_angles=EulerAnglesYPR)

		Calculate euler rotation angles from camera to world rotation matrix.

		:arg R: Rotation matrix.
		:type R: Metashape.Matrix
		:arg euler_angles: Euler angles to use.
		:type euler_angles: Metashape.EulerAngles
		:return: Rotation angles in degrees.
		:rtype: Metashape.Vector"""
	...
	def mat2opk (self, *args, **kwargs) -> Vector:
		"""mat2opk(R)

		Calculate omega, phi, kappa from camera to world rotation matrix.

		:arg R: Rotation matrix.
		:type R: Metashape.Matrix
		:return: Omega, phi, kappa angles in degrees.
		:rtype: Metashape.Vector"""
	...
	def mat2rvec (self, *args, **kwargs) -> Vector:
		"""mat2rvec(R)

		Calculate rotation vector from rotation matrix.

		:arg R: Rotation matrix.
		:type R: Metashape.Matrix
		:return: Rotation vector.
		:rtype: Metashape.Vector"""
	...
	def mat2ypr (self, *args, **kwargs) -> Vector:
		"""mat2ypr(R)

		Calculate yaw, pitch, roll from camera to world rotation matrix.

		:arg R: Rotation matrix.
		:type R: Metashape.Matrix
		:return: Yaw, pitch roll angles in degrees.
		:rtype: Metashape.Vector"""
	...
	def opk2mat (self, *args, **kwargs) -> Matrix:
		"""opk2mat(angles)

		Calculate camera to world rotation matrix from omega, phi, kappa angles.

		:arg angles: Omega, phi, kappa angles in degrees.
		:type angles: Metashape.Vector
		:return: Rotation matrix.
		:rtype: Metashape.Matrix"""
	...
	def rvec2mat (self, *args, **kwargs) -> Matrix:
		"""rvec2mat(rvec)

		Calculate rotation matrix from rotation vector.

		:arg rvec: Rotation vector.
		:type rvec: Metashape.Vector
		:return: Rotation matrix.
		:rtype: Metashape.Matrix"""
	...
	def ypr2mat (self, *args, **kwargs) -> Matrix:
		"""ypr2mat(angles)

		Calculate camera to world rotation matrix from yaw, pitch, roll angles.

		:arg angles: Yaw, pitch, roll angles in degrees.
		:type angles: Metashape.Vector
		:return: Rotation matrix.
		:rtype: Metashape.Matrix"""
	...

class Vector:
	def copy (self, *args, **kwargs) -> Vector:
		"""copy()

		Return a copy of the vector.

		:return: A copy of the vector.
		:rtype: Metashape.Vector"""
	...
	def cross (self, *args, **kwargs) -> Vector:
		"""cross(a, b)

		Cross product of 2 vectors.

		:arg a: First vector.
		:type a: Metashape.Vector
		:arg b: Second vector.
		:type b: Metashape.Vector
		:return: Cross product.
		:rtype: Metashape.Vector"""
	...
	def norm (self, *args, **kwargs):
		"""norm()

		Return norm of the vector."""
	...
	def norm2 (self, *args, **kwargs):
		"""norm2()

		Return squared norm of the vector."""
	...
	def normalize (self, *args, **kwargs):
		"""normalize()

		Normalize vector to the unit length."""
	...
	def normalized (self, *args, **kwargs) -> Vector:
		"""normalized()

		Return a new, normalized vector.

		:return: a normalized copy of the vector
		:rtype: Metashape.Vector"""
	...
	size:  int
	"""Vector dimensions.

	:type: int"""

	w:  float
	"""Vector W component.

	:type: float"""

	x:  float
	"""Vector X component.

	:type: float"""

	y:  float
	"""Vector Y component.

	:type: float"""

	z:  float
	"""Vector Z component.

	:type: float"""

	def zero (self, *args, **kwargs):
		"""zero()

		Set all elements to zero."""
	...

class Version:
	build:  int
	"""Build number.

	:type: int"""

	def copy (self, *args, **kwargs) -> Version:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Version"""
	...
	major:  int
	"""Major version number.

	:type: int"""

	micro:  int
	"""Micro version number.

	:type: int"""

	minor:  int
	"""Minor version number.

	:type: int"""


class Viewpoint:
	center:  Vector
	"""Camera center.

	:type: Vector"""

	coo:  Vector
	"""Center of orbit.

	:type: Vector"""

	def copy (self, *args, **kwargs) -> Viewpoint:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Viewpoint"""
	...
	fov:  float
	"""Camera vertical field of view in degrees.

	:type: float"""

	height:  int
	"""OpenGL window height.

	:type: int"""

	mag:  float
	"""Camera magnification defined by distance to the center of rotation.

	:type: float"""

	rot:  Matrix
	"""Camera rotation matrix.

	:type: Matrix"""

	width:  int
	"""OpenGL window width.

	:type: int"""


class Vignetting:
	def copy (self, *args, **kwargs) -> Vignetting:
		"""copy()

		Return a copy of the object.

		:return: A copy of the object.
		:rtype: Metashape.Vignetting"""
	...
