/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

/**
 * NetworkClient class provides access to the network processing server and allows<br>
 * to create and manage tasks.
 */
public class NetworkClient {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  public NetworkClient(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  public static long getCPtr(NetworkClient obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_NetworkClient(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public NetworkClient() {
    this(MetashapeJNI.new_NetworkClient(), true);
  }

  static public class LogRecord {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public LogRecord(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(LogRecord obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_LogRecord(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public static long[] cArrayUnwrap(NetworkClient.LogRecord[] arrayWrapper) {
      long[] cArray = new long[arrayWrapper.length];
      for (int i=0; i<arrayWrapper.length; i++)
        cArray[i] = NetworkClient.LogRecord.getCPtr(arrayWrapper[i]);
      return cArray;
    }
  
    public static NetworkClient.LogRecord[] cArrayWrap(long[] cArray, boolean cMemoryOwn) {
      NetworkClient.LogRecord[] arrayWrapper = new NetworkClient.LogRecord[cArray.length];
      for (int i=0; i<cArray.length; i++)
        arrayWrapper[i] = new NetworkClient.LogRecord(cArray[i], cMemoryOwn);
      return arrayWrapper;
    }
  
    public void setType(int value) {
      MetashapeJNI.NetworkClient_LogRecord_type_set(swigCPtr, this, value);
    }
  
    public int getType() {
      return MetashapeJNI.NetworkClient_LogRecord_type_get(swigCPtr, this);
    }
  
    public void setText(String value) {
      MetashapeJNI.NetworkClient_LogRecord_text_set(swigCPtr, this, value);
    }
  
    public String getText() {
      return MetashapeJNI.NetworkClient_LogRecord_text_get(swigCPtr, this);
    }
  
    public LogRecord() {
      this(MetashapeJNI.new_NetworkClient_LogRecord(), true);
    }
  
  }

  static public class ResourceRecord {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public ResourceRecord(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(ResourceRecord obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_ResourceRecord(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public static long[] cArrayUnwrap(NetworkClient.ResourceRecord[] arrayWrapper) {
      long[] cArray = new long[arrayWrapper.length];
      for (int i=0; i<arrayWrapper.length; i++)
        cArray[i] = NetworkClient.ResourceRecord.getCPtr(arrayWrapper[i]);
      return cArray;
    }
  
    public static NetworkClient.ResourceRecord[] cArrayWrap(long[] cArray, boolean cMemoryOwn) {
      NetworkClient.ResourceRecord[] arrayWrapper = new NetworkClient.ResourceRecord[cArray.length];
      for (int i=0; i<cArray.length; i++)
        arrayWrapper[i] = new NetworkClient.ResourceRecord(cArray[i], cMemoryOwn);
      return arrayWrapper;
    }
  
    public void setTime(double value) {
      MetashapeJNI.NetworkClient_ResourceRecord_time_set(swigCPtr, this, value);
    }
  
    public double getTime() {
      return MetashapeJNI.NetworkClient_ResourceRecord_time_get(swigCPtr, this);
    }
  
    public void setRamUsage(double value) {
      MetashapeJNI.NetworkClient_ResourceRecord_ramUsage_set(swigCPtr, this, value);
    }
  
    public double getRamUsage() {
      return MetashapeJNI.NetworkClient_ResourceRecord_ramUsage_get(swigCPtr, this);
    }
  
    public void setCpuUsage(double value) {
      MetashapeJNI.NetworkClient_ResourceRecord_cpuUsage_set(swigCPtr, this, value);
    }
  
    public double getCpuUsage() {
      return MetashapeJNI.NetworkClient_ResourceRecord_cpuUsage_get(swigCPtr, this);
    }
  
    public ResourceRecord() {
      this(MetashapeJNI.new_NetworkClient_ResourceRecord(), true);
    }
  
  }

  static public class ServerInfo {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public ServerInfo(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(ServerInfo obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_ServerInfo(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public void setTimeStarted(long value) {
      MetashapeJNI.NetworkClient_ServerInfo_timeStarted_set(swigCPtr, this, value);
    }
  
    public long getTimeStarted() {
      return MetashapeJNI.NetworkClient_ServerInfo_timeStarted_get(swigCPtr, this);
    }
  
    public void setVersion(String value) {
      MetashapeJNI.NetworkClient_ServerInfo_version_set(swigCPtr, this, value);
    }
  
    public String getVersion() {
      return MetashapeJNI.NetworkClient_ServerInfo_version_get(swigCPtr, this);
    }
  
    public ServerInfo() {
      this(MetashapeJNI.new_NetworkClient_ServerInfo(), true);
    }
  
  }

  static public class TaskStatus {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public TaskStatus(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(TaskStatus obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_TaskStatus(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public static long[] cArrayUnwrap(NetworkClient.TaskStatus[] arrayWrapper) {
      long[] cArray = new long[arrayWrapper.length];
      for (int i=0; i<arrayWrapper.length; i++)
        cArray[i] = NetworkClient.TaskStatus.getCPtr(arrayWrapper[i]);
      return cArray;
    }
  
    public static NetworkClient.TaskStatus[] cArrayWrap(long[] cArray, boolean cMemoryOwn) {
      NetworkClient.TaskStatus[] arrayWrapper = new NetworkClient.TaskStatus[cArray.length];
      for (int i=0; i<cArray.length; i++)
        arrayWrapper[i] = new NetworkClient.TaskStatus(cArray[i], cMemoryOwn);
      return arrayWrapper;
    }
  
    public void setTask(NetworkTask value) {
      MetashapeJNI.NetworkClient_TaskStatus_task_set(swigCPtr, this, NetworkTask.getCPtr(value), value);
    }
  
    public NetworkTask getTask() {
      long cPtr = MetashapeJNI.NetworkClient_TaskStatus_task_get(swigCPtr, this);
      return (cPtr == 0) ? null : new NetworkTask(cPtr, false);
    }
  
    public void setStatus(NetworkClient.Status value) {
      MetashapeJNI.NetworkClient_TaskStatus_status_set(swigCPtr, this, value.ordinal());
    }
  
    public NetworkClient.Status getStatus() {
      return NetworkClient.Status.class.getEnumConstants()[MetashapeJNI.NetworkClient_TaskStatus_status_get(swigCPtr, this)];
    }
  
    public void setProgress(double value) {
      MetashapeJNI.NetworkClient_TaskStatus_progress_set(swigCPtr, this, value);
    }
  
    public double getProgress() {
      return MetashapeJNI.NetworkClient_TaskStatus_progress_get(swigCPtr, this);
    }
  
    public void setTimeElapsed(double value) {
      MetashapeJNI.NetworkClient_TaskStatus_timeElapsed_set(swigCPtr, this, value);
    }
  
    public double getTimeElapsed() {
      return MetashapeJNI.NetworkClient_TaskStatus_timeElapsed_get(swigCPtr, this);
    }
  
    public void setTimeLeft(double value) {
      MetashapeJNI.NetworkClient_TaskStatus_timeLeft_set(swigCPtr, this, value);
    }
  
    public double getTimeLeft() {
      return MetashapeJNI.NetworkClient_TaskStatus_timeLeft_get(swigCPtr, this);
    }
  
    public void setItemsTotal(int value) {
      MetashapeJNI.NetworkClient_TaskStatus_itemsTotal_set(swigCPtr, this, value);
    }
  
    public int getItemsTotal() {
      return MetashapeJNI.NetworkClient_TaskStatus_itemsTotal_get(swigCPtr, this);
    }
  
    public void setItemsDone(int value) {
      MetashapeJNI.NetworkClient_TaskStatus_itemsDone_set(swigCPtr, this, value);
    }
  
    public int getItemsDone() {
      return MetashapeJNI.NetworkClient_TaskStatus_itemsDone_get(swigCPtr, this);
    }
  
    public void setWorkitemsWaiting(int value) {
      MetashapeJNI.NetworkClient_TaskStatus_workitemsWaiting_set(swigCPtr, this, value);
    }
  
    public int getWorkitemsWaiting() {
      return MetashapeJNI.NetworkClient_TaskStatus_workitemsWaiting_get(swigCPtr, this);
    }
  
    public void setWorkitemsWorking(int value) {
      MetashapeJNI.NetworkClient_TaskStatus_workitemsWorking_set(swigCPtr, this, value);
    }
  
    public int getWorkitemsWorking() {
      return MetashapeJNI.NetworkClient_TaskStatus_workitemsWorking_get(swigCPtr, this);
    }
  
    public void setWorkitemsCompleted(int value) {
      MetashapeJNI.NetworkClient_TaskStatus_workitemsCompleted_set(swigCPtr, this, value);
    }
  
    public int getWorkitemsCompleted() {
      return MetashapeJNI.NetworkClient_TaskStatus_workitemsCompleted_get(swigCPtr, this);
    }
  
    public void setWorkitemsFailed(int value) {
      MetashapeJNI.NetworkClient_TaskStatus_workitemsFailed_set(swigCPtr, this, value);
    }
  
    public int getWorkitemsFailed() {
      return MetashapeJNI.NetworkClient_TaskStatus_workitemsFailed_get(swigCPtr, this);
    }
  
    public void setLog(NetworkClient.LogRecord[] value) {
      MetashapeJNI.NetworkClient_TaskStatus_log_set(swigCPtr, this, NetworkClient.LogRecord.cArrayUnwrap(value));
    }
  
    public NetworkClient.LogRecord[] getLog() { return NetworkClient.LogRecord.cArrayWrap(MetashapeJNI.NetworkClient_TaskStatus_log_get(swigCPtr, this), false); }
  
    public TaskStatus() {
      this(MetashapeJNI.new_NetworkClient_TaskStatus(), true);
    }
  
  }

  static public class BatchStatus {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public BatchStatus(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(BatchStatus obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_BatchStatus(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public void setPath(String value) {
      MetashapeJNI.NetworkClient_BatchStatus_path_set(swigCPtr, this, value);
    }
  
    public String getPath() {
      return MetashapeJNI.NetworkClient_BatchStatus_path_get(swigCPtr, this);
    }
  
    public void setUuid(String value) {
      MetashapeJNI.NetworkClient_BatchStatus_uuid_set(swigCPtr, this, value);
    }
  
    public String getUuid() {
      return MetashapeJNI.NetworkClient_BatchStatus_uuid_get(swigCPtr, this);
    }
  
    public void setMeta(MetaData value) {
      MetashapeJNI.NetworkClient_BatchStatus_meta_set(swigCPtr, this, MetaData.getCPtr(value), value);
    }
  
    public MetaData getMeta() {
      long cPtr = MetashapeJNI.NetworkClient_BatchStatus_meta_get(swigCPtr, this);
      return (cPtr == 0) ? null : new MetaData(cPtr, false);
    }
  
    public void setStatus(NetworkClient.Status value) {
      MetashapeJNI.NetworkClient_BatchStatus_status_set(swigCPtr, this, value.ordinal());
    }
  
    public NetworkClient.Status getStatus() {
      return NetworkClient.Status.class.getEnumConstants()[MetashapeJNI.NetworkClient_BatchStatus_status_get(swigCPtr, this)];
    }
  
    public void setPriority(int value) {
      MetashapeJNI.NetworkClient_BatchStatus_priority_set(swigCPtr, this, value);
    }
  
    public int getPriority() {
      return MetashapeJNI.NetworkClient_BatchStatus_priority_get(swigCPtr, this);
    }
  
    public void setTimeStarted(long value) {
      MetashapeJNI.NetworkClient_BatchStatus_timeStarted_set(swigCPtr, this, value);
    }
  
    public long getTimeStarted() {
      return MetashapeJNI.NetworkClient_BatchStatus_timeStarted_get(swigCPtr, this);
    }
  
    public void setTimeFinished(long value) {
      MetashapeJNI.NetworkClient_BatchStatus_timeFinished_set(swigCPtr, this, value);
    }
  
    public long getTimeFinished() {
      return MetashapeJNI.NetworkClient_BatchStatus_timeFinished_get(swigCPtr, this);
    }
  
    public void setTasks(NetworkClient.TaskStatus[] value) {
      MetashapeJNI.NetworkClient_BatchStatus_tasks_set(swigCPtr, this, NetworkClient.TaskStatus.cArrayUnwrap(value));
    }
  
    public NetworkClient.TaskStatus[] getTasks() { return NetworkClient.TaskStatus.cArrayWrap(MetashapeJNI.NetworkClient_BatchStatus_tasks_get(swigCPtr, this), false); }
  
    public void setErrorTime(long value) {
      MetashapeJNI.NetworkClient_BatchStatus_errorTime_set(swigCPtr, this, value);
    }
  
    public long getErrorTime() {
      return MetashapeJNI.NetworkClient_BatchStatus_errorTime_get(swigCPtr, this);
    }
  
    public void setErrorNodeId(long value) {
      MetashapeJNI.NetworkClient_BatchStatus_errorNodeId_set(swigCPtr, this, value);
    }
  
    public long getErrorNodeId() {
      return MetashapeJNI.NetworkClient_BatchStatus_errorNodeId_get(swigCPtr, this);
    }
  
    public void setErrorMessage(String value) {
      MetashapeJNI.NetworkClient_BatchStatus_errorMessage_set(swigCPtr, this, value);
    }
  
    public String getErrorMessage() {
      return MetashapeJNI.NetworkClient_BatchStatus_errorMessage_get(swigCPtr, this);
    }
  
    public void setNextRevision(long value) {
      MetashapeJNI.NetworkClient_BatchStatus_nextRevision_set(swigCPtr, this, value);
    }
  
    public long getNextRevision() {
      return MetashapeJNI.NetworkClient_BatchStatus_nextRevision_get(swigCPtr, this);
    }
  
    public BatchStatus() {
      this(MetashapeJNI.new_NetworkClient_BatchStatus(), true);
    }
  
  }

  static public class BatchItem {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public BatchItem(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(BatchItem obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_BatchItem(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public static long[] cArrayUnwrap(NetworkClient.BatchItem[] arrayWrapper) {
      long[] cArray = new long[arrayWrapper.length];
      for (int i=0; i<arrayWrapper.length; i++)
        cArray[i] = NetworkClient.BatchItem.getCPtr(arrayWrapper[i]);
      return cArray;
    }
  
    public static NetworkClient.BatchItem[] cArrayWrap(long[] cArray, boolean cMemoryOwn) {
      NetworkClient.BatchItem[] arrayWrapper = new NetworkClient.BatchItem[cArray.length];
      for (int i=0; i<cArray.length; i++)
        arrayWrapper[i] = new NetworkClient.BatchItem(cArray[i], cMemoryOwn);
      return arrayWrapper;
    }
  
    public void setBatchId(long value) {
      MetashapeJNI.NetworkClient_BatchItem_batchId_set(swigCPtr, this, value);
    }
  
    public long getBatchId() {
      return MetashapeJNI.NetworkClient_BatchItem_batchId_get(swigCPtr, this);
    }
  
    public void setPath(String value) {
      MetashapeJNI.NetworkClient_BatchItem_path_set(swigCPtr, this, value);
    }
  
    public String getPath() {
      return MetashapeJNI.NetworkClient_BatchItem_path_get(swigCPtr, this);
    }
  
    public void setUuid(String value) {
      MetashapeJNI.NetworkClient_BatchItem_uuid_set(swigCPtr, this, value);
    }
  
    public String getUuid() {
      return MetashapeJNI.NetworkClient_BatchItem_uuid_get(swigCPtr, this);
    }
  
    public void setMeta(MetaData value) {
      MetashapeJNI.NetworkClient_BatchItem_meta_set(swigCPtr, this, MetaData.getCPtr(value), value);
    }
  
    public MetaData getMeta() {
      long cPtr = MetashapeJNI.NetworkClient_BatchItem_meta_get(swigCPtr, this);
      return (cPtr == 0) ? null : new MetaData(cPtr, false);
    }
  
    public void setStatus(NetworkClient.Status value) {
      MetashapeJNI.NetworkClient_BatchItem_status_set(swigCPtr, this, value.ordinal());
    }
  
    public NetworkClient.Status getStatus() {
      return NetworkClient.Status.class.getEnumConstants()[MetashapeJNI.NetworkClient_BatchItem_status_get(swigCPtr, this)];
    }
  
    public void setPriority(int value) {
      MetashapeJNI.NetworkClient_BatchItem_priority_set(swigCPtr, this, value);
    }
  
    public int getPriority() {
      return MetashapeJNI.NetworkClient_BatchItem_priority_get(swigCPtr, this);
    }
  
    public void setNodeLimit(int value) {
      MetashapeJNI.NetworkClient_BatchItem_nodeLimit_set(swigCPtr, this, value);
    }
  
    public int getNodeLimit() {
      return MetashapeJNI.NetworkClient_BatchItem_nodeLimit_get(swigCPtr, this);
    }
  
    public void setNodeVersion(String value) {
      MetashapeJNI.NetworkClient_BatchItem_nodeVersion_set(swigCPtr, this, value);
    }
  
    public String getNodeVersion() {
      return MetashapeJNI.NetworkClient_BatchItem_nodeVersion_get(swigCPtr, this);
    }
  
    public void setTimeStarted(long value) {
      MetashapeJNI.NetworkClient_BatchItem_timeStarted_set(swigCPtr, this, value);
    }
  
    public long getTimeStarted() {
      return MetashapeJNI.NetworkClient_BatchItem_timeStarted_get(swigCPtr, this);
    }
  
    public void setTimeFinished(long value) {
      MetashapeJNI.NetworkClient_BatchItem_timeFinished_set(swigCPtr, this, value);
    }
  
    public long getTimeFinished() {
      return MetashapeJNI.NetworkClient_BatchItem_timeFinished_get(swigCPtr, this);
    }
  
    public void setTask(NetworkClient.TaskStatus value) {
      MetashapeJNI.NetworkClient_BatchItem_task_set(swigCPtr, this, NetworkClient.TaskStatus.getCPtr(value), value);
    }
  
    public NetworkClient.TaskStatus getTask() {
      long cPtr = MetashapeJNI.NetworkClient_BatchItem_task_get(swigCPtr, this);
      return (cPtr == 0) ? null : new NetworkClient.TaskStatus(cPtr, false);
    }
  
    public BatchItem() {
      this(MetashapeJNI.new_NetworkClient_BatchItem(), true);
    }
  
  }

  static public class NodeStatus {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public NodeStatus(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(NodeStatus obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_NodeStatus(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public void setUuid(String value) {
      MetashapeJNI.NetworkClient_NodeStatus_uuid_set(swigCPtr, this, value);
    }
  
    public String getUuid() {
      return MetashapeJNI.NetworkClient_NodeStatus_uuid_get(swigCPtr, this);
    }
  
    public void setHostname(String value) {
      MetashapeJNI.NetworkClient_NodeStatus_hostname_set(swigCPtr, this, value);
    }
  
    public String getHostname() {
      return MetashapeJNI.NetworkClient_NodeStatus_hostname_get(swigCPtr, this);
    }
  
    public void setHostaddr(String value) {
      MetashapeJNI.NetworkClient_NodeStatus_hostaddr_set(swigCPtr, this, value);
    }
  
    public String getHostaddr() {
      return MetashapeJNI.NetworkClient_NodeStatus_hostaddr_get(swigCPtr, this);
    }
  
    public void setRamSize(double value) {
      MetashapeJNI.NetworkClient_NodeStatus_ramSize_set(swigCPtr, this, value);
    }
  
    public double getRamSize() {
      return MetashapeJNI.NetworkClient_NodeStatus_ramSize_get(swigCPtr, this);
    }
  
    public void setGpuMask(long value) {
      MetashapeJNI.NetworkClient_NodeStatus_gpuMask_set(swigCPtr, this, value);
    }
  
    public long getGpuMask() {
      return MetashapeJNI.NetworkClient_NodeStatus_gpuMask_get(swigCPtr, this);
    }
  
    public void setCpuEnable(boolean value) {
      MetashapeJNI.NetworkClient_NodeStatus_cpuEnable_set(swigCPtr, this, value);
    }
  
    public boolean getCpuEnable() {
      return MetashapeJNI.NetworkClient_NodeStatus_cpuEnable_get(swigCPtr, this);
    }
  
    public void setNextRevision(long value) {
      MetashapeJNI.NetworkClient_NodeStatus_nextRevision_set(swigCPtr, this, value);
    }
  
    public long getNextRevision() {
      return MetashapeJNI.NetworkClient_NodeStatus_nextRevision_get(swigCPtr, this);
    }
  
    public void setLog(NetworkClient.LogRecord[] value) {
      MetashapeJNI.NetworkClient_NodeStatus_log_set(swigCPtr, this, NetworkClient.LogRecord.cArrayUnwrap(value));
    }
  
    public NetworkClient.LogRecord[] getLog() { return NetworkClient.LogRecord.cArrayWrap(MetashapeJNI.NetworkClient_NodeStatus_log_get(swigCPtr, this), false); }
  
    public void setResourceUsage(NetworkClient.ResourceRecord[] value) {
      MetashapeJNI.NetworkClient_NodeStatus_resourceUsage_set(swigCPtr, this, NetworkClient.ResourceRecord.cArrayUnwrap(value));
    }
  
    public NetworkClient.ResourceRecord[] getResourceUsage() { return NetworkClient.ResourceRecord.cArrayWrap(MetashapeJNI.NetworkClient_NodeStatus_resourceUsage_get(swigCPtr, this), false); }
  
    public NodeStatus() {
      this(MetashapeJNI.new_NetworkClient_NodeStatus(), true);
    }
  
  }

  static public class NodeItem {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public NodeItem(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(NodeItem obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_NodeItem(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public static long[] cArrayUnwrap(NetworkClient.NodeItem[] arrayWrapper) {
      long[] cArray = new long[arrayWrapper.length];
      for (int i=0; i<arrayWrapper.length; i++)
        cArray[i] = NetworkClient.NodeItem.getCPtr(arrayWrapper[i]);
      return cArray;
    }
  
    public static NetworkClient.NodeItem[] cArrayWrap(long[] cArray, boolean cMemoryOwn) {
      NetworkClient.NodeItem[] arrayWrapper = new NetworkClient.NodeItem[cArray.length];
      for (int i=0; i<cArray.length; i++)
        arrayWrapper[i] = new NetworkClient.NodeItem(cArray[i], cMemoryOwn);
      return arrayWrapper;
    }
  
    public void setUuid(String value) {
      MetashapeJNI.NetworkClient_NodeItem_uuid_set(swigCPtr, this, value);
    }
  
    public String getUuid() {
      return MetashapeJNI.NetworkClient_NodeItem_uuid_get(swigCPtr, this);
    }
  
    public void setHostaddr(String value) {
      MetashapeJNI.NetworkClient_NodeItem_hostaddr_set(swigCPtr, this, value);
    }
  
    public String getHostaddr() {
      return MetashapeJNI.NetworkClient_NodeItem_hostaddr_get(swigCPtr, this);
    }
  
    public void setHostname(String value) {
      MetashapeJNI.NetworkClient_NodeItem_hostname_set(swigCPtr, this, value);
    }
  
    public String getHostname() {
      return MetashapeJNI.NetworkClient_NodeItem_hostname_get(swigCPtr, this);
    }
  
    public void setNode_id(long value) {
      MetashapeJNI.NetworkClient_NodeItem_node_id_set(swigCPtr, this, value);
    }
  
    public long getNode_id() {
      return MetashapeJNI.NetworkClient_NodeItem_node_id_get(swigCPtr, this);
    }
  
    public void setVersion(String value) {
      MetashapeJNI.NetworkClient_NodeItem_version_set(swigCPtr, this, value);
    }
  
    public String getVersion() {
      return MetashapeJNI.NetworkClient_NodeItem_version_get(swigCPtr, this);
    }
  
    public void setStatus(NetworkClient.Status value) {
      MetashapeJNI.NetworkClient_NodeItem_status_set(swigCPtr, this, value.ordinal());
    }
  
    public NetworkClient.Status getStatus() {
      return NetworkClient.Status.class.getEnumConstants()[MetashapeJNI.NetworkClient_NodeItem_status_get(swigCPtr, this)];
    }
  
    public void setPriority(int value) {
      MetashapeJNI.NetworkClient_NodeItem_priority_set(swigCPtr, this, value);
    }
  
    public int getPriority() {
      return MetashapeJNI.NetworkClient_NodeItem_priority_get(swigCPtr, this);
    }
  
    public void setTimeConnected(long value) {
      MetashapeJNI.NetworkClient_NodeItem_timeConnected_set(swigCPtr, this, value);
    }
  
    public long getTimeConnected() {
      return MetashapeJNI.NetworkClient_NodeItem_timeConnected_get(swigCPtr, this);
    }
  
    public void setTimeDisconnected(long value) {
      MetashapeJNI.NetworkClient_NodeItem_timeDisconnected_set(swigCPtr, this, value);
    }
  
    public long getTimeDisconnected() {
      return MetashapeJNI.NetworkClient_NodeItem_timeDisconnected_get(swigCPtr, this);
    }
  
    public void setCapability(int value) {
      MetashapeJNI.NetworkClient_NodeItem_capability_set(swigCPtr, this, value);
    }
  
    public int getCapability() {
      return MetashapeJNI.NetworkClient_NodeItem_capability_get(swigCPtr, this);
    }
  
    public void setRamSize(double value) {
      MetashapeJNI.NetworkClient_NodeItem_ramSize_set(swigCPtr, this, value);
    }
  
    public double getRamSize() {
      return MetashapeJNI.NetworkClient_NodeItem_ramSize_get(swigCPtr, this);
    }
  
    public void setGpuMask(long value) {
      MetashapeJNI.NetworkClient_NodeItem_gpuMask_set(swigCPtr, this, value);
    }
  
    public long getGpuMask() {
      return MetashapeJNI.NetworkClient_NodeItem_gpuMask_get(swigCPtr, this);
    }
  
    public void setCpuEnable(boolean value) {
      MetashapeJNI.NetworkClient_NodeItem_cpuEnable_set(swigCPtr, this, value);
    }
  
    public boolean getCpuEnable() {
      return MetashapeJNI.NetworkClient_NodeItem_cpuEnable_get(swigCPtr, this);
    }
  
    public void setBatchId(long value) {
      MetashapeJNI.NetworkClient_NodeItem_batchId_set(swigCPtr, this, value);
    }
  
    public long getBatchId() {
      return MetashapeJNI.NetworkClient_NodeItem_batchId_get(swigCPtr, this);
    }
  
    public void setProgress(double value) {
      MetashapeJNI.NetworkClient_NodeItem_progress_set(swigCPtr, this, value);
    }
  
    public double getProgress() {
      return MetashapeJNI.NetworkClient_NodeItem_progress_get(swigCPtr, this);
    }
  
    public void setTask(NetworkTask value) {
      MetashapeJNI.NetworkClient_NodeItem_task_set(swigCPtr, this, NetworkTask.getCPtr(value), value);
    }
  
    public NetworkTask getTask() {
      long cPtr = MetashapeJNI.NetworkClient_NodeItem_task_get(swigCPtr, this);
      return (cPtr == 0) ? null : new NetworkTask(cPtr, false);
    }
  
    public void setErrorCount(long value) {
      MetashapeJNI.NetworkClient_NodeItem_errorCount_set(swigCPtr, this, value);
    }
  
    public long getErrorCount() {
      return MetashapeJNI.NetworkClient_NodeItem_errorCount_get(swigCPtr, this);
    }
  
    public void setErrorTime(long value) {
      MetashapeJNI.NetworkClient_NodeItem_errorTime_set(swigCPtr, this, value);
    }
  
    public long getErrorTime() {
      return MetashapeJNI.NetworkClient_NodeItem_errorTime_get(swigCPtr, this);
    }
  
    public void setErrorBatchId(long value) {
      MetashapeJNI.NetworkClient_NodeItem_errorBatchId_set(swigCPtr, this, value);
    }
  
    public long getErrorBatchId() {
      return MetashapeJNI.NetworkClient_NodeItem_errorBatchId_get(swigCPtr, this);
    }
  
    public void setErrorMessage(String value) {
      MetashapeJNI.NetworkClient_NodeItem_errorMessage_set(swigCPtr, this, value);
    }
  
    public String getErrorMessage() {
      return MetashapeJNI.NetworkClient_NodeItem_errorMessage_get(swigCPtr, this);
    }
  
    public void setResourceUsage(NetworkClient.ResourceRecord value) {
      MetashapeJNI.NetworkClient_NodeItem_resourceUsage_set(swigCPtr, this, NetworkClient.ResourceRecord.getCPtr(value), value);
    }
  
    public NetworkClient.ResourceRecord getResourceUsage() {
      long cPtr = MetashapeJNI.NetworkClient_NodeItem_resourceUsage_get(swigCPtr, this);
      return (cPtr == 0) ? null : new NetworkClient.ResourceRecord(cPtr, false);
    }
  
    public NodeItem() {
      this(MetashapeJNI.new_NetworkClient_NodeItem(), true);
    }
  
  }

  static public class BatchList {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public BatchList(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(BatchList obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_BatchList(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public void setItems(NetworkClient.BatchItem[] value) {
      MetashapeJNI.NetworkClient_BatchList_items_set(swigCPtr, this, NetworkClient.BatchItem.cArrayUnwrap(value));
    }
  
    public NetworkClient.BatchItem[] getItems() { return NetworkClient.BatchItem.cArrayWrap(MetashapeJNI.NetworkClient_BatchList_items_get(swigCPtr, this), false); }
  
    public void setNextRevision(long value) {
      MetashapeJNI.NetworkClient_BatchList_nextRevision_set(swigCPtr, this, value);
    }
  
    public long getNextRevision() {
      return MetashapeJNI.NetworkClient_BatchList_nextRevision_get(swigCPtr, this);
    }
  
    public BatchList() {
      this(MetashapeJNI.new_NetworkClient_BatchList(), true);
    }
  
  }

  static public class NodeList {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    public NodeList(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    public static long getCPtr(NodeList obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_NetworkClient_NodeList(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    public void setItems(NetworkClient.NodeItem[] value) {
      MetashapeJNI.NetworkClient_NodeList_items_set(swigCPtr, this, NetworkClient.NodeItem.cArrayUnwrap(value));
    }
  
    public NetworkClient.NodeItem[] getItems() { return NetworkClient.NodeItem.cArrayWrap(MetashapeJNI.NetworkClient_NodeList_items_get(swigCPtr, this), false); }
  
    public void setNextRevision(long value) {
      MetashapeJNI.NetworkClient_NodeList_nextRevision_set(swigCPtr, this, value);
    }
  
    public long getNextRevision() {
      return MetashapeJNI.NetworkClient_NodeList_nextRevision_get(swigCPtr, this);
    }
  
    public NodeList() {
      this(MetashapeJNI.new_NetworkClient_NodeList(), true);
    }
  
  }

  /**
   * Connect to the server.<br>
   * @param host Server hostname.<br>
   * @param port Communication port.
   */
  public boolean connect(String host, int port) {
    return MetashapeJNI.NetworkClient_connect(swigCPtr, this, host, port);
  }

  /**
   * Disconnect from the server.
   */
  public void disconnect() {
    MetashapeJNI.NetworkClient_disconnect(swigCPtr, this);
  }

  /**
   * Create new batch.<br>
   * @param path Project path relative to root folder.<br>
   * @param tasks Project path relative to root folder.<br>
   * @param meta Batch metadata.<br>
   * @return Batch id.
   */
  public int createBatch(String path, NetworkTask[] tasks, MetaData meta) {
    return MetashapeJNI.NetworkClient_createBatch(swigCPtr, this, path, NetworkTask.cArrayUnwrap(tasks), MetaData.getCPtr(meta), meta);
  }

  /**
   * Get batch id based on project path.<br>
   * @param path Project path relative to root folder.<br>
   * @return Batch id.
   */
  public int findBatch(String path) {
    return MetashapeJNI.NetworkClient_findBatch(swigCPtr, this, path);
  }

  /**
   * Pause batch.<br>
   * @param batch_id Batch id.
   */
  public void pauseBatch(int batch_id) {
    MetashapeJNI.NetworkClient_pauseBatch(swigCPtr, this, batch_id);
  }

  /**
   * Resume batch.<br>
   * @param batch_id Batch id.
   */
  public void resumeBatch(int batch_id) {
    MetashapeJNI.NetworkClient_resumeBatch(swigCPtr, this, batch_id);
  }

  /**
   * Abort batch.<br>
   * @param batch_id Batch id.
   */
  public void abortBatch(int batch_id) {
    MetashapeJNI.NetworkClient_abortBatch(swigCPtr, this, batch_id);
  }

  /**
   * Set batch priority.<br>
   * @param batch_id Batch id.<br>
   * @param priority Batch priority (2 - Highest, 1 - High, 0 - Normal, -1 - Low, -2 - Lowest).
   */
  public void setBatchPriority(int batch_id, int priority) {
    MetashapeJNI.NetworkClient_setBatchPriority(swigCPtr, this, batch_id, priority);
  }

  /**
   * Set node limit of the batch.<br>
   * @param batch_id Batch id.<br>
   * @param node_limit Node limit of the batch (0 - unlimited).
   */
  public void setBatchNodeLimit(int batch_id, int node_limit) {
    MetashapeJNI.NetworkClient_setBatchNodeLimit(swigCPtr, this, batch_id, node_limit);
  }

  /**
   * Pause node.<br>
   * @param node_id Node id.
   */
  public void pauseNode(int node_id) {
    MetashapeJNI.NetworkClient_pauseNode(swigCPtr, this, node_id);
  }

  /**
   * Resume node.<br>
   * @param node_id Node id.
   */
  public void resumeNode(int node_id) {
    MetashapeJNI.NetworkClient_resumeNode(swigCPtr, this, node_id);
  }

  /**
   * Abort node.<br>
   * @param node_id Node id.
   */
  public void abortNode(int node_id) {
    MetashapeJNI.NetworkClient_abortNode(swigCPtr, this, node_id);
  }

  /**
   * Quit node.<br>
   * @param node_id Node id.
   */
  public void quitNode(int node_id) {
    MetashapeJNI.NetworkClient_quitNode(swigCPtr, this, node_id);
  }

  /**
   * Set node priority.<br>
   * @param node_id Node id.<br>
   * @param priority Node priority (2 - Highest, 1 - High, 0 - Normal, -1 - Low, -2 - Lowest).
   */
  public void setNodePriority(int node_id, int priority) {
    MetashapeJNI.NetworkClient_setNodePriority(swigCPtr, this, node_id, priority);
  }

  /**
   * Set node capability.<br>
   * @param node_id Node id.<br>
   * @param capability Node capability (1 - CPU, 2 - GPU, 3 - Any).
   */
  public void setNodeCapability(int node_id, int capability) {
    MetashapeJNI.NetworkClient_setNodeCapability(swigCPtr, this, node_id, capability);
  }

  /**
   * Set node GPU mask.<br>
   * @param node_id Node id.<br>
   * @param gpu_mask GPU device mask.
   */
  public void setNodeGPUMask(int node_id, long gpu_mask) {
    MetashapeJNI.NetworkClient_setNodeGPUMask(swigCPtr, this, node_id, gpu_mask);
  }

  /**
   * Set node CPU enable flag.<br>
   * @param node_id Node id.<br>
   * @param cpu_enable CPU enable flag.
   */
  public void setNodeCPUEnable(int node_id, boolean cpu_enable) {
    MetashapeJNI.NetworkClient_setNodeCPUEnable(swigCPtr, this, node_id, cpu_enable);
  }

  /**
   * Get server information.
   */
  public NetworkClient.ServerInfo getServerInfo() {
    return new NetworkClient.ServerInfo(MetashapeJNI.NetworkClient_getServerInfo(swigCPtr, this), true);
  }

  /**
   * Set master server.
   */
  public void setMasterServer(String hostname) {
    MetashapeJNI.NetworkClient_setMasterServer(swigCPtr, this, hostname);
  }

  /**
   * Get batch status.<br>
   * @param batch_id Batch id.<br>
   * @param revision First revision to get.<br>
   * @return Batch status.
   */
  public NetworkClient.BatchStatus getBatchStatus(int batch_id, long revision) {
    return new NetworkClient.BatchStatus(MetashapeJNI.NetworkClient_getBatchStatus(swigCPtr, this, batch_id, revision), true);
  }

  /**
   * Get node status.<br>
   * @param node_id Node id.<br>
   * @param revision First revision to get.<br>
   * @return Node status.
   */
  public NetworkClient.NodeStatus getNodeStatus(int node_id, long revision) {
    return new NetworkClient.NodeStatus(MetashapeJNI.NetworkClient_getNodeStatus(swigCPtr, this, node_id, revision), true);
  }

  /**
   * Get list of batches.<br>
   * @param revision First revision to get.<br>
   * @return List of batches.
   */
  public NetworkClient.BatchList getBatchList(long revision) {
    return new NetworkClient.BatchList(MetashapeJNI.NetworkClient_getBatchList(swigCPtr, this, revision), true);
  }

  /**
   * Get list of nodes.<br>
   * @param revision: First revision to get.<br>
   * @return List of nodes.
   */
  public NetworkClient.NodeList getNodeList(long revision) {
    return new NetworkClient.NodeList(MetashapeJNI.NetworkClient_getNodeList(swigCPtr, this, revision), true);
  }

  /**
   * Dump current state of batches.<br>
   * <br>
   * @return Batches data.
   */
  public String dumpBatches(int[] keys) {
    return MetashapeJNI.NetworkClient_dumpBatches(swigCPtr, this, keys);
  }

  /**
   * Load batches from dump.<br>
   * @param data Batches data.
   */
  public void loadBatches(String data) {
    MetashapeJNI.NetworkClient_loadBatches(swigCPtr, this, data);
  }

  public enum Status {
    StatusPending,
    StatusInProgress,
    StatusCompleted,
    StatusPaused,
    StatusAborted,
    StatusReady;
  }

}
