/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.CameraGroup;
import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.Image;
import com.agisoft.metashape.Matrix4x4d;
import com.agisoft.metashape.MetaData;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Photo;
import com.agisoft.metashape.Sensor;
import com.agisoft.metashape.Shutter;
import com.agisoft.metashape.Vector2d;
import com.agisoft.metashape.Vector3d;
import com.agisoft.metashape.Vignetting;

public class Camera {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public Camera(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(Camera camera) {
        return camera == null ? 0L : camera.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Camera(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public static long[] cArrayUnwrap(Camera[] cameraArray) {
        long[] lArray = new long[cameraArray.length];
        for (int i = 0; i < cameraArray.length; ++i) {
            lArray[i] = Camera.getCPtr(cameraArray[i]);
        }
        return lArray;
    }

    public static Camera[] cArrayWrap(long[] lArray, boolean bl) {
        Camera[] cameraArray = new Camera[lArray.length];
        for (int i = 0; i < lArray.length; ++i) {
            cameraArray[i] = new Camera(lArray[i], bl);
        }
        return cameraArray;
    }

    public Camera(Camera camera) {
        this(MetashapeJNI.new_Camera(Camera.getCPtr(camera), camera), true);
    }

    public int getKey() {
        return MetashapeJNI.Camera_getKey(this.swigCPtr, this);
    }

    public Chunk getChunk() {
        long l = MetashapeJNI.Camera_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Chunk(l, true);
    }

    public void setType(Type type) {
        MetashapeJNI.Camera_setType(this.swigCPtr, this, type.ordinal());
    }

    public Type getType() {
        return ((Type[])Type.class.getEnumConstants())[MetashapeJNI.Camera_getType(this.swigCPtr, this)];
    }

    public void setLabel(String string) {
        MetashapeJNI.Camera_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Camera_getLabel(this.swigCPtr, this);
    }

    public void setEnabled(boolean bl) {
        MetashapeJNI.Camera_setEnabled(this.swigCPtr, this, bl);
    }

    public boolean isEnabled() {
        return MetashapeJNI.Camera_isEnabled(this.swigCPtr, this);
    }

    public void setSelected(boolean bl) {
        MetashapeJNI.Camera_setSelected(this.swigCPtr, this, bl);
    }

    public boolean isSelected() {
        return MetashapeJNI.Camera_isSelected(this.swigCPtr, this);
    }

    public void setOrientation(int n) {
        MetashapeJNI.Camera_setOrientation(this.swigCPtr, this, n);
    }

    public int getOrientation() {
        return MetashapeJNI.Camera_getOrientation(this.swigCPtr, this);
    }

    public void setSensor(Sensor sensor) {
        MetashapeJNI.Camera_setSensor(this.swigCPtr, this, sensor == null ? 0L : Sensor.getCPtr(sensor), sensor);
    }

    public Sensor getSensor() {
        long l = MetashapeJNI.Camera_getSensor(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Sensor(l, true);
    }

    public void setMaster(Camera camera) {
        MetashapeJNI.Camera_setMaster(this.swigCPtr, this, camera == null ? 0L : Camera.getCPtr(camera), camera);
    }

    public Camera getMaster() {
        long l = MetashapeJNI.Camera_getMaster(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Camera(l, true);
    }

    public void setGroup(CameraGroup cameraGroup) {
        MetashapeJNI.Camera_setGroup(this.swigCPtr, this, cameraGroup == null ? 0L : CameraGroup.getCPtr(cameraGroup), cameraGroup);
    }

    public CameraGroup getGroup() {
        long l = MetashapeJNI.Camera_getGroup(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new CameraGroup(l, true);
    }

    public void setPhoto(Photo photo) {
        MetashapeJNI.Camera_setPhoto(this.swigCPtr, this, photo == null ? 0L : Photo.getCPtr(photo), photo);
    }

    public Photo getPhoto() {
        long l = MetashapeJNI.Camera_getPhoto(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Photo(l, true);
    }

    public void setTransform(Matrix4x4d matrix4x4d) {
        MetashapeJNI.Camera_setTransform(this.swigCPtr, this, matrix4x4d == null ? 0L : Matrix4x4d.getCPtr(matrix4x4d), matrix4x4d);
    }

    public Matrix4x4d getTransform() {
        long l = MetashapeJNI.Camera_getTransform(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Matrix4x4d(l, true);
    }

    public void setMask(Image image) {
        MetashapeJNI.Camera_setMask(this.swigCPtr, this, image == null ? 0L : Image.getCPtr(image), image);
    }

    public Image getMask() {
        long l = MetashapeJNI.Camera_getMask(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Image(l, true);
    }

    public void setThumbnail(Image image) {
        MetashapeJNI.Camera_setThumbnail(this.swigCPtr, this, image == null ? 0L : Image.getCPtr(image), image);
    }

    public Image getThumbnail() {
        long l = MetashapeJNI.Camera_getThumbnail(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Image(l, true);
    }

    public void setShutter(Shutter shutter) {
        MetashapeJNI.Camera_setShutter(this.swigCPtr, this, shutter == null ? 0L : Shutter.getCPtr(shutter), shutter);
    }

    public Shutter getShutter() {
        long l = MetashapeJNI.Camera_getShutter(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Shutter(l, true);
    }

    public void setVignetting(Vignetting[] vignettingArray) {
        MetashapeJNI.Camera_setVignetting(this.swigCPtr, this, Vignetting.cArrayUnwrap(vignettingArray));
    }

    public Vignetting[] getVignetting() {
        return Vignetting.cArrayWrap(MetashapeJNI.Camera_getVignetting(this.swigCPtr, this), true);
    }

    public Vector3d getCenter() {
        return new Vector3d(MetashapeJNI.Camera_getCenter(this.swigCPtr, this), true);
    }

    public Vector2d getError(Vector3d vector3d, Vector2d vector2d) {
        return new Vector2d(MetashapeJNI.Camera_getError(this.swigCPtr, this, Vector3d.getCPtr(vector3d), vector3d, Vector2d.getCPtr(vector2d), vector2d), true);
    }

    public Vector2d project(Vector3d vector3d) {
        return new Vector2d(MetashapeJNI.Camera_project(this.swigCPtr, this, Vector3d.getCPtr(vector3d), vector3d), true);
    }

    public Vector3d unproject(Vector2d vector2d) {
        return new Vector3d(MetashapeJNI.Camera_unproject__SWIG_0(this.swigCPtr, this, Vector2d.getCPtr(vector2d), vector2d), true);
    }

    public Vector3d unproject(Vector3d vector3d) {
        return new Vector3d(MetashapeJNI.Camera_unproject__SWIG_1(this.swigCPtr, this, Vector3d.getCPtr(vector3d), vector3d), true);
    }

    public Image loadImage() {
        long l = MetashapeJNI.Camera_loadImage(this.swigCPtr, this);
        if (l == 0L) {
            return null;
        }
        return new Image(l, true);
    }

    public Reference getReference() {
        return new Reference(MetashapeJNI.Camera_getReference(this.swigCPtr, this), true);
    }

    public void setReference(Reference reference) {
        MetashapeJNI.Camera_setReference(this.swigCPtr, this, Reference.getCPtr(reference), reference);
    }

    public void setMeta(MetaData metaData) {
        MetashapeJNI.Camera_setMeta(this.swigCPtr, this, MetaData.getCPtr(metaData), metaData);
    }

    public MetaData getMeta() {
        return new MetaData(MetashapeJNI.Camera_getMeta(this.swigCPtr, this), true);
    }

    public static enum Type {
        TypeRegular,
        TypeKeyframe;

    }

    public static class Reference {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public Reference(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(Reference reference) {
            return reference == null ? 0L : reference.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_Camera_Reference(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public Reference(Reference reference) {
            this(MetashapeJNI.new_Camera_Reference(Reference.getCPtr(reference), reference), true);
        }

        public void setLocationEnabled(boolean bl) {
            MetashapeJNI.Camera_Reference_setLocationEnabled(this.swigCPtr, this, bl);
        }

        public boolean isLocationEnabled() {
            return MetashapeJNI.Camera_Reference_isLocationEnabled(this.swigCPtr, this);
        }

        public void setRotationEnabled(boolean bl) {
            MetashapeJNI.Camera_Reference_setRotationEnabled(this.swigCPtr, this, bl);
        }

        public boolean isRotationEnabled() {
            return MetashapeJNI.Camera_Reference_isRotationEnabled(this.swigCPtr, this);
        }

        public void setLocation(Vector3d vector3d) {
            MetashapeJNI.Camera_Reference_setLocation(this.swigCPtr, this, vector3d == null ? 0L : Vector3d.getCPtr(vector3d), vector3d);
        }

        public Vector3d getLocation() {
            long l = MetashapeJNI.Camera_Reference_getLocation(this.swigCPtr, this);
            if (l == 0L) {
                return null;
            }
            return new Vector3d(l, true);
        }

        public void setRotation(Vector3d vector3d) {
            MetashapeJNI.Camera_Reference_setRotation(this.swigCPtr, this, vector3d == null ? 0L : Vector3d.getCPtr(vector3d), vector3d);
        }

        public Vector3d getRotation() {
            long l = MetashapeJNI.Camera_Reference_getRotation(this.swigCPtr, this);
            if (l == 0L) {
                return null;
            }
            return new Vector3d(l, true);
        }

        public void setLocationAccuracy(Vector3d vector3d) {
            MetashapeJNI.Camera_Reference_setLocationAccuracy(this.swigCPtr, this, vector3d == null ? 0L : Vector3d.getCPtr(vector3d), vector3d);
        }

        public Vector3d getLocationAccuracy() {
            long l = MetashapeJNI.Camera_Reference_getLocationAccuracy(this.swigCPtr, this);
            if (l == 0L) {
                return null;
            }
            return new Vector3d(l, true);
        }

        public void setRotationAccuracy(Vector3d vector3d) {
            MetashapeJNI.Camera_Reference_setRotationAccuracy(this.swigCPtr, this, vector3d == null ? 0L : Vector3d.getCPtr(vector3d), vector3d);
        }

        public Vector3d getRotationAccuracy() {
            long l = MetashapeJNI.Camera_Reference_getRotationAccuracy(this.swigCPtr, this);
            if (l == 0L) {
                return null;
            }
            return new Vector3d(l, true);
        }
    }
}

