/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

/**
 * Dense point cloud.
 */
public class DenseCloud {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  public DenseCloud(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  public static long getCPtr(DenseCloud obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_DenseCloud(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public static long[] cArrayUnwrap(DenseCloud[] arrayWrapper) {
    long[] cArray = new long[arrayWrapper.length];
    for (int i=0; i<arrayWrapper.length; i++)
      cArray[i] = DenseCloud.getCPtr(arrayWrapper[i]);
    return cArray;
  }

  public static DenseCloud[] cArrayWrap(long[] cArray, boolean cMemoryOwn) {
    DenseCloud[] arrayWrapper = new DenseCloud[cArray.length];
    for (int i=0; i<cArray.length; i++)
      arrayWrapper[i] = new DenseCloud(cArray[i], cMemoryOwn);
    return arrayWrapper;
  }

  public DenseCloud() {
    this(MetashapeJNI.new_DenseCloud__SWIG_0(), true);
  }

  public DenseCloud(DenseCloud dense_cloud) {
    this(MetashapeJNI.new_DenseCloud__SWIG_1(DenseCloud.getCPtr(dense_cloud), dense_cloud), true);
  }

  /**
   *  Dense cloud identifier.
   */
  public int getKey() {
    return MetashapeJNI.DenseCloud_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Chunk getChunk() {
    long ptr = MetashapeJNI.DenseCloud_getChunk(swigCPtr, this);
    if (ptr == 0)
        return null;
    return new Chunk(ptr, true);
  }

  /**
   *  Dense cloud label.
   */
  public void setLabel(String label) {
    MetashapeJNI.DenseCloud_setLabel(swigCPtr, this, label);
  }

  /**
   *  Dense cloud label.
   */
  public String getLabel() {
    return MetashapeJNI.DenseCloud_getLabel(swigCPtr, this);
  }

  /**
   *  Path to dense cloud file.
   */
  public String getPath() {
    return MetashapeJNI.DenseCloud_getPath(swigCPtr, this);
  }

  /**
   *  Dense cloud meta data.
   */
  public void setMeta(MetaData meta) {
    MetashapeJNI.DenseCloud_setMeta(swigCPtr, this, MetaData.getCPtr(meta), meta);
  }

  /**
   *  Dense cloud meta data.
   */
  public MetaData getMeta() {
    return new MetaData(MetashapeJNI.DenseCloud_getMeta(swigCPtr, this), true);
  }

  /**
   *  4x4 dense cloud transformation matrix.
   */
  public void setTransform(Matrix4x4d transform) {
    MetashapeJNI.DenseCloud_setTransform(swigCPtr, this, Matrix4x4d.getCPtr(transform), transform);
  }

  /**
   *  4x4 dense cloud transformation matrix.
   */
  public Matrix4x4d getTransform() {
    return new Matrix4x4d(MetashapeJNI.DenseCloud_getTransform(swigCPtr, this), true);
  }

  /**
   *  Reference coordinate system, may be null.
   */
  public void setCoordinateSystem(CoordinateSystem crs) {
    MetashapeJNI.DenseCloud_setCoordinateSystem(swigCPtr, this, crs == null ? 0 : CoordinateSystem.getCPtr(crs), crs);
  }

  /**
   *  Reference coordinate system, may be null.
   */
  public CoordinateSystem getCoordinateSystem() {
    long ptr = MetashapeJNI.DenseCloud_getCoordinateSystem(swigCPtr, this);
    if (ptr == 0)
        return null;
    return new CoordinateSystem(ptr, true);
  }

  /**
   * Returns ray intersection with the dense point cloud.<br>
   * @param origin Ray origin.<br>
   * @param target Point on the ray.<br>
   * @return Coordinates of the intersection point, may be null.
   */
  public Vector3d pickPoint(Vector3d origin, Vector3d target) {
    long ptr = MetashapeJNI.DenseCloud_pickPoint(swigCPtr, this, Vector3d.getCPtr(origin), origin, Vector3d.getCPtr(target), target);
    if (ptr == 0)
        return null;
    return new Vector3d(ptr, true);
  }

  /**
   * Permanently removes deleted points from dense cloud.<br>
   * @param progress Progress callback.
   */
  public void compactPoints(Progress progress) {
    MetashapeJNI.DenseCloud_compactPoints(swigCPtr, this, progress);
  }

  /**
   * Remove points.<br>
   * @param point_classes Classes of points to be removed.<br>
   * @param progress Progress callback.
   */
  public void removePoints(int[] point_classes, Progress progress) {
    MetashapeJNI.DenseCloud_removePoints(swigCPtr, this, point_classes, progress);
  }

  /**
   * Restore deleted points.<br>
   * @param point_classes Classes of points to be restored.<br>
   * @param progress Progress callback.
   */
  public void restorePoints(int[] point_classes, Progress progress) {
    MetashapeJNI.DenseCloud_restorePoints(swigCPtr, this, point_classes, progress);
  }

  /**
   * Assign class to points.<br>
   * @param target Target class.<br>
   * @param source Classes of points to be replaced.<br>
   * @param progress Progress callback.
   */
  public void assignClass(int target, int[] source, Progress progress) {
    MetashapeJNI.DenseCloud_assignClass(swigCPtr, this, target, source, progress);
  }

  /**
   * Generate dense cloud preview image.<br>
   * @param width Preview image width.<br>
   * @param height Preview image height.<br>
   * @param transform 4x4 viewpoint transformation matrix.<br>
   * @param point_size Point size.<br>
   * @return Preview image.
   */
  public Image renderPreview(long width, long height, Matrix4x4d transform, int point_size, Progress progress) {
    return new Image(MetashapeJNI.DenseCloud_renderPreview(swigCPtr, this, width, height, Matrix4x4d.getCPtr(transform), transform, point_size, progress), true);
  }

}
