/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.MetaData;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.NetworkTask;

public class NetworkClient {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    public NetworkClient(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    public static long getCPtr(NetworkClient networkClient) {
        return networkClient == null ? 0L : networkClient.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_NetworkClient(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public NetworkClient() {
        this(MetashapeJNI.new_NetworkClient(), true);
    }

    public boolean connect(String string, int n) {
        return MetashapeJNI.NetworkClient_connect(this.swigCPtr, this, string, n);
    }

    public void disconnect() {
        MetashapeJNI.NetworkClient_disconnect(this.swigCPtr, this);
    }

    public int createBatch(String string, NetworkTask[] networkTaskArray, MetaData metaData) {
        return MetashapeJNI.NetworkClient_createBatch(this.swigCPtr, this, string, NetworkTask.cArrayUnwrap(networkTaskArray), MetaData.getCPtr(metaData), metaData);
    }

    public int findBatch(String string) {
        return MetashapeJNI.NetworkClient_findBatch(this.swigCPtr, this, string);
    }

    public void pauseBatch(int n) {
        MetashapeJNI.NetworkClient_pauseBatch(this.swigCPtr, this, n);
    }

    public void resumeBatch(int n) {
        MetashapeJNI.NetworkClient_resumeBatch(this.swigCPtr, this, n);
    }

    public void abortBatch(int n) {
        MetashapeJNI.NetworkClient_abortBatch(this.swigCPtr, this, n);
    }

    public void setBatchPriority(int n, int n2) {
        MetashapeJNI.NetworkClient_setBatchPriority(this.swigCPtr, this, n, n2);
    }

    public void setBatchNodeLimit(int n, int n2) {
        MetashapeJNI.NetworkClient_setBatchNodeLimit(this.swigCPtr, this, n, n2);
    }

    public void pauseNode(int n) {
        MetashapeJNI.NetworkClient_pauseNode(this.swigCPtr, this, n);
    }

    public void resumeNode(int n) {
        MetashapeJNI.NetworkClient_resumeNode(this.swigCPtr, this, n);
    }

    public void abortNode(int n) {
        MetashapeJNI.NetworkClient_abortNode(this.swigCPtr, this, n);
    }

    public void quitNode(int n) {
        MetashapeJNI.NetworkClient_quitNode(this.swigCPtr, this, n);
    }

    public void setNodePriority(int n, int n2) {
        MetashapeJNI.NetworkClient_setNodePriority(this.swigCPtr, this, n, n2);
    }

    public void setNodeCapability(int n, int n2) {
        MetashapeJNI.NetworkClient_setNodeCapability(this.swigCPtr, this, n, n2);
    }

    public void setNodeGPUMask(int n, long l) {
        MetashapeJNI.NetworkClient_setNodeGPUMask(this.swigCPtr, this, n, l);
    }

    public void setNodeCPUEnable(int n, boolean bl) {
        MetashapeJNI.NetworkClient_setNodeCPUEnable(this.swigCPtr, this, n, bl);
    }

    public ServerInfo getServerInfo() {
        return new ServerInfo(MetashapeJNI.NetworkClient_getServerInfo(this.swigCPtr, this), true);
    }

    public void setMasterServer(String string) {
        MetashapeJNI.NetworkClient_setMasterServer(this.swigCPtr, this, string);
    }

    public BatchStatus getBatchStatus(int n, long l) {
        return new BatchStatus(MetashapeJNI.NetworkClient_getBatchStatus(this.swigCPtr, this, n, l), true);
    }

    public NodeStatus getNodeStatus(int n, long l) {
        return new NodeStatus(MetashapeJNI.NetworkClient_getNodeStatus(this.swigCPtr, this, n, l), true);
    }

    public BatchList getBatchList(long l) {
        return new BatchList(MetashapeJNI.NetworkClient_getBatchList(this.swigCPtr, this, l), true);
    }

    public NodeList getNodeList(long l) {
        return new NodeList(MetashapeJNI.NetworkClient_getNodeList(this.swigCPtr, this, l), true);
    }

    public String dumpBatches(int[] nArray) {
        return MetashapeJNI.NetworkClient_dumpBatches(this.swigCPtr, this, nArray);
    }

    public void loadBatches(String string) {
        MetashapeJNI.NetworkClient_loadBatches(this.swigCPtr, this, string);
    }

    public static enum Status {
        StatusPending,
        StatusInProgress,
        StatusCompleted,
        StatusPaused,
        StatusAborted,
        StatusReady,
        StatusOffline;

    }

    public static class NodeList {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public NodeList(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(NodeList nodeList) {
            return nodeList == null ? 0L : nodeList.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_NodeList(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public void update(NodeList nodeList) {
            MetashapeJNI.NetworkClient_NodeList_update(this.swigCPtr, this, NodeList.getCPtr(nodeList), nodeList);
        }

        public void setItems(NodeItem[] nodeItemArray) {
            MetashapeJNI.NetworkClient_NodeList_items_set(this.swigCPtr, this, NodeItem.cArrayUnwrap(nodeItemArray));
        }

        public NodeItem[] getItems() {
            return NodeItem.cArrayWrap(MetashapeJNI.NetworkClient_NodeList_items_get(this.swigCPtr, this), false);
        }

        public void setNextRevision(long l) {
            MetashapeJNI.NetworkClient_NodeList_nextRevision_set(this.swigCPtr, this, l);
        }

        public long getNextRevision() {
            return MetashapeJNI.NetworkClient_NodeList_nextRevision_get(this.swigCPtr, this);
        }

        public NodeList() {
            this(MetashapeJNI.new_NetworkClient_NodeList(), true);
        }
    }

    public static class BatchList {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public BatchList(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(BatchList batchList) {
            return batchList == null ? 0L : batchList.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_BatchList(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public void update(BatchList batchList) {
            MetashapeJNI.NetworkClient_BatchList_update(this.swigCPtr, this, BatchList.getCPtr(batchList), batchList);
        }

        public void setItems(BatchItem[] batchItemArray) {
            MetashapeJNI.NetworkClient_BatchList_items_set(this.swigCPtr, this, BatchItem.cArrayUnwrap(batchItemArray));
        }

        public BatchItem[] getItems() {
            return BatchItem.cArrayWrap(MetashapeJNI.NetworkClient_BatchList_items_get(this.swigCPtr, this), false);
        }

        public void setNextRevision(long l) {
            MetashapeJNI.NetworkClient_BatchList_nextRevision_set(this.swigCPtr, this, l);
        }

        public long getNextRevision() {
            return MetashapeJNI.NetworkClient_BatchList_nextRevision_get(this.swigCPtr, this);
        }

        public BatchList() {
            this(MetashapeJNI.new_NetworkClient_BatchList(), true);
        }
    }

    public static class NodeItem {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public NodeItem(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(NodeItem nodeItem) {
            return nodeItem == null ? 0L : nodeItem.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_NodeItem(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public static long[] cArrayUnwrap(NodeItem[] nodeItemArray) {
            long[] lArray = new long[nodeItemArray.length];
            for (int i = 0; i < nodeItemArray.length; ++i) {
                lArray[i] = NodeItem.getCPtr(nodeItemArray[i]);
            }
            return lArray;
        }

        public static NodeItem[] cArrayWrap(long[] lArray, boolean bl) {
            NodeItem[] nodeItemArray = new NodeItem[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                nodeItemArray[i] = new NodeItem(lArray[i], bl);
            }
            return nodeItemArray;
        }

        public void setUuid(String string) {
            MetashapeJNI.NetworkClient_NodeItem_uuid_set(this.swigCPtr, this, string);
        }

        public String getUuid() {
            return MetashapeJNI.NetworkClient_NodeItem_uuid_get(this.swigCPtr, this);
        }

        public void setHostaddr(String string) {
            MetashapeJNI.NetworkClient_NodeItem_hostaddr_set(this.swigCPtr, this, string);
        }

        public String getHostaddr() {
            return MetashapeJNI.NetworkClient_NodeItem_hostaddr_get(this.swigCPtr, this);
        }

        public void setHostname(String string) {
            MetashapeJNI.NetworkClient_NodeItem_hostname_set(this.swigCPtr, this, string);
        }

        public String getHostname() {
            return MetashapeJNI.NetworkClient_NodeItem_hostname_get(this.swigCPtr, this);
        }

        public void setNodeId(long l) {
            MetashapeJNI.NetworkClient_NodeItem_nodeId_set(this.swigCPtr, this, l);
        }

        public long getNodeId() {
            return MetashapeJNI.NetworkClient_NodeItem_nodeId_get(this.swigCPtr, this);
        }

        public void setVersion(String string) {
            MetashapeJNI.NetworkClient_NodeItem_version_set(this.swigCPtr, this, string);
        }

        public String getVersion() {
            return MetashapeJNI.NetworkClient_NodeItem_version_get(this.swigCPtr, this);
        }

        public void setStatus(Status status) {
            MetashapeJNI.NetworkClient_NodeItem_status_set(this.swigCPtr, this, status.ordinal());
        }

        public Status getStatus() {
            return ((Status[])Status.class.getEnumConstants())[MetashapeJNI.NetworkClient_NodeItem_status_get(this.swigCPtr, this)];
        }

        public void setPaused(boolean bl) {
            MetashapeJNI.NetworkClient_NodeItem_paused_set(this.swigCPtr, this, bl);
        }

        public boolean getPaused() {
            return MetashapeJNI.NetworkClient_NodeItem_paused_get(this.swigCPtr, this);
        }

        public void setPriority(int n) {
            MetashapeJNI.NetworkClient_NodeItem_priority_set(this.swigCPtr, this, n);
        }

        public int getPriority() {
            return MetashapeJNI.NetworkClient_NodeItem_priority_get(this.swigCPtr, this);
        }

        public void setTimeConnected(long l) {
            MetashapeJNI.NetworkClient_NodeItem_timeConnected_set(this.swigCPtr, this, l);
        }

        public long getTimeConnected() {
            return MetashapeJNI.NetworkClient_NodeItem_timeConnected_get(this.swigCPtr, this);
        }

        public void setTimeDisconnected(long l) {
            MetashapeJNI.NetworkClient_NodeItem_timeDisconnected_set(this.swigCPtr, this, l);
        }

        public long getTimeDisconnected() {
            return MetashapeJNI.NetworkClient_NodeItem_timeDisconnected_get(this.swigCPtr, this);
        }

        public void setCapability(int n) {
            MetashapeJNI.NetworkClient_NodeItem_capability_set(this.swigCPtr, this, n);
        }

        public int getCapability() {
            return MetashapeJNI.NetworkClient_NodeItem_capability_get(this.swigCPtr, this);
        }

        public void setRamSize(double d) {
            MetashapeJNI.NetworkClient_NodeItem_ramSize_set(this.swigCPtr, this, d);
        }

        public double getRamSize() {
            return MetashapeJNI.NetworkClient_NodeItem_ramSize_get(this.swigCPtr, this);
        }

        public void setGpuMask(long l) {
            MetashapeJNI.NetworkClient_NodeItem_gpuMask_set(this.swigCPtr, this, l);
        }

        public long getGpuMask() {
            return MetashapeJNI.NetworkClient_NodeItem_gpuMask_get(this.swigCPtr, this);
        }

        public void setCpuEnable(boolean bl) {
            MetashapeJNI.NetworkClient_NodeItem_cpuEnable_set(this.swigCPtr, this, bl);
        }

        public boolean getCpuEnable() {
            return MetashapeJNI.NetworkClient_NodeItem_cpuEnable_get(this.swigCPtr, this);
        }

        public void setBatchId(long l) {
            MetashapeJNI.NetworkClient_NodeItem_batchId_set(this.swigCPtr, this, l);
        }

        public long getBatchId() {
            return MetashapeJNI.NetworkClient_NodeItem_batchId_get(this.swigCPtr, this);
        }

        public void setProgress(double d) {
            MetashapeJNI.NetworkClient_NodeItem_progress_set(this.swigCPtr, this, d);
        }

        public double getProgress() {
            return MetashapeJNI.NetworkClient_NodeItem_progress_get(this.swigCPtr, this);
        }

        public void setTask(NetworkTask networkTask) {
            MetashapeJNI.NetworkClient_NodeItem_task_set(this.swigCPtr, this, NetworkTask.getCPtr(networkTask), networkTask);
        }

        public NetworkTask getTask() {
            long l = MetashapeJNI.NetworkClient_NodeItem_task_get(this.swigCPtr, this);
            return l == 0L ? null : new NetworkTask(l, false);
        }

        public void setErrorCount(long l) {
            MetashapeJNI.NetworkClient_NodeItem_errorCount_set(this.swigCPtr, this, l);
        }

        public long getErrorCount() {
            return MetashapeJNI.NetworkClient_NodeItem_errorCount_get(this.swigCPtr, this);
        }

        public void setErrorTime(long l) {
            MetashapeJNI.NetworkClient_NodeItem_errorTime_set(this.swigCPtr, this, l);
        }

        public long getErrorTime() {
            return MetashapeJNI.NetworkClient_NodeItem_errorTime_get(this.swigCPtr, this);
        }

        public void setErrorBatchId(long l) {
            MetashapeJNI.NetworkClient_NodeItem_errorBatchId_set(this.swigCPtr, this, l);
        }

        public long getErrorBatchId() {
            return MetashapeJNI.NetworkClient_NodeItem_errorBatchId_get(this.swigCPtr, this);
        }

        public void setErrorMessage(String string) {
            MetashapeJNI.NetworkClient_NodeItem_errorMessage_set(this.swigCPtr, this, string);
        }

        public String getErrorMessage() {
            return MetashapeJNI.NetworkClient_NodeItem_errorMessage_get(this.swigCPtr, this);
        }

        public void setResourceUsage(ResourceRecord resourceRecord) {
            MetashapeJNI.NetworkClient_NodeItem_resourceUsage_set(this.swigCPtr, this, ResourceRecord.getCPtr(resourceRecord), resourceRecord);
        }

        public ResourceRecord getResourceUsage() {
            long l = MetashapeJNI.NetworkClient_NodeItem_resourceUsage_get(this.swigCPtr, this);
            return l == 0L ? null : new ResourceRecord(l, false);
        }

        public NodeItem() {
            this(MetashapeJNI.new_NetworkClient_NodeItem(), true);
        }
    }

    public static class NodeStatus {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public NodeStatus(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(NodeStatus nodeStatus) {
            return nodeStatus == null ? 0L : nodeStatus.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_NodeStatus(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public void setUuid(String string) {
            MetashapeJNI.NetworkClient_NodeStatus_uuid_set(this.swigCPtr, this, string);
        }

        public String getUuid() {
            return MetashapeJNI.NetworkClient_NodeStatus_uuid_get(this.swigCPtr, this);
        }

        public void setHostname(String string) {
            MetashapeJNI.NetworkClient_NodeStatus_hostname_set(this.swigCPtr, this, string);
        }

        public String getHostname() {
            return MetashapeJNI.NetworkClient_NodeStatus_hostname_get(this.swigCPtr, this);
        }

        public void setHostaddr(String string) {
            MetashapeJNI.NetworkClient_NodeStatus_hostaddr_set(this.swigCPtr, this, string);
        }

        public String getHostaddr() {
            return MetashapeJNI.NetworkClient_NodeStatus_hostaddr_get(this.swigCPtr, this);
        }

        public void setRamSize(double d) {
            MetashapeJNI.NetworkClient_NodeStatus_ramSize_set(this.swigCPtr, this, d);
        }

        public double getRamSize() {
            return MetashapeJNI.NetworkClient_NodeStatus_ramSize_get(this.swigCPtr, this);
        }

        public void setGpuMask(long l) {
            MetashapeJNI.NetworkClient_NodeStatus_gpuMask_set(this.swigCPtr, this, l);
        }

        public long getGpuMask() {
            return MetashapeJNI.NetworkClient_NodeStatus_gpuMask_get(this.swigCPtr, this);
        }

        public void setCpuEnable(boolean bl) {
            MetashapeJNI.NetworkClient_NodeStatus_cpuEnable_set(this.swigCPtr, this, bl);
        }

        public boolean getCpuEnable() {
            return MetashapeJNI.NetworkClient_NodeStatus_cpuEnable_get(this.swigCPtr, this);
        }

        public void setNextRevision(long l) {
            MetashapeJNI.NetworkClient_NodeStatus_nextRevision_set(this.swigCPtr, this, l);
        }

        public long getNextRevision() {
            return MetashapeJNI.NetworkClient_NodeStatus_nextRevision_get(this.swigCPtr, this);
        }

        public void setLog(LogRecord[] logRecordArray) {
            MetashapeJNI.NetworkClient_NodeStatus_log_set(this.swigCPtr, this, LogRecord.cArrayUnwrap(logRecordArray));
        }

        public LogRecord[] getLog() {
            return LogRecord.cArrayWrap(MetashapeJNI.NetworkClient_NodeStatus_log_get(this.swigCPtr, this), false);
        }

        public void setResourceUsage(ResourceRecord[] resourceRecordArray) {
            MetashapeJNI.NetworkClient_NodeStatus_resourceUsage_set(this.swigCPtr, this, ResourceRecord.cArrayUnwrap(resourceRecordArray));
        }

        public ResourceRecord[] getResourceUsage() {
            return ResourceRecord.cArrayWrap(MetashapeJNI.NetworkClient_NodeStatus_resourceUsage_get(this.swigCPtr, this), false);
        }

        public NodeStatus() {
            this(MetashapeJNI.new_NetworkClient_NodeStatus(), true);
        }
    }

    public static class BatchItem {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public BatchItem(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(BatchItem batchItem) {
            return batchItem == null ? 0L : batchItem.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_BatchItem(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public static long[] cArrayUnwrap(BatchItem[] batchItemArray) {
            long[] lArray = new long[batchItemArray.length];
            for (int i = 0; i < batchItemArray.length; ++i) {
                lArray[i] = BatchItem.getCPtr(batchItemArray[i]);
            }
            return lArray;
        }

        public static BatchItem[] cArrayWrap(long[] lArray, boolean bl) {
            BatchItem[] batchItemArray = new BatchItem[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                batchItemArray[i] = new BatchItem(lArray[i], bl);
            }
            return batchItemArray;
        }

        public void setBatchId(long l) {
            MetashapeJNI.NetworkClient_BatchItem_batchId_set(this.swigCPtr, this, l);
        }

        public long getBatchId() {
            return MetashapeJNI.NetworkClient_BatchItem_batchId_get(this.swigCPtr, this);
        }

        public void setPath(String string) {
            MetashapeJNI.NetworkClient_BatchItem_path_set(this.swigCPtr, this, string);
        }

        public String getPath() {
            return MetashapeJNI.NetworkClient_BatchItem_path_get(this.swigCPtr, this);
        }

        public void setUuid(String string) {
            MetashapeJNI.NetworkClient_BatchItem_uuid_set(this.swigCPtr, this, string);
        }

        public String getUuid() {
            return MetashapeJNI.NetworkClient_BatchItem_uuid_get(this.swigCPtr, this);
        }

        public void setMeta(MetaData metaData) {
            MetashapeJNI.NetworkClient_BatchItem_meta_set(this.swigCPtr, this, MetaData.getCPtr(metaData), metaData);
        }

        public MetaData getMeta() {
            long l = MetashapeJNI.NetworkClient_BatchItem_meta_get(this.swigCPtr, this);
            return l == 0L ? null : new MetaData(l, false);
        }

        public void setStatus(Status status) {
            MetashapeJNI.NetworkClient_BatchItem_status_set(this.swigCPtr, this, status.ordinal());
        }

        public Status getStatus() {
            return ((Status[])Status.class.getEnumConstants())[MetashapeJNI.NetworkClient_BatchItem_status_get(this.swigCPtr, this)];
        }

        public void setPaused(boolean bl) {
            MetashapeJNI.NetworkClient_BatchItem_paused_set(this.swigCPtr, this, bl);
        }

        public boolean getPaused() {
            return MetashapeJNI.NetworkClient_BatchItem_paused_get(this.swigCPtr, this);
        }

        public void setPriority(int n) {
            MetashapeJNI.NetworkClient_BatchItem_priority_set(this.swigCPtr, this, n);
        }

        public int getPriority() {
            return MetashapeJNI.NetworkClient_BatchItem_priority_get(this.swigCPtr, this);
        }

        public void setNodeLimit(int n) {
            MetashapeJNI.NetworkClient_BatchItem_nodeLimit_set(this.swigCPtr, this, n);
        }

        public int getNodeLimit() {
            return MetashapeJNI.NetworkClient_BatchItem_nodeLimit_get(this.swigCPtr, this);
        }

        public void setNodeVersion(String string) {
            MetashapeJNI.NetworkClient_BatchItem_nodeVersion_set(this.swigCPtr, this, string);
        }

        public String getNodeVersion() {
            return MetashapeJNI.NetworkClient_BatchItem_nodeVersion_get(this.swigCPtr, this);
        }

        public void setTimeStarted(long l) {
            MetashapeJNI.NetworkClient_BatchItem_timeStarted_set(this.swigCPtr, this, l);
        }

        public long getTimeStarted() {
            return MetashapeJNI.NetworkClient_BatchItem_timeStarted_get(this.swigCPtr, this);
        }

        public void setTimeFinished(long l) {
            MetashapeJNI.NetworkClient_BatchItem_timeFinished_set(this.swigCPtr, this, l);
        }

        public long getTimeFinished() {
            return MetashapeJNI.NetworkClient_BatchItem_timeFinished_get(this.swigCPtr, this);
        }

        public void setTask(TaskStatus taskStatus) {
            MetashapeJNI.NetworkClient_BatchItem_task_set(this.swigCPtr, this, TaskStatus.getCPtr(taskStatus), taskStatus);
        }

        public TaskStatus getTask() {
            long l = MetashapeJNI.NetworkClient_BatchItem_task_get(this.swigCPtr, this);
            return l == 0L ? null : new TaskStatus(l, false);
        }

        public BatchItem() {
            this(MetashapeJNI.new_NetworkClient_BatchItem(), true);
        }
    }

    public static class BatchStatus {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public BatchStatus(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(BatchStatus batchStatus) {
            return batchStatus == null ? 0L : batchStatus.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_BatchStatus(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public void update(BatchStatus batchStatus) {
            MetashapeJNI.NetworkClient_BatchStatus_update(this.swigCPtr, this, BatchStatus.getCPtr(batchStatus), batchStatus);
        }

        public void setPath(String string) {
            MetashapeJNI.NetworkClient_BatchStatus_path_set(this.swigCPtr, this, string);
        }

        public String getPath() {
            return MetashapeJNI.NetworkClient_BatchStatus_path_get(this.swigCPtr, this);
        }

        public void setUuid(String string) {
            MetashapeJNI.NetworkClient_BatchStatus_uuid_set(this.swigCPtr, this, string);
        }

        public String getUuid() {
            return MetashapeJNI.NetworkClient_BatchStatus_uuid_get(this.swigCPtr, this);
        }

        public void setMeta(MetaData metaData) {
            MetashapeJNI.NetworkClient_BatchStatus_meta_set(this.swigCPtr, this, MetaData.getCPtr(metaData), metaData);
        }

        public MetaData getMeta() {
            long l = MetashapeJNI.NetworkClient_BatchStatus_meta_get(this.swigCPtr, this);
            return l == 0L ? null : new MetaData(l, false);
        }

        public void setStatus(Status status) {
            MetashapeJNI.NetworkClient_BatchStatus_status_set(this.swigCPtr, this, status.ordinal());
        }

        public Status getStatus() {
            return ((Status[])Status.class.getEnumConstants())[MetashapeJNI.NetworkClient_BatchStatus_status_get(this.swigCPtr, this)];
        }

        public void setPaused(boolean bl) {
            MetashapeJNI.NetworkClient_BatchStatus_paused_set(this.swigCPtr, this, bl);
        }

        public boolean getPaused() {
            return MetashapeJNI.NetworkClient_BatchStatus_paused_get(this.swigCPtr, this);
        }

        public void setPriority(int n) {
            MetashapeJNI.NetworkClient_BatchStatus_priority_set(this.swigCPtr, this, n);
        }

        public int getPriority() {
            return MetashapeJNI.NetworkClient_BatchStatus_priority_get(this.swigCPtr, this);
        }

        public void setTimeStarted(long l) {
            MetashapeJNI.NetworkClient_BatchStatus_timeStarted_set(this.swigCPtr, this, l);
        }

        public long getTimeStarted() {
            return MetashapeJNI.NetworkClient_BatchStatus_timeStarted_get(this.swigCPtr, this);
        }

        public void setTimeFinished(long l) {
            MetashapeJNI.NetworkClient_BatchStatus_timeFinished_set(this.swigCPtr, this, l);
        }

        public long getTimeFinished() {
            return MetashapeJNI.NetworkClient_BatchStatus_timeFinished_get(this.swigCPtr, this);
        }

        public void setTasks(TaskStatus[] taskStatusArray) {
            MetashapeJNI.NetworkClient_BatchStatus_tasks_set(this.swigCPtr, this, TaskStatus.cArrayUnwrap(taskStatusArray));
        }

        public TaskStatus[] getTasks() {
            return TaskStatus.cArrayWrap(MetashapeJNI.NetworkClient_BatchStatus_tasks_get(this.swigCPtr, this), false);
        }

        public void setErrorTime(long l) {
            MetashapeJNI.NetworkClient_BatchStatus_errorTime_set(this.swigCPtr, this, l);
        }

        public long getErrorTime() {
            return MetashapeJNI.NetworkClient_BatchStatus_errorTime_get(this.swigCPtr, this);
        }

        public void setErrorNodeId(long l) {
            MetashapeJNI.NetworkClient_BatchStatus_errorNodeId_set(this.swigCPtr, this, l);
        }

        public long getErrorNodeId() {
            return MetashapeJNI.NetworkClient_BatchStatus_errorNodeId_get(this.swigCPtr, this);
        }

        public void setErrorMessage(String string) {
            MetashapeJNI.NetworkClient_BatchStatus_errorMessage_set(this.swigCPtr, this, string);
        }

        public String getErrorMessage() {
            return MetashapeJNI.NetworkClient_BatchStatus_errorMessage_get(this.swigCPtr, this);
        }

        public void setNextRevision(long l) {
            MetashapeJNI.NetworkClient_BatchStatus_nextRevision_set(this.swigCPtr, this, l);
        }

        public long getNextRevision() {
            return MetashapeJNI.NetworkClient_BatchStatus_nextRevision_get(this.swigCPtr, this);
        }

        public BatchStatus() {
            this(MetashapeJNI.new_NetworkClient_BatchStatus(), true);
        }
    }

    public static class TaskStatus {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public TaskStatus(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(TaskStatus taskStatus) {
            return taskStatus == null ? 0L : taskStatus.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_TaskStatus(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public static long[] cArrayUnwrap(TaskStatus[] taskStatusArray) {
            long[] lArray = new long[taskStatusArray.length];
            for (int i = 0; i < taskStatusArray.length; ++i) {
                lArray[i] = TaskStatus.getCPtr(taskStatusArray[i]);
            }
            return lArray;
        }

        public static TaskStatus[] cArrayWrap(long[] lArray, boolean bl) {
            TaskStatus[] taskStatusArray = new TaskStatus[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                taskStatusArray[i] = new TaskStatus(lArray[i], bl);
            }
            return taskStatusArray;
        }

        public void setTask(NetworkTask networkTask) {
            MetashapeJNI.NetworkClient_TaskStatus_task_set(this.swigCPtr, this, NetworkTask.getCPtr(networkTask), networkTask);
        }

        public NetworkTask getTask() {
            long l = MetashapeJNI.NetworkClient_TaskStatus_task_get(this.swigCPtr, this);
            return l == 0L ? null : new NetworkTask(l, false);
        }

        public void setStatus(Status status) {
            MetashapeJNI.NetworkClient_TaskStatus_status_set(this.swigCPtr, this, status.ordinal());
        }

        public Status getStatus() {
            return ((Status[])Status.class.getEnumConstants())[MetashapeJNI.NetworkClient_TaskStatus_status_get(this.swigCPtr, this)];
        }

        public void setProgress(double d) {
            MetashapeJNI.NetworkClient_TaskStatus_progress_set(this.swigCPtr, this, d);
        }

        public double getProgress() {
            return MetashapeJNI.NetworkClient_TaskStatus_progress_get(this.swigCPtr, this);
        }

        public void setTimeElapsed(double d) {
            MetashapeJNI.NetworkClient_TaskStatus_timeElapsed_set(this.swigCPtr, this, d);
        }

        public double getTimeElapsed() {
            return MetashapeJNI.NetworkClient_TaskStatus_timeElapsed_get(this.swigCPtr, this);
        }

        public void setTimeLeft(double d) {
            MetashapeJNI.NetworkClient_TaskStatus_timeLeft_set(this.swigCPtr, this, d);
        }

        public double getTimeLeft() {
            return MetashapeJNI.NetworkClient_TaskStatus_timeLeft_get(this.swigCPtr, this);
        }

        public void setProcessingTime(double d) {
            MetashapeJNI.NetworkClient_TaskStatus_processingTime_set(this.swigCPtr, this, d);
        }

        public double getProcessingTime() {
            return MetashapeJNI.NetworkClient_TaskStatus_processingTime_get(this.swigCPtr, this);
        }

        public void setItemsTotal(int n) {
            MetashapeJNI.NetworkClient_TaskStatus_itemsTotal_set(this.swigCPtr, this, n);
        }

        public int getItemsTotal() {
            return MetashapeJNI.NetworkClient_TaskStatus_itemsTotal_get(this.swigCPtr, this);
        }

        public void setItemsDone(int n) {
            MetashapeJNI.NetworkClient_TaskStatus_itemsDone_set(this.swigCPtr, this, n);
        }

        public int getItemsDone() {
            return MetashapeJNI.NetworkClient_TaskStatus_itemsDone_get(this.swigCPtr, this);
        }

        public void setWorkitemsWaiting(int n) {
            MetashapeJNI.NetworkClient_TaskStatus_workitemsWaiting_set(this.swigCPtr, this, n);
        }

        public int getWorkitemsWaiting() {
            return MetashapeJNI.NetworkClient_TaskStatus_workitemsWaiting_get(this.swigCPtr, this);
        }

        public void setWorkitemsWorking(int n) {
            MetashapeJNI.NetworkClient_TaskStatus_workitemsWorking_set(this.swigCPtr, this, n);
        }

        public int getWorkitemsWorking() {
            return MetashapeJNI.NetworkClient_TaskStatus_workitemsWorking_get(this.swigCPtr, this);
        }

        public void setWorkitemsCompleted(int n) {
            MetashapeJNI.NetworkClient_TaskStatus_workitemsCompleted_set(this.swigCPtr, this, n);
        }

        public int getWorkitemsCompleted() {
            return MetashapeJNI.NetworkClient_TaskStatus_workitemsCompleted_get(this.swigCPtr, this);
        }

        public void setWorkitemsFailed(int n) {
            MetashapeJNI.NetworkClient_TaskStatus_workitemsFailed_set(this.swigCPtr, this, n);
        }

        public int getWorkitemsFailed() {
            return MetashapeJNI.NetworkClient_TaskStatus_workitemsFailed_get(this.swigCPtr, this);
        }

        public void setLog(LogRecord[] logRecordArray) {
            MetashapeJNI.NetworkClient_TaskStatus_log_set(this.swigCPtr, this, LogRecord.cArrayUnwrap(logRecordArray));
        }

        public LogRecord[] getLog() {
            return LogRecord.cArrayWrap(MetashapeJNI.NetworkClient_TaskStatus_log_get(this.swigCPtr, this), false);
        }

        public TaskStatus() {
            this(MetashapeJNI.new_NetworkClient_TaskStatus(), true);
        }
    }

    public static class ServerInfo {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public ServerInfo(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(ServerInfo serverInfo) {
            return serverInfo == null ? 0L : serverInfo.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_ServerInfo(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public void setTimeStarted(long l) {
            MetashapeJNI.NetworkClient_ServerInfo_timeStarted_set(this.swigCPtr, this, l);
        }

        public long getTimeStarted() {
            return MetashapeJNI.NetworkClient_ServerInfo_timeStarted_get(this.swigCPtr, this);
        }

        public void setVersion(String string) {
            MetashapeJNI.NetworkClient_ServerInfo_version_set(this.swigCPtr, this, string);
        }

        public String getVersion() {
            return MetashapeJNI.NetworkClient_ServerInfo_version_get(this.swigCPtr, this);
        }

        public ServerInfo() {
            this(MetashapeJNI.new_NetworkClient_ServerInfo(), true);
        }
    }

    public static class ResourceRecord {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public ResourceRecord(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(ResourceRecord resourceRecord) {
            return resourceRecord == null ? 0L : resourceRecord.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_ResourceRecord(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public static long[] cArrayUnwrap(ResourceRecord[] resourceRecordArray) {
            long[] lArray = new long[resourceRecordArray.length];
            for (int i = 0; i < resourceRecordArray.length; ++i) {
                lArray[i] = ResourceRecord.getCPtr(resourceRecordArray[i]);
            }
            return lArray;
        }

        public static ResourceRecord[] cArrayWrap(long[] lArray, boolean bl) {
            ResourceRecord[] resourceRecordArray = new ResourceRecord[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                resourceRecordArray[i] = new ResourceRecord(lArray[i], bl);
            }
            return resourceRecordArray;
        }

        public void setTime(double d) {
            MetashapeJNI.NetworkClient_ResourceRecord_time_set(this.swigCPtr, this, d);
        }

        public double getTime() {
            return MetashapeJNI.NetworkClient_ResourceRecord_time_get(this.swigCPtr, this);
        }

        public void setRamUsage(double d) {
            MetashapeJNI.NetworkClient_ResourceRecord_ramUsage_set(this.swigCPtr, this, d);
        }

        public double getRamUsage() {
            return MetashapeJNI.NetworkClient_ResourceRecord_ramUsage_get(this.swigCPtr, this);
        }

        public void setCpuUsage(double d) {
            MetashapeJNI.NetworkClient_ResourceRecord_cpuUsage_set(this.swigCPtr, this, d);
        }

        public double getCpuUsage() {
            return MetashapeJNI.NetworkClient_ResourceRecord_cpuUsage_get(this.swigCPtr, this);
        }

        public ResourceRecord() {
            this(MetashapeJNI.new_NetworkClient_ResourceRecord(), true);
        }
    }

    public static class LogRecord {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        public LogRecord(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        public static long getCPtr(LogRecord logRecord) {
            return logRecord == null ? 0L : logRecord.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_NetworkClient_LogRecord(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public static long[] cArrayUnwrap(LogRecord[] logRecordArray) {
            long[] lArray = new long[logRecordArray.length];
            for (int i = 0; i < logRecordArray.length; ++i) {
                lArray[i] = LogRecord.getCPtr(logRecordArray[i]);
            }
            return lArray;
        }

        public static LogRecord[] cArrayWrap(long[] lArray, boolean bl) {
            LogRecord[] logRecordArray = new LogRecord[lArray.length];
            for (int i = 0; i < lArray.length; ++i) {
                logRecordArray[i] = new LogRecord(lArray[i], bl);
            }
            return logRecordArray;
        }

        public void setType(int n) {
            MetashapeJNI.NetworkClient_LogRecord_type_set(this.swigCPtr, this, n);
        }

        public int getType() {
            return MetashapeJNI.NetworkClient_LogRecord_type_get(this.swigCPtr, this);
        }

        public void setText(String string) {
            MetashapeJNI.NetworkClient_LogRecord_text_set(this.swigCPtr, this, string);
        }

        public String getText() {
            return MetashapeJNI.NetworkClient_LogRecord_text_get(this.swigCPtr, this);
        }

        public LogRecord() {
            this(MetashapeJNI.new_NetworkClient_LogRecord(), true);
        }
    }
}

