/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

/**
 * Calibration object contains camera calibration information including image size,<br>
 * focal length, principal point coordinates and distortion coefficients.
 */
public class Calibration {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  public Calibration(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  public static long getCPtr(Calibration obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_Calibration(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  public Calibration() {
    this(MetashapeJNI.new_Calibration__SWIG_0(), true);
  }

  public Calibration(Calibration calibration) {
    this(MetashapeJNI.new_Calibration__SWIG_1(Calibration.getCPtr(calibration), calibration), true);
  }

  /**
   *  Camera model.
   */
  public Calibration.Type getType() {
    return Calibration.Type.class.getEnumConstants()[MetashapeJNI.Calibration_getType(swigCPtr, this)];
  }

  /**
   *  Image width.
   */
  public long getWidth() {
    return MetashapeJNI.Calibration_getWidth(swigCPtr, this);
  }

  /**
   *  Image height.
   */
  public long getHeight() {
    return MetashapeJNI.Calibration_getHeight(swigCPtr, this);
  }

  /**
   *  Camera model.
   */
  public void setType(Calibration.Type type) {
    MetashapeJNI.Calibration_setType(swigCPtr, this, type.ordinal());
  }

  /**
   *  Image width.
   */
  public void setWidth(long width) {
    MetashapeJNI.Calibration_setWidth(swigCPtr, this, width);
  }

  /**
   *  Image height.
   */
  public void setHeight(long height) {
    MetashapeJNI.Calibration_setHeight(swigCPtr, this, height);
  }

  /**
   *  Focal length.
   */
  public void setF(double value) {
    MetashapeJNI.Calibration_setF(swigCPtr, this, value);
  }

  /**
   *  Focal length.
   */
  public double getF() {
    return MetashapeJNI.Calibration_getF(swigCPtr, this);
  }

  /**
   *  Principal point X coordinate.
   */
  public void setCx(double value) {
    MetashapeJNI.Calibration_setCx(swigCPtr, this, value);
  }

  /**
   *  Principal point X coordinate.
   */
  public double getCx() {
    return MetashapeJNI.Calibration_getCx(swigCPtr, this);
  }

  /**
   *  Principal point Y coordinate.
   */
  public void setCy(double value) {
    MetashapeJNI.Calibration_setCy(swigCPtr, this, value);
  }

  /**
   *  Principal point Y coordinate.
   */
  public double getCy() {
    return MetashapeJNI.Calibration_getCy(swigCPtr, this);
  }

  /**
   *  Affinity.
   */
  public void setB1(double value) {
    MetashapeJNI.Calibration_setB1(swigCPtr, this, value);
  }

  /**
   *  Affinity.
   */
  public double getB1() {
    return MetashapeJNI.Calibration_getB1(swigCPtr, this);
  }

  /**
   *  Non-orthogonality.
   */
  public void setB2(double value) {
    MetashapeJNI.Calibration_setB2(swigCPtr, this, value);
  }

  /**
   *  Non-orthogonality.
   */
  public double getB2() {
    return MetashapeJNI.Calibration_getB2(swigCPtr, this);
  }

  /**
   *  Radial distortion coefficient K1.
   */
  public void setK1(double value) {
    MetashapeJNI.Calibration_setK1(swigCPtr, this, value);
  }

  /**
   *  Radial distortion coefficient K1.
   */
  public double getK1() {
    return MetashapeJNI.Calibration_getK1(swigCPtr, this);
  }

  /**
   *  Radial distortion coefficient K2.
   */
  public void setK2(double value) {
    MetashapeJNI.Calibration_setK2(swigCPtr, this, value);
  }

  /**
   *  Radial distortion coefficient K2.
   */
  public double getK2() {
    return MetashapeJNI.Calibration_getK2(swigCPtr, this);
  }

  /**
   *  Radial distortion coefficient K3.
   */
  public void setK3(double value) {
    MetashapeJNI.Calibration_setK3(swigCPtr, this, value);
  }

  /**
   *  Radial distortion coefficient K3.
   */
  public double getK3() {
    return MetashapeJNI.Calibration_getK3(swigCPtr, this);
  }

  /**
   *  Radial distortion coefficient K4.
   */
  public void setK4(double value) {
    MetashapeJNI.Calibration_setK4(swigCPtr, this, value);
  }

  /**
   *  Radial distortion coefficient K4.
   */
  public double getK4() {
    return MetashapeJNI.Calibration_getK4(swigCPtr, this);
  }

  /**
   *  Decentering distortion coefficient P1.
   */
  public void setP1(double value) {
    MetashapeJNI.Calibration_setP1(swigCPtr, this, value);
  }

  /**
   *  Decentering distortion coefficient P1.
   */
  public double getP1() {
    return MetashapeJNI.Calibration_getP1(swigCPtr, this);
  }

  /**
   *  Decentering distortion coefficiant P2.
   */
  public void setP2(double value) {
    MetashapeJNI.Calibration_setP2(swigCPtr, this, value);
  }

  /**
   *  Decentering distortion coefficiant P2.
   */
  public double getP2() {
    return MetashapeJNI.Calibration_getP2(swigCPtr, this);
  }

  /**
   *  Decentering distortion coefficient P3.
   */
  public void setP3(double value) {
    MetashapeJNI.Calibration_setP3(swigCPtr, this, value);
  }

  /**
   *  Decentering distortion coefficient P3.
   */
  public double getP3() {
    return MetashapeJNI.Calibration_getP3(swigCPtr, this);
  }

  /**
   *  Decentering distortion coefficiant P4.
   */
  public void setP4(double value) {
    MetashapeJNI.Calibration_setP4(swigCPtr, this, value);
  }

  /**
   *  Decentering distortion coefficiant P4.
   */
  public double getP4() {
    return MetashapeJNI.Calibration_getP4(swigCPtr, this);
  }

  /**
   *  RPC model.
   */
  public void setRPCModel(RPCModel rpc) {
    MetashapeJNI.Calibration_setRPCModel(swigCPtr, this, RPCModel.getCPtr(rpc), rpc);
  }

  /**
   *  RPC model.
   */
  public RPCModel getRPCModel() {
    return new RPCModel(MetashapeJNI.Calibration_getRPCModel(swigCPtr, this), true);
  }

  /**
   * Save calibration to file.<br>
   * @param path path to calibration file.<br>
   * @param format Calibration format.<br>
   * @param label Calibration label used in Australis, CalibCam and CalCam formats.<br>
   * @param pixel_size Pixel size in mm used to convert normalized calibration coefficients to Australis and CalibCam coefficients.<br>
   * @param focal_length Focal length (Grid calibration format only).<br>
   * @param cx X principal point coordinate (Grid calibration format only).<br>
   * @param cy Y principal point coordinate (Grid calibration format only).
   */
  public void save(String path, CalibrationFormat format, String label, Vector2d pixel_size, double focal_length, double cx, double cy) {
    MetashapeJNI.Calibration_save(swigCPtr, this, path, format.ordinal(), label, Vector2d.getCPtr(pixel_size), pixel_size, focal_length, cx, cy);
  }

  /**
   * Load calibration from file.<br>
   * @param path Path to calibration file.<br>
   * @param format Calibration format.
   */
  public void load(String path, CalibrationFormat format) {
    MetashapeJNI.Calibration_load(swigCPtr, this, path, format.ordinal());
  }

  /**
   * Return projected pixel coordinates of the point.<br>
   * @param point Coordinates of the point to be projected.<br>
   * @return 2D projected point coordinates.
   */
  public Vector2d project(Vector3d point) {
    return new Vector2d(MetashapeJNI.Calibration_project(swigCPtr, this, Vector3d.getCPtr(point), point), true);
  }

  /**
   * Return direction corresponding to the image point.<br>
   * @param point Pixel coordinates of the point.<br>
   * @return 3D vector in the camera coordinate system.
   */
  public Vector3d unproject(Vector2d point) {
    return new Vector3d(MetashapeJNI.Calibration_unproject(swigCPtr, this, Vector2d.getCPtr(point), point), true);
  }

  /**
   * Return projection error.<br>
   * @param point Coordinates of the point to be projected.<br>
   * @param proj Pixel coordinates of the point.<br>
   * @return 2D projection error.
   */
  public Vector2d getError(Vector3d point, Vector2d proj) {
    return new Vector2d(MetashapeJNI.Calibration_getError(swigCPtr, this, Vector3d.getCPtr(point), point, Vector2d.getCPtr(proj), proj), true);
  }

  public enum Type {
    TypeFrame,
    TypeFisheye,
    TypeSpherical,
    TypeCylindrical,
    TypeRPC;
  }

}
