/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Progress;
import com.agisoft.metashape.SwigHelpers;
import java.util.Map;
import java.util.Optional;

public class Document
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Document(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Document document) {
        return document == null ? 0L : document.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Document(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Document() {
        this(MetashapeJNI.new_Document__SWIG_0(), true);
    }

    public Document(Document document) {
        this(MetashapeJNI.new_Document__SWIG_1(Document.getCPtr(document), document), true);
    }

    public String dump() {
        return MetashapeJNI.Document_dump(this.swigCPtr, this);
    }

    public void load(String string) {
        MetashapeJNI.Document_load(this.swigCPtr, this, string);
    }

    public void clear() {
        MetashapeJNI.Document_clear(this.swigCPtr, this);
    }

    public void save(String string, Progress progress) {
        MetashapeJNI.Document_save__SWIG_0(this.swigCPtr, this, string, progress);
    }

    public void save(String string, int[] nArray, Progress progress) {
        MetashapeJNI.Document_save__SWIG_1(this.swigCPtr, this, string, nArray, progress);
    }

    public void open(String string, boolean bl, Progress progress) {
        MetashapeJNI.Document_open(this.swigCPtr, this, string, bl, progress);
    }

    public String getPath() {
        return MetashapeJNI.Document_getPath(this.swigCPtr, this);
    }

    public void setReadOnly(boolean bl) {
        MetashapeJNI.Document_setReadOnly(this.swigCPtr, this, bl);
    }

    public boolean isReadOnly() {
        return MetashapeJNI.Document_isReadOnly(this.swigCPtr, this);
    }

    public Chunk addChunk() {
        return new Chunk(MetashapeJNI.Document_addChunk(this.swigCPtr, this), true);
    }

    public Chunk[] getChunks() {
        return SwigHelpers.cArrayWrap(MetashapeJNI.Document_getChunks(this.swigCPtr, this), true, Chunk.class);
    }

    public int[] getChunkKeys() {
        return MetashapeJNI.Document_getChunkKeys(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk(int n) {
        long l = MetashapeJNI.Document_getChunk(this.swigCPtr, this, n);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public Chunk getActiveChunk() {
        return new Chunk(MetashapeJNI.Document_getActiveChunk(this.swigCPtr, this), true);
    }

    public void setActiveChunk(Chunk chunk) {
        MetashapeJNI.Document_setActiveChunk(this.swigCPtr, this, Chunk.getCPtr(chunk), chunk);
    }

    public void remove(Chunk chunk) {
        MetashapeJNI.Document_remove(this.swigCPtr, this, Chunk.getCPtr(chunk), chunk);
    }

    public void append(Document document, Progress progress) {
        MetashapeJNI.Document_append(this.swigCPtr, this, Document.getCPtr(document), document, progress);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.Document_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.Document_getMeta(this.swigCPtr, this);
    }
}

