/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * Tie point cloud.
 */
public class PointCloud implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected PointCloud(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(PointCloud obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_PointCloud(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  static public class Track {

    private Color color;

    public Track() {
      color = new Color();
    }

    public void setColor(Color value) {
      this.color = value;
    }

    public Color getColor() {
      return color;
    }

  }

  static public class Point {

    private Vector coord;
    private long track_id;
    private boolean selected;
    private boolean valid;

    public Point() {
      coord = new Vector(0, 0, 0);
      track_id = 0;
      selected = false;
      valid = true;
    }

    public void setCoord(Vector coord) {
      this.coord = coord;
    }

    public Vector getCoord() { return coord; }

    public void setValid(boolean on) {
      this.valid = on;
    }

    public boolean isValid() {
      return valid;
    }

    public void setSelected(boolean on) {
      this.selected = on;
    }

    public boolean isSelected() {
      return selected;
    }

    public void setTrackId(long track_id) {
      this.track_id = track_id;
    }

    public long getTrackId() {
      return track_id;
    }

  }

  static public class Projection {

    private Vector coord;
    private float size;
    private long track_id;

    public Projection() {
      coord = new Vector(0, 0);
      size = 1;
      track_id = 0;
    }

    public void setCoord(Vector coord) {
      this.coord = coord;
    }

    public Vector getCoord() { return coord; }

    public void setSize(float size) {
      this.size = size;
    }

    public float getSize() {
      return size;
    }

    public void setTrackId(long track_id) {
      this.track_id = track_id;
    }

    public long getTrackId() {
      return track_id;
    }

  }

  public PointCloud() {
    this(MetashapeJNI.new_PointCloud__SWIG_0(), true);
  }

  public PointCloud(PointCloud point_cloud) {
    this(MetashapeJNI.new_PointCloud__SWIG_1(PointCloud.getCPtr(point_cloud), point_cloud), true);
  }

  static public class Tracks implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected Tracks(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(Tracks obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_PointCloud_Tracks(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    @Override
    public void close() {
      delete();
    }
  
    public Tracks() {
      this(MetashapeJNI.new_PointCloud_Tracks__SWIG_0(), true);
    }
  
    public Tracks(PointCloud.Tracks tracks) {
      this(MetashapeJNI.new_PointCloud_Tracks__SWIG_1(PointCloud.Tracks.getCPtr(tracks), tracks), true);
    }
  
    public PointCloud.Tracks copy() {
      return new PointCloud.Tracks(MetashapeJNI.PointCloud_Tracks_copy(swigCPtr, this), true);
    }
  
    public void resize(long size) {
      MetashapeJNI.PointCloud_Tracks_resize(swigCPtr, this, size);
    }
  
    public long getSize() {
      return MetashapeJNI.PointCloud_Tracks_getSize(swigCPtr, this);
    }
  
    public void set(long index, PointCloud.Track track) {
      MetashapeJNI.PointCloud_Tracks_set(swigCPtr, this, index, track);
    }
  
    public PointCloud.Track get(long index) { return MetashapeJNI.PointCloud_Tracks_get(swigCPtr, this, index); }
  
  }

  static public class Points implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected Points(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(Points obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_PointCloud_Points(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    @Override
    public void close() {
      delete();
    }
  
    public Points() {
      this(MetashapeJNI.new_PointCloud_Points__SWIG_0(), true);
    }
  
    public Points(PointCloud.Points points) {
      this(MetashapeJNI.new_PointCloud_Points__SWIG_1(PointCloud.Points.getCPtr(points), points), true);
    }
  
    public PointCloud.Points copy() {
      return new PointCloud.Points(MetashapeJNI.PointCloud_Points_copy(swigCPtr, this), true);
    }
  
    public void resize(long size) {
      MetashapeJNI.PointCloud_Points_resize(swigCPtr, this, size);
    }
  
    public long getSize() {
      return MetashapeJNI.PointCloud_Points_getSize(swigCPtr, this);
    }
  
    public void set(long index, PointCloud.Point point) {
      MetashapeJNI.PointCloud_Points_set(swigCPtr, this, index, point);
    }
  
    public PointCloud.Point get(long index) { return MetashapeJNI.PointCloud_Points_get(swigCPtr, this, index); }
  
  }

  static public class Projections implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected Projections(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(Projections obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_PointCloud_Projections(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    @Override
    public void close() {
      delete();
    }
  
    public Projections() {
      this(MetashapeJNI.new_PointCloud_Projections__SWIG_0(), true);
    }
  
    public Projections(PointCloud.Projections projections) {
      this(MetashapeJNI.new_PointCloud_Projections__SWIG_1(PointCloud.Projections.getCPtr(projections), projections), true);
    }
  
    public PointCloud.Projections copy() {
      return new PointCloud.Projections(MetashapeJNI.PointCloud_Projections_copy(swigCPtr, this), true);
    }
  
    public void resize(long size) {
      MetashapeJNI.PointCloud_Projections_resize(swigCPtr, this, size);
    }
  
    public long getSize() {
      return MetashapeJNI.PointCloud_Projections_getSize(swigCPtr, this);
    }
  
    public void set(long index, PointCloud.Projection proj) {
      MetashapeJNI.PointCloud_Projections_set(swigCPtr, this, index, proj);
    }
  
    public PointCloud.Projection get(long index) { return MetashapeJNI.PointCloud_Projections_get(swigCPtr, this, index); }
  
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.PointCloud_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Path to point cloud file.
   */
  public String getPath() {
    return MetashapeJNI.PointCloud_getPath(swigCPtr, this);
  }

  /**
   *  Point cloud meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.PointCloud_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Point cloud meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.PointCloud_getMeta(swigCPtr, this); }

  /**
   *  List of tracks, may be null.
   */
  public void setTracks(Optional<PointCloud.Tracks> tracks) {
    MetashapeJNI.PointCloud_setTracks(swigCPtr, this, tracks.isPresent() ? PointCloud.Tracks.getCPtr(tracks.get()) : 0);
  }

  /**
   *  List of tracks, may be null.
   */
  public Optional<PointCloud.Tracks> getTracks() {
    long ptr = MetashapeJNI.PointCloud_getTracks(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new PointCloud.Tracks(ptr, true));
  }

  /**
   *  List of points, may be null.
   */
  public void setPoints(Optional<PointCloud.Points> points) {
    MetashapeJNI.PointCloud_setPoints(swigCPtr, this, points.isPresent() ? PointCloud.Points.getCPtr(points.get()) : 0);
  }

  /**
   *  List of points, may be null.
   */
  public Optional<PointCloud.Points> getPoints() {
    long ptr = MetashapeJNI.PointCloud_getPoints(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new PointCloud.Points(ptr, true));
  }

  /**
   *  Point projections for the camera, may be null.
   */
  public void setProjections(int camera, Optional<PointCloud.Projections> projections) {
    MetashapeJNI.PointCloud_setProjections(swigCPtr, this, camera, projections.isPresent() ? PointCloud.Projections.getCPtr(projections.get()) : 0);
  }

  /**
   *  Point projections for the camera, may be null.
   */
  public Optional<PointCloud.Projections> getProjections(int camera) {
    long ptr = MetashapeJNI.PointCloud_getProjections(swigCPtr, this, camera);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new PointCloud.Projections(ptr, true));
  }

  public int[] getCameraKeys() { return MetashapeJNI.PointCloud_getCameraKeys(swigCPtr, this); }

  /**
   * Remove points with insufficient number of projections.<br>
   * @param progress Progress callback.
   */
  public void cleanup(Progress progress) {
    MetashapeJNI.PointCloud_cleanup(swigCPtr, this, progress);
  }

  /**
   * Returns ray intersection with the tie point cloud.<br>
   * @param origin Ray origin.<br>
   * @param target Point on the ray.<br>
   * @return Coordinates of the intersection point, may be null.
   */
  public Optional<Vector> pickPoint(Vector origin, Vector target) {
	Vector values = MetashapeJNI.PointCloud_pickPoint(swigCPtr, this, origin, target);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   * Generate point cloud preview image.<br>
   * @param width Preview image width.<br>
   * @param height Preview image height.<br>
   * @param transform 4x4 viewpoint transformation matrix.<br>
   * @param point_size Point size.<br>
   * @return Preview image.
   */
  public Image renderPreview(long width, long height, Matrix transform, int point_size, Progress progress) {
    return new Image(MetashapeJNI.PointCloud_renderPreview(swigCPtr, this, width, height, transform, point_size, progress), true);
  }

}
