/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.Vector;
import java.util.Optional;

public class Transform {
    private Optional<Matrix> rotation;
    private Optional<Vector> translation;
    private Optional<Double> scale;

    public Transform() {
        this.reset();
    }

    public void setRotation(Optional<Matrix> optional) {
        this.rotation = optional;
    }

    public Optional<Matrix> getRotation() {
        return this.rotation;
    }

    public void setTranslation(Optional<Vector> optional) {
        this.translation = optional;
    }

    public Optional<Vector> getTranslation() {
        return this.translation;
    }

    public void setScale(Optional<Double> optional) {
        this.scale = optional;
    }

    public Optional<Double> getScale() {
        return this.scale;
    }

    public void setMatrix(Matrix matrix) {
        this.translation = Optional.of(matrix.translation());
        this.rotation = Optional.of(matrix.rotation());
        this.scale = Optional.of(matrix.scale());
    }

    public Matrix getMatrix() {
        Vector vector = this.translation.orElse(new Vector(0.0, 0.0, 0.0));
        Matrix matrix = this.rotation.orElse(Matrix.makeDiag(new Vector(1.0, 1.0, 1.0, 1.0)));
        Double d = this.scale.orElse(1.0);
        return Matrix.makeTranslation(vector).mul(Matrix.makeRotation(matrix)).mul(Matrix.makeScale(new Vector(d, d, d)));
    }

    public boolean hasMatrix() {
        return this.translation.isPresent() && this.rotation.isPresent() && this.scale.isPresent();
    }

    public void reset() {
        this.translation = Optional.empty();
        this.rotation = Optional.empty();
        this.scale = Optional.empty();
    }

    public Vector transformPoint(Vector vector) {
        return this.getMatrix().mulp(vector);
    }

    public Vector transformVector(Vector vector) {
        return this.getMatrix().mulv(vector);
    }
}

