/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * Dense point cloud.
 */
public class DenseCloud implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected DenseCloud(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(DenseCloud obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_DenseCloud(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public DenseCloud(DenseCloud dense_cloud) {
    this(MetashapeJNI.new_DenseCloud(DenseCloud.getCPtr(dense_cloud), dense_cloud), true);
  }

  /**
   *  Dense cloud identifier.
   */
  public int getKey() {
    return MetashapeJNI.DenseCloud_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.DenseCloud_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Dense cloud label.
   */
  public void setLabel(String label) {
    MetashapeJNI.DenseCloud_setLabel(swigCPtr, this, label);
  }

  /**
   *  Dense cloud label.
   */
  public String getLabel() {
    return MetashapeJNI.DenseCloud_getLabel(swigCPtr, this);
  }

  /**
   *  Path to dense cloud file.
   */
  public String getPath() {
    return MetashapeJNI.DenseCloud_getPath(swigCPtr, this);
  }

  /**
   *  Dense cloud meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.DenseCloud_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Dense cloud meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.DenseCloud_getMeta(swigCPtr, this); }

  /**
   *  4x4 dense cloud transformation matrix.
   */
  public void setTransform(Matrix transform) {
    MetashapeJNI.DenseCloud_setTransform(swigCPtr, this, transform);
  }

  /**
   *  4x4 dense cloud transformation matrix.
   */
  public Matrix getTransform() { return MetashapeJNI.DenseCloud_getTransform(swigCPtr, this); }

  /**
   *  Reference coordinate system, may be null.
   */
  public void setCoordinateSystem(Optional<CoordinateSystem> crs) {
    MetashapeJNI.DenseCloud_setCoordinateSystem(swigCPtr, this, crs.isPresent() ? CoordinateSystem.getCPtr(crs.get()) : 0);
  }

  /**
   *  Reference coordinate system, may be null.
   */
  public Optional<CoordinateSystem> getCoordinateSystem() {
    long ptr = MetashapeJNI.DenseCloud_getCoordinateSystem(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CoordinateSystem(ptr, true));
  }

  /**
   * Returns ray intersection with the dense point cloud.<br>
   * @param origin Ray origin.<br>
   * @param target Point on the ray.<br>
   * @return Coordinates of the intersection point, may be null.
   */
  public Optional<Vector> pickPoint(Vector origin, Vector target) {
	Vector values = MetashapeJNI.DenseCloud_pickPoint(swigCPtr, this, origin, target);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   * Permanently removes deleted points from dense cloud.<br>
   * @param progress Progress callback.
   */
  public void compactPoints(Progress progress) {
    MetashapeJNI.DenseCloud_compactPoints(swigCPtr, this, progress);
  }

  /**
   * Remove points.<br>
   * @param point_classes Classes of points to be removed.<br>
   * @param progress Progress callback.
   */
  public void removePoints(int[] point_classes, Progress progress) {
    MetashapeJNI.DenseCloud_removePoints(swigCPtr, this, point_classes, progress);
  }

  /**
   * Restore deleted points.<br>
   * @param point_classes Classes of points to be restored.<br>
   * @param progress Progress callback.
   */
  public void restorePoints(int[] point_classes, Progress progress) {
    MetashapeJNI.DenseCloud_restorePoints(swigCPtr, this, point_classes, progress);
  }

  /**
   * Assign class to points.<br>
   * @param target Target class.<br>
   * @param source Classes of points to be replaced.<br>
   * @param progress Progress callback.
   */
  public void assignClass(int target, int[] source, Progress progress) {
    MetashapeJNI.DenseCloud_assignClass(swigCPtr, this, target, source, progress);
  }

  /**
   * Generate dense cloud preview image.<br>
   * @param width Preview image width.<br>
   * @param height Preview image height.<br>
   * @param transform 4x4 viewpoint transformation matrix.<br>
   * @param point_size Point size.<br>
   * @return Preview image.
   */
  public Image renderPreview(long width, long height, Matrix transform, int point_size, Progress progress) {
    return new Image(MetashapeJNI.DenseCloud_renderPreview(swigCPtr, this, width, height, transform, point_size, progress), true);
  }

}
