/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.CoordinateSystem;
import com.agisoft.metashape.Image;
import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Progress;
import com.agisoft.metashape.Vector;
import java.util.Map;
import java.util.Optional;

public class DenseCloud
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DenseCloud(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DenseCloud denseCloud) {
        return denseCloud == null ? 0L : denseCloud.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_DenseCloud(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public DenseCloud(DenseCloud denseCloud) {
        this(MetashapeJNI.new_DenseCloud(DenseCloud.getCPtr(denseCloud), denseCloud), true);
    }

    public int getKey() {
        return MetashapeJNI.DenseCloud_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.DenseCloud_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setLabel(String string) {
        MetashapeJNI.DenseCloud_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.DenseCloud_getLabel(this.swigCPtr, this);
    }

    public String getPath() {
        return MetashapeJNI.DenseCloud_getPath(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.DenseCloud_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.DenseCloud_getMeta(this.swigCPtr, this);
    }

    public void setTransform(Matrix matrix) {
        MetashapeJNI.DenseCloud_setTransform(this.swigCPtr, this, matrix);
    }

    public Matrix getTransform() {
        return MetashapeJNI.DenseCloud_getTransform(this.swigCPtr, this);
    }

    public void setCoordinateSystem(Optional<CoordinateSystem> optional) {
        MetashapeJNI.DenseCloud_setCoordinateSystem(this.swigCPtr, this, optional.isPresent() ? CoordinateSystem.getCPtr(optional.get()) : 0L);
    }

    public Optional<CoordinateSystem> getCoordinateSystem() {
        long l = MetashapeJNI.DenseCloud_getCoordinateSystem(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new CoordinateSystem(l, true));
    }

    public Optional<Vector> pickPoint(Vector vector, Vector vector2) {
        Vector vector3 = MetashapeJNI.DenseCloud_pickPoint(this.swigCPtr, this, vector, vector2);
        return vector3 == null ? Optional.empty() : Optional.of(vector3);
    }

    public void compactPoints(Progress progress) {
        MetashapeJNI.DenseCloud_compactPoints(this.swigCPtr, this, progress);
    }

    public void removePoints(int[] nArray, Progress progress) {
        MetashapeJNI.DenseCloud_removePoints(this.swigCPtr, this, nArray, progress);
    }

    public void restorePoints(int[] nArray, Progress progress) {
        MetashapeJNI.DenseCloud_restorePoints(this.swigCPtr, this, nArray, progress);
    }

    public void assignClass(int n, int[] nArray, Progress progress) {
        MetashapeJNI.DenseCloud_assignClass(this.swigCPtr, this, n, nArray, progress);
    }

    public Image renderPreview(long l, long l2, Matrix matrix, int n, Progress progress) {
        return new Image(MetashapeJNI.DenseCloud_renderPreview(this.swigCPtr, this, l, l2, matrix, n, progress), true);
    }
}

