/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.Color;
import com.agisoft.metashape.Image;
import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Progress;
import com.agisoft.metashape.Vector;
import java.util.Map;
import java.util.Optional;

public class PointCloud
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected PointCloud(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(PointCloud pointCloud) {
        return pointCloud == null ? 0L : pointCloud.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_PointCloud(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public PointCloud() {
        this(MetashapeJNI.new_PointCloud__SWIG_0(), true);
    }

    public PointCloud(PointCloud pointCloud) {
        this(MetashapeJNI.new_PointCloud__SWIG_1(PointCloud.getCPtr(pointCloud), pointCloud), true);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.PointCloud_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public String getPath() {
        return MetashapeJNI.PointCloud_getPath(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.PointCloud_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.PointCloud_getMeta(this.swigCPtr, this);
    }

    public void setTracks(Optional<Tracks> optional) {
        MetashapeJNI.PointCloud_setTracks(this.swigCPtr, this, optional.isPresent() ? Tracks.getCPtr(optional.get()) : 0L);
    }

    public Optional<Tracks> getTracks() {
        long l = MetashapeJNI.PointCloud_getTracks(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Tracks(l, true));
    }

    public void setPoints(Optional<Points> optional) {
        MetashapeJNI.PointCloud_setPoints(this.swigCPtr, this, optional.isPresent() ? Points.getCPtr(optional.get()) : 0L);
    }

    public Optional<Points> getPoints() {
        long l = MetashapeJNI.PointCloud_getPoints(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Points(l, true));
    }

    public void setProjections(int n, Optional<Projections> optional) {
        MetashapeJNI.PointCloud_setProjections(this.swigCPtr, this, n, optional.isPresent() ? Projections.getCPtr(optional.get()) : 0L);
    }

    public Optional<Projections> getProjections(int n) {
        long l = MetashapeJNI.PointCloud_getProjections(this.swigCPtr, this, n);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Projections(l, true));
    }

    public int[] getCameraKeys() {
        return MetashapeJNI.PointCloud_getCameraKeys(this.swigCPtr, this);
    }

    public void cleanup(Progress progress) {
        MetashapeJNI.PointCloud_cleanup(this.swigCPtr, this, progress);
    }

    public Optional<Vector> pickPoint(Vector vector, Vector vector2) {
        Vector vector3 = MetashapeJNI.PointCloud_pickPoint(this.swigCPtr, this, vector, vector2);
        return vector3 == null ? Optional.empty() : Optional.of(vector3);
    }

    public Image renderPreview(long l, long l2, Matrix matrix, int n, Progress progress) {
        return new Image(MetashapeJNI.PointCloud_renderPreview(this.swigCPtr, this, l, l2, matrix, n, progress), true);
    }

    public static class Projections
    implements AutoCloseable {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Projections(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Projections projections) {
            return projections == null ? 0L : projections.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_PointCloud_Projections(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        @Override
        public void close() {
            this.delete();
        }

        public Projections() {
            this(MetashapeJNI.new_PointCloud_Projections__SWIG_0(), true);
        }

        public Projections(Projections projections) {
            this(MetashapeJNI.new_PointCloud_Projections__SWIG_1(Projections.getCPtr(projections), projections), true);
        }

        public Projections copy() {
            return new Projections(MetashapeJNI.PointCloud_Projections_copy(this.swigCPtr, this), true);
        }

        public void resize(long l) {
            MetashapeJNI.PointCloud_Projections_resize(this.swigCPtr, this, l);
        }

        public long getSize() {
            return MetashapeJNI.PointCloud_Projections_getSize(this.swigCPtr, this);
        }

        public void set(long l, Projection projection) {
            MetashapeJNI.PointCloud_Projections_set(this.swigCPtr, this, l, projection);
        }

        public Projection get(long l) {
            return MetashapeJNI.PointCloud_Projections_get(this.swigCPtr, this, l);
        }
    }

    public static class Points
    implements AutoCloseable {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Points(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Points points) {
            return points == null ? 0L : points.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_PointCloud_Points(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        @Override
        public void close() {
            this.delete();
        }

        public Points() {
            this(MetashapeJNI.new_PointCloud_Points__SWIG_0(), true);
        }

        public Points(Points points) {
            this(MetashapeJNI.new_PointCloud_Points__SWIG_1(Points.getCPtr(points), points), true);
        }

        public Points copy() {
            return new Points(MetashapeJNI.PointCloud_Points_copy(this.swigCPtr, this), true);
        }

        public void resize(long l) {
            MetashapeJNI.PointCloud_Points_resize(this.swigCPtr, this, l);
        }

        public long getSize() {
            return MetashapeJNI.PointCloud_Points_getSize(this.swigCPtr, this);
        }

        public void set(long l, Point point) {
            MetashapeJNI.PointCloud_Points_set(this.swigCPtr, this, l, point);
        }

        public Point get(long l) {
            return MetashapeJNI.PointCloud_Points_get(this.swigCPtr, this, l);
        }
    }

    public static class Tracks
    implements AutoCloseable {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Tracks(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Tracks tracks) {
            return tracks == null ? 0L : tracks.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_PointCloud_Tracks(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        @Override
        public void close() {
            this.delete();
        }

        public Tracks() {
            this(MetashapeJNI.new_PointCloud_Tracks__SWIG_0(), true);
        }

        public Tracks(Tracks tracks) {
            this(MetashapeJNI.new_PointCloud_Tracks__SWIG_1(Tracks.getCPtr(tracks), tracks), true);
        }

        public Tracks copy() {
            return new Tracks(MetashapeJNI.PointCloud_Tracks_copy(this.swigCPtr, this), true);
        }

        public void resize(long l) {
            MetashapeJNI.PointCloud_Tracks_resize(this.swigCPtr, this, l);
        }

        public long getSize() {
            return MetashapeJNI.PointCloud_Tracks_getSize(this.swigCPtr, this);
        }

        public void set(long l, Track track) {
            MetashapeJNI.PointCloud_Tracks_set(this.swigCPtr, this, l, track);
        }

        public Track get(long l) {
            return MetashapeJNI.PointCloud_Tracks_get(this.swigCPtr, this, l);
        }
    }

    public static class Projection {
        private Vector coord = new Vector(0.0, 0.0);
        private float size = 1.0f;
        private long track_id = 0L;

        public void setCoord(Vector vector) {
            this.coord = vector;
        }

        public Vector getCoord() {
            return this.coord;
        }

        public void setSize(float f) {
            this.size = f;
        }

        public float getSize() {
            return this.size;
        }

        public void setTrackId(long l) {
            this.track_id = l;
        }

        public long getTrackId() {
            return this.track_id;
        }
    }

    public static class Point {
        private Vector coord = new Vector(0.0, 0.0, 0.0);
        private long track_id = 0L;
        private boolean selected = false;
        private boolean valid = true;

        public void setCoord(Vector vector) {
            this.coord = vector;
        }

        public Vector getCoord() {
            return this.coord;
        }

        public void setValid(boolean bl) {
            this.valid = bl;
        }

        public boolean isValid() {
            return this.valid;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setTrackId(long l) {
            this.track_id = l;
        }

        public long getTrackId() {
            return this.track_id;
        }
    }

    public static class Track {
        private Color color = new Color();

        public void setColor(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

