/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.CoordinateSystem;
import com.agisoft.metashape.Image;
import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Progress;
import com.agisoft.metashape.Vector;
import java.util.Map;
import java.util.Optional;

public class TiledModel
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TiledModel(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(TiledModel tiledModel) {
        return tiledModel == null ? 0L : tiledModel.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_TiledModel(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public TiledModel(TiledModel tiledModel) {
        this(MetashapeJNI.new_TiledModel(TiledModel.getCPtr(tiledModel), tiledModel), true);
    }

    public int getKey() {
        return MetashapeJNI.TiledModel_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.TiledModel_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setLabel(String string) {
        MetashapeJNI.TiledModel_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.TiledModel_getLabel(this.swigCPtr, this);
    }

    public String getPath() {
        return MetashapeJNI.TiledModel_getPath(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.TiledModel_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.TiledModel_getMeta(this.swigCPtr, this);
    }

    public void setTransform(Matrix matrix) {
        MetashapeJNI.TiledModel_setTransform(this.swigCPtr, this, matrix);
    }

    public Matrix getTransform() {
        return MetashapeJNI.TiledModel_getTransform(this.swigCPtr, this);
    }

    public void setCoordinateSystem(Optional<CoordinateSystem> optional) {
        MetashapeJNI.TiledModel_setCoordinateSystem(this.swigCPtr, this, optional.isPresent() ? CoordinateSystem.getCPtr(optional.get()) : 0L);
    }

    public Optional<CoordinateSystem> getCoordinateSystem() {
        long l = MetashapeJNI.TiledModel_getCoordinateSystem(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new CoordinateSystem(l, true));
    }

    public Optional<Vector> pickPoint(Vector vector, Vector vector2) {
        Vector vector3 = MetashapeJNI.TiledModel_pickPoint(this.swigCPtr, this, vector, vector2);
        return vector3 == null ? Optional.empty() : Optional.of(vector3);
    }

    public Image renderPreview(long l, long l2, Matrix matrix, Progress progress) {
        return new Image(MetashapeJNI.TiledModel_renderPreview(this.swigCPtr, this, l, l2, matrix, progress), true);
    }
}

