/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * Digital elevation model.
 */
public class Elevation implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Elevation(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Elevation obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_Elevation(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public Elevation(Elevation elevation) {
    this(MetashapeJNI.new_Elevation(Elevation.getCPtr(elevation), elevation), true);
  }

  /**
   *  Elevation model identifier.
   */
  public int getKey() {
    return MetashapeJNI.Elevation_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.Elevation_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Elevation model label.
   */
  public void setLabel(String label) {
    MetashapeJNI.Elevation_setLabel(swigCPtr, this, label);
  }

  /**
   *  Elevation model label.
   */
  public String getLabel() {
    return MetashapeJNI.Elevation_getLabel(swigCPtr, this);
  }

  /**
   *  Path to elevation data.
   */
  public String getPath() {
    return MetashapeJNI.Elevation_getPath(swigCPtr, this);
  }

  /**
   *  Elevation model meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.Elevation_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Elevation model meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.Elevation_getMeta(swigCPtr, this); }

  /**
   *  Elevation model width.
   */
  public long getWidth() {
    return MetashapeJNI.Elevation_getWidth(swigCPtr, this);
  }

  /**
   *  Elevation model height.
   */
  public long getHeight() {
    return MetashapeJNI.Elevation_getHeight(swigCPtr, this);
  }

  /**
   *  Coordinates of the top left corner.
   */
  public Vector getTopLeft() { return MetashapeJNI.Elevation_getTopLeft(swigCPtr, this); }

  /**
   *  Coordinates of the bottom right corner.
   */
  public Vector getBottomRight() { return MetashapeJNI.Elevation_getBottomRight(swigCPtr, this); }

  /**
   *  Projection of elevation model.
   */
  public OrthoProjection getProjection() {
    return new OrthoProjection(MetashapeJNI.Elevation_getProjection(swigCPtr, this), true);
  }

  /**
   *  DEM resolution in meters.
   */
  public double getResolution() {
    return MetashapeJNI.Elevation_getResolution(swigCPtr, this);
  }

  /**
   *  Minimum elevation value.
   */
  public float getMinElevation() {
    return MetashapeJNI.Elevation_getMinElevation(swigCPtr, this);
  }

  /**
   *  Maximum elevation value.
   */
  public float getMaxElevation() {
    return MetashapeJNI.Elevation_getMaxElevation(swigCPtr, this);
  }

}
