/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.Color;
import com.agisoft.metashape.Image;
import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Progress;
import com.agisoft.metashape.SwigHelpers;
import com.agisoft.metashape.Vector;
import java.util.Map;
import java.util.Optional;

public class Model
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Model(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Model model) {
        return model == null ? 0L : model.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Model(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Model(Model model) {
        this(MetashapeJNI.new_Model(Model.getCPtr(model), model), true);
    }

    public int getKey() {
        return MetashapeJNI.Model_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.Model_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setLabel(String string) {
        MetashapeJNI.Model_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Model_getLabel(this.swigCPtr, this);
    }

    public Texture[] getTextures() {
        return SwigHelpers.cArrayWrap(MetashapeJNI.Model_getTextures(this.swigCPtr, this), true, Texture.class);
    }

    public Optional<Texture> getActiveTexture(TextureType textureType) {
        long l = MetashapeJNI.Model_getActiveTexture(this.swigCPtr, this, textureType.ordinal());
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Texture(l, true));
    }

    public void setMesh(Optional<Mesh> optional) {
        MetashapeJNI.Model_setMesh(this.swigCPtr, this, optional.isPresent() ? Mesh.getCPtr(optional.get()) : 0L);
    }

    public Optional<Mesh> getMesh() {
        long l = MetashapeJNI.Model_getMesh(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Mesh(l, true));
    }

    public String getPath() {
        return MetashapeJNI.Model_getPath(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.Model_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.Model_getMeta(this.swigCPtr, this);
    }

    public int getFaceCount() {
        return MetashapeJNI.Model_getFaceCount(this.swigCPtr, this);
    }

    public int getVertexCount() {
        return MetashapeJNI.Model_getVertexCount(this.swigCPtr, this);
    }

    public boolean hasUV() {
        return MetashapeJNI.Model_hasUV(this.swigCPtr, this);
    }

    public boolean hasVertexColors() {
        return MetashapeJNI.Model_hasVertexColors(this.swigCPtr, this);
    }

    public boolean hasVertexConfidence() {
        return MetashapeJNI.Model_hasVertexConfidence(this.swigCPtr, this);
    }

    public Optional<Vector> pickPoint(Vector vector, Vector vector2) {
        Vector vector3 = MetashapeJNI.Model_pickPoint(this.swigCPtr, this, vector, vector2);
        return vector3 == null ? Optional.empty() : Optional.of(vector3);
    }

    public Image renderPreview(long l, long l2, Matrix matrix, Progress progress) {
        return new Image(MetashapeJNI.Model_renderPreview(this.swigCPtr, this, l, l2, matrix, progress), true);
    }

    public static enum TextureType {
        DiffuseMap,
        NormalMap,
        OcclusionMap;

    }

    public static class Mesh
    implements AutoCloseable {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Mesh(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Mesh mesh) {
            return mesh == null ? 0L : mesh.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_Model_Mesh(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        @Override
        public void close() {
            this.delete();
        }

        public Mesh() {
            this(MetashapeJNI.new_Model_Mesh__SWIG_0(), true);
        }

        public Mesh(Mesh mesh) {
            this(MetashapeJNI.new_Model_Mesh__SWIG_1(Mesh.getCPtr(mesh), mesh), true);
        }

        public void setFaceCount(int n) {
            MetashapeJNI.Model_Mesh_setFaceCount(this.swigCPtr, this, n);
        }

        public int getFaceCount() {
            return MetashapeJNI.Model_Mesh_getFaceCount(this.swigCPtr, this);
        }

        public void setVertexCount(int n) {
            MetashapeJNI.Model_Mesh_setVertexCount(this.swigCPtr, this, n);
        }

        public int getVertexCount() {
            return MetashapeJNI.Model_Mesh_getVertexCount(this.swigCPtr, this);
        }

        public void setFace(int n, Face face) {
            MetashapeJNI.Model_Mesh_setFace(this.swigCPtr, this, n, face);
        }

        public Face getFace(int n) {
            return MetashapeJNI.Model_Mesh_getFace(this.swigCPtr, this, n);
        }

        public void setVertex(int n, Vertex vertex) {
            MetashapeJNI.Model_Mesh_setVertex(this.swigCPtr, this, n, vertex);
        }

        public Vertex getVertex(int n) {
            return MetashapeJNI.Model_Mesh_getVertex(this.swigCPtr, this, n);
        }

        public void setVertexColor(int n, Color color) {
            MetashapeJNI.Model_Mesh_setVertexColor(this.swigCPtr, this, n, color);
        }

        public Color getVertexColor(int n) {
            return MetashapeJNI.Model_Mesh_getVertexColor(this.swigCPtr, this, n);
        }

        public boolean hasUV() {
            return MetashapeJNI.Model_Mesh_hasUV(this.swigCPtr, this);
        }

        public boolean hasVertexColors() {
            return MetashapeJNI.Model_Mesh_hasVertexColors(this.swigCPtr, this);
        }

        public boolean hasVertexConfidence() {
            return MetashapeJNI.Model_Mesh_hasVertexConfidence(this.swigCPtr, this);
        }
    }

    public static class Texture
    implements AutoCloseable {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected Texture(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(Texture texture) {
            return texture == null ? 0L : texture.swigCPtr;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    MetashapeJNI.delete_Model_Texture(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        @Override
        public void close() {
            this.delete();
        }

        public int getKey() {
            return MetashapeJNI.Model_Texture_getKey(this.swigCPtr, this);
        }

        public TextureType getTextureType() {
            return ((TextureType[])TextureType.class.getEnumConstants())[MetashapeJNI.Model_Texture_getTextureType(this.swigCPtr, this)];
        }

        public void setLabel(String string) {
            MetashapeJNI.Model_Texture_setLabel(this.swigCPtr, this, string);
        }

        public String getLabel() {
            return MetashapeJNI.Model_Texture_getLabel(this.swigCPtr, this);
        }

        public void setMeta(Map<String, String> map) {
            MetashapeJNI.Model_Texture_setMeta(this.swigCPtr, this, map);
        }

        public Map<String, String> getMeta() {
            return MetashapeJNI.Model_Texture_getMeta(this.swigCPtr, this);
        }
    }

    public static class TexVertex {
        private Vector coord = new Vector(0.0, 0.0);

        public void setCoord(Vector vector) {
            this.coord = vector;
        }

        public Vector getCoord() {
            return this.coord;
        }
    }

    public static class TexFace {
        private int[] vertices = new int[3];
        private int texture_id = 0;

        public void setTextureIndex(int n) {
            this.texture_id = n;
        }

        public int getTextureIndex() {
            return this.texture_id;
        }

        public void setVertices(int[] nArray) {
            this.vertices = nArray;
        }

        public int[] getVertices() {
            return this.vertices;
        }
    }

    public static class Vertex {
        private Vector coord = new Vector(0.0, 0.0);
        private float confidence = 0.0f;

        public void setCoord(Vector vector) {
            this.coord = vector;
        }

        public Vector getCoord() {
            return this.coord;
        }

        public void setConfidence(float f) {
            this.confidence = f;
        }

        public float getConfidence() {
            return this.confidence;
        }
    }

    public static class Face {
        private int[] vertices = new int[3];
        private boolean selected = false;
        private boolean hidden = false;

        public void setHidden(boolean bl) {
            this.hidden = bl;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setSelected(boolean bl) {
            this.selected = bl;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setVertices(int[] nArray) {
            this.vertices = nArray;
        }

        public int[] getVertices() {
            return this.vertices;
        }
    }
}

