/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

public class Marker implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Marker(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Marker obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_Marker(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  static public class Reference {

    private Optional<Vector> location;
    private Optional<Vector> location_accuracy;
    private boolean enabled;

    public Reference() {
      location = Optional.empty();
      location_accuracy = Optional.empty();
      enabled = false;
    }

    /**
     *  Enabled flag.
     */
    public void setEnabled(boolean state) {
      enabled = state;
    }

    /**
     *  Enabled flag.
     */
    public boolean isEnabled() {
      return enabled;
    }

    /**
     *  Marker coordinates, may be null.
     */
    public void setLocation(Optional<Vector> location) {
      this.location = location;
    }

    /**
     *  Marker coordinates, may be null
     */
    public Optional<Vector> getLocation() {
      return location;
    }

    /**
     *  Marker location accuracy, may be null.
     */
    public void setLocationAccuracy(Optional<Vector> accuracy) {
      location_accuracy = accuracy;
    }

    /**
     *  Marker location accuracy, may be null.
     */
    public Optional<Vector> getLocationAccuracy() {
      return location_accuracy;
    }

  }

  static public class Projection {

    private Optional<Vector> point;
    private boolean pinned;

    public Projection() {
      point = Optional.empty();
      pinned = false;
    }

    public void setPoint(Optional<Vector> point) {
      this.point = point;
    }

    public Optional<Vector> getPoint() {
      return point;
    }

    public void setPinned(boolean pinned) {
      this.pinned = pinned;
    }

    public boolean isPinned() {
      return pinned;
    }

  }

  public Marker(Marker marker) {
    this(MetashapeJNI.new_Marker(Marker.getCPtr(marker), marker), true);
  }

  /**
   *  Marker identifier.
   */
  public int getKey() {
    return MetashapeJNI.Marker_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.Marker_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Marker type.
   */
  public void setType(Marker.Type type) {
    MetashapeJNI.Marker_setType(swigCPtr, this, type.ordinal());
  }

  /**
   *  Marker type.
   */
  public Marker.Type getType() {
    return Marker.Type.class.getEnumConstants()[MetashapeJNI.Marker_getType(swigCPtr, this)];
  }

  /**
   *  Marker label.
   */
  public void setLabel(String label) {
    MetashapeJNI.Marker_setLabel(swigCPtr, this, label);
  }

  /**
   *  Marker label.
   */
  public String getLabel() {
    return MetashapeJNI.Marker_getLabel(swigCPtr, this);
  }

  /**
   *  Enables/disables the marker.
   */
  public void setEnabled(boolean state) {
    MetashapeJNI.Marker_setEnabled(swigCPtr, this, state);
  }

  /**
   *  Enables/disables the marker.
   */
  public boolean isEnabled() {
    return MetashapeJNI.Marker_isEnabled(swigCPtr, this);
  }

  /**
   *  Selects/deselects the marker.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.Marker_setSelected(swigCPtr, this, state);
  }

  /**
   *  Selects/deselects the marker.
   */
  public boolean isSelected() {
    return MetashapeJNI.Marker_isSelected(swigCPtr, this);
  }

  /**
   * Set marker projection.<br>
   * @param camera Camera key.<br>
   * @param projection Image coordinates, may be null.
   */
  public void setProjection(int camera, Optional<Marker.Projection> projection) {
    MetashapeJNI.Marker_setProjection(swigCPtr, this, camera, projection.isPresent() ? projection.get() : null);
  }

  /**
   * Get marker projection.<br>
   * @param camera Camera key.<br>
   * @return Image coordinates, may be null.
   */
  public Optional<Marker.Projection> getProjection(int camera) {
	Marker.Projection values = MetashapeJNI.Marker_getProjection(swigCPtr, this, camera);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   *  Marker position in the current frame, may be null.
   */
  public Optional<Vector> getPosition() {
	Vector values = MetashapeJNI.Marker_getPosition(swigCPtr, this);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   *  List of camera keys containing marker projections.
   */
  public int[] getCameraKeys() { return MetashapeJNI.Marker_getCameraKeys(swigCPtr, this); }

  /**
   *  Marker reference data.
   */
  public Marker.Reference getReference() { return MetashapeJNI.Marker_getReference(swigCPtr, this); }

  /**
   *  Marker reference data.
   */
  public void setReference(Marker.Reference reference) {
    MetashapeJNI.Marker_setReference(swigCPtr, this, reference);
  }

  /**
   *  Marker meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.Marker_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Marker meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.Marker_getMeta(swigCPtr, this); }

  public enum Type {
    TypeRegular,
    TypeInternal,
    TypeFiducial;
  }

}
