/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * NetworkClient class provides access to the network processing server and allows<br>
 * to create and manage tasks.
 */
public class NetworkClient implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected NetworkClient(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(NetworkClient obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_NetworkClient(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  static public class LogRecord {

    private int type;
    private String text;

    public void setType(int type) {
      this.type = type;
    }

    public int getType() {
      return this.type;
    }

    public void setText(String text) {
      this.text = text;
    }

    public String getText() {
      return text;
    }

  }

  static public class ResourceRecord {

    private double time;
    private double ram_usage;
    private double cpu_usage;

    public void setTime(double value) {
      this.time = value;
    }

    public double getTime() {
      return time;
    }

    public void setRamUsage(double value) {
      this.ram_usage = value;
    }

    public double getRamUsage() {
      return ram_usage;
    }

    public void setCpuUsage(double value) {
      this.cpu_usage = value;
    }

    public double getCpuUsage() {
      return cpu_usage;
    }

  }

  static public class ServerInfo {

    private long time_started;
    private String version;

    public void setTimeStarted(long value) {
      this.time_started = value;
    }

    public long getTimeStarted() {
      return time_started;
    }

    public void setVersion(String value) {
      this.version = value;
    }

    public String getVersion() {
      return version;
    }

  }

  static public class ServerStatus {

    private double ram_size;
    private String master_hostaddr;
    private int slave_count;
    private int scheduling_mode;
    private long next_revision;
    private NetworkClient.LogRecord[] log;
    private NetworkClient.ResourceRecord[] resource_usage;

    public void setRamSize(double value) {
      this.ram_size = value;
    }

    public double getRamSize() {
      return ram_size;
    }

    public void setMasterHostaddr(String value) {
      this.master_hostaddr = value;
    }

    public String getMasterHostaddr() {
      return master_hostaddr;
    }

    public void setSlaveCount(int value) {
      this.slave_count = value;
    }

    public int getSlaveCount() {
      return slave_count;
    }

    public void setSchedulingMode(int value) {
      this.scheduling_mode = value;
    }

    public int getSchedulingMode() {
      return scheduling_mode;
    }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

    public void setLog(NetworkClient.LogRecord[] value) {
      this.log = value;
    }

    public NetworkClient.LogRecord[] getLog() { return log; }

    public void setResourceUsage(NetworkClient.ResourceRecord[] value) {
      this.resource_usage = value;
    }

    public NetworkClient.ResourceRecord[] getResourceUsage() { return resource_usage; }

  }

  static public class TaskStatus {

    private NetworkTask task;
    private NetworkClient.Status status;
    private double progress;
    private double time_elapsed;
    private double time_left;
    private double processing_time;
    private int items_total;
    private int items_done;
    private int workitems_waiting;
    private int workitems_working;
    private int workitems_completed;
    private int workitems_failed;
    private NetworkClient.LogRecord[] log;

    public void update(NetworkClient.TaskStatus update) {
      this.task = update.task;
      this.status = update.status;
      this.progress = update.progress;
      this.time_elapsed = update.time_elapsed;
      this.time_left = update.time_left;
      this.processing_time = update.processing_time;
      this.items_total = update.items_total;
      this.items_done = update.items_done;
      this.workitems_waiting = update.workitems_waiting;
      this.workitems_working = update.workitems_working;
      this.workitems_completed = update.workitems_completed;
      this.workitems_failed = update.workitems_failed;

      NetworkClient.LogRecord[] new_log = new NetworkClient.LogRecord[this.log.length + update.log.length];
      for (int k = 0; k < this.log.length; k++)
        new_log[k] = this.log[k];
      for (int k = 0; k < update.log.length; k++)
        new_log[this.log.length + k] = update.log[k];
      this.log = new_log;
    }

    public void setTask(NetworkTask value) {
      this.task = value;
    }

    public NetworkTask getTask() { return this.task; }

    public void setStatus(NetworkClient.Status value) {
      this.status = value;
    }

    public NetworkClient.Status getStatus() {
      return this.status;
    }

    public void setProgress(double value) {
      this.progress = value;
    }

    public double getProgress() {
      return progress;
    }

    public void setTimeElapsed(double value) {
      this.time_elapsed = value;
    }

    public double getTimeElapsed() {
      return time_elapsed;
    }

    public void setTimeLeft(double value) {
      this.time_left = value;
    }

    public double getTimeLeft() {
      return time_left;
    }

    public void setProcessingTime(double value) {
      this.processing_time = value;
    }

    public double getProcessingTime() {
      return processing_time;
    }

    public void setItemsTotal(int value) {
      this.items_total = value;
    }

    public int getItemsTotal() {
      return items_total;
    }

    public void setItemsDone(int value) {
      this.items_done = value;
    }

    public int getItemsDone() {
      return items_done;
    }

    public void setWorkitemsWaiting(int value) {
      this.workitems_waiting = value;
    }

    public int getWorkitemsWaiting() {
      return workitems_waiting;
    }

    public void setWorkitemsWorking(int value) {
      this.workitems_working = value;
    }

    public int getWorkitemsWorking() {
      return workitems_working;
    }

    public void setWorkitemsCompleted(int value) {
      this.workitems_completed = value;
    }

    public int getWorkitemsCompleted() {
      return workitems_completed;
    }

    public void setWorkitemsFailed(int value) {
      this.workitems_failed = value;
    }

    public int getWorkitemsFailed() {
      return workitems_failed;
    }

    public void setLog(NetworkClient.LogRecord[] value) {
      this.log = value;
    }

    public NetworkClient.LogRecord[] getLog() { return log; }

  }

  static public class BatchStatus {

    private String path;
    private String uuid;
    private Map<String, String> meta;
    private NetworkClient.Status status;
    private boolean paused;
    private int priority;
    private int node_limit;
    private long time_started;
    private long time_finished;
    private NetworkClient.TaskStatus[] tasks;
    private long error_time;
    private long error_node_id;
    private String error_message;
    private long next_revision;

    public void update(NetworkClient.BatchStatus update) {
      this.path = update.path;
      this.uuid = update.uuid;
      this.meta = update.meta;
      this.status = update.status;
      this.paused = update.paused;
      this.priority = update.priority;
      this.time_started = update.time_started;
      this.time_finished = update.time_finished;
      this.error_time = update.error_time;
      this.error_node_id = update.error_node_id;
      this.error_message = update.error_message;
      this.next_revision = update.next_revision;

      NetworkClient.TaskStatus[] new_tasks = new NetworkClient.TaskStatus[update.tasks.length];
      for (int k = 0; k < update.tasks.length; k++) {
        if (k < this.tasks.length) {
          new_tasks[k] = this.tasks[k];
          new_tasks[k].update(update.tasks[k]);
        } else {
          new_tasks[k] = update.tasks[k];
        }
      }
      this.tasks = new_tasks;
    }

    public void setPath(String value) {
      this.path = value;
    }

    public String getPath() {
      return path;
    }

    public void setUuid(String value) {
      this.uuid = value;
    }

    public String getUuid() {
      return uuid;
    }

    public void setMeta(Map<String, String> value) {
      this.meta = value;
    }

    public Map<String, String> getMeta() { return meta; }

    public void setStatus(NetworkClient.Status value) {
      this.status = value;
    }

    public NetworkClient.Status getStatus() {
      return status;
    }

    public void setPaused(boolean value) {
      this.paused = value;
    }

    public boolean getPaused() {
      return paused;
    }

    public void setPriority(int value) {
      this.priority = value;
    }

    public int getPriority() {
      return priority;
    }

    public void setNodeLimit(int value) {
      this.node_limit = value;
    }

    public int getNodeLimit() {
      return node_limit;
    }

    public void setTimeStarted(long value) {
      this.time_started = value;
    }

    public long getTimeStarted() {
      return time_started;
    }

    public void setTimeFinished(long value) {
      this.time_finished = value;
    }

    public long getTimeFinished() {
      return time_finished;
    }

    public void setTasks(NetworkClient.TaskStatus[] value) {
      this.tasks = value;
    }

    public NetworkClient.TaskStatus[] getTasks() { return tasks; }

    public void setErrorTime(long value) {
      this.error_time = value;
    }

    public long getErrorTime() {
      return error_time;
    }

    public void setErrorNodeId(long value) {
      this.error_node_id = value;
    }

    public long getErrorNodeId() {
      return error_node_id;
    }

    public void setErrorMessage(String value) {
      this.error_message = value;
    }

    public String getErrorMessage() {
      return error_message;
    }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

  }

  static public class BatchItem {

    private long batch_id;
    private String path;
    private String uuid;
    private Map<String, String> meta;
    private NetworkClient.Status status;
    private boolean paused;
    private int priority;
    private int node_limit;
    private String node_version;
    private long time_started;
    private long time_finished;
    private NetworkClient.TaskStatus task;

    public void setBatchId(long value) {
      this.batch_id = value;
    }

    public long getBatchId() {
      return batch_id;
    }

    public void setPath(String value) {
      this.path = value;
    }

    public String getPath() {
      return path;
    }

    public void setUuid(String value) {
      this.uuid = value;
    }

    public String getUuid() {
      return uuid;
    }

    public void setMeta(Map<String, String> value) {
      this.meta = value;
    }

    public Map<String, String> getMeta() { return meta; }

    public void setStatus(NetworkClient.Status value) {
      this.status = value;
    }

    public NetworkClient.Status getStatus() {
      return status;
    }

    public void setPaused(boolean value) {
      this.paused = value;
    }

    public boolean getPaused() {
      return paused;
    }

    public void setPriority(int value) {
      this.priority = value;
    }

    public int getPriority() {
      return priority;
    }

    public void setNodeLimit(int value) {
      this.node_limit = value;
    }

    public int getNodeLimit() {
      return node_limit;
    }

    public void setNodeVersion(String value) {
      this.node_version = value;
    }

    public String getNodeVersion() {
      return node_version;
    }

    public void setTimeStarted(long value) {
      this.time_started = value;
    }

    public long getTimeStarted() {
      return time_started;
    }

    public void setTimeFinished(long value) {
      this.time_finished = value;
    }

    public long getTimeFinished() {
      return time_finished;
    }

    public void setTask(NetworkClient.TaskStatus value) {
      this.task = value;
    }

    public NetworkClient.TaskStatus getTask() {
      return task;
    }

  }

  static public class NodeStatus {

    private String uuid;
    private String hostname;
    private String hostaddr;
    private double ram_size;
    private long gpu_mask;
    private boolean cpu_enable;
    private long next_revision;
    private NetworkClient.LogRecord[] log;
    private NetworkClient.ResourceRecord[] resource_usage;

    public void setUuid(String value) {
      this.uuid = value;
    }

    public String getUuid() {
      return uuid;
    }

    public void setHostname(String value) {
      this.hostname = value;
    }

    public String getHostname() {
      return hostname;
    }

    public void setHostaddr(String value) {
      this.hostaddr = value;
    }

    public String getHostaddr() {
      return hostaddr;
    }

    public void setRamSize(double value) {
      this.ram_size = value;
    }

    public double getRamSize() {
      return ram_size;
    }

    public void setGpuMask(long value) {
      this.gpu_mask = value;
    }

    public long getGpuMask() {
      return gpu_mask;
    }

    public void setCpuEnable(boolean value) {
      this.cpu_enable = value;
    }

    public boolean getCpuEnable() {
      return cpu_enable;
    }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

    public void setLog(NetworkClient.LogRecord[] value) {
      this.log = value;
    }

    public NetworkClient.LogRecord[] getLog() { return log; }

    public void setResourceUsage(NetworkClient.ResourceRecord[] value) {
      this.resource_usage = value;
    }

    public NetworkClient.ResourceRecord[] getResourceUsage() { return resource_usage; }

  }

  static public class NodeItem {

    private String uuid;
    private String hostaddr;
    private String hostname;
    private long node_id;
    private String version;
    private NetworkClient.Status status;
    private boolean paused;
    private int priority;
    private long time_connected;
    private long time_disconnected;
    private int capability;
    private double ram_size;
    private long gpu_mask;
    private boolean cpu_enable;
    private long batch_id;
    private double progress;
    private NetworkTask task;
    private long error_count;
    private long error_time;
    private long error_batch_id;
    private String error_message;
    private NetworkClient.ResourceRecord resource_usage;

    public void setUuid(String value) {
      this.uuid = value;
    }

    public String getUuid() {
      return uuid;
    }

    public void setHostaddr(String value) {
      this.hostaddr = value;
    }

    public String getHostaddr() {
      return hostaddr;
    }

    public void setHostname(String value) {
      this.hostname = value;
    }

    public String getHostname() {
      return hostname;
    }

    public void setNodeId(long value) {
      this.node_id = value;
    }

    public long getNodeId() {
      return node_id;
    }

    public void setVersion(String value) {
      this.version = value;
    }

    public String getVersion() {
      return version;
    }

    public void setStatus(NetworkClient.Status value) {
      this.status = value;
    }

    public NetworkClient.Status getStatus() {
      return status;
    }

    public void setPaused(boolean value) {
      this.paused = value;
    }

    public boolean getPaused() {
      return paused;
    }

    public void setPriority(int value) {
      this.priority = value;
    }

    public int getPriority() {
      return priority;
    }

    public void setTimeConnected(long value) {
      this.time_connected = value;
    }

    public long getTimeConnected() {
      return time_connected;
    }

    public void setTimeDisconnected(long value) {
      this.time_disconnected = value;
    }

    public long getTimeDisconnected() {
      return time_disconnected;
    }

    public void setCapability(int value) {
      this.capability = value;
    }

    public int getCapability() {
      return capability;
    }

    public void setRamSize(double value) {
      this.ram_size = value;
    }

    public double getRamSize() {
      return ram_size;
    }

    public void setGpuMask(long value) {
      this.gpu_mask = value;
    }

    public long getGpuMask() {
      return gpu_mask;
    }

    public void setCpuEnable(boolean value) {
      this.cpu_enable = value;
    }

    public boolean getCpuEnable() {
      return cpu_enable;
    }

    public void setBatchId(long value) {
      this.batch_id = value;
    }

    public long getBatchId() {
      return batch_id;
    }

    public void setProgress(double value) {
      this.progress = value;
    }

    public double getProgress() {
      return progress;
    }

    public void setTask(NetworkTask value) {
      this.task = value;
    }

    public NetworkTask getTask() { return task; }

    public void setErrorCount(long value) {
      this.error_count = value;
    }

    public long getErrorCount() {
      return error_count;
    }

    public void setErrorTime(long value) {
      this.error_time = value;
    }

    public long getErrorTime() {
      return error_time;
    }

    public void setErrorBatchId(long value) {
      this.error_batch_id = value;
    }

    public long getErrorBatchId() {
      return error_batch_id;
    }

    public void setErrorMessage(String value) {
      this.error_message = value;
    }

    public String getErrorMessage() {
      return error_message;
    }

    public void setResourceUsage(NetworkClient.ResourceRecord value) {
      this.resource_usage = value;
    }

    public NetworkClient.ResourceRecord getResourceUsage() { return resource_usage; }

  }

  static public class BatchList {

    private NetworkClient.BatchItem[] items;
    private long next_revision;

    public void update(NetworkClient.BatchList update) {
      Map<Long, Integer> map = new HashMap<Long, Integer>();
      for (int k = 0; k < items.length; k++)
        map.put(items[k].getBatchId(), k);

      List<NetworkClient.BatchItem> items = Arrays.asList(this.items);
      for (int k = 0; k < update.items.length; k++) {
        long batch_id = update.getItems()[k].getBatchId();
        if (map.containsKey(batch_id))
            items.set(map.get(batch_id), update.items[k]); else
            items.add(update.items[k]);
      }
      this.items = items.toArray(new NetworkClient.BatchItem[0]);
      next_revision = update.next_revision;
    }

    public void setItems(NetworkClient.BatchItem[] value) {
      this.items = value;
    }

    public NetworkClient.BatchItem[] getItems() { return items; }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

  }

  static public class NodeList {

    private NetworkClient.NodeItem[] items;
    private long next_revision;

    public void update(NetworkClient.NodeList update) {
      Map<Long, Integer> map = new HashMap<Long, Integer>();
      for (int k = 0; k < items.length; k++)
        map.put(items[k].getNodeId(), k);

      List<NetworkClient.NodeItem> items = Arrays.asList(this.items);
      for (int k = 0; k < update.items.length; k++) {
        long node_id = update.getItems()[k].getNodeId();
        if (map.containsKey(node_id))
            items.set(map.get(node_id), update.items[k]); else
            items.add(update.items[k]);
      }
      this.items = items.toArray(new NetworkClient.NodeItem[0]);
      next_revision = update.next_revision;
    }

    public void setItems(NetworkClient.NodeItem[] value) {
      this.items = value;
    }

    public NetworkClient.NodeItem[] getItems() { return items; }

    public void setNextRevision(long value) {
      this.next_revision = value;
    }

    public long getNextRevision() {
      return next_revision;
    }

  }

  public NetworkClient() {
    this(MetashapeJNI.new_NetworkClient(), true);
  }

  /**
   * Connect to the server.<br>
   * @param host Server hostname.<br>
   * @param port Communication port.
   */
  public boolean connect(String host, int port) {
    return MetashapeJNI.NetworkClient_connect(swigCPtr, this, host, port);
  }

  /**
   * Disconnect from the server.
   */
  public void disconnect() {
    MetashapeJNI.NetworkClient_disconnect(swigCPtr, this);
  }

  /**
   * Create new batch.<br>
   * @param path Project path relative to root folder.<br>
   * @param tasks List of processing tasks to execute.<br>
   * @param meta Batch metadata.<br>
   * @return Batch id.
   */
  public int createBatch(String path, NetworkTask[] tasks, Map<String,String> meta) {
    return MetashapeJNI.NetworkClient_createBatch(swigCPtr, this, path, tasks, meta);
  }

  /**
   * Get batch id based on project path.<br>
   * @param path Project path relative to root folder.<br>
   * @return Batch id.
   */
  public int findBatch(String path) {
    return MetashapeJNI.NetworkClient_findBatch(swigCPtr, this, path);
  }

  /**
   * Abort batch.<br>
   * @param batch_id Batch id.
   */
  public void abortBatch(int batch_id) {
    MetashapeJNI.NetworkClient_abortBatch(swigCPtr, this, batch_id);
  }

  /**
   * Set batch paused state.<br>
   * @param batch_id Batch id.<br>
   * @param paused Paused state.
   */
  public void setBatchPaused(int batch_id, boolean paused) {
    MetashapeJNI.NetworkClient_setBatchPaused(swigCPtr, this, batch_id, paused);
  }

  /**
   * Set batch priority.<br>
   * @param batch_id Batch id.<br>
   * @param priority Batch priority (2 - Highest, 1 - High, 0 - Normal, -1 - Low, -2 - Lowest).
   */
  public void setBatchPriority(int batch_id, int priority) {
    MetashapeJNI.NetworkClient_setBatchPriority(swigCPtr, this, batch_id, priority);
  }

  /**
   * Set node limit of the batch.<br>
   * @param batch_id Batch id.<br>
   * @param node_limit Node limit of the batch (0 - unlimited).
   */
  public void setBatchNodeLimit(int batch_id, int node_limit) {
    MetashapeJNI.NetworkClient_setBatchNodeLimit(swigCPtr, this, batch_id, node_limit);
  }

  /**
   * Abort node.<br>
   * @param node_id Node id.
   */
  public void abortNode(int node_id) {
    MetashapeJNI.NetworkClient_abortNode(swigCPtr, this, node_id);
  }

  /**
   * Quit node.<br>
   * @param node_id Node id.
   */
  public void quitNode(int node_id) {
    MetashapeJNI.NetworkClient_quitNode(swigCPtr, this, node_id);
  }

  /**
   * Set node paused state.<br>
   * @param node_id Node id.<br>
   * @param paused Paused state.
   */
  public void setNodePaused(int node_id, boolean paused) {
    MetashapeJNI.NetworkClient_setNodePaused(swigCPtr, this, node_id, paused);
  }

  /**
   * Set node priority.<br>
   * @param node_id Node id.<br>
   * @param priority Node priority (2 - Highest, 1 - High, 0 - Normal, -1 - Low, -2 - Lowest).
   */
  public void setNodePriority(int node_id, int priority) {
    MetashapeJNI.NetworkClient_setNodePriority(swigCPtr, this, node_id, priority);
  }

  /**
   * Set node capability.<br>
   * @param node_id Node id.<br>
   * @param capability Node capability (1 - CPU, 2 - GPU, 3 - Any).
   */
  public void setNodeCapability(int node_id, int capability) {
    MetashapeJNI.NetworkClient_setNodeCapability(swigCPtr, this, node_id, capability);
  }

  /**
   * Set node GPU mask.<br>
   * @param node_id Node id.<br>
   * @param gpu_mask GPU device mask.
   */
  public void setNodeGPUMask(int node_id, long gpu_mask) {
    MetashapeJNI.NetworkClient_setNodeGPUMask(swigCPtr, this, node_id, gpu_mask);
  }

  /**
   * Set node CPU enable flag.<br>
   * @param node_id Node id.<br>
   * @param cpu_enable CPU enable flag.
   */
  public void setNodeCPUEnable(int node_id, boolean cpu_enable) {
    MetashapeJNI.NetworkClient_setNodeCPUEnable(swigCPtr, this, node_id, cpu_enable);
  }

  /**
   * Get server information.
   */
  public NetworkClient.ServerInfo getServerInfo() { return MetashapeJNI.NetworkClient_getServerInfo(swigCPtr, this); }

  /**
   * Get server status.<br>
   * @param revision First revision to get.<br>
   * @return Server status.
   */
  public NetworkClient.ServerStatus getServerStatus(long revision) { return MetashapeJNI.NetworkClient_getServerStatus(swigCPtr, this, revision); }

  /**
   * Set master server.
   */
  public void setMasterServer(String hostname) {
    MetashapeJNI.NetworkClient_setMasterServer(swigCPtr, this, hostname);
  }

  /**
   * Get batch status.<br>
   * @param batch_id Batch id.<br>
   * @param revision First revision to get.<br>
   * @return Batch status.
   */
  public NetworkClient.BatchStatus getBatchStatus(int batch_id, long revision) { return MetashapeJNI.NetworkClient_getBatchStatus(swigCPtr, this, batch_id, revision); }

  /**
   * Get node status.<br>
   * @param node_id Node id.<br>
   * @param revision First revision to get.<br>
   * @return Node status.
   */
  public NetworkClient.NodeStatus getNodeStatus(int node_id, long revision) { return MetashapeJNI.NetworkClient_getNodeStatus(swigCPtr, this, node_id, revision); }

  /**
   * Get list of batches.<br>
   * @param revision First revision to get.<br>
   * @return List of batches.
   */
  public NetworkClient.BatchList getBatchList(long revision) { return MetashapeJNI.NetworkClient_getBatchList(swigCPtr, this, revision); }

  /**
   * Get list of nodes.<br>
   * @param revision: First revision to get.<br>
   * @return List of nodes.
   */
  public NetworkClient.NodeList getNodeList(long revision) { return MetashapeJNI.NetworkClient_getNodeList(swigCPtr, this, revision); }

  /**
   * Dump current state of batches.<br>
   * <br>
   * @return Batches data.
   */
  public String dumpBatches(int[] keys) {
    return MetashapeJNI.NetworkClient_dumpBatches(swigCPtr, this, keys);
  }

  /**
   * Load batches from dump.<br>
   * @param data Batches data.
   */
  public void loadBatches(String data) {
    MetashapeJNI.NetworkClient_loadBatches(swigCPtr, this, data);
  }

  public enum Status {
    StatusPending,
    StatusInProgress,
    StatusCompleted,
    StatusAborted,
    StatusReady,
    StatusOffline;
  }

}
