/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.MetashapeJNI;
import java.util.Optional;

public class CameraGroup
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CameraGroup(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(CameraGroup cameraGroup) {
        return cameraGroup == null ? 0L : cameraGroup.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_CameraGroup(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public CameraGroup(CameraGroup cameraGroup) {
        this(MetashapeJNI.new_CameraGroup(CameraGroup.getCPtr(cameraGroup), cameraGroup), true);
    }

    public int getKey() {
        return MetashapeJNI.CameraGroup_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.CameraGroup_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setGroupType(GroupType groupType) {
        MetashapeJNI.CameraGroup_setGroupType(this.swigCPtr, this, groupType.ordinal());
    }

    public GroupType getGroupType() {
        return ((GroupType[])GroupType.class.getEnumConstants())[MetashapeJNI.CameraGroup_getGroupType(this.swigCPtr, this)];
    }

    public void setLabel(String string) {
        MetashapeJNI.CameraGroup_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.CameraGroup_getLabel(this.swigCPtr, this);
    }

    public void setSelected(boolean bl) {
        MetashapeJNI.CameraGroup_setSelected(this.swigCPtr, this, bl);
    }

    public boolean isSelected() {
        return MetashapeJNI.CameraGroup_isSelected(this.swigCPtr, this);
    }

    public static enum GroupType {
        GroupTypeFolder,
        GroupTypeStation;

    }
}

