/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Document;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.NetworkTask;
import com.agisoft.metashape.Progress;

public class CloudClient
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected CloudClient(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(CloudClient cloudClient) {
        return cloudClient == null ? 0L : cloudClient.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_CloudClient(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public void setUsername(String string) {
        MetashapeJNI.CloudClient_setUsername(this.swigCPtr, this, string);
    }

    public String getUsername() {
        return MetashapeJNI.CloudClient_getUsername(this.swigCPtr, this);
    }

    public void setPassword(String string) {
        MetashapeJNI.CloudClient_setPassword(this.swigCPtr, this, string);
    }

    public String getPassword() {
        return MetashapeJNI.CloudClient_getPassword(this.swigCPtr, this);
    }

    public void setClientId(String string) {
        MetashapeJNI.CloudClient_setClientId(this.swigCPtr, this, string);
    }

    public String getClientId() {
        return MetashapeJNI.CloudClient_getClientId(this.swigCPtr, this);
    }

    public void setClientSecret(String string) {
        MetashapeJNI.CloudClient_setClientSecret(this.swigCPtr, this, string);
    }

    public String getClientSecret() {
        return MetashapeJNI.CloudClient_getClientSecret(this.swigCPtr, this);
    }

    public void uploadProject(Document document, Progress progress) {
        MetashapeJNI.CloudClient_uploadProject(this.swigCPtr, this, Document.getCPtr(document), document, progress);
    }

    public void downloadProject(Document document, Progress progress) {
        MetashapeJNI.CloudClient_downloadProject(this.swigCPtr, this, Document.getCPtr(document), document, progress);
    }

    public void processProject(Document document, NetworkTask[] networkTaskArray) {
        MetashapeJNI.CloudClient_processProject(this.swigCPtr, this, Document.getCPtr(document), document, networkTaskArray);
    }

    public ProcessingStatus getProcessingStatus(Document document) {
        return MetashapeJNI.CloudClient_getProcessingStatus(this.swigCPtr, this, Document.getCPtr(document), document);
    }

    public void abortProcessing(Document document) {
        MetashapeJNI.CloudClient_abortProcessing(this.swigCPtr, this, Document.getCPtr(document), document);
    }

    public ProjectInfo[] getProjectList() {
        return MetashapeJNI.CloudClient_getProjectList(this.swigCPtr, this);
    }

    public CloudClient() {
        this(MetashapeJNI.new_CloudClient(), true);
    }

    public static class ProjectInfo {
        private String project_id;
        private String project_name;
        private String creation_date;
        private long project_size;
        private long photos_size;
        private boolean shared_with_me;

        public void setProjectId(String string) {
            this.project_id = string;
        }

        public String getProjectId() {
            return this.project_id;
        }

        public void setProjectName(String string) {
            this.project_name = string;
        }

        public String getProjectName() {
            return this.project_name;
        }

        public void setCreationDate(String string) {
            this.creation_date = string;
        }

        public String getCreationDate() {
            return this.creation_date;
        }

        public void setProjectSize(long l) {
            this.project_size = l;
        }

        public long getProjectSize() {
            return this.project_size;
        }

        public void setPhotosSize(long l) {
            this.photos_size = l;
        }

        public long getPhotosSize() {
            return this.photos_size;
        }

        public void setSharedWithMe(boolean bl) {
            this.shared_with_me = bl;
        }

        public boolean getSharedWithMe() {
            return this.shared_with_me;
        }
    }

    public static class ProcessingStatus {
        private String status;
        private double progress;
        private String error;

        public void setStatus(String string) {
            this.status = string;
        }

        public String getStatus() {
            return this.status;
        }

        public void setProgress(double d) {
            this.progress = d;
        }

        public double getProgress() {
            return this.progress;
        }

        public void setError(String string) {
            this.error = string;
        }

        public String getError() {
            return this.error;
        }
    }
}

