/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.CoordinateSystem;
import com.agisoft.metashape.Image;
import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Progress;
import com.agisoft.metashape.Vector;
import java.util.Map;
import java.util.Optional;

public class PointCloud
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected PointCloud(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(PointCloud pointCloud) {
        return pointCloud == null ? 0L : pointCloud.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_PointCloud(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public PointCloud(PointCloud pointCloud) {
        this(MetashapeJNI.new_PointCloud(PointCloud.getCPtr(pointCloud), pointCloud), true);
    }

    public int getKey() {
        return MetashapeJNI.PointCloud_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.PointCloud_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setLabel(String string) {
        MetashapeJNI.PointCloud_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.PointCloud_getLabel(this.swigCPtr, this);
    }

    public String getPath() {
        return MetashapeJNI.PointCloud_getPath(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.PointCloud_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.PointCloud_getMeta(this.swigCPtr, this);
    }

    public void setTransform(Matrix matrix) {
        MetashapeJNI.PointCloud_setTransform(this.swigCPtr, this, matrix);
    }

    public Matrix getTransform() {
        return MetashapeJNI.PointCloud_getTransform(this.swigCPtr, this);
    }

    public void setCoordinateSystem(CoordinateSystem coordinateSystem) {
        MetashapeJNI.PointCloud_setCoordinateSystem(this.swigCPtr, this, coordinateSystem == null ? 0L : CoordinateSystem.getCPtr(coordinateSystem), coordinateSystem);
    }

    public Optional<CoordinateSystem> getCoordinateSystem() {
        long l = MetashapeJNI.PointCloud_getCoordinateSystem(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new CoordinateSystem(l, true));
    }

    public Optional<Vector> pickPoint(Vector vector, Vector vector2) {
        Vector vector3 = MetashapeJNI.PointCloud_pickPoint(this.swigCPtr, this, vector, vector2);
        return vector3 == null ? Optional.empty() : Optional.of(vector3);
    }

    public void compactPoints(Progress progress) {
        MetashapeJNI.PointCloud_compactPoints(this.swigCPtr, this, progress);
    }

    public void removePoints(int[] nArray, Progress progress) {
        MetashapeJNI.PointCloud_removePoints(this.swigCPtr, this, nArray, progress);
    }

    public void restorePoints(int[] nArray, Progress progress) {
        MetashapeJNI.PointCloud_restorePoints(this.swigCPtr, this, nArray, progress);
    }

    public void assignClass(int n, int[] nArray, Progress progress) {
        MetashapeJNI.PointCloud_assignClass(this.swigCPtr, this, n, nArray, progress);
    }

    public Image renderPreview(long l, long l2, Matrix matrix, int n, Progress progress) {
        return new Image(MetashapeJNI.PointCloud_renderPreview(this.swigCPtr, this, l, l2, matrix, n, progress), true);
    }
}

