/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.Vector;
import java.util.Optional;

public class Transform {
    private Matrix rotation;
    private Vector translation;
    private Double scale;

    public Transform() {
        this.reset();
    }

    public void setRotation(Matrix matrix) {
        this.rotation = matrix;
    }

    public Optional<Matrix> getRotation() {
        return Optional.ofNullable(this.rotation);
    }

    public void setTranslation(Vector vector) {
        this.translation = vector;
    }

    public Optional<Vector> getTranslation() {
        return Optional.ofNullable(this.translation);
    }

    public void setScale(Double d) {
        this.scale = d;
    }

    public Optional<Double> getScale() {
        return Optional.ofNullable(this.scale);
    }

    public void setMatrix(Matrix matrix) {
        this.translation = matrix.translation();
        this.rotation = matrix.rotation();
        this.scale = matrix.scale();
    }

    public Matrix getMatrix() {
        Vector vector = this.translation != null ? this.translation : new Vector(0.0, 0.0, 0.0);
        Matrix matrix = this.rotation != null ? this.rotation : Matrix.makeDiag(new Vector(1.0, 1.0, 1.0, 1.0));
        Double d = this.scale != null ? this.scale : 1.0;
        return Matrix.makeTranslation(vector).mul(Matrix.makeRotation(matrix)).mul(Matrix.makeScale(new Vector(d, d, d)));
    }

    public boolean hasMatrix() {
        return this.translation != null && this.rotation != null && this.scale != null;
    }

    public void reset() {
        this.translation = null;
        this.rotation = null;
        this.scale = null;
    }

    public Vector transformPoint(Vector vector) {
        return this.getMatrix().mulp(vector);
    }

    public Vector transformVector(Vector vector) {
        return this.getMatrix().mulv(vector);
    }
}

