/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * Polygonal model.
 */
public class Model implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Model(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Model obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_Model(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  static public class Face {

    private int[] vertices;
    private boolean selected;
    private boolean hidden;

    public Face() {
      vertices = new int[3];
      selected = false;
      hidden = false;
    }

    /**
     *  Face visibility flag.
     */
    public void setHidden(boolean on) {
      this.hidden = on;
    }

    /**
     *  Face visibility flag.
     */
    public boolean isHidden() {
      return hidden;
    }

    /**
     *  Face selection flag.
     */
    public void setSelected(boolean on) {
      this.selected = on;
    }

    /**
     *  Face selection flag.
     */
    public boolean isSelected() {
      return selected;
    }

    /**
     *  Vertex indices.
     */
    public void setVertices(int[] ids) {
      this.vertices = ids;
    }

    /**
     *  Vertex indices.
     */
    public int[] getVertices() { return vertices; }

  }

  static public class Vertex {

    private Vector coord;
    private float confidence;

    public Vertex() {
      coord = new Vector(0, 0);
      confidence = 0;
    }

    /**
     *  Vertex coordinates.
     */
    public void setCoord(Vector coord) {
      this.coord = coord;
    }

    /**
     *  Vertex coordinates.
     */
    public Vector getCoord() { return coord; }

    /**
     *  Vertex confidence.
     */
    public void setConfidence(float confidence) {
      this.confidence = confidence;
    }

    /**
     *  Vertex confidence.
     */
    public float getConfidence() {
      return confidence;
    }

  }

  static public class TexFace {

    private int[] vertices;
    private int texture_id;

    public TexFace() {
      vertices = new int[3];
      texture_id = 0;
    }

    /**
     *  Texture page index.
     */
    public void setTextureIndex(int index) {
      this.texture_id = index;
    }

    /**
     *  Texture page index.
     */
    public int getTextureIndex() {
      return texture_id;
    }

    /**
     *  Texture vertex indices.
     */
    public void setVertices(int[] ids) {
      this.vertices = ids;
    }

    /**
     *  Texture vertex indices.
     */
    public int[] getVertices() { return vertices; }

  }

  static public class TexVertex {

    private Vector coord;

    public TexVertex() {
      coord = new Vector(0, 0);
    }

    /**
     *  Vertex texture coordinates.
     */
    public void setCoord(Vector coord) {
      this.coord = coord;
    }

    /**
     *  Vertex texture coordinates.
     */
    public Vector getCoord() { return coord; }

  }

  public Model(Model model) {
    this(MetashapeJNI.new_Model(Model.getCPtr(model), model), true);
  }

  static public class Texture implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected Texture(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(Texture obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_Model_Texture(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    @Override
    public void close() {
      delete();
    }
  
    /**
     *  Texture identifier.
     */
    public int getKey() {
      return MetashapeJNI.Model_Texture_getKey(swigCPtr, this);
    }
  
    /**
     *  Texture type.
     */
    public Model.TextureType getTextureType() {
      return Model.TextureType.class.getEnumConstants()[MetashapeJNI.Model_Texture_getTextureType(swigCPtr, this)];
    }
  
    /**
     *  Texture label.
     */
    public void setLabel(String label) {
      MetashapeJNI.Model_Texture_setLabel(swigCPtr, this, label);
    }
  
    /**
     *  Texture label.
     */
    public String getLabel() {
      return MetashapeJNI.Model_Texture_getLabel(swigCPtr, this);
    }
  
    /**
     *  Texture meta data.
     */
    public void setMeta(Map<String,String> meta) {
      MetashapeJNI.Model_Texture_setMeta(swigCPtr, this, meta);
    }
  
    /**
     *  Texture meta data.
     */
    public Map<String,String> getMeta() { return MetashapeJNI.Model_Texture_getMeta(swigCPtr, this); }
  
  }

  static public class Mesh implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
  
    protected Mesh(long cPtr, boolean cMemoryOwn) {
      swigCMemOwn = cMemoryOwn;
      swigCPtr = cPtr;
    }
  
    protected static long getCPtr(Mesh obj) {
      return (obj == null) ? 0 : obj.swigCPtr;
    }
  
    @SuppressWarnings("deprecation")
    protected void finalize() {
      delete();
    }
  
    public synchronized void delete() {
      if (swigCPtr != 0) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          MetashapeJNI.delete_Model_Mesh(swigCPtr);
        }
        swigCPtr = 0;
      }
    }
  
    @Override
    public void close() {
      delete();
    }
  
    public Mesh() {
      this(MetashapeJNI.new_Model_Mesh__SWIG_0(), true);
    }
  
    public Mesh(Model.Mesh mesh) {
      this(MetashapeJNI.new_Model_Mesh__SWIG_1(Model.Mesh.getCPtr(mesh), mesh), true);
    }
  
    /**
     *  Mesh face count.
     */
    public void setFaceCount(int count) {
      MetashapeJNI.Model_Mesh_setFaceCount(swigCPtr, this, count);
    }
  
    /**
     *  Mesh face count.
     */
    public int getFaceCount() {
      return MetashapeJNI.Model_Mesh_getFaceCount(swigCPtr, this);
    }
  
    /**
     *  Mesh vertex count.
     */
    public void setVertexCount(int count) {
      MetashapeJNI.Model_Mesh_setVertexCount(swigCPtr, this, count);
    }
  
    /**
     *  Mesh vertex count.
     */
    public int getVertexCount() {
      return MetashapeJNI.Model_Mesh_getVertexCount(swigCPtr, this);
    }
  
    /**
     *  Mesh face.
     */
    public void setFace(int index, Model.Face f) {
      MetashapeJNI.Model_Mesh_setFace(swigCPtr, this, index, f);
    }
  
    /**
     *  Mesh face.
     */
    public Model.Face getFace(int index) { return MetashapeJNI.Model_Mesh_getFace(swigCPtr, this, index); }
  
    /**
     *  Mesh vertex.
     */
    public void setVertex(int index, Model.Vertex v) {
      MetashapeJNI.Model_Mesh_setVertex(swigCPtr, this, index, v);
    }
  
    /**
     *  Mesh vertex.
     */
    public Model.Vertex getVertex(int index) { return MetashapeJNI.Model_Mesh_getVertex(swigCPtr, this, index); }
  
    /**
     *  Mesh vertex color.
     */
    public void setVertexColor(int index, Color color) {
      MetashapeJNI.Model_Mesh_setVertexColor(swigCPtr, this, index, color);
    }
  
    /**
     *  Mesh vertex color.
     */
    public Color getVertexColor(int index) { return MetashapeJNI.Model_Mesh_getVertexColor(swigCPtr, this, index); }
  
    /**
     *  Returns true if model has UV coordinates.
     */
    public boolean hasUV() {
      return MetashapeJNI.Model_Mesh_hasUV(swigCPtr, this);
    }
  
    /**
     *  Returns true if model has vertex colors.
     */
    public boolean hasVertexColors() {
      return MetashapeJNI.Model_Mesh_hasVertexColors(swigCPtr, this);
    }
  
    /**
     *  Returns true if model has confidence values.
     */
    public boolean hasVertexConfidence() {
      return MetashapeJNI.Model_Mesh_hasVertexConfidence(swigCPtr, this);
    }
  
  }

  /**
   *  Model identifier.
   */
  public int getKey() {
    return MetashapeJNI.Model_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.Model_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Model label.
   */
  public void setLabel(String label) {
    MetashapeJNI.Model_setLabel(swigCPtr, this, label);
  }

  /**
   *  Model label.
   */
  public String getLabel() {
    return MetashapeJNI.Model_getLabel(swigCPtr, this);
  }

  /**
   *  List of textures in the model.
   */
  public Model.Texture[] getTextures() { return SwigHelpers.cArrayWrap(MetashapeJNI.Model_getTextures(swigCPtr, this), true, Model.Texture.class); }

  /**
   *  Active texture of a given type, may be null.
   */
  public Optional<Model.Texture> getActiveTexture(Model.TextureType type) {
    long ptr = MetashapeJNI.Model_getActiveTexture(swigCPtr, this, type.ordinal());
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Model.Texture(ptr, true));
  }

  /**
   *  Model mesh, may be null.
   */
  public void setMesh(Model.Mesh mesh) {
    MetashapeJNI.Model_setMesh(swigCPtr, this, mesh == null ? 0 : Model.Mesh.getCPtr(mesh));
  }

  /**
   *  Model mesh, may be null.
   */
  public Optional<Model.Mesh> getMesh() {
    long ptr = MetashapeJNI.Model_getMesh(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Model.Mesh(ptr, true));
  }

  /**
   *  Path to model file.
   */
  public String getPath() {
    return MetashapeJNI.Model_getPath(swigCPtr, this);
  }

  /**
   *  Model meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.Model_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Model meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.Model_getMeta(swigCPtr, this); }

  /**
   *  Face count.
   */
  public int getFaceCount() {
    return MetashapeJNI.Model_getFaceCount(swigCPtr, this);
  }

  /**
   *  Vertex count;
   */
  public int getVertexCount() {
    return MetashapeJNI.Model_getVertexCount(swigCPtr, this);
  }

  /**
   *  Returns true if model has UV coordinates.
   */
  public boolean hasUV() {
    return MetashapeJNI.Model_hasUV(swigCPtr, this);
  }

  /**
   *  Returns true if model has vertex colors.
   */
  public boolean hasVertexColors() {
    return MetashapeJNI.Model_hasVertexColors(swigCPtr, this);
  }

  /**
   *  Returns true if model has confidence values.
   */
  public boolean hasVertexConfidence() {
    return MetashapeJNI.Model_hasVertexConfidence(swigCPtr, this);
  }

  /**
   * Returns ray intersection with the model surface.<br>
   * @param origin Ray origin.<br>
   * @param target Point on the ray.<br>
   * @return Coordinates of the intersection point, may be null.
   */
  public Optional<Vector> pickPoint(Vector origin, Vector target) {
	Vector values = MetashapeJNI.Model_pickPoint(swigCPtr, this, origin, target);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   * Generate model preview image.<br>
   * @param width Preview image width.<br>
   * @param height Preview image height.<br>
   * @param transform 4x4 viewpoint transformation matrix.<br>
   * @return Preview image.
   */
  public Image renderPreview(long width, long height, Matrix transform, Progress progress) {
    return new Image(MetashapeJNI.Model_renderPreview(swigCPtr, this, width, height, transform, progress), true);
  }

  public enum TextureType {
    DiffuseMap,
    NormalMap,
    OcclusionMap;
  }

}
