package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ExportPointCloud extends Task {

	public ExportPointCloud() {
		super("ExportPointCloud");
	}

	/**
	 *  Enables/disables binary encoding for selected format (if applicable).
	 */
	public void setBinary(boolean value) {
		setParameter("binary", (Object) value);
	}

	/**
	 *  Enables/disables binary encoding for selected format (if applicable).
	 */
	public boolean getBinary() {
		return (boolean) getParameter("binary");
	}

	/**
	 *  Block height in meters. Default: 1000.0
	 */
	public void setBlockHeight(double value) {
		setParameter("block_height", (Object) value);
	}

	/**
	 *  Block height in meters. Default: 1000.0
	 */
	public double getBlockHeight() {
		return (double) getParameter("block_height");
	}

	/**
	 *  Block width in meters. Default: 1000.0
	 */
	public void setBlockWidth(double value) {
		setParameter("block_width", (Object) value);
	}

	/**
	 *  Block width in meters. Default: 1000.0
	 */
	public double getBlockWidth() {
		return (double) getParameter("block_width");
	}

	/**
	 *  List of point classes to be exported.
	 */
	public void setClasses(int[] value) {
		setParameter("classes", (Object) value);
	}

	/**
	 *  List of point classes to be exported.
	 */
	public int[] getClasses() {
		return (int[]) getParameter("classes");
	}

	/**
	 *  Clip point cloud to boundary shapes.
	 */
	public void setClipToBoundary(boolean value) {
		setParameter("clip_to_boundary", (Object) value);
	}

	/**
	 *  Clip point cloud to boundary shapes.
	 */
	public boolean getClipToBoundary() {
		return (boolean) getParameter("clip_to_boundary");
	}

	/**
	 *  Convert colors to 8 bit RGB.
	 */
	public void setColorsRgb8Bit(boolean value) {
		setParameter("colors_rgb_8bit", (Object) value);
	}

	/**
	 *  Convert colors to 8 bit RGB.
	 */
	public boolean getColorsRgb8Bit() {
		return (boolean) getParameter("colors_rgb_8bit");
	}

	/**
	 *  Optional comment (if supported by selected format).
	 */
	public void setComment(String value) {
		setParameter("comment", (Object) value);
	}

	/**
	 *  Optional comment (if supported by selected format).
	 */
	public String getComment() {
		return (String) getParameter("comment");
	}

	/**
	 *  Enable compression (Cesium format only).
	 */
	public void setCompression(boolean value) {
		setParameter("compression", (Object) value);
	}

	/**
	 *  Enable compression (Cesium format only).
	 */
	public boolean getCompression() {
		return (boolean) getParameter("compression");
	}

	/**
	 *  Output coordinate system.
	 */
	public void setCRS(CoordinateSystem value) {
		setParameter("crs", (Object) value);
	}

	/**
	 *  Output coordinate system.
	 */
	public CoordinateSystem getCRS() {
		return (CoordinateSystem) getParameter("crs");
	}

	/**
	 *  Tileset subdivision depth (Cesium format only). Default: 5
	 */
	public void setFolderDepth(int value) {
		setParameter("folder_depth", (Object) value);
	}

	/**
	 *  Tileset subdivision depth (Cesium format only). Default: 5
	 */
	public int getFolderDepth() {
		return (int) getParameter("folder_depth");
	}

	/**
	 *  Export format. Default: PointCloudFormat.PointCloudFormatNone
	 */
	public void setFormat(PointCloudFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  Export format. Default: PointCloudFormat.PointCloudFormatNone
	 */
	public PointCloudFormat getFormat() {
		return (PointCloudFormat) getParameter("format");
	}

	/**
	 *  Image data format. Default: ImageFormat.ImageFormatJPEG
	 */
	public void setImageFormat(ImageFormat value) {
		setParameter("image_format", (Object) value);
	}

	/**
	 *  Image data format. Default: ImageFormat.ImageFormatJPEG
	 */
	public ImageFormat getImageFormat() {
		return (ImageFormat) getParameter("image_format");
	}

	/**
	 *  Path to output file.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Path to output file.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  Point cloud key to export. Default: -1
	 */
	public void setPointCloud(int value) {
		setParameter("point_cloud", (Object) value);
	}

	/**
	 *  Point cloud key to export. Default: -1
	 */
	public int getPointCloud() {
		return (int) getParameter("point_cloud");
	}

	/**
	 *  Raster band transformation. Default: RasterTransformType.RasterTransformNone
	 */
	public void setRasterTransform(RasterTransformType value) {
		setParameter("raster_transform", (Object) value);
	}

	/**
	 *  Raster band transformation. Default: RasterTransformType.RasterTransformNone
	 */
	public RasterTransformType getRasterTransform() {
		return (RasterTransformType) getParameter("raster_transform");
	}

	/**
	 *  Region to be exported.
	 */
	public void setRegion(BBox value) {
		setParameter("region", (Object) value);
	}

	/**
	 *  Region to be exported.
	 */
	public BBox getRegion() {
		return (BBox) getParameter("region");
	}

	/**
	 *  Enable comment export.
	 */
	public void setSaveComment(boolean value) {
		setParameter("save_comment", (Object) value);
	}

	/**
	 *  Enable comment export.
	 */
	public boolean getSaveComment() {
		return (boolean) getParameter("save_comment");
	}

	/**
	 *  Enable image export.
	 */
	public void setSaveImages(boolean value) {
		setParameter("save_images", (Object) value);
	}

	/**
	 *  Enable image export.
	 */
	public boolean getSaveImages() {
		return (boolean) getParameter("save_images");
	}

	/**
	 *  Enables/disables export of point classification.
	 */
	public void setSavePointClassification(boolean value) {
		setParameter("save_point_classification", (Object) value);
	}

	/**
	 *  Enables/disables export of point classification.
	 */
	public boolean getSavePointClassification() {
		return (boolean) getParameter("save_point_classification");
	}

	/**
	 *  Enables/disables export of point color.
	 */
	public void setSavePointColor(boolean value) {
		setParameter("save_point_color", (Object) value);
	}

	/**
	 *  Enables/disables export of point color.
	 */
	public boolean getSavePointColor() {
		return (boolean) getParameter("save_point_color");
	}

	/**
	 *  Enables/disables export of point confidence.
	 */
	public void setSavePointConfidence(boolean value) {
		setParameter("save_point_confidence", (Object) value);
	}

	/**
	 *  Enables/disables export of point confidence.
	 */
	public boolean getSavePointConfidence() {
		return (boolean) getParameter("save_point_confidence");
	}

	/**
	 *  Enables/disables export of point row and column indices.
	 */
	public void setSavePointIndex(boolean value) {
		setParameter("save_point_index", (Object) value);
	}

	/**
	 *  Enables/disables export of point row and column indices.
	 */
	public boolean getSavePointIndex() {
		return (boolean) getParameter("save_point_index");
	}

	/**
	 *  Enables/disables export of point intensity.
	 */
	public void setSavePointIntensity(boolean value) {
		setParameter("save_point_intensity", (Object) value);
	}

	/**
	 *  Enables/disables export of point intensity.
	 */
	public boolean getSavePointIntensity() {
		return (boolean) getParameter("save_point_intensity");
	}

	/**
	 *  Enables/disables export of point normal.
	 */
	public void setSavePointNormal(boolean value) {
		setParameter("save_point_normal", (Object) value);
	}

	/**
	 *  Enables/disables export of point normal.
	 */
	public boolean getSavePointNormal() {
		return (boolean) getParameter("save_point_normal");
	}

	/**
	 *  Enables/disables export of point return number.
	 */
	public void setSavePointReturnNumber(boolean value) {
		setParameter("save_point_return_number", (Object) value);
	}

	/**
	 *  Enables/disables export of point return number.
	 */
	public boolean getSavePointReturnNumber() {
		return (boolean) getParameter("save_point_return_number");
	}

	/**
	 *  Enables/disables export of point scan angle.
	 */
	public void setSavePointScanAngle(boolean value) {
		setParameter("save_point_scan_angle", (Object) value);
	}

	/**
	 *  Enables/disables export of point scan angle.
	 */
	public boolean getSavePointScanAngle() {
		return (boolean) getParameter("save_point_scan_angle");
	}

	/**
	 *  Enables/disables export of point source ID.
	 */
	public void setSavePointSourceId(boolean value) {
		setParameter("save_point_source_id", (Object) value);
	}

	/**
	 *  Enables/disables export of point source ID.
	 */
	public boolean getSavePointSourceId() {
		return (boolean) getParameter("save_point_source_id");
	}

	/**
	 *  Enables/disables export of point timestamp.
	 */
	public void setSavePointTimestamp(boolean value) {
		setParameter("save_point_timestamp", (Object) value);
	}

	/**
	 *  Enables/disables export of point timestamp.
	 */
	public boolean getSavePointTimestamp() {
		return (boolean) getParameter("save_point_timestamp");
	}

	/**
	 *  Target screen space error (Cesium format only). Default: 16.0
	 */
	public void setScreenSpaceError(double value) {
		setParameter("screen_space_error", (Object) value);
	}

	/**
	 *  Target screen space error (Cesium format only). Default: 16.0
	 */
	public double getScreenSpaceError() {
		return (double) getParameter("screen_space_error");
	}

	/**
	 *  Optional shift to be applied to point coordinates.
	 */
	public void setShift(Vector value) {
		setParameter("shift", (Object) value);
	}

	/**
	 *  Optional shift to be applied to point coordinates.
	 */
	public Vector getShift() {
		return (Vector) getParameter("shift");
	}

	/**
	 *  Selects between point cloud and tie points. If not specified, uses point cloud if available. Default: DataSource.PointCloudData
	 */
	public void setSourceData(DataSource value) {
		setParameter("source_data", (Object) value);
	}

	/**
	 *  Selects between point cloud and tie points. If not specified, uses point cloud if available. Default: DataSource.PointCloudData
	 */
	public DataSource getSourceData() {
		return (DataSource) getParameter("source_data");
	}

	/**
	 *  Enable tiled export.
	 */
	public void setSplitInBlocks(boolean value) {
		setParameter("split_in_blocks", (Object) value);
	}

	/**
	 *  Enable tiled export.
	 */
	public boolean getSplitInBlocks() {
		return (boolean) getParameter("split_in_blocks");
	}

	/**
	 *  Enable fine-level task subdivision.
	 */
	public void setSubdivideTask(boolean value) {
		setParameter("subdivide_task", (Object) value);
	}

	/**
	 *  Enable fine-level task subdivision.
	 */
	public boolean getSubdivideTask() {
		return (boolean) getParameter("subdivide_task");
	}

	/**
	 *  Default view.
	 */
	public void setViewpoint(Viewpoint value) {
		setParameter("viewpoint", (Object) value);
	}

	/**
	 *  Default view.
	 */
	public Viewpoint getViewpoint() {
		return (Viewpoint) getParameter("viewpoint");
	}

}
