package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ImportDepthImages extends Task {

	public ImportDepthImages() {
		super("ImportDepthImages");
	}

	/**
	 *  List of corresponding color files, if present.
	 */
	public void setColorFilenames(String[] value) {
		setParameter("color_filenames", (Object) value);
	}

	/**
	 *  List of corresponding color files, if present.
	 */
	public String[] getColorFilenames() {
		return (String[]) getParameter("color_filenames");
	}

	/**
	 *  List of files to import.
	 */
	public void setFilenames(String[] value) {
		setParameter("filenames", (Object) value);
	}

	/**
	 *  List of files to import.
	 */
	public String[] getFilenames() {
		return (String[]) getParameter("filenames");
	}

	/**
	 *  Point cloud format. Default: PointCloudFormat.PointCloudFormatNone
	 */
	public void setFormat(PointCloudFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  Point cloud format. Default: PointCloudFormat.PointCloudFormatNone
	 */
	public PointCloudFormat getFormat() {
		return (PointCloudFormat) getParameter("format");
	}

	/**
	 *  Path template to output files.
	 */
	public void setImagePath(String value) {
		setParameter("image_path", (Object) value);
	}

	/**
	 *  Path template to output files.
	 */
	public String getImagePath() {
		return (String) getParameter("image_path");
	}

	/**
	 *  Import as a multi-camera system
	 */
	public void setMultiplane(boolean value) {
		setParameter("multiplane", (Object) value);
	}

	/**
	 *  Import as a multi-camera system
	 */
	public boolean getMultiplane() {
		return (boolean) getParameter("multiplane");
	}

}
