/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.CameraGroup;
import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.Image;
import com.agisoft.metashape.Matrix;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Photo;
import com.agisoft.metashape.Sensor;
import com.agisoft.metashape.Shutter;
import com.agisoft.metashape.Vector;
import com.agisoft.metashape.Vignetting;
import java.util.Map;
import java.util.Optional;

public class Camera
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Camera(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Camera camera) {
        return camera == null ? 0L : camera.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Camera(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Camera(Camera camera) {
        this(MetashapeJNI.new_Camera(Camera.getCPtr(camera), camera), true);
    }

    public int getKey() {
        return MetashapeJNI.Camera_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.Camera_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setType(Type type) {
        MetashapeJNI.Camera_setType(this.swigCPtr, this, type.ordinal());
    }

    public Type getType() {
        return ((Type[])Type.class.getEnumConstants())[MetashapeJNI.Camera_getType(this.swigCPtr, this)];
    }

    public void setLabel(String string) {
        MetashapeJNI.Camera_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Camera_getLabel(this.swigCPtr, this);
    }

    public void setEnabled(boolean bl) {
        MetashapeJNI.Camera_setEnabled(this.swigCPtr, this, bl);
    }

    public boolean isEnabled() {
        return MetashapeJNI.Camera_isEnabled(this.swigCPtr, this);
    }

    public void setSelected(boolean bl) {
        MetashapeJNI.Camera_setSelected(this.swigCPtr, this, bl);
    }

    public boolean isSelected() {
        return MetashapeJNI.Camera_isSelected(this.swigCPtr, this);
    }

    public void setOrientation(int n) {
        MetashapeJNI.Camera_setOrientation(this.swigCPtr, this, n);
    }

    public int getOrientation() {
        return MetashapeJNI.Camera_getOrientation(this.swigCPtr, this);
    }

    public void setSensor(Sensor sensor) {
        MetashapeJNI.Camera_setSensor(this.swigCPtr, this, sensor == null ? 0L : Sensor.getCPtr(sensor), sensor);
    }

    public Optional<Sensor> getSensor() {
        long l = MetashapeJNI.Camera_getSensor(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Sensor(l, true));
    }

    public void setMaster(Camera camera) {
        MetashapeJNI.Camera_setMaster(this.swigCPtr, this, camera == null ? 0L : Camera.getCPtr(camera), camera);
    }

    public Optional<Camera> getMaster() {
        long l = MetashapeJNI.Camera_getMaster(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Camera(l, true));
    }

    public void setGroup(CameraGroup cameraGroup) {
        MetashapeJNI.Camera_setGroup(this.swigCPtr, this, cameraGroup == null ? 0L : CameraGroup.getCPtr(cameraGroup), cameraGroup);
    }

    public Optional<CameraGroup> getGroup() {
        long l = MetashapeJNI.Camera_getGroup(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new CameraGroup(l, true));
    }

    public void setPhoto(Photo photo) {
        MetashapeJNI.Camera_setPhoto(this.swigCPtr, this, photo);
    }

    public Optional<Photo> getPhoto() {
        Photo photo = MetashapeJNI.Camera_getPhoto(this.swigCPtr, this);
        return photo == null ? Optional.empty() : Optional.of(photo);
    }

    public void setTransform(Matrix matrix) {
        MetashapeJNI.Camera_setTransform(this.swigCPtr, this, matrix);
    }

    public Optional<Matrix> getTransform() {
        Matrix matrix = MetashapeJNI.Camera_getTransform(this.swigCPtr, this);
        return matrix == null ? Optional.empty() : Optional.of(matrix);
    }

    public void setMask(Image image) {
        MetashapeJNI.Camera_setMask(this.swigCPtr, this, image == null ? 0L : Image.getCPtr(image), image);
    }

    public Optional<Image> getMask() {
        long l = MetashapeJNI.Camera_getMask(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Image(l, true));
    }

    public void setThumbnail(Image image) {
        MetashapeJNI.Camera_setThumbnail(this.swigCPtr, this, image == null ? 0L : Image.getCPtr(image), image);
    }

    public Optional<Image> getThumbnail() {
        long l = MetashapeJNI.Camera_getThumbnail(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Image(l, true));
    }

    public void setShutter(Shutter shutter) {
        MetashapeJNI.Camera_setShutter(this.swigCPtr, this, shutter);
    }

    public Optional<Shutter> getShutter() {
        Shutter shutter = MetashapeJNI.Camera_getShutter(this.swigCPtr, this);
        return shutter == null ? Optional.empty() : Optional.of(shutter);
    }

    public void setVignetting(Vignetting[] vignettingArray) {
        MetashapeJNI.Camera_setVignetting(this.swigCPtr, this, vignettingArray);
    }

    public Vignetting[] getVignetting() {
        return MetashapeJNI.Camera_getVignetting(this.swigCPtr, this);
    }

    public Vector getCenter() {
        return MetashapeJNI.Camera_getCenter(this.swigCPtr, this);
    }

    public Vector getError(Vector vector, Vector vector2) {
        return MetashapeJNI.Camera_getError(this.swigCPtr, this, vector, vector2);
    }

    public Vector project(Vector vector) {
        return MetashapeJNI.Camera_project(this.swigCPtr, this, vector);
    }

    public Vector unproject(Vector vector) {
        return MetashapeJNI.Camera_unproject(this.swigCPtr, this, vector);
    }

    public Vector unproject3D(Vector vector) {
        return MetashapeJNI.Camera_unproject3D(this.swigCPtr, this, vector);
    }

    public Optional<Image> loadImage() {
        long l = MetashapeJNI.Camera_loadImage(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Image(l, true));
    }

    public Reference getReference() {
        return MetashapeJNI.Camera_getReference(this.swigCPtr, this);
    }

    public void setReference(Reference reference) {
        MetashapeJNI.Camera_setReference(this.swigCPtr, this, reference);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.Camera_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.Camera_getMeta(this.swigCPtr, this);
    }

    public static enum Type {
        TypeRegular,
        TypeKeyframe;

    }

    public static class Reference {
        private Optional<Vector> location = Optional.empty();
        private Optional<Vector> rotation = Optional.empty();
        private Optional<Vector> location_accuracy = Optional.empty();
        private Optional<Vector> rotation_accuracy = Optional.empty();
        private boolean location_enabled = false;
        private boolean rotation_enabled = false;

        public void setLocationEnabled(boolean bl) {
            this.location_enabled = bl;
        }

        public boolean isLocationEnabled() {
            return this.location_enabled;
        }

        public void setRotationEnabled(boolean bl) {
            this.rotation_enabled = bl;
        }

        public boolean isRotationEnabled() {
            return this.rotation_enabled;
        }

        public void setLocation(Optional<Vector> optional) {
            this.location = optional;
        }

        public Optional<Vector> getLocation() {
            return this.location;
        }

        public void setRotation(Optional<Vector> optional) {
            this.rotation = optional;
        }

        public Optional<Vector> getRotation() {
            return this.rotation;
        }

        public void setLocationAccuracy(Optional<Vector> optional) {
            this.location_accuracy = optional;
        }

        public Optional<Vector> getLocationAccuracy() {
            return this.location_accuracy;
        }

        public void setRotationAccuracy(Optional<Vector> optional) {
            this.rotation_accuracy = optional;
        }

        public Optional<Vector> getRotationAccuracy() {
            return this.rotation_accuracy;
        }
    }
}

