/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Vector;
import java.util.Map;
import java.util.Optional;

public class Marker
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Marker(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Marker marker) {
        return marker == null ? 0L : marker.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Marker(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Marker(Marker marker) {
        this(MetashapeJNI.new_Marker(Marker.getCPtr(marker), marker), true);
    }

    public int getKey() {
        return MetashapeJNI.Marker_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.Marker_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setType(Type type) {
        MetashapeJNI.Marker_setType(this.swigCPtr, this, type.ordinal());
    }

    public Type getType() {
        return ((Type[])Type.class.getEnumConstants())[MetashapeJNI.Marker_getType(this.swigCPtr, this)];
    }

    public void setLabel(String string) {
        MetashapeJNI.Marker_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Marker_getLabel(this.swigCPtr, this);
    }

    public void setEnabled(boolean bl) {
        MetashapeJNI.Marker_setEnabled(this.swigCPtr, this, bl);
    }

    public boolean isEnabled() {
        return MetashapeJNI.Marker_isEnabled(this.swigCPtr, this);
    }

    public void setSelected(boolean bl) {
        MetashapeJNI.Marker_setSelected(this.swigCPtr, this, bl);
    }

    public boolean isSelected() {
        return MetashapeJNI.Marker_isSelected(this.swigCPtr, this);
    }

    public void setProjection(int n, Projection projection) {
        MetashapeJNI.Marker_setProjection(this.swigCPtr, this, n, projection);
    }

    public Optional<Projection> getProjection(int n) {
        Projection projection = MetashapeJNI.Marker_getProjection(this.swigCPtr, this, n);
        return projection == null ? Optional.empty() : Optional.of(projection);
    }

    public Optional<Vector> getPosition() {
        Vector vector = MetashapeJNI.Marker_getPosition(this.swigCPtr, this);
        return vector == null ? Optional.empty() : Optional.of(vector);
    }

    public int[] getCameraKeys() {
        return MetashapeJNI.Marker_getCameraKeys(this.swigCPtr, this);
    }

    public Reference getReference() {
        return MetashapeJNI.Marker_getReference(this.swigCPtr, this);
    }

    public void setReference(Reference reference) {
        MetashapeJNI.Marker_setReference(this.swigCPtr, this, reference);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.Marker_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.Marker_getMeta(this.swigCPtr, this);
    }

    public static enum Type {
        TypeRegular,
        TypeInternal,
        TypeFiducial;

    }

    public static class Projection {
        private Optional<Vector> point = Optional.empty();
        private boolean pinned = false;

        public void setPoint(Optional<Vector> optional) {
            this.point = optional;
        }

        public Optional<Vector> getPoint() {
            return this.point;
        }

        public void setPinned(boolean bl) {
            this.pinned = bl;
        }

        public boolean isPinned() {
            return this.pinned;
        }
    }

    public static class Reference {
        private Optional<Vector> location = Optional.empty();
        private Optional<Vector> location_accuracy = Optional.empty();
        private boolean enabled = false;

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setLocation(Optional<Vector> optional) {
            this.location = optional;
        }

        public Optional<Vector> getLocation() {
            return this.location;
        }

        public void setLocationAccuracy(Optional<Vector> optional) {
            this.location_accuracy = optional;
        }

        public Optional<Vector> getLocationAccuracy() {
            return this.location_accuracy;
        }
    }
}

