/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Antenna;
import com.agisoft.metashape.Calibration;
import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.Vector;
import com.agisoft.metashape.Vignetting;
import java.util.Map;
import java.util.Optional;

public class Sensor
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Sensor(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Sensor sensor) {
        return sensor == null ? 0L : sensor.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Sensor(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Sensor(Sensor sensor) {
        this(MetashapeJNI.new_Sensor(Sensor.getCPtr(sensor), sensor), true);
    }

    public int getKey() {
        return MetashapeJNI.Sensor_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.Sensor_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setLabel(String string) {
        MetashapeJNI.Sensor_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.Sensor_getLabel(this.swigCPtr, this);
    }

    public void setResolution(long l, long l2) {
        MetashapeJNI.Sensor_setResolution(this.swigCPtr, this, l, l2);
    }

    public long getWidth() {
        return MetashapeJNI.Sensor_getWidth(this.swigCPtr, this);
    }

    public long getHeight() {
        return MetashapeJNI.Sensor_getHeight(this.swigCPtr, this);
    }

    public void setCameraModel(Calibration.Type type) {
        MetashapeJNI.Sensor_setCameraModel(this.swigCPtr, this, type.ordinal());
    }

    public Calibration.Type getCameraModel() {
        return ((Calibration.Type[])Calibration.Type.class.getEnumConstants())[MetashapeJNI.Sensor_getCameraModel(this.swigCPtr, this)];
    }

    public void setCalibration(Calibration calibration) {
        MetashapeJNI.Sensor_setCalibration(this.swigCPtr, this, Calibration.getCPtr(calibration), calibration);
    }

    public Calibration getCalibration() {
        return new Calibration(MetashapeJNI.Sensor_getCalibration(this.swigCPtr, this), true);
    }

    public void setUserCalib(Calibration calibration) {
        MetashapeJNI.Sensor_setUserCalib(this.swigCPtr, this, calibration == null ? 0L : Calibration.getCPtr(calibration), calibration);
    }

    public Optional<Calibration> getUserCalib() {
        long l = MetashapeJNI.Sensor_getUserCalib(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Calibration(l, true));
    }

    public void setFixed(boolean bl) {
        MetashapeJNI.Sensor_setFixed(this.swigCPtr, this, bl);
    }

    public boolean isFixed() {
        return MetashapeJNI.Sensor_isFixed(this.swigCPtr, this);
    }

    public void setPixelSize(double d, double d2) {
        MetashapeJNI.Sensor_setPixelSize(this.swigCPtr, this, d, d2);
    }

    public double getPixelWidth() {
        return MetashapeJNI.Sensor_getPixelWidth(this.swigCPtr, this);
    }

    public double getPixelHeight() {
        return MetashapeJNI.Sensor_getPixelHeight(this.swigCPtr, this);
    }

    public void setFocalLength(double d) {
        MetashapeJNI.Sensor_setFocalLength(this.swigCPtr, this, d);
    }

    public double getFocalLength() {
        return MetashapeJNI.Sensor_getFocalLength(this.swigCPtr, this);
    }

    public void setMaster(Sensor sensor) {
        MetashapeJNI.Sensor_setMaster(this.swigCPtr, this, sensor == null ? 0L : Sensor.getCPtr(sensor), sensor);
    }

    public Optional<Sensor> getMaster() {
        long l = MetashapeJNI.Sensor_getMaster(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Sensor(l, true));
    }

    public void setReference(Reference reference) {
        MetashapeJNI.Sensor_setReference(this.swigCPtr, this, reference);
    }

    public Reference getReference() {
        return MetashapeJNI.Sensor_getReference(this.swigCPtr, this);
    }

    public void setAntenna(Antenna antenna) {
        MetashapeJNI.Sensor_setAntenna(this.swigCPtr, this, antenna);
    }

    public Antenna getAntenna() {
        return MetashapeJNI.Sensor_getAntenna(this.swigCPtr, this);
    }

    public void setVignetting(Vignetting[] vignettingArray) {
        MetashapeJNI.Sensor_setVignetting(this.swigCPtr, this, vignettingArray);
    }

    public Vignetting[] getVignetting() {
        return MetashapeJNI.Sensor_getVignetting(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.Sensor_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.Sensor_getMeta(this.swigCPtr, this);
    }

    public void makeMaster() {
        MetashapeJNI.Sensor_makeMaster(this.swigCPtr, this);
    }

    public static class Reference {
        private Optional<Vector> location = Optional.empty();
        private Optional<Vector> rotation = Optional.empty();
        private Optional<Vector> location_accuracy = Optional.empty();
        private Optional<Vector> rotation_accuracy = Optional.empty();
        private boolean location_enabled = false;
        private boolean rotation_enabled = false;

        public void setLocationEnabled(boolean bl) {
            this.location_enabled = bl;
        }

        public boolean isLocationEnabled() {
            return this.location_enabled;
        }

        public void setRotationEnabled(boolean bl) {
            this.rotation_enabled = bl;
        }

        public boolean isRotationEnabled() {
            return this.rotation_enabled;
        }

        public void setLocation(Optional<Vector> optional) {
            this.location = optional;
        }

        public Optional<Vector> getLocation() {
            return this.location;
        }

        public void setRotation(Optional<Vector> optional) {
            this.rotation = optional;
        }

        public Optional<Vector> getRotation() {
            return this.rotation;
        }

        public void setLocationAccuracy(Optional<Vector> optional) {
            this.location_accuracy = optional;
        }

        public Optional<Vector> getLocationAccuracy() {
            return this.location_accuracy;
        }

        public void setRotationAccuracy(Optional<Vector> optional) {
            this.rotation_accuracy = optional;
        }

        public Optional<Vector> getRotationAccuracy() {
            return this.rotation_accuracy;
        }
    }
}

