package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ClassifyGroundPoints extends Task {

	public ClassifyGroundPoints() {
		super("ClassifyGroundPoints");
	}

	/**
	 *  Cell size (meters). Default: 50.0
	 */
	public void setCellSize(double value) {
		setParameter("cell_size", (Object) value);
	}

	/**
	 *  Cell size (meters). Default: 50.0
	 */
	public double getCellSize() {
		return (double) getParameter("cell_size");
	}

	/**
	 *  Erosion radius (meters). Default: 0.0
	 */
	public void setErosionRadius(double value) {
		setParameter("erosion_radius", (Object) value);
	}

	/**
	 *  Erosion radius (meters). Default: 0.0
	 */
	public double getErosionRadius() {
		return (double) getParameter("erosion_radius");
	}

	/**
	 *  Keep existing ground points.
	 */
	public void setKeepExisting(boolean value) {
		setParameter("keep_existing", (Object) value);
	}

	/**
	 *  Keep existing ground points.
	 */
	public boolean getKeepExisting() {
		return (boolean) getParameter("keep_existing");
	}

	/**
	 *  Maximum angle (degrees). Default: 15.0
	 */
	public void setMaxAngle(double value) {
		setParameter("max_angle", (Object) value);
	}

	/**
	 *  Maximum angle (degrees). Default: 15.0
	 */
	public double getMaxAngle() {
		return (double) getParameter("max_angle");
	}

	/**
	 *  Maximum distance (meters). Default: 1.0
	 */
	public void setMaxDistance(double value) {
		setParameter("max_distance", (Object) value);
	}

	/**
	 *  Maximum distance (meters). Default: 1.0
	 */
	public double getMaxDistance() {
		return (double) getParameter("max_distance");
	}

	/**
	 *  Point cloud key to classify. Default: -1
	 */
	public void setPointCloud(int value) {
		setParameter("point_cloud", (Object) value);
	}

	/**
	 *  Point cloud key to classify. Default: -1
	 */
	public int getPointCloud() {
		return (int) getParameter("point_cloud");
	}

	/**
	 *  Point return number to use (0 - any return, 1 - first return, -1 - last return). Default: 0
	 */
	public void setReturnNumber(int value) {
		setParameter("return_number", (Object) value);
	}

	/**
	 *  Point return number to use (0 - any return, 1 - first return, -1 - last return). Default: 0
	 */
	public int getReturnNumber() {
		return (int) getParameter("return_number");
	}

	/**
	 *  Class of points to be re-classified. Default: -1
	 */
	public void setSourceClass(int value) {
		setParameter("source_class", (Object) value);
	}

	/**
	 *  Class of points to be re-classified. Default: -1
	 */
	public int getSourceClass() {
		return (int) getParameter("source_class");
	}

}
