package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class DetectPowerlines extends Task {

	public DetectPowerlines() {
		super("DetectPowerlines");
	}

	/**
	 *  Maximum allowed distance between polyline and smooth continuous curve. Default: 0.01
	 */
	public void setMaxQuantizationError(double value) {
		setParameter("max_quantization_error", (Object) value);
	}

	/**
	 *  Maximum allowed distance between polyline and smooth continuous curve. Default: 0.01
	 */
	public double getMaxQuantizationError() {
		return (double) getParameter("max_quantization_error");
	}

	/**
	 *  Minimum altitude for reconstructed powerlines. Default: 1.0
	 */
	public void setMinAltitude(double value) {
		setParameter("min_altitude", (Object) value);
	}

	/**
	 *  Minimum altitude for reconstructed powerlines. Default: 1.0
	 */
	public double getMinAltitude() {
		return (double) getParameter("min_altitude");
	}

	/**
	 *  Maximum number of vertices per detected line. Default: 100
	 */
	public void setNPointsPerLine(int value) {
		setParameter("n_points_per_line", (Object) value);
	}

	/**
	 *  Maximum number of vertices per detected line. Default: 100
	 */
	public int getNPointsPerLine() {
		return (int) getParameter("n_points_per_line");
	}

	/**
	 *  Use model for visibility checks.
	 */
	public void setUseModel(boolean value) {
		setParameter("use_model", (Object) value);
	}

	/**
	 *  Use model for visibility checks.
	 */
	public boolean getUseModel() {
		return (boolean) getParameter("use_model");
	}

}
