package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class FilterPointCloud extends Task {

	public FilterPointCloud() {
		super("FilterPointCloud");
	}

	/**
	 *  Point cloud key to filter. Default: -1
	 */
	public void setPointCloud(int value) {
		setParameter("point_cloud", (Object) value);
	}

	/**
	 *  Point cloud key to filter. Default: -1
	 */
	public int getPointCloud() {
		return (int) getParameter("point_cloud");
	}

	/**
	 *  Desired point spacing (m). Default: 0.0
	 */
	public void setPointSpacing(double value) {
		setParameter("point_spacing", (Object) value);
	}

	/**
	 *  Desired point spacing (m). Default: 0.0
	 */
	public double getPointSpacing() {
		return (double) getParameter("point_spacing");
	}

}
