/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.NetworkTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkClient
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected NetworkClient(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(NetworkClient networkClient) {
        return networkClient == null ? 0L : networkClient.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_NetworkClient(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public NetworkClient() {
        this(MetashapeJNI.new_NetworkClient(), true);
    }

    public boolean connect(String string, int n) {
        return MetashapeJNI.NetworkClient_connect(this.swigCPtr, this, string, n);
    }

    public void disconnect() {
        MetashapeJNI.NetworkClient_disconnect(this.swigCPtr, this);
    }

    public int createBatch(String string, NetworkTask[] networkTaskArray, Map<String, String> map) {
        return MetashapeJNI.NetworkClient_createBatch(this.swigCPtr, this, string, networkTaskArray, map);
    }

    public int findBatch(String string) {
        return MetashapeJNI.NetworkClient_findBatch(this.swigCPtr, this, string);
    }

    public void abortBatch(int n) {
        MetashapeJNI.NetworkClient_abortBatch(this.swigCPtr, this, n);
    }

    public void setBatchPaused(int n, boolean bl) {
        MetashapeJNI.NetworkClient_setBatchPaused(this.swigCPtr, this, n, bl);
    }

    public void setBatchPriority(int n, int n2) {
        MetashapeJNI.NetworkClient_setBatchPriority(this.swigCPtr, this, n, n2);
    }

    public void setBatchNodeLimit(int n, int n2) {
        MetashapeJNI.NetworkClient_setBatchNodeLimit(this.swigCPtr, this, n, n2);
    }

    public void abortNode(int n) {
        MetashapeJNI.NetworkClient_abortNode(this.swigCPtr, this, n);
    }

    public void quitNode(int n) {
        MetashapeJNI.NetworkClient_quitNode(this.swigCPtr, this, n);
    }

    public void setNodePaused(int n, boolean bl) {
        MetashapeJNI.NetworkClient_setNodePaused(this.swigCPtr, this, n, bl);
    }

    public void setNodePriority(int n, int n2) {
        MetashapeJNI.NetworkClient_setNodePriority(this.swigCPtr, this, n, n2);
    }

    public void setNodeCapability(int n, int n2) {
        MetashapeJNI.NetworkClient_setNodeCapability(this.swigCPtr, this, n, n2);
    }

    public void setNodeGPUMask(int n, long l) {
        MetashapeJNI.NetworkClient_setNodeGPUMask(this.swigCPtr, this, n, l);
    }

    public void setNodeCPUEnable(int n, boolean bl) {
        MetashapeJNI.NetworkClient_setNodeCPUEnable(this.swigCPtr, this, n, bl);
    }

    public ServerInfo getServerInfo() {
        return MetashapeJNI.NetworkClient_getServerInfo(this.swigCPtr, this);
    }

    public ServerStatus getServerStatus(long l) {
        return MetashapeJNI.NetworkClient_getServerStatus(this.swigCPtr, this, l);
    }

    public void setMasterServer(String string) {
        MetashapeJNI.NetworkClient_setMasterServer(this.swigCPtr, this, string);
    }

    public BatchStatus getBatchStatus(int n, long l) {
        return MetashapeJNI.NetworkClient_getBatchStatus(this.swigCPtr, this, n, l);
    }

    public NodeStatus getNodeStatus(int n, long l) {
        return MetashapeJNI.NetworkClient_getNodeStatus(this.swigCPtr, this, n, l);
    }

    public BatchList getBatchList(long l) {
        return MetashapeJNI.NetworkClient_getBatchList(this.swigCPtr, this, l);
    }

    public NodeList getNodeList(long l) {
        return MetashapeJNI.NetworkClient_getNodeList(this.swigCPtr, this, l);
    }

    public String dumpBatches(int[] nArray) {
        return MetashapeJNI.NetworkClient_dumpBatches(this.swigCPtr, this, nArray);
    }

    public void loadBatches(String string) {
        MetashapeJNI.NetworkClient_loadBatches(this.swigCPtr, this, string);
    }

    public static enum Status {
        StatusPending,
        StatusInProgress,
        StatusCompleted,
        StatusAborted,
        StatusReady,
        StatusOffline;

    }

    public static class NodeList {
        private NodeItem[] items;
        private long next_revision;

        public void update(NodeList nodeList) {
            HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
            for (int i = 0; i < this.items.length; ++i) {
                hashMap.put(this.items[i].getNodeId(), i);
            }
            List<NodeItem> list = Arrays.asList(this.items);
            for (int i = 0; i < nodeList.items.length; ++i) {
                long l = nodeList.getItems()[i].getNodeId();
                if (hashMap.containsKey(l)) {
                    list.set((Integer)hashMap.get(l), nodeList.items[i]);
                    continue;
                }
                list.add(nodeList.items[i]);
            }
            this.items = list.toArray(new NodeItem[0]);
            this.next_revision = nodeList.next_revision;
        }

        public void setItems(NodeItem[] nodeItemArray) {
            this.items = nodeItemArray;
        }

        public NodeItem[] getItems() {
            return this.items;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }
    }

    public static class BatchList {
        private BatchItem[] items;
        private long next_revision;

        public void update(BatchList batchList) {
            HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
            for (int i = 0; i < this.items.length; ++i) {
                hashMap.put(this.items[i].getBatchId(), i);
            }
            List<BatchItem> list = Arrays.asList(this.items);
            for (int i = 0; i < batchList.items.length; ++i) {
                long l = batchList.getItems()[i].getBatchId();
                if (hashMap.containsKey(l)) {
                    list.set((Integer)hashMap.get(l), batchList.items[i]);
                    continue;
                }
                list.add(batchList.items[i]);
            }
            this.items = list.toArray(new BatchItem[0]);
            this.next_revision = batchList.next_revision;
        }

        public void setItems(BatchItem[] batchItemArray) {
            this.items = batchItemArray;
        }

        public BatchItem[] getItems() {
            return this.items;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }
    }

    public static class NodeItem {
        private String uuid;
        private String hostaddr;
        private String hostname;
        private long node_id;
        private String version;
        private Status status;
        private boolean paused;
        private int priority;
        private long time_connected;
        private long time_disconnected;
        private int capability;
        private double ram_size;
        private long gpu_mask;
        private boolean cpu_enable;
        private long batch_id;
        private double progress;
        private NetworkTask task;
        private long error_count;
        private long error_time;
        private long error_batch_id;
        private String error_message;
        private ResourceRecord resource_usage;

        public void setUuid(String string) {
            this.uuid = string;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setHostaddr(String string) {
            this.hostaddr = string;
        }

        public String getHostaddr() {
            return this.hostaddr;
        }

        public void setHostname(String string) {
            this.hostname = string;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setNodeId(long l) {
            this.node_id = l;
        }

        public long getNodeId() {
            return this.node_id;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getVersion() {
            return this.version;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setPaused(boolean bl) {
            this.paused = bl;
        }

        public boolean getPaused() {
            return this.paused;
        }

        public void setPriority(int n) {
            this.priority = n;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setTimeConnected(long l) {
            this.time_connected = l;
        }

        public long getTimeConnected() {
            return this.time_connected;
        }

        public void setTimeDisconnected(long l) {
            this.time_disconnected = l;
        }

        public long getTimeDisconnected() {
            return this.time_disconnected;
        }

        public void setCapability(int n) {
            this.capability = n;
        }

        public int getCapability() {
            return this.capability;
        }

        public void setRamSize(double d) {
            this.ram_size = d;
        }

        public double getRamSize() {
            return this.ram_size;
        }

        public void setGpuMask(long l) {
            this.gpu_mask = l;
        }

        public long getGpuMask() {
            return this.gpu_mask;
        }

        public void setCpuEnable(boolean bl) {
            this.cpu_enable = bl;
        }

        public boolean getCpuEnable() {
            return this.cpu_enable;
        }

        public void setBatchId(long l) {
            this.batch_id = l;
        }

        public long getBatchId() {
            return this.batch_id;
        }

        public void setProgress(double d) {
            this.progress = d;
        }

        public double getProgress() {
            return this.progress;
        }

        public void setTask(NetworkTask networkTask) {
            this.task = networkTask;
        }

        public NetworkTask getTask() {
            return this.task;
        }

        public void setErrorCount(long l) {
            this.error_count = l;
        }

        public long getErrorCount() {
            return this.error_count;
        }

        public void setErrorTime(long l) {
            this.error_time = l;
        }

        public long getErrorTime() {
            return this.error_time;
        }

        public void setErrorBatchId(long l) {
            this.error_batch_id = l;
        }

        public long getErrorBatchId() {
            return this.error_batch_id;
        }

        public void setErrorMessage(String string) {
            this.error_message = string;
        }

        public String getErrorMessage() {
            return this.error_message;
        }

        public void setResourceUsage(ResourceRecord resourceRecord) {
            this.resource_usage = resourceRecord;
        }

        public ResourceRecord getResourceUsage() {
            return this.resource_usage;
        }
    }

    public static class NodeStatus {
        private String uuid;
        private String hostname;
        private String hostaddr;
        private double ram_size;
        private long gpu_mask;
        private boolean cpu_enable;
        private long next_revision;
        private LogRecord[] log;
        private ResourceRecord[] resource_usage;

        public void setUuid(String string) {
            this.uuid = string;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setHostname(String string) {
            this.hostname = string;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostaddr(String string) {
            this.hostaddr = string;
        }

        public String getHostaddr() {
            return this.hostaddr;
        }

        public void setRamSize(double d) {
            this.ram_size = d;
        }

        public double getRamSize() {
            return this.ram_size;
        }

        public void setGpuMask(long l) {
            this.gpu_mask = l;
        }

        public long getGpuMask() {
            return this.gpu_mask;
        }

        public void setCpuEnable(boolean bl) {
            this.cpu_enable = bl;
        }

        public boolean getCpuEnable() {
            return this.cpu_enable;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }

        public void setLog(LogRecord[] logRecordArray) {
            this.log = logRecordArray;
        }

        public LogRecord[] getLog() {
            return this.log;
        }

        public void setResourceUsage(ResourceRecord[] resourceRecordArray) {
            this.resource_usage = resourceRecordArray;
        }

        public ResourceRecord[] getResourceUsage() {
            return this.resource_usage;
        }
    }

    public static class BatchItem {
        private long batch_id;
        private String path;
        private String uuid;
        private Map<String, String> meta;
        private Status status;
        private boolean paused;
        private int priority;
        private int node_limit;
        private String node_version;
        private long time_started;
        private long time_finished;
        private TaskStatus task;

        public void setBatchId(long l) {
            this.batch_id = l;
        }

        public long getBatchId() {
            return this.batch_id;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setUuid(String string) {
            this.uuid = string;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setMeta(Map<String, String> map) {
            this.meta = map;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setPaused(boolean bl) {
            this.paused = bl;
        }

        public boolean getPaused() {
            return this.paused;
        }

        public void setPriority(int n) {
            this.priority = n;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setNodeLimit(int n) {
            this.node_limit = n;
        }

        public int getNodeLimit() {
            return this.node_limit;
        }

        public void setNodeVersion(String string) {
            this.node_version = string;
        }

        public String getNodeVersion() {
            return this.node_version;
        }

        public void setTimeStarted(long l) {
            this.time_started = l;
        }

        public long getTimeStarted() {
            return this.time_started;
        }

        public void setTimeFinished(long l) {
            this.time_finished = l;
        }

        public long getTimeFinished() {
            return this.time_finished;
        }

        public void setTask(TaskStatus taskStatus) {
            this.task = taskStatus;
        }

        public TaskStatus getTask() {
            return this.task;
        }
    }

    public static class BatchStatus {
        private String path;
        private String uuid;
        private Map<String, String> meta;
        private Status status;
        private boolean paused;
        private int priority;
        private int node_limit;
        private long time_started;
        private long time_finished;
        private TaskStatus[] tasks;
        private long error_time;
        private long error_node_id;
        private String error_message;
        private long next_revision;

        public void update(BatchStatus batchStatus) {
            this.path = batchStatus.path;
            this.uuid = batchStatus.uuid;
            this.meta = batchStatus.meta;
            this.status = batchStatus.status;
            this.paused = batchStatus.paused;
            this.priority = batchStatus.priority;
            this.time_started = batchStatus.time_started;
            this.time_finished = batchStatus.time_finished;
            this.error_time = batchStatus.error_time;
            this.error_node_id = batchStatus.error_node_id;
            this.error_message = batchStatus.error_message;
            this.next_revision = batchStatus.next_revision;
            TaskStatus[] taskStatusArray = new TaskStatus[batchStatus.tasks.length];
            for (int i = 0; i < batchStatus.tasks.length; ++i) {
                if (i < this.tasks.length) {
                    taskStatusArray[i] = this.tasks[i];
                    taskStatusArray[i].update(batchStatus.tasks[i]);
                    continue;
                }
                taskStatusArray[i] = batchStatus.tasks[i];
            }
            this.tasks = taskStatusArray;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setUuid(String string) {
            this.uuid = string;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setMeta(Map<String, String> map) {
            this.meta = map;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setPaused(boolean bl) {
            this.paused = bl;
        }

        public boolean getPaused() {
            return this.paused;
        }

        public void setPriority(int n) {
            this.priority = n;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setNodeLimit(int n) {
            this.node_limit = n;
        }

        public int getNodeLimit() {
            return this.node_limit;
        }

        public void setTimeStarted(long l) {
            this.time_started = l;
        }

        public long getTimeStarted() {
            return this.time_started;
        }

        public void setTimeFinished(long l) {
            this.time_finished = l;
        }

        public long getTimeFinished() {
            return this.time_finished;
        }

        public void setTasks(TaskStatus[] taskStatusArray) {
            this.tasks = taskStatusArray;
        }

        public TaskStatus[] getTasks() {
            return this.tasks;
        }

        public void setErrorTime(long l) {
            this.error_time = l;
        }

        public long getErrorTime() {
            return this.error_time;
        }

        public void setErrorNodeId(long l) {
            this.error_node_id = l;
        }

        public long getErrorNodeId() {
            return this.error_node_id;
        }

        public void setErrorMessage(String string) {
            this.error_message = string;
        }

        public String getErrorMessage() {
            return this.error_message;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }
    }

    public static class TaskStatus {
        private NetworkTask task;
        private Status status;
        private double progress;
        private double time_elapsed;
        private double time_left;
        private double processing_time;
        private int items_total;
        private int items_done;
        private int workitems_waiting;
        private int workitems_working;
        private int workitems_completed;
        private int workitems_failed;
        private LogRecord[] log;

        public void update(TaskStatus taskStatus) {
            int n;
            this.task = taskStatus.task;
            this.status = taskStatus.status;
            this.progress = taskStatus.progress;
            this.time_elapsed = taskStatus.time_elapsed;
            this.time_left = taskStatus.time_left;
            this.processing_time = taskStatus.processing_time;
            this.items_total = taskStatus.items_total;
            this.items_done = taskStatus.items_done;
            this.workitems_waiting = taskStatus.workitems_waiting;
            this.workitems_working = taskStatus.workitems_working;
            this.workitems_completed = taskStatus.workitems_completed;
            this.workitems_failed = taskStatus.workitems_failed;
            LogRecord[] logRecordArray = new LogRecord[this.log.length + taskStatus.log.length];
            for (n = 0; n < this.log.length; ++n) {
                logRecordArray[n] = this.log[n];
            }
            for (n = 0; n < taskStatus.log.length; ++n) {
                logRecordArray[this.log.length + n] = taskStatus.log[n];
            }
            this.log = logRecordArray;
        }

        public void setTask(NetworkTask networkTask) {
            this.task = networkTask;
        }

        public NetworkTask getTask() {
            return this.task;
        }

        public void setStatus(Status status) {
            this.status = status;
        }

        public Status getStatus() {
            return this.status;
        }

        public void setProgress(double d) {
            this.progress = d;
        }

        public double getProgress() {
            return this.progress;
        }

        public void setTimeElapsed(double d) {
            this.time_elapsed = d;
        }

        public double getTimeElapsed() {
            return this.time_elapsed;
        }

        public void setTimeLeft(double d) {
            this.time_left = d;
        }

        public double getTimeLeft() {
            return this.time_left;
        }

        public void setProcessingTime(double d) {
            this.processing_time = d;
        }

        public double getProcessingTime() {
            return this.processing_time;
        }

        public void setItemsTotal(int n) {
            this.items_total = n;
        }

        public int getItemsTotal() {
            return this.items_total;
        }

        public void setItemsDone(int n) {
            this.items_done = n;
        }

        public int getItemsDone() {
            return this.items_done;
        }

        public void setWorkitemsWaiting(int n) {
            this.workitems_waiting = n;
        }

        public int getWorkitemsWaiting() {
            return this.workitems_waiting;
        }

        public void setWorkitemsWorking(int n) {
            this.workitems_working = n;
        }

        public int getWorkitemsWorking() {
            return this.workitems_working;
        }

        public void setWorkitemsCompleted(int n) {
            this.workitems_completed = n;
        }

        public int getWorkitemsCompleted() {
            return this.workitems_completed;
        }

        public void setWorkitemsFailed(int n) {
            this.workitems_failed = n;
        }

        public int getWorkitemsFailed() {
            return this.workitems_failed;
        }

        public void setLog(LogRecord[] logRecordArray) {
            this.log = logRecordArray;
        }

        public LogRecord[] getLog() {
            return this.log;
        }
    }

    public static class ServerStatus {
        private double ram_size;
        private String master_hostaddr;
        private int slave_count;
        private int scheduling_mode;
        private long next_revision;
        private LogRecord[] log;
        private ResourceRecord[] resource_usage;

        public void setRamSize(double d) {
            this.ram_size = d;
        }

        public double getRamSize() {
            return this.ram_size;
        }

        public void setMasterHostaddr(String string) {
            this.master_hostaddr = string;
        }

        public String getMasterHostaddr() {
            return this.master_hostaddr;
        }

        public void setSlaveCount(int n) {
            this.slave_count = n;
        }

        public int getSlaveCount() {
            return this.slave_count;
        }

        public void setSchedulingMode(int n) {
            this.scheduling_mode = n;
        }

        public int getSchedulingMode() {
            return this.scheduling_mode;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }

        public void setLog(LogRecord[] logRecordArray) {
            this.log = logRecordArray;
        }

        public LogRecord[] getLog() {
            return this.log;
        }

        public void setResourceUsage(ResourceRecord[] resourceRecordArray) {
            this.resource_usage = resourceRecordArray;
        }

        public ResourceRecord[] getResourceUsage() {
            return this.resource_usage;
        }
    }

    public static class ServerInfo {
        private long time_started;
        private String version;

        public void setTimeStarted(long l) {
            this.time_started = l;
        }

        public long getTimeStarted() {
            return this.time_started;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static class ResourceRecord {
        private double time;
        private double ram_usage;
        private double cpu_usage;

        public void setTime(double d) {
            this.time = d;
        }

        public double getTime() {
            return this.time;
        }

        public void setRamUsage(double d) {
            this.ram_usage = d;
        }

        public double getRamUsage() {
            return this.ram_usage;
        }

        public void setCpuUsage(double d) {
            this.cpu_usage = d;
        }

        public double getCpuUsage() {
            return this.cpu_usage;
        }
    }

    public static class LogRecord {
        private int type;
        private String text;

        public void setType(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        public void setText(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }
    }
}

