/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Chunk;
import com.agisoft.metashape.DepthMap;
import com.agisoft.metashape.MetashapeJNI;
import java.util.Map;
import java.util.Optional;

public class DepthMaps
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DepthMaps(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DepthMaps depthMaps) {
        return depthMaps == null ? 0L : depthMaps.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_DepthMaps(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public DepthMaps(DepthMaps depthMaps) {
        this(MetashapeJNI.new_DepthMaps(DepthMaps.getCPtr(depthMaps), depthMaps), true);
    }

    public int getKey() {
        return MetashapeJNI.DepthMaps_getKey(this.swigCPtr, this);
    }

    public Optional<Chunk> getChunk() {
        long l = MetashapeJNI.DepthMaps_getChunk(this.swigCPtr, this);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new Chunk(l, true));
    }

    public void setLabel(String string) {
        MetashapeJNI.DepthMaps_setLabel(this.swigCPtr, this, string);
    }

    public String getLabel() {
        return MetashapeJNI.DepthMaps_getLabel(this.swigCPtr, this);
    }

    public void setDepthMap(int n, DepthMap depthMap) {
        MetashapeJNI.DepthMaps_setDepthMap(this.swigCPtr, this, n, depthMap == null ? 0L : DepthMap.getCPtr(depthMap), depthMap);
    }

    public Optional<DepthMap> getDepthMap(int n) {
        long l = MetashapeJNI.DepthMaps_getDepthMap(this.swigCPtr, this, n);
        if (l == 0L) {
            return Optional.empty();
        }
        return Optional.of(new DepthMap(l, true));
    }

    public String getPath() {
        return MetashapeJNI.DepthMaps_getPath(this.swigCPtr, this);
    }

    public void setMeta(Map<String, String> map) {
        MetashapeJNI.DepthMaps_setMeta(this.swigCPtr, this, map);
    }

    public Map<String, String> getMeta() {
        return MetashapeJNI.DepthMaps_getMeta(this.swigCPtr, this);
    }
}

