/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

public class Vector {
    private double[] data;

    public Vector() {
        this.data = null;
    }

    public Vector(int n) {
        this.data = new double[n];
    }

    public Vector(double d, double d2) {
        this.data = new double[]{d, d2};
    }

    public Vector(double d, double d2, double d3) {
        this.data = new double[]{d, d2, d3};
    }

    public Vector(double d, double d2, double d3, double d4) {
        this.data = new double[]{d, d2, d3, d4};
    }

    public Vector(double[] dArray) {
        this.data = dArray;
    }

    public int getSize() {
        return this.data.length;
    }

    public double get(int n) {
        return this.data[n];
    }

    public void set(int n, double d) {
        this.data[n] = d;
    }

    public double getX() {
        return this.data[0];
    }

    public double getY() {
        return this.data[1];
    }

    public double getZ() {
        return this.data[2];
    }

    public double getW() {
        return this.data[3];
    }

    public void setX(double d) {
        this.data[0] = d;
    }

    public void setY(double d) {
        this.data[1] = d;
    }

    public void setZ(double d) {
        this.data[2] = d;
    }

    public void setW(double d) {
        this.data[3] = d;
    }

    public double[] getData() {
        return this.data;
    }

    public void setData(double[] dArray) {
        this.data = dArray;
    }

    public double dot(Vector vector) {
        double d = 0.0;
        for (int i = 0; i < this.data.length; ++i) {
            d += this.data[i] * vector.data[i];
        }
        return d;
    }

    public Vector mul(double d) {
        Vector vector = new Vector(new double[this.data.length]);
        for (int i = 0; i < this.data.length; ++i) {
            vector.data[i] = this.data[i] * d;
        }
        return vector;
    }

    public Vector add(Vector vector) {
        Vector vector2 = new Vector(new double[this.data.length]);
        for (int i = 0; i < this.data.length; ++i) {
            vector2.data[i] = this.data[i] + vector.data[i];
        }
        return vector2;
    }

    public Vector sub(Vector vector) {
        Vector vector2 = new Vector(new double[this.data.length]);
        for (int i = 0; i < this.data.length; ++i) {
            vector2.data[i] = this.data[i] - vector.data[i];
        }
        return vector2;
    }

    public Vector cross(Vector vector) {
        return new Vector(this.getY() * vector.getZ() - vector.getY() * this.getZ(), this.getZ() * vector.getX() - vector.getZ() * this.getX(), this.getX() * vector.getY() - vector.getX() * this.getY());
    }

    public double norm() {
        return Math.sqrt(this.dot(this));
    }

    public Vector normalized() {
        double d = this.norm();
        if (d != 0.0) {
            d = 1.0 / d;
        }
        return this.mul(d);
    }
}

