/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * Camera instance.
 */
public class Camera implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Camera(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Camera obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_Camera(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  static public class Reference {

    private Vector location;
    private Vector rotation;
    private Vector location_accuracy;
    private Vector rotation_accuracy;
    private boolean location_enabled;
    private boolean rotation_enabled;

    public Reference() {
      location = null;
      rotation = null;
      location_accuracy = null;
      rotation_accuracy = null;
      location_enabled = false;
      rotation_enabled = false;
    }

    /**
     *  Location enabled flag.
     */
    public void setLocationEnabled(boolean state) {
      location_enabled = state;
    }

    /**
     *  Location enabled flag.
     */
    public boolean isLocationEnabled() {
      return location_enabled;
    }

    /**
     *  Rotation enabled flag.
     */
    public void setRotationEnabled(boolean state) {
      rotation_enabled = state;
    }

    /**
     *  Rotation enabled flag.
     */
    public boolean isRotationEnabled() {
      return rotation_enabled;
    }

    /**
     *  Camera coordinates, may be null.
     */
    public void setLocation(Vector location) {
      this.location = location;
    }

    /**
     *  Camera coordinates.
     */
    public Optional<Vector> getLocation() {
      return Optional.ofNullable(location);
    }

    /**
     *  Camera rotation angles, may be null.
     */
    public void setRotation(Vector rotation) {
      this.rotation = rotation;
    }

    /**
     *  Camera rotation angles.
     */
    public Optional<Vector> getRotation() {
      return Optional.ofNullable(rotation);
    }

    /**
     *  Camera location accuracy, may be null.
     */
    public void setLocationAccuracy(Vector accuracy) {
      location_accuracy = accuracy;
    }

    /**
     *  Camera location accuracy.
     */
    public Optional<Vector> getLocationAccuracy() {
      return Optional.ofNullable(location_accuracy);
    }

    /**
     *  Camera rotation accuracy, may be null.
     */
    public void setRotationAccuracy(Vector accuracy) {
      rotation_accuracy = accuracy;
    }

    /**
     *  Camera rotation accuracy.
     */
    public Optional<Vector> getRotationAccuracy() {
      return Optional.ofNullable(rotation_accuracy);
    }

  }

  public Camera(Camera camera) {
    this(MetashapeJNI.new_Camera(Camera.getCPtr(camera), camera), true);
  }

  /**
   *  Camera identifier.
   */
  public int getKey() {
    return MetashapeJNI.Camera_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.Camera_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Camera type.
   */
  public void setType(Camera.Type type) {
    MetashapeJNI.Camera_setType(swigCPtr, this, type.ordinal());
  }

  /**
   *  Camera type.
   */
  public Camera.Type getType() {
    return Camera.Type.class.getEnumConstants()[MetashapeJNI.Camera_getType(swigCPtr, this)];
  }

  /**
   *  Camera label.
   */
  public void setLabel(String label) {
    MetashapeJNI.Camera_setLabel(swigCPtr, this, label);
  }

  /**
   *  Camera label.
   */
  public String getLabel() {
    return MetashapeJNI.Camera_getLabel(swigCPtr, this);
  }

  /**
   *  Enables/disables the photo.
   */
  public void setEnabled(boolean state) {
    MetashapeJNI.Camera_setEnabled(swigCPtr, this, state);
  }

  /**
   *  Enables/disables the photo.
   */
  public boolean isEnabled() {
    return MetashapeJNI.Camera_isEnabled(swigCPtr, this);
  }

  /**
   *  Selects/deselects the photo.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.Camera_setSelected(swigCPtr, this, state);
  }

  /**
   *  Selects/deselects the photo.
   */
  public boolean isSelected() {
    return MetashapeJNI.Camera_isSelected(swigCPtr, this);
  }

  /**
   *  Image orientation (1 - normal, 6 - 90 degree, 3 - 180 degree, 8 - 270 degree).
   */
  public void setOrientation(int orientation) {
    MetashapeJNI.Camera_setOrientation(swigCPtr, this, orientation);
  }

  /**
   *  Image orientation (1 - normal, 6 - 90 degree, 3 - 180 degree, 8 - 270 degree).
   */
  public int getOrientation() {
    return MetashapeJNI.Camera_getOrientation(swigCPtr, this);
  }

  /**
   *  Camera sensor, may be null.
   */
  public void setSensor(Sensor sensor) {
    MetashapeJNI.Camera_setSensor(swigCPtr, this, sensor == null ? 0 : Sensor.getCPtr(sensor), sensor);
  }

  /**
   *  Camera sensor, may be null.
   */
  public Optional<Sensor> getSensor() {
    long ptr = MetashapeJNI.Camera_getSensor(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Sensor(ptr, true));
  }

  /**
   *  Camera master, may be null.
   */
  public void setMaster(Camera camera) {
    MetashapeJNI.Camera_setMaster(swigCPtr, this, camera == null ? 0 : Camera.getCPtr(camera), camera);
  }

  /**
   *  Camera master, may be null.
   */
  public Optional<Camera> getMaster() {
    long ptr = MetashapeJNI.Camera_getMaster(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Camera(ptr, true));
  }

  /**
   *  Camera group, may be null.
   */
  public void setGroup(CameraGroup group) {
    MetashapeJNI.Camera_setGroup(swigCPtr, this, group == null ? 0 : CameraGroup.getCPtr(group), group);
  }

  /**
   *  Camera group, may be null.
   */
  public Optional<CameraGroup> getGroup() {
    long ptr = MetashapeJNI.Camera_getGroup(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CameraGroup(ptr, true));
  }

  /**
   *  Camera photo, may be null.
   */
  public void setPhoto(Photo photo) {
    MetashapeJNI.Camera_setPhoto(swigCPtr, this, photo);
  }

  /**
   *  Camera photo, may be null.
   */
  public Optional<Photo> getPhoto() {
	Photo values = MetashapeJNI.Camera_getPhoto(swigCPtr, this);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   *  4x4 matrix describing photo location in the chunk coordinate system, may be null.
   */
  public void setTransform(Matrix transform) {
    MetashapeJNI.Camera_setTransform(swigCPtr, this, transform);
  }

  /**
   *  4x4 matrix describing photo location in the chunk coordinate system, may be null.
   */
  public Optional<Matrix> getTransform() {
	Matrix values = MetashapeJNI.Camera_getTransform(swigCPtr, this);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   *  Camera mask, may be null.
   */
  public void setMask(Image mask) {
    MetashapeJNI.Camera_setMask(swigCPtr, this, mask == null ? 0 : Image.getCPtr(mask), mask);
  }

  /**
   *  Camera mask, may be null.
   */
  public Optional<Image> getMask() {
    long ptr = MetashapeJNI.Camera_getMask(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Image(ptr, true));
  }

  /**
   *  Camera thumbnail, may be null.
   */
  public void setThumbnail(Image thumbnail) {
    MetashapeJNI.Camera_setThumbnail(swigCPtr, this, thumbnail == null ? 0 : Image.getCPtr(thumbnail), thumbnail);
  }

  /**
   *  Camera thumbnail, may be null.
   */
  public Optional<Image> getThumbnail() {
    long ptr = MetashapeJNI.Camera_getThumbnail(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Image(ptr, true));
  }

  /**
   *  Camera shutter, may be null.
   */
  public void setShutter(Shutter shutter) {
    MetashapeJNI.Camera_setShutter(swigCPtr, this, shutter);
  }

  /**
   *  Camera shutter, may be null.
   */
  public Optional<Shutter> getShutter() {
	Shutter values = MetashapeJNI.Camera_getShutter(swigCPtr, this);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   *  Vignetting for each band.
   */
  public void setVignetting(Vignetting[] vignetting) {
    MetashapeJNI.Camera_setVignetting(swigCPtr, this, vignetting);
  }

  /**
   *  Vignetting for each band.
   */
  public Vignetting[] getVignetting() { return MetashapeJNI.Camera_getVignetting(swigCPtr, this); }

  public Vector getCenter() { return MetashapeJNI.Camera_getCenter(swigCPtr, this); }

  public Vector getError(Vector pt, Vector proj) { return MetashapeJNI.Camera_getError(swigCPtr, this, pt, proj); }

  public Vector project(Vector pt) { return MetashapeJNI.Camera_project(swigCPtr, this, pt); }

  public Vector unproject(Vector proj) { return MetashapeJNI.Camera_unproject(swigCPtr, this, proj); }

  public Vector unproject3D(Vector proj) { return MetashapeJNI.Camera_unproject3D(swigCPtr, this, proj); }

  /**
   *  Camera image, may be null.
   */
  public Optional<Image> loadImage() {
    long ptr = MetashapeJNI.Camera_loadImage(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Image(ptr, true));
  }

  /**
   *  Camera reference data.
   */
  public Camera.Reference getReference() { return MetashapeJNI.Camera_getReference(swigCPtr, this); }

  /**
   *  Camera reference data.
   */
  public void setReference(Camera.Reference reference) {
    MetashapeJNI.Camera_setReference(swigCPtr, this, reference);
  }

  /**
   *  Camera meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.Camera_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Camera meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.Camera_getMeta(swigCPtr, this); }

  public enum Type {
    TypeRegular,
    TypeKeyframe;
  }

}
