package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class SmoothPointCloud extends Task {

	public SmoothPointCloud() {
		super("SmoothPointCloud");
	}

	/**
	 *  Key of point cloud to filter. Default: -1
	 */
	public void setPointCloud(int value) {
		setParameter("point_cloud", (Object) value);
	}

	/**
	 *  Key of point cloud to filter. Default: -1
	 */
	public int getPointCloud() {
		return (int) getParameter("point_cloud");
	}

	/**
	 *  Desired smoothing radius (m). Default: 0.0
	 */
	public void setSmoothingRadius(double value) {
		setParameter("smoothing_radius", (Object) value);
	}

	/**
	 *  Desired smoothing radius (m). Default: 0.0
	 */
	public double getSmoothingRadius() {
		return (double) getParameter("smoothing_radius");
	}

}
