/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.Vector;

public class Matrix {
    private double[][] data;

    public Matrix() {
        this.data = null;
    }

    public Matrix(int n, int n2) {
        this.data = new double[n][n2];
    }

    public Matrix(double[][] dArray) {
        this.data = dArray;
    }

    public int getRows() {
        return this.data.length;
    }

    public int getColumns() {
        return this.data[0].length;
    }

    public double get(int n, int n2) {
        return this.data[n][n2];
    }

    public void set(int n, int n2, double d) {
        this.data[n][n2] = d;
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
    }

    public Matrix mul(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRows(), matrix.getColumns());
        for (int i = 0; i < matrix2.getRows(); ++i) {
            for (int j = 0; j < matrix2.getColumns(); ++j) {
                double d = 0.0;
                for (int k = 0; k < this.getColumns(); ++k) {
                    d += this.get(i, k) * matrix.get(k, j);
                }
                matrix2.set(i, j, d);
            }
        }
        return matrix2;
    }

    public Vector mul(Vector vector) {
        Vector vector2 = new Vector(this.getRows());
        for (int i = 0; i < this.getRows(); ++i) {
            double d = 0.0;
            for (int j = 0; j < this.getColumns(); ++j) {
                d += this.get(i, j) * vector.get(j);
            }
            vector2.set(i, d);
        }
        return vector2;
    }

    public Matrix mul(double d) {
        Matrix matrix = new Matrix(this.getRows(), this.getColumns());
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.getColumns(); ++j) {
                matrix.data[i][j] = this.data[i][j] * d;
            }
        }
        return matrix;
    }

    public Vector mulp(Vector vector) {
        double d = this.data[this.getRows() - 1][this.getColumns() - 1];
        for (int i = 0; i < this.getColumns() - 1; ++i) {
            d += this.data[this.getRows() - 1][i] * vector.get(i);
        }
        if (d != 0.0) {
            d = 1.0 / d;
        }
        Vector vector2 = new Vector(this.getRows() - 1);
        for (int i = 0; i < this.getRows() - 1; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.getColumns() - 1; ++j) {
                d2 += this.get(i, j) * vector.get(j);
            }
            vector2.set(i, d2 * d);
        }
        return vector2;
    }

    public Vector mulv(Vector vector) {
        Vector vector2 = new Vector(this.getRows() - 1);
        for (int i = 0; i < this.getRows() - 1; ++i) {
            double d = 0.0;
            for (int j = 0; j < this.getColumns() - 1; ++j) {
                d += this.get(i, j) * vector.get(j);
            }
            vector2.set(i, d);
        }
        return vector2;
    }

    public Matrix add(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRows(), this.getColumns());
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                matrix2.data[i][j] = this.data[i][j] + matrix.data[i][j];
            }
        }
        return matrix2;
    }

    public Matrix sub(Matrix matrix) {
        Matrix matrix2 = new Matrix(this.getRows(), this.getColumns());
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                matrix2.data[i][j] = this.data[i][j] - matrix.data[i][j];
            }
        }
        return matrix2;
    }

    public Matrix t() {
        Matrix matrix = new Matrix(this.getColumns(), this.getRows());
        for (int i = 0; i < this.getRows(); ++i) {
            for (int j = 0; j < this.data.length; ++j) {
                matrix.data[j][i] = this.data[i][j];
            }
        }
        return matrix;
    }

    public Vector getRow(int n) {
        return new Vector(this.data[n]);
    }

    public Vector getColumn(int n) {
        Vector vector = new Vector(this.getRows());
        for (int i = 0; i < this.getRows(); ++i) {
            vector.set(i, this.data[i][n]);
        }
        return vector;
    }

    public double det() {
        if (this.getRows() == 2 && this.getColumns() == 2) {
            return this.data[0][0] * this.data[1][1] - this.data[0][1] * this.data[1][0];
        }
        if (this.getRows() == 3 && this.getColumns() == 3) {
            return this.data[0][0] * (this.data[1][1] * this.data[2][2] - this.data[1][2] * this.data[2][1]) - this.data[0][1] * (this.data[1][0] * this.data[2][2] - this.data[1][2] * this.data[2][0]) + this.data[0][2] * (this.data[1][0] * this.data[2][1] - this.data[1][1] * this.data[2][0]);
        }
        if (this.getRows() == 4 && this.getColumns() == 4) {
            return (this.data[0][0] * this.data[1][1] - this.data[0][1] * this.data[1][0]) * (this.data[2][2] * this.data[3][3] - this.data[2][3] * this.data[3][2]) - (this.data[0][0] * this.data[1][2] - this.data[0][2] * this.data[1][0]) * (this.data[2][1] * this.data[3][3] - this.data[2][3] * this.data[3][1]) + (this.data[0][0] * this.data[1][3] - this.data[0][3] * this.data[1][0]) * (this.data[2][1] * this.data[3][2] - this.data[2][2] * this.data[3][1]) + (this.data[0][1] * this.data[1][2] - this.data[0][2] * this.data[1][1]) * (this.data[2][0] * this.data[3][3] - this.data[2][3] * this.data[3][0]) - (this.data[0][1] * this.data[1][3] - this.data[0][3] * this.data[1][1]) * (this.data[2][0] * this.data[3][2] - this.data[2][2] * this.data[3][0]) + (this.data[0][2] * this.data[1][3] - this.data[0][3] * this.data[1][2]) * (this.data[2][0] * this.data[3][1] - this.data[2][1] * this.data[3][0]);
        }
        return 0.0;
    }

    public Matrix inv() {
        if (this.getRows() == 2 && this.getColumns() == 2) {
            double d = 1.0 / this.det();
            Matrix matrix = new Matrix(this.getColumns(), this.getRows());
            matrix.data[0][0] = this.data[1][1] * d;
            matrix.data[0][1] = -this.data[0][1] * d;
            matrix.data[1][0] = -this.data[1][0] * d;
            matrix.data[1][1] = this.data[0][0] * d;
            return matrix;
        }
        if (this.getRows() == 3 && this.getColumns() == 3) {
            double d = 1.0 / this.det();
            Matrix matrix = new Matrix(this.getColumns(), this.getRows());
            matrix.data[0][0] = (this.data[1][1] * this.data[2][2] - this.data[1][2] * this.data[2][1]) * d;
            matrix.data[0][1] = (this.data[0][2] * this.data[2][1] - this.data[0][1] * this.data[2][2]) * d;
            matrix.data[0][2] = (this.data[0][1] * this.data[1][2] - this.data[0][2] * this.data[1][1]) * d;
            matrix.data[1][0] = (this.data[1][2] * this.data[2][0] - this.data[1][0] * this.data[2][2]) * d;
            matrix.data[1][1] = (this.data[0][0] * this.data[2][2] - this.data[0][2] * this.data[2][0]) * d;
            matrix.data[1][2] = (this.data[0][2] * this.data[1][0] - this.data[0][0] * this.data[1][2]) * d;
            matrix.data[2][0] = (this.data[1][0] * this.data[2][1] - this.data[1][1] * this.data[2][0]) * d;
            matrix.data[2][1] = (this.data[0][1] * this.data[2][0] - this.data[0][0] * this.data[2][1]) * d;
            matrix.data[2][2] = (this.data[0][0] * this.data[1][1] - this.data[0][1] * this.data[1][0]) * d;
            return matrix;
        }
        if (this.getRows() == 4 && this.getColumns() == 4) {
            double d = this.data[0][0] * this.data[1][1] - this.data[0][1] * this.data[1][0];
            double d2 = this.data[0][0] * this.data[1][2] - this.data[0][2] * this.data[1][0];
            double d3 = this.data[0][0] * this.data[1][3] - this.data[0][3] * this.data[1][0];
            double d4 = this.data[0][1] * this.data[1][2] - this.data[0][2] * this.data[1][1];
            double d5 = this.data[0][1] * this.data[1][3] - this.data[0][3] * this.data[1][1];
            double d6 = this.data[0][2] * this.data[1][3] - this.data[0][3] * this.data[1][2];
            double d7 = this.data[2][0] * this.data[3][1] - this.data[2][1] * this.data[3][0];
            double d8 = this.data[2][0] * this.data[3][2] - this.data[2][2] * this.data[3][0];
            double d9 = this.data[2][0] * this.data[3][3] - this.data[2][3] * this.data[3][0];
            double d10 = this.data[2][1] * this.data[3][2] - this.data[2][2] * this.data[3][1];
            double d11 = this.data[2][1] * this.data[3][3] - this.data[2][3] * this.data[3][1];
            double d12 = this.data[2][2] * this.data[3][3] - this.data[2][3] * this.data[3][2];
            double d13 = 1.0 / (d * d12 - d2 * d11 + d3 * d10 + d4 * d9 - d5 * d8 + d6 * d7);
            Matrix matrix = new Matrix(this.getColumns(), this.getRows());
            matrix.data[0][0] = (this.data[1][1] * d12 - this.data[1][2] * d11 + this.data[1][3] * d10) * d13;
            matrix.data[0][1] = (-this.data[0][1] * d12 + this.data[0][2] * d11 - this.data[0][3] * d10) * d13;
            matrix.data[0][2] = (this.data[3][1] * d6 - this.data[3][2] * d5 + this.data[3][3] * d4) * d13;
            matrix.data[0][3] = (-this.data[2][1] * d6 + this.data[2][2] * d5 - this.data[2][3] * d4) * d13;
            matrix.data[1][0] = (-this.data[1][0] * d12 + this.data[1][2] * d9 - this.data[1][3] * d8) * d13;
            matrix.data[1][1] = (this.data[0][0] * d12 - this.data[0][2] * d9 + this.data[0][3] * d8) * d13;
            matrix.data[1][2] = (-this.data[3][0] * d6 + this.data[3][2] * d3 - this.data[3][3] * d2) * d13;
            matrix.data[1][3] = (this.data[2][0] * d6 - this.data[2][2] * d3 + this.data[2][3] * d2) * d13;
            matrix.data[2][0] = (this.data[1][0] * d11 - this.data[1][1] * d9 + this.data[1][3] * d7) * d13;
            matrix.data[2][1] = (-this.data[0][0] * d11 + this.data[0][1] * d9 - this.data[0][3] * d7) * d13;
            matrix.data[2][2] = (this.data[3][0] * d5 - this.data[3][1] * d3 + this.data[3][3] * d) * d13;
            matrix.data[2][3] = (-this.data[2][0] * d5 + this.data[2][1] * d3 - this.data[2][3] * d) * d13;
            matrix.data[3][0] = (-this.data[1][0] * d10 + this.data[1][1] * d8 - this.data[1][2] * d7) * d13;
            matrix.data[3][1] = (this.data[0][0] * d10 - this.data[0][1] * d8 + this.data[0][2] * d7) * d13;
            matrix.data[3][2] = (-this.data[3][0] * d4 + this.data[3][1] * d2 - this.data[3][2] * d) * d13;
            matrix.data[3][3] = (this.data[2][0] * d4 - this.data[2][1] * d2 + this.data[2][2] * d) * d13;
            return matrix;
        }
        return null;
    }

    public Vector translation() {
        if (this.getRows() != 4 || this.getColumns() != 4) {
            return null;
        }
        Vector vector = new Vector(this.data[0][3], this.data[1][3], this.data[2][3]);
        return vector.mul(1.0 / this.data[3][3]);
    }

    public double scale() {
        Matrix matrix = new Matrix(3, 3);
        matrix.data[0] = new double[]{this.data[0][0], this.data[0][1], this.data[0][2]};
        matrix.data[1] = new double[]{this.data[1][0], this.data[1][1], this.data[1][2]};
        matrix.data[2] = new double[]{this.data[2][0], this.data[2][1], this.data[2][2]};
        Matrix matrix2 = matrix.t().mul(matrix);
        double d = (matrix2.data[0][0] + matrix2.data[1][1] + matrix2.data[2][2]) / 3.0;
        if (d <= 0.0) {
            return 0.0;
        }
        return Math.sqrt(d);
    }

    public Vector scale3() {
        Matrix matrix = new Matrix(3, 3);
        matrix.data[0] = new double[]{this.data[0][0], this.data[0][1], this.data[0][2]};
        matrix.data[1] = new double[]{this.data[1][0], this.data[1][1], this.data[1][2]};
        matrix.data[2] = new double[]{this.data[2][0], this.data[2][1], this.data[2][2]};
        Matrix matrix2 = matrix.t().mul(matrix);
        Vector vector = new Vector(matrix2.data[0][0], matrix2.data[1][1], matrix2.data[2][2]);
        if (vector.getX() > 0.0) {
            vector.setX(Math.sqrt(vector.getX()));
        }
        if (vector.getY() > 0.0) {
            vector.setY(Math.sqrt(vector.getY()));
        }
        if (vector.getZ() > 0.0) {
            vector.setZ(Math.sqrt(vector.getZ()));
        }
        return vector;
    }

    public Matrix rotation() {
        if (this.getRows() != 4 || this.getColumns() != 4) {
            return null;
        }
        Matrix matrix = new Matrix(3, 3);
        matrix.data[0] = new double[]{this.data[0][0], this.data[0][1], this.data[0][2]};
        matrix.data[1] = new double[]{this.data[1][0], this.data[1][1], this.data[1][2]};
        matrix.data[2] = new double[]{this.data[2][0], this.data[2][1], this.data[2][2]};
        Vector vector = this.scale3();
        if (vector.getX() != 0.0) {
            vector.setX(1.0 / vector.getX());
        }
        if (vector.getY() != 0.0) {
            vector.setY(1.0 / vector.getY());
        }
        if (vector.getZ() != 0.0) {
            vector.setZ(1.0 / vector.getZ());
        }
        return matrix.mul(Matrix.makeDiag(vector));
    }

    public static Matrix makeDiag(Vector vector) {
        Matrix matrix = new Matrix(vector.getSize(), vector.getSize());
        for (int i = 0; i < vector.getSize(); ++i) {
            for (int j = 0; j < vector.getSize(); ++j) {
                matrix.set(i, j, 0.0);
            }
            matrix.set(i, i, vector.get(i));
        }
        return matrix;
    }

    public static Matrix makeRotation(Matrix matrix) {
        int n;
        Matrix matrix2 = new Matrix(matrix.getRows() + 1, matrix.getColumns() + 1);
        for (n = 0; n < matrix.getRows(); ++n) {
            for (int i = 0; i < matrix.getColumns(); ++i) {
                matrix2.set(n, i, matrix.get(n, i));
            }
            matrix2.set(n, matrix.getColumns(), 0.0);
        }
        for (n = 0; n < matrix.getColumns(); ++n) {
            matrix2.set(matrix.getRows(), n, 0.0);
        }
        matrix2.set(matrix.getRows(), matrix.getColumns(), 1.0);
        return matrix2;
    }

    public static Matrix makeTranslation(Vector vector) {
        int n;
        Matrix matrix = new Matrix(vector.getSize() + 1, vector.getSize() + 1);
        for (n = 0; n < matrix.getRows(); ++n) {
            for (int i = 0; i < matrix.getColumns(); ++i) {
                matrix.set(n, i, 0.0);
            }
        }
        for (n = 0; n < vector.getSize(); ++n) {
            matrix.set(n, vector.getSize(), vector.get(n));
        }
        for (n = 0; n <= vector.getSize(); ++n) {
            matrix.set(n, n, 1.0);
        }
        return matrix;
    }

    public static Matrix makeScale(Vector vector) {
        int n;
        Matrix matrix = new Matrix(vector.getSize() + 1, vector.getSize() + 1);
        for (n = 0; n < matrix.getRows(); ++n) {
            for (int i = 0; i < matrix.getColumns(); ++i) {
                matrix.set(n, i, 0.0);
            }
        }
        for (n = 0; n < vector.getSize(); ++n) {
            matrix.set(n, n, vector.get(n));
        }
        matrix.set(vector.getSize(), vector.getSize(), 1.0);
        return matrix;
    }
}

