/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.NetworkTask;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NetworkClient
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected NetworkClient(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(NetworkClient networkClient) {
        return networkClient == null ? 0L : networkClient.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_NetworkClient(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public NetworkClient() {
        this(MetashapeJNI.new_NetworkClient(), true);
    }

    public boolean connect(String string, int n) {
        return MetashapeJNI.NetworkClient_connect(this.swigCPtr, this, string, n);
    }

    public void disconnect() {
        MetashapeJNI.NetworkClient_disconnect(this.swigCPtr, this);
    }

    public int createBatch(String string, NetworkTask[] networkTaskArray, Map<String, String> map) {
        return MetashapeJNI.NetworkClient_createBatch(this.swigCPtr, this, string, networkTaskArray, map);
    }

    public int findBatch(String string) {
        return MetashapeJNI.NetworkClient_findBatch(this.swigCPtr, this, string);
    }

    public void abortBatch(int n) {
        MetashapeJNI.NetworkClient_abortBatch(this.swigCPtr, this, n);
    }

    public void setBatchPaused(int n, boolean bl) {
        MetashapeJNI.NetworkClient_setBatchPaused(this.swigCPtr, this, n, bl);
    }

    public void setBatchPriority(int n, int n2) {
        MetashapeJNI.NetworkClient_setBatchPriority(this.swigCPtr, this, n, n2);
    }

    public void setBatchWorkerLimit(int n, int n2) {
        MetashapeJNI.NetworkClient_setBatchWorkerLimit(this.swigCPtr, this, n, n2);
    }

    public void abortWorker(int n) {
        MetashapeJNI.NetworkClient_abortWorker(this.swigCPtr, this, n);
    }

    public void quitWorker(int n) {
        MetashapeJNI.NetworkClient_quitWorker(this.swigCPtr, this, n);
    }

    public void setWorkerPaused(int n, boolean bl) {
        MetashapeJNI.NetworkClient_setWorkerPaused(this.swigCPtr, this, n, bl);
    }

    public void setWorkerPriority(int n, int n2) {
        MetashapeJNI.NetworkClient_setWorkerPriority(this.swigCPtr, this, n, n2);
    }

    public void setWorkerCapability(int n, int n2) {
        MetashapeJNI.NetworkClient_setWorkerCapability(this.swigCPtr, this, n, n2);
    }

    public void setWorkerGpuMask(int n, long l) {
        MetashapeJNI.NetworkClient_setWorkerGpuMask(this.swigCPtr, this, n, l);
    }

    public void setWorkerCpuEnabled(int n, boolean bl) {
        MetashapeJNI.NetworkClient_setWorkerCpuEnabled(this.swigCPtr, this, n, bl);
    }

    public ServerVersion getServerVersion() {
        return MetashapeJNI.NetworkClient_getServerVersion(this.swigCPtr, this);
    }

    public ServerInfo getServerInfo(long l) {
        return MetashapeJNI.NetworkClient_getServerInfo(this.swigCPtr, this, l);
    }

    public void setMasterServer(String string) {
        MetashapeJNI.NetworkClient_setMasterServer(this.swigCPtr, this, string);
    }

    public BatchInfo getBatchInfo(int n, long l) {
        return MetashapeJNI.NetworkClient_getBatchInfo(this.swigCPtr, this, n, l);
    }

    public WorkerInfo getWorkerInfo(int n, long l) {
        return MetashapeJNI.NetworkClient_getWorkerInfo(this.swigCPtr, this, n, l);
    }

    public BatchList getBatchList(long l) {
        return MetashapeJNI.NetworkClient_getBatchList(this.swigCPtr, this, l);
    }

    public WorkerList getWorkerList(long l) {
        return MetashapeJNI.NetworkClient_getWorkerList(this.swigCPtr, this, l);
    }

    public String exportBatches(int[] nArray) {
        return MetashapeJNI.NetworkClient_exportBatches(this.swigCPtr, this, nArray);
    }

    public void importBatches(String string) {
        MetashapeJNI.NetworkClient_importBatches(this.swigCPtr, this, string);
    }

    public static enum State {
        StatePending,
        StateInProgress,
        StateCompleted,
        StateReady,
        StateOffline;

    }

    public static class WorkerList {
        private WorkerItem[] workers;
        private long next_revision;

        public void update(WorkerList workerList) {
            HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
            for (int i = 0; i < this.workers.length; ++i) {
                hashMap.put(this.workers[i].getWorkerId(), i);
            }
            List<WorkerItem> list = Arrays.asList(this.workers);
            for (int i = 0; i < workerList.workers.length; ++i) {
                long l = workerList.getWorkers()[i].getWorkerId();
                if (hashMap.containsKey(l)) {
                    list.set((Integer)hashMap.get(l), workerList.workers[i]);
                    continue;
                }
                list.add(workerList.workers[i]);
            }
            this.workers = list.toArray(new WorkerItem[0]);
            this.next_revision = workerList.next_revision;
        }

        public void setWorkers(WorkerItem[] workerItemArray) {
            this.workers = workerItemArray;
        }

        public WorkerItem[] getWorkers() {
            return this.workers;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }
    }

    public static class BatchList {
        private BatchItem[] batches;
        private long next_revision;

        public void update(BatchList batchList) {
            HashMap<Long, Integer> hashMap = new HashMap<Long, Integer>();
            for (int i = 0; i < this.batches.length; ++i) {
                hashMap.put(this.batches[i].getBatchId(), i);
            }
            List<BatchItem> list = Arrays.asList(this.batches);
            for (int i = 0; i < batchList.batches.length; ++i) {
                long l = batchList.getBatches()[i].getBatchId();
                if (hashMap.containsKey(l)) {
                    list.set((Integer)hashMap.get(l), batchList.batches[i]);
                    continue;
                }
                list.add(batchList.batches[i]);
            }
            this.batches = list.toArray(new BatchItem[0]);
            this.next_revision = batchList.next_revision;
        }

        public void setBatches(BatchItem[] batchItemArray) {
            this.batches = batchItemArray;
        }

        public BatchItem[] getBatches() {
            return this.batches;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }
    }

    public static class WorkerItem {
        private String uuid;
        private String hostaddr;
        private String hostname;
        private long worker_id;
        private String version;
        private State state;
        private boolean aborted;
        private boolean paused;
        private int priority;
        private long connected_at;
        private long disconnected_at;
        private int capability;
        private double memory_size;
        private long gpu_mask;
        private boolean cpu_enabled;
        private long batch_id;
        private double progress;
        private NetworkTask task;
        private long error_count;
        private long error_time;
        private long error_batch_id;
        private String error_message;
        private ResourceRecord resource_usage;

        public void setUuid(String string) {
            this.uuid = string;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setHostaddr(String string) {
            this.hostaddr = string;
        }

        public String getHostaddr() {
            return this.hostaddr;
        }

        public void setHostname(String string) {
            this.hostname = string;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setWorkerId(long l) {
            this.worker_id = l;
        }

        public long getWorkerId() {
            return this.worker_id;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getVersion() {
            return this.version;
        }

        public void setState(State state) {
            this.state = state;
        }

        public State getState() {
            return this.state;
        }

        public void setAborted(boolean bl) {
            this.aborted = bl;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void setPaused(boolean bl) {
            this.paused = bl;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void setPriority(int n) {
            this.priority = n;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setConnectedAt(long l) {
            this.connected_at = l;
        }

        public long getConnectedAt() {
            return this.connected_at;
        }

        public void setDisconnectedAt(long l) {
            this.disconnected_at = l;
        }

        public long getDisconnectedAt() {
            return this.disconnected_at;
        }

        public void setCapability(int n) {
            this.capability = n;
        }

        public int getCapability() {
            return this.capability;
        }

        public void setMemorySize(double d) {
            this.memory_size = d;
        }

        public double getMemorySize() {
            return this.memory_size;
        }

        public void setGpuMask(long l) {
            this.gpu_mask = l;
        }

        public long getGpuMask() {
            return this.gpu_mask;
        }

        public void setCpuEnabled(boolean bl) {
            this.cpu_enabled = bl;
        }

        public boolean isCpuEnabled() {
            return this.cpu_enabled;
        }

        public void setBatchId(long l) {
            this.batch_id = l;
        }

        public long getBatchId() {
            return this.batch_id;
        }

        public void setProgress(double d) {
            this.progress = d;
        }

        public double getProgress() {
            return this.progress;
        }

        public void setTask(NetworkTask networkTask) {
            this.task = networkTask;
        }

        public NetworkTask getTask() {
            return this.task;
        }

        public void setErrorCount(long l) {
            this.error_count = l;
        }

        public long getErrorCount() {
            return this.error_count;
        }

        public void setErrorTime(long l) {
            this.error_time = l;
        }

        public long getErrorTime() {
            return this.error_time;
        }

        public void setErrorBatchId(long l) {
            this.error_batch_id = l;
        }

        public long getErrorBatchId() {
            return this.error_batch_id;
        }

        public void setErrorMessage(String string) {
            this.error_message = string;
        }

        public String getErrorMessage() {
            return this.error_message;
        }

        public void setResourceUsage(ResourceRecord resourceRecord) {
            this.resource_usage = resourceRecord;
        }

        public ResourceRecord getResourceUsage() {
            return this.resource_usage;
        }
    }

    public static class WorkerInfo {
        private String uuid;
        private String hostname;
        private String hostaddr;
        private double memory_size;
        private long gpu_mask;
        private boolean cpu_enabled;
        private long next_revision;
        private OutputRecord[] output;
        private ResourceRecord[] resource_usage;

        public void setUuid(String string) {
            this.uuid = string;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setHostname(String string) {
            this.hostname = string;
        }

        public String getHostname() {
            return this.hostname;
        }

        public void setHostaddr(String string) {
            this.hostaddr = string;
        }

        public String getHostaddr() {
            return this.hostaddr;
        }

        public void setMemorySize(double d) {
            this.memory_size = d;
        }

        public double getMemorySize() {
            return this.memory_size;
        }

        public void setGpuMask(long l) {
            this.gpu_mask = l;
        }

        public long getGpuMask() {
            return this.gpu_mask;
        }

        public void setCpuEnabled(boolean bl) {
            this.cpu_enabled = bl;
        }

        public boolean isCpuEnabled() {
            return this.cpu_enabled;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }

        public void setOutput(OutputRecord[] outputRecordArray) {
            this.output = outputRecordArray;
        }

        public OutputRecord[] getOutput() {
            return this.output;
        }

        public void setResourceUsage(ResourceRecord[] resourceRecordArray) {
            this.resource_usage = resourceRecordArray;
        }

        public ResourceRecord[] getResourceUsage() {
            return this.resource_usage;
        }
    }

    public static class BatchItem {
        private long batch_id;
        private String path;
        private String uuid;
        private Map<String, String> meta;
        private String username;
        private State state;
        private boolean aborted;
        private boolean failed;
        private boolean paused;
        private int priority;
        private int worker_limit;
        private String min_worker_version;
        private String max_worker_version;
        private String worker_version;
        private long started_at;
        private long finished_at;
        private TaskInfo task_info;

        public void setBatchId(long l) {
            this.batch_id = l;
        }

        public long getBatchId() {
            return this.batch_id;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setUuid(String string) {
            this.uuid = string;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setMeta(Map<String, String> map) {
            this.meta = map;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public void setUsername(String string) {
            this.username = string;
        }

        public String getUsername() {
            return this.username;
        }

        public void setState(State state) {
            this.state = state;
        }

        public State getState() {
            return this.state;
        }

        public void setAborted(boolean bl) {
            this.aborted = bl;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void setFailed(boolean bl) {
            this.failed = bl;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setPaused(boolean bl) {
            this.paused = bl;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void setPriority(int n) {
            this.priority = n;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setWorkerLimit(int n) {
            this.worker_limit = n;
        }

        public int getWorkerLimit() {
            return this.worker_limit;
        }

        public void setMinWorkerVersion(String string) {
            this.min_worker_version = string;
        }

        public String getMinWorkerVersion() {
            return this.min_worker_version;
        }

        public void setMaxWorkerVersion(String string) {
            this.max_worker_version = string;
        }

        public String getMaxWorkerVersion() {
            return this.max_worker_version;
        }

        public void setWorkerVersion(String string) {
            this.worker_version = string;
        }

        public String getWorkerVersion() {
            return this.worker_version;
        }

        public void setStartedAt(long l) {
            this.started_at = l;
        }

        public long getStartedAt() {
            return this.started_at;
        }

        public void setFinishedAt(long l) {
            this.finished_at = l;
        }

        public long getFinishedAt() {
            return this.finished_at;
        }

        public void setTaskInfo(TaskInfo taskInfo) {
            this.task_info = taskInfo;
        }

        public TaskInfo getTaskInfo() {
            return this.task_info;
        }
    }

    public static class BatchInfo {
        private String path;
        private String uuid;
        private Map<String, String> meta;
        private String username;
        private String min_worker_version;
        private String max_worker_version;
        private String worker_version;
        private State state;
        private boolean aborted;
        private boolean failed;
        private boolean paused;
        private int priority;
        private int worker_limit;
        private long started_at;
        private long finished_at;
        private TaskInfo[] tasks;
        private long error_time;
        private long error_worker_id;
        private String error_message;
        private long next_revision;

        public void update(BatchInfo batchInfo) {
            this.path = batchInfo.path;
            this.uuid = batchInfo.uuid;
            this.meta = batchInfo.meta;
            this.username = batchInfo.username;
            this.min_worker_version = batchInfo.min_worker_version;
            this.max_worker_version = batchInfo.max_worker_version;
            this.worker_version = batchInfo.worker_version;
            this.state = batchInfo.state;
            this.aborted = batchInfo.aborted;
            this.failed = batchInfo.failed;
            this.paused = batchInfo.paused;
            this.priority = batchInfo.priority;
            this.started_at = batchInfo.started_at;
            this.finished_at = batchInfo.finished_at;
            this.error_time = batchInfo.error_time;
            this.error_worker_id = batchInfo.error_worker_id;
            this.error_message = batchInfo.error_message;
            this.next_revision = batchInfo.next_revision;
            TaskInfo[] taskInfoArray = new TaskInfo[batchInfo.tasks.length];
            for (int i = 0; i < batchInfo.tasks.length; ++i) {
                if (i < this.tasks.length) {
                    taskInfoArray[i] = this.tasks[i];
                    taskInfoArray[i].update(batchInfo.tasks[i]);
                    continue;
                }
                taskInfoArray[i] = batchInfo.tasks[i];
            }
            this.tasks = taskInfoArray;
        }

        public void setPath(String string) {
            this.path = string;
        }

        public String getPath() {
            return this.path;
        }

        public void setUuid(String string) {
            this.uuid = string;
        }

        public String getUuid() {
            return this.uuid;
        }

        public void setMeta(Map<String, String> map) {
            this.meta = map;
        }

        public Map<String, String> getMeta() {
            return this.meta;
        }

        public void setUsername(String string) {
            this.username = string;
        }

        public String getUsername() {
            return this.username;
        }

        public void setMinWorkerVersion(String string) {
            this.min_worker_version = string;
        }

        public String getMinWorkerVersion() {
            return this.min_worker_version;
        }

        public void setMaxWorkerVersion(String string) {
            this.max_worker_version = string;
        }

        public String getMaxWorkerVersion() {
            return this.max_worker_version;
        }

        public void setWorkerVersion(String string) {
            this.worker_version = string;
        }

        public String getWorkerVersion() {
            return this.worker_version;
        }

        public void setState(State state) {
            this.state = state;
        }

        public State getState() {
            return this.state;
        }

        public void setAborted(boolean bl) {
            this.aborted = bl;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void setFailed(boolean bl) {
            this.failed = bl;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setPaused(boolean bl) {
            this.paused = bl;
        }

        public boolean isPaused() {
            return this.paused;
        }

        public void setPriority(int n) {
            this.priority = n;
        }

        public int getPriority() {
            return this.priority;
        }

        public void setWorkerLimit(int n) {
            this.worker_limit = n;
        }

        public int getWorkerLimit() {
            return this.worker_limit;
        }

        public void setStartedAt(long l) {
            this.started_at = l;
        }

        public long getStartedAt() {
            return this.started_at;
        }

        public void setFinishedAt(long l) {
            this.finished_at = l;
        }

        public long getFinishedAt() {
            return this.finished_at;
        }

        public void setTasks(TaskInfo[] taskInfoArray) {
            this.tasks = taskInfoArray;
        }

        public TaskInfo[] getTasks() {
            return this.tasks;
        }

        public void setErrorTime(long l) {
            this.error_time = l;
        }

        public long getErrorTime() {
            return this.error_time;
        }

        public void setErrorWorkerId(long l) {
            this.error_worker_id = l;
        }

        public long getErrorWorkerId() {
            return this.error_worker_id;
        }

        public void setErrorMessage(String string) {
            this.error_message = string;
        }

        public String getErrorMessage() {
            return this.error_message;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }
    }

    public static class TaskInfo {
        private NetworkTask task;
        private State state;
        private boolean aborted;
        private boolean failed;
        private double progress;
        private double elapsed_time;
        private double remaining_time;
        private double processing_time;
        private int target_count;
        private int targets_completed;
        private int workitems_waiting;
        private int workitems_inprogress;
        private int workitems_completed;
        private int workitems_failed;
        private OutputRecord[] output;

        public void update(TaskInfo taskInfo) {
            int n;
            this.task = taskInfo.task;
            this.state = taskInfo.state;
            this.aborted = taskInfo.aborted;
            this.failed = taskInfo.failed;
            this.progress = taskInfo.progress;
            this.elapsed_time = taskInfo.elapsed_time;
            this.remaining_time = taskInfo.remaining_time;
            this.processing_time = taskInfo.processing_time;
            this.target_count = taskInfo.target_count;
            this.targets_completed = taskInfo.targets_completed;
            this.workitems_waiting = taskInfo.workitems_waiting;
            this.workitems_inprogress = taskInfo.workitems_inprogress;
            this.workitems_completed = taskInfo.workitems_completed;
            this.workitems_failed = taskInfo.workitems_failed;
            OutputRecord[] outputRecordArray = new OutputRecord[this.output.length + taskInfo.output.length];
            for (n = 0; n < this.output.length; ++n) {
                outputRecordArray[n] = this.output[n];
            }
            for (n = 0; n < taskInfo.output.length; ++n) {
                outputRecordArray[this.output.length + n] = taskInfo.output[n];
            }
            this.output = outputRecordArray;
        }

        public void setTask(NetworkTask networkTask) {
            this.task = networkTask;
        }

        public NetworkTask getTask() {
            return this.task;
        }

        public void setState(State state) {
            this.state = state;
        }

        public State getState() {
            return this.state;
        }

        public void setAborted(boolean bl) {
            this.aborted = bl;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public void setFailed(boolean bl) {
            this.failed = bl;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public void setProgress(double d) {
            this.progress = d;
        }

        public double getProgress() {
            return this.progress;
        }

        public void setElapsedTime(double d) {
            this.elapsed_time = d;
        }

        public double getElapsedTime() {
            return this.elapsed_time;
        }

        public void setRemainingTime(double d) {
            this.remaining_time = d;
        }

        public double getRemainingTime() {
            return this.remaining_time;
        }

        public void setProcessingTime(double d) {
            this.processing_time = d;
        }

        public double getProcessingTime() {
            return this.processing_time;
        }

        public void setTargetCount(int n) {
            this.target_count = n;
        }

        public int getTargetCount() {
            return this.target_count;
        }

        public void setTargetsCompleted(int n) {
            this.targets_completed = n;
        }

        public int getTargetsCompleted() {
            return this.targets_completed;
        }

        public void setWorkitemsWaiting(int n) {
            this.workitems_waiting = n;
        }

        public int getWorkitemsWaiting() {
            return this.workitems_waiting;
        }

        public void setWorkitemsInprogress(int n) {
            this.workitems_inprogress = n;
        }

        public int getWorkitemsInprogress() {
            return this.workitems_inprogress;
        }

        public void setWorkitemsCompleted(int n) {
            this.workitems_completed = n;
        }

        public int getWorkitemsCompleted() {
            return this.workitems_completed;
        }

        public void setWorkitemsFailed(int n) {
            this.workitems_failed = n;
        }

        public int getWorkitemsFailed() {
            return this.workitems_failed;
        }

        public void setOutput(OutputRecord[] outputRecordArray) {
            this.output = outputRecordArray;
        }

        public OutputRecord[] getOutput() {
            return this.output;
        }
    }

    public static class ServerInfo {
        private String name;
        private String version;
        private long started_at;
        private double memory_size;
        private String master;
        private int slave_count;
        private int scheduling_mode;
        private long next_revision;
        private OutputRecord[] output;
        private ResourceRecord[] resource_usage;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getVersion() {
            return this.version;
        }

        public void setStartedAt(long l) {
            this.started_at = l;
        }

        public long getStartedAt() {
            return this.started_at;
        }

        public void setMemorySize(double d) {
            this.memory_size = d;
        }

        public double getMemorySize() {
            return this.memory_size;
        }

        public void setMaster(String string) {
            this.master = string;
        }

        public String getMaster() {
            return this.master;
        }

        public void setSlaveCount(int n) {
            this.slave_count = n;
        }

        public int getSlaveCount() {
            return this.slave_count;
        }

        public void setSchedulingMode(int n) {
            this.scheduling_mode = n;
        }

        public int getSchedulingMode() {
            return this.scheduling_mode;
        }

        public void setNextRevision(long l) {
            this.next_revision = l;
        }

        public long getNextRevision() {
            return this.next_revision;
        }

        public void setOutput(OutputRecord[] outputRecordArray) {
            this.output = outputRecordArray;
        }

        public OutputRecord[] getOutput() {
            return this.output;
        }

        public void setResourceUsage(ResourceRecord[] resourceRecordArray) {
            this.resource_usage = resourceRecordArray;
        }

        public ResourceRecord[] getResourceUsage() {
            return this.resource_usage;
        }
    }

    public static class ServerVersion {
        private String name;
        private String version;

        public void setName(String string) {
            this.name = string;
        }

        public String getName() {
            return this.name;
        }

        public void setVersion(String string) {
            this.version = string;
        }

        public String getVersion() {
            return this.version;
        }
    }

    public static class ResourceRecord {
        private double time;
        private double memory_usage;
        private double cpu_usage;

        public void setTime(double d) {
            this.time = d;
        }

        public double getTime() {
            return this.time;
        }

        public void setMemoryUsage(double d) {
            this.memory_usage = d;
        }

        public double getMemoryUsage() {
            return this.memory_usage;
        }

        public void setCpuUsage(double d) {
            this.cpu_usage = d;
        }

        public double getCpuUsage() {
            return this.cpu_usage;
        }
    }

    public static class OutputRecord {
        private int type;
        private String text;

        public void setType(int n) {
            this.type = n;
        }

        public int getType() {
            return this.type;
        }

        public void setText(String string) {
            this.text = string;
        }

        public String getText() {
            return this.text;
        }
    }
}

