package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ColorizeModel extends Task {

	public ColorizeModel() {
		super("ColorizeModel");
	}

	/**
	 *  Key of model to colorize. Default: -1
	 */
	public void setModel(int value) {
		setParameter("model", (Object) value);
	}

	/**
	 *  Key of model to colorize. Default: -1
	 */
	public int getModel() {
		return (int) getParameter("model");
	}

	/**
	 *  Source data to extract colors from. Default: DataSource.ImagesData
	 */
	public void setSourceData(DataSource value) {
		setParameter("source_data", (Object) value);
	}

	/**
	 *  Source data to extract colors from. Default: DataSource.ImagesData
	 */
	public DataSource getSourceData() {
		return (DataSource) getParameter("source_data");
	}

}
