package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class DecimateModel extends Task {

	public DecimateModel() {
		super("DecimateModel");
	}

	/**
	 *  Apply to selection.
	 */
	public void setApplyToSelection(boolean value) {
		setParameter("apply_to_selection", (Object) value);
	}

	/**
	 *  Apply to selection.
	 */
	public boolean getApplyToSelection() {
		return (boolean) getParameter("apply_to_selection");
	}

	/**
	 *  Target face count. Default: 200000
	 */
	public void setFaceCount(int value) {
		setParameter("face_count", (Object) value);
	}

	/**
	 *  Target face count. Default: 200000
	 */
	public int getFaceCount() {
		return (int) getParameter("face_count");
	}

	/**
	 *  List of frames to process.
	 */
	public void setFrames(int[] value) {
		setParameter("frames", (Object) value);
	}

	/**
	 *  List of frames to process.
	 */
	public int[] getFrames() {
		return (int[]) getParameter("frames");
	}

	/**
	 *  Model to process. Default: -1
	 */
	public void setModel(int value) {
		setParameter("model", (Object) value);
	}

	/**
	 *  Model to process. Default: -1
	 */
	public int getModel() {
		return (int) getParameter("model");
	}

	/**
	 *  Replace source model with decimated model.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace source model with decimated model.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

}
