package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ExportTiledModel extends Task {

	public ExportTiledModel() {
		super("ExportTiledModel");
	}

	/**
	 *  Clip tiled model to boundary shapes.
	 */
	public void setClipToBoundary(boolean value) {
		setParameter("clip_to_boundary", (Object) value);
	}

	/**
	 *  Clip tiled model to boundary shapes.
	 */
	public boolean getClipToBoundary() {
		return (boolean) getParameter("clip_to_boundary");
	}

	/**
	 *  Output coordinate system.
	 */
	public void setCRS(CoordinateSystem value) {
		setParameter("crs", (Object) value);
	}

	/**
	 *  Output coordinate system.
	 */
	public CoordinateSystem getCRS() {
		return (CoordinateSystem) getParameter("crs");
	}

	/**
	 *  Number of faces per megapixel of texture resolution (block model export only). Default: 20000
	 */
	public void setFaceCount(int value) {
		setParameter("face_count", (Object) value);
	}

	/**
	 *  Number of faces per megapixel of texture resolution (block model export only). Default: 20000
	 */
	public int getFaceCount() {
		return (int) getParameter("face_count");
	}

	/**
	 *  Tileset subdivision depth (Cesium format only). Default: 5
	 */
	public void setFolderDepth(int value) {
		setParameter("folder_depth", (Object) value);
	}

	/**
	 *  Tileset subdivision depth (Cesium format only). Default: 5
	 */
	public int getFolderDepth() {
		return (int) getParameter("folder_depth");
	}

	/**
	 *  Export format. Default: TiledModelFormat.TiledModelFormatNone
	 */
	public void setFormat(TiledModelFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  Export format. Default: TiledModelFormat.TiledModelFormatNone
	 */
	public TiledModelFormat getFormat() {
		return (TiledModelFormat) getParameter("format");
	}

	/**
	 *  Image compression parameters.
	 */
	public void setImageCompression(ImageCompression value) {
		setParameter("image_compression", (Object) value);
	}

	/**
	 *  Image compression parameters.
	 */
	public ImageCompression getImageCompression() {
		return (ImageCompression) getParameter("image_compression");
	}

	/**
	 *  Enable mesh compression (Cesium format only).
	 */
	public void setModelCompression(boolean value) {
		setParameter("model_compression", (Object) value);
	}

	/**
	 *  Enable mesh compression (Cesium format only).
	 */
	public boolean getModelCompression() {
		return (boolean) getParameter("model_compression");
	}

	/**
	 *  Model format for zip export. Default: ModelFormat.ModelFormatCOLLADA
	 */
	public void setModelFormat(ModelFormat value) {
		setParameter("model_format", (Object) value);
	}

	/**
	 *  Model format for zip export. Default: ModelFormat.ModelFormatCOLLADA
	 */
	public ModelFormat getModelFormat() {
		return (ModelFormat) getParameter("model_format");
	}

	/**
	 *  Block model key to export. Default: -1
	 */
	public void setModelGroup(int value) {
		setParameter("model_group", (Object) value);
	}

	/**
	 *  Block model key to export. Default: -1
	 */
	public int getModelGroup() {
		return (int) getParameter("model_group");
	}

	/**
	 *  Path to output model.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Path to output model.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  Target model resolution in meters (block model export only). Default: 0.0
	 */
	public void setPixelSize(double value) {
		setParameter("pixel_size", (Object) value);
	}

	/**
	 *  Target model resolution in meters (block model export only). Default: 0.0
	 */
	public double getPixelSize() {
		return (double) getParameter("pixel_size");
	}

	/**
	 *  Raster band transformation. Default: RasterTransformType.RasterTransformNone
	 */
	public void setRasterTransform(RasterTransformType value) {
		setParameter("raster_transform", (Object) value);
	}

	/**
	 *  Raster band transformation. Default: RasterTransformType.RasterTransformNone
	 */
	public RasterTransformType getRasterTransform() {
		return (RasterTransformType) getParameter("raster_transform");
	}

	/**
	 *  Target screen space error (Cesium format only). Default: 16.0
	 */
	public void setScreenSpaceError(double value) {
		setParameter("screen_space_error", (Object) value);
	}

	/**
	 *  Target screen space error (Cesium format only). Default: 16.0
	 */
	public double getScreenSpaceError() {
		return (double) getParameter("screen_space_error");
	}

	/**
	 *  Texture format. Default: ImageFormat.ImageFormatJPEG
	 */
	public void setTextureFormat(ImageFormat value) {
		setParameter("texture_format", (Object) value);
	}

	/**
	 *  Texture format. Default: ImageFormat.ImageFormatJPEG
	 */
	public ImageFormat getTextureFormat() {
		return (ImageFormat) getParameter("texture_format");
	}

	/**
	 *  Size of tiles in pixels (block model export only). Default: 256
	 */
	public void setTileSize(int value) {
		setParameter("tile_size", (Object) value);
	}

	/**
	 *  Size of tiles in pixels (block model export only). Default: 256
	 */
	public int getTileSize() {
		return (int) getParameter("tile_size");
	}

	/**
	 *  Tiled model key to export. Default: -1
	 */
	public void setTiledModel(int value) {
		setParameter("tiled_model", (Object) value);
	}

	/**
	 *  Tiled model key to export. Default: -1
	 */
	public int getTiledModel() {
		return (int) getParameter("tiled_model");
	}

	/**
	 *  Cesium 3D Tiles format version to export (1.0 or 1.1).
	 */
	public void setTilesetVersion(String value) {
		setParameter("tileset_version", (Object) value);
	}

	/**
	 *  Cesium 3D Tiles format version to export (1.0 or 1.1).
	 */
	public String getTilesetVersion() {
		return (String) getParameter("tileset_version");
	}

	/**
	 *  Use tileset transform instead of individual tile transforms (Cesium format only).
	 */
	public void setUseTilesetTransform(boolean value) {
		setParameter("use_tileset_transform", (Object) value);
	}

	/**
	 *  Use tileset transform instead of individual tile transforms (Cesium format only).
	 */
	public boolean getUseTilesetTransform() {
		return (boolean) getParameter("use_tileset_transform");
	}

}
