package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class ImportPointCloud extends Task {

	public ImportPointCloud() {
		super("ImportPointCloud");
	}

	/**
	 *  Calculate point normals.
	 */
	public void setCalculateNormals(boolean value) {
		setParameter("calculate_normals", (Object) value);
	}

	/**
	 *  Calculate point normals.
	 */
	public boolean getCalculateNormals() {
		return (boolean) getParameter("calculate_normals");
	}

	/**
	 *  Point cloud coordinate system.
	 */
	public void setCRS(CoordinateSystem value) {
		setParameter("crs", (Object) value);
	}

	/**
	 *  Point cloud coordinate system.
	 */
	public CoordinateSystem getCRS() {
		return (CoordinateSystem) getParameter("crs");
	}

	/**
	 *  Point cloud format. Default: PointCloudFormat.PointCloudFormatNone
	 */
	public void setFormat(PointCloudFormat value) {
		setParameter("format", (Object) value);
	}

	/**
	 *  Point cloud format. Default: PointCloudFormat.PointCloudFormatNone
	 */
	public PointCloudFormat getFormat() {
		return (PointCloudFormat) getParameter("format");
	}

	/**
	 *  List of point cloud paths to import in each frame of a multiframe chunk.
	 */
	public void setFramePaths(String[] value) {
		setParameter("frame_paths", (Object) value);
	}

	/**
	 *  List of point cloud paths to import in each frame of a multiframe chunk.
	 */
	public String[] getFramePaths() {
		return (String[]) getParameter("frame_paths");
	}

	/**
	 *  Ignore normals in imported file.
	 */
	public void setIgnoreNormals(boolean value) {
		setParameter("ignore_normals", (Object) value);
	}

	/**
	 *  Ignore normals in imported file.
	 */
	public boolean getIgnoreNormals() {
		return (boolean) getParameter("ignore_normals");
	}

	/**
	 *  Do not use laser scan origin as scanner position for structured point clouds.
	 */
	public void setIgnoreScannerOrigin(boolean value) {
		setParameter("ignore_scanner_origin", (Object) value);
	}

	/**
	 *  Do not use laser scan origin as scanner position for structured point clouds.
	 */
	public boolean getIgnoreScannerOrigin() {
		return (boolean) getParameter("ignore_scanner_origin");
	}

	/**
	 *  Do not attach trajectory to imported point cloud.
	 */
	public void setIgnoreTrajectory(boolean value) {
		setParameter("ignore_trajectory", (Object) value);
	}

	/**
	 *  Do not attach trajectory to imported point cloud.
	 */
	public boolean getIgnoreTrajectory() {
		return (boolean) getParameter("ignore_trajectory");
	}

	/**
	 *  Import images embedded in laser scan.
	 */
	public void setImportImages(boolean value) {
		setParameter("import_images", (Object) value);
	}

	/**
	 *  Import images embedded in laser scan.
	 */
	public boolean getImportImages() {
		return (boolean) getParameter("import_images");
	}

	/**
	 *  Import point clouds as laser scans.
	 */
	public void setIsLaserScan(boolean value) {
		setParameter("is_laser_scan", (Object) value);
	}

	/**
	 *  Import point clouds as laser scans.
	 */
	public boolean getIsLaserScan() {
		return (boolean) getParameter("is_laser_scan");
	}

	/**
	 *  Path to point cloud.
	 */
	public void setPath(String value) {
		setParameter("path", (Object) value);
	}

	/**
	 *  Path to point cloud.
	 */
	public String getPath() {
		return (String) getParameter("path");
	}

	/**
	 *  Number of point neighbors to use for normal estimation. Default: 28
	 */
	public void setPointNeighbors(int value) {
		setParameter("point_neighbors", (Object) value);
	}

	/**
	 *  Number of point neighbors to use for normal estimation. Default: 28
	 */
	public int getPointNeighbors() {
		return (int) getParameter("point_neighbors");
	}

	/**
	 *  Coordinate precision (m). For default precision use 0. Default: 0.0
	 */
	public void setPrecision(double value) {
		setParameter("precision", (Object) value);
	}

	/**
	 *  Coordinate precision (m). For default precision use 0. Default: 0.0
	 */
	public double getPrecision() {
		return (double) getParameter("precision");
	}

	/**
	 *  Replace default asset with imported point cloud.
	 */
	public void setReplaceAsset(boolean value) {
		setParameter("replace_asset", (Object) value);
	}

	/**
	 *  Replace default asset with imported point cloud.
	 */
	public boolean getReplaceAsset() {
		return (boolean) getParameter("replace_asset");
	}

	/**
	 *  Use laser scan origin as scanner position for unstructured point clouds.
	 */
	public void setScannerAtOrigin(boolean value) {
		setParameter("scanner_at_origin", (Object) value);
	}

	/**
	 *  Use laser scan origin as scanner position for unstructured point clouds.
	 */
	public boolean getScannerAtOrigin() {
		return (boolean) getParameter("scanner_at_origin");
	}

	/**
	 *  Optional shift to be applied to point coordinates.
	 */
	public void setShift(Vector value) {
		setParameter("shift", (Object) value);
	}

	/**
	 *  Optional shift to be applied to point coordinates.
	 */
	public Vector getShift() {
		return (Vector) getParameter("shift");
	}

	/**
	 *  Trajectory key to attach. Default: -1
	 */
	public void setTrajectory(int value) {
		setParameter("trajectory", (Object) value);
	}

	/**
	 *  Trajectory key to attach. Default: -1
	 */
	public int getTrajectory() {
		return (int) getParameter("trajectory");
	}

}
