/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 4.0.1
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

public class CoordinateSystem implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected CoordinateSystem(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(CoordinateSystem obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_CoordinateSystem(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public CoordinateSystem() {
    this(MetashapeJNI.new_CoordinateSystem__SWIG_0(), true);
  }

  public CoordinateSystem(CoordinateSystem crs) {
    this(MetashapeJNI.new_CoordinateSystem__SWIG_1(CoordinateSystem.getCPtr(crs), crs), true);
  }

  /**
   *  Authority identifier of the coordinate system.
   */
  public String getAuthority() {
    return MetashapeJNI.CoordinateSystem_getAuthority(swigCPtr, this);
  }

  /**
   *  Coordinate system definition in WKT format.
   */
  public String getWkt() {
    return MetashapeJNI.CoordinateSystem_getWkt(swigCPtr, this);
  }

  /**
   *  Coordinate system definition in PROJ.4 format.
   */
  public String getProj4() {
    return MetashapeJNI.CoordinateSystem_getProj4(swigCPtr, this);
  }

  /**
   * Initialize projection based on specified WKT definition or authority identifier.<br>
   * @param wkt WKT definition of coordinate system or authority identifier.
   */
  public boolean init(String wkt) {
    return MetashapeJNI.CoordinateSystem_init(swigCPtr, this, wkt);
  }

  /**
   * Projects point from geocentric coordinates to projected geographic coordinate system.<br>
   * @param point 3D point in geocentric coordinates.<br>
   * @return 3D point in projected coordinates.
   */
  public Vector project(Vector point) { return MetashapeJNI.CoordinateSystem_project(swigCPtr, this, point); }

  /**
   * Unprojects point from projected coordinates to geocentric coordinates.<br>
   * @param point 3D point in projected coordinate system.<br>
   * @return 3D point in geocentric coordinates.
   */
  public Vector unproject(Vector point) { return MetashapeJNI.CoordinateSystem_unproject(swigCPtr, this, point); }

  /**
   * Returns 4x4 transformation matrix to LSE coordinates at the given point.<br>
   * @param point Coordinates of the origin in the geocentric coordinates.<br>
   * @return Transformation from geocentric coordinates to local coordinates.
   */
  public Matrix localframe(Vector point) { return MetashapeJNI.CoordinateSystem_localframe(swigCPtr, this, point); }

  /**
   * Construct geographic coordinate system using coordinate system datum.<br>
   * @return Geographic coordinate system, may be null.
   */
  public Optional<CoordinateSystem> makeGeographic() {
    long ptr = MetashapeJNI.CoordinateSystem_makeGeographic(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CoordinateSystem(ptr, true));
  }

  /**
   * Construct geocentric coordinate system using coordinate system datum.<br>
   * @return Geocentric coordinate system, may be null.
   */
  public Optional<CoordinateSystem> makeGeocentric() {
    long ptr = MetashapeJNI.CoordinateSystem_makeGeocentric(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CoordinateSystem(ptr, true));
  }

  /**
   * Coordinate transformation from source to target coordinate system datum.<br>
   * @param source Source coordinate system.<br>
   * @param target Target coordinate system.<br>
   * @return Transformation matrix, may be null.
   */
  public static Optional<Matrix> datumTransform(CoordinateSystem source, CoordinateSystem target) {
	Matrix values = MetashapeJNI.CoordinateSystem_datumTransform(CoordinateSystem.getCPtr(source), source, CoordinateSystem.getCPtr(target), target);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   * Transform point coordinates between coordinate systems.<br>
   * @param point Point coordinates.<br>
   * @param source Source coordinate system.<br>
   * @param target Target coordinate system.<br>
   * @return Transformed point coordinates.
   */
  public static Vector transform(Vector point, CoordinateSystem source, CoordinateSystem target) { return MetashapeJNI.CoordinateSystem_transform(point, CoordinateSystem.getCPtr(source), source, CoordinateSystem.getCPtr(target), target); }

  /**
   * Local approximation of coordinate transformation from source to target coordinate system at the given point.<br>
   * @param point Point coordinates.<br>
   * @param source Source coordinate system.<br>
   * @param target Target coordinate system.<br>
   * @return Transformation matrix.
   */
  public static Matrix transformationMatrix(Vector point, CoordinateSystem source, CoordinateSystem target) { return MetashapeJNI.CoordinateSystem_transformationMatrix(point, CoordinateSystem.getCPtr(source), source, CoordinateSystem.getCPtr(target), target); }

  /**
   * Register geoid model.<br>
   * @param path Path to geoid file.
   */
  public static boolean addGeoid(String path) {
    return MetashapeJNI.CoordinateSystem_addGeoid(path);
  }

}
