/*
 * Decompiled with CFR 0.152.
 */
package com.agisoft.metashape;

import com.agisoft.metashape.MetashapeJNI;
import com.agisoft.metashape.SwigHelpers;
import com.agisoft.metashape.Vector;

public class Geometry
implements AutoCloseable {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected Geometry(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Geometry geometry) {
        return geometry == null ? 0L : geometry.swigCPtr;
    }

    protected static long swigRelease(Geometry geometry) {
        long l = 0L;
        if (geometry != null) {
            if (!geometry.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = geometry.swigCPtr;
            geometry.swigCMemOwn = false;
            geometry.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                MetashapeJNI.delete_Geometry(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    @Override
    public void close() {
        this.delete();
    }

    public Geometry() {
        this(MetashapeJNI.new_Geometry__SWIG_0(), true);
    }

    public Geometry(Geometry geometry) {
        this(MetashapeJNI.new_Geometry__SWIG_1(Geometry.getCPtr(geometry), geometry), true);
    }

    public void setType(Type type) {
        MetashapeJNI.Geometry_setType(this.swigCPtr, this, type.ordinal());
    }

    public Type getType() {
        return ((Type[])Type.class.getEnumConstants())[MetashapeJNI.Geometry_getType(this.swigCPtr, this)];
    }

    public void setVertices(Vector[] vectorArray) {
        MetashapeJNI.Geometry_setVertices(this.swigCPtr, this, vectorArray);
    }

    public Vector[] getVertices() {
        return MetashapeJNI.Geometry_getVertices(this.swigCPtr, this);
    }

    public void setVertices2D(Vector[] vectorArray) {
        MetashapeJNI.Geometry_setVertices2D(this.swigCPtr, this, vectorArray);
    }

    public Vector[] getVertices2D() {
        return MetashapeJNI.Geometry_getVertices2D(this.swigCPtr, this);
    }

    public void setGeometries(Geometry[] geometryArray) {
        MetashapeJNI.Geometry_setGeometries(this.swigCPtr, this, SwigHelpers.cArrayUnwrap(geometryArray, Geometry.class));
    }

    public Geometry[] getGeometries() {
        return SwigHelpers.cArrayWrap(MetashapeJNI.Geometry_getGeometries(this.swigCPtr, this), true, Geometry.class);
    }

    public void set3D(boolean bl) {
        MetashapeJNI.Geometry_set3D(this.swigCPtr, this, bl);
    }

    public boolean is3D() {
        return MetashapeJNI.Geometry_is3D(this.swigCPtr, this);
    }

    public static Geometry makePoint(Vector vector, boolean bl) {
        return new Geometry(MetashapeJNI.Geometry_makePoint__SWIG_0(vector, bl), true);
    }

    public static Geometry makePoint(Vector vector) {
        return new Geometry(MetashapeJNI.Geometry_makePoint__SWIG_1(vector), true);
    }

    public static Geometry makeLineString(Vector[] vectorArray, boolean bl) {
        return new Geometry(MetashapeJNI.Geometry_makeLineString__SWIG_0(vectorArray, bl), true);
    }

    public static Geometry makeLineString(Vector[] vectorArray) {
        return new Geometry(MetashapeJNI.Geometry_makeLineString__SWIG_1(vectorArray), true);
    }

    public static Geometry makePolygon(Vector[] vectorArray, boolean bl) {
        return new Geometry(MetashapeJNI.Geometry_makePolygon__SWIG_0(vectorArray, bl), true);
    }

    public static Geometry makePolygon(Vector[] vectorArray) {
        return new Geometry(MetashapeJNI.Geometry_makePolygon__SWIG_1(vectorArray), true);
    }

    public static Geometry makePoint2D(Vector vector) {
        return new Geometry(MetashapeJNI.Geometry_makePoint2D(vector), true);
    }

    public static Geometry makeLineString2D(Vector[] vectorArray) {
        return new Geometry(MetashapeJNI.Geometry_makeLineString2D(vectorArray), true);
    }

    public static Geometry makePolygon2D(Vector[] vectorArray) {
        return new Geometry(MetashapeJNI.Geometry_makePolygon2D(vectorArray), true);
    }

    public static Geometry makeMultiPoint(Geometry[] geometryArray) {
        return new Geometry(MetashapeJNI.Geometry_makeMultiPoint(SwigHelpers.cArrayUnwrap(geometryArray, Geometry.class)), true);
    }

    public static Geometry makeMultiLineString(Geometry[] geometryArray) {
        return new Geometry(MetashapeJNI.Geometry_makeMultiLineString(SwigHelpers.cArrayUnwrap(geometryArray, Geometry.class)), true);
    }

    public static Geometry makeMultiPolygon(Geometry[] geometryArray) {
        return new Geometry(MetashapeJNI.Geometry_makeMultiPolygon(SwigHelpers.cArrayUnwrap(geometryArray, Geometry.class)), true);
    }

    public static Geometry makeGeometryCollection(Geometry[] geometryArray) {
        return new Geometry(MetashapeJNI.Geometry_makeGeometryCollection(SwigHelpers.cArrayUnwrap(geometryArray, Geometry.class)), true);
    }

    public static enum Type {
        Empty,
        Point,
        LineString,
        Polygon,
        MultiPoint,
        MultiLineString,
        MultiPolygon,
        GeometryCollection;

    }
}

