package com.agisoft.metashape;

import java.util.Optional;

/**
 * GPS antenna position relative to camera.
 */
public class Antenna {

	private Vector location;
	private Vector rotation;
	private Vector bias;
	private Vector location_reference;
	private Vector rotation_reference;
	private Vector bias_reference;
	private Vector location_accuracy;
	private Vector rotation_accuracy;
	private Vector bias_accuracy;
	private boolean location_fixed;
	private boolean rotation_fixed;
	private boolean bias_fixed;

	public Antenna() {
		location = new Vector(0, 0, 0);
		rotation = new Vector(0, 0, 0);
		bias  = new Vector(0, 0, 0);
		location_reference = null;
		rotation_reference = null;
		bias_reference = null;
		location_accuracy = new Vector(0.05, 0.05, 0.05);
		rotation_accuracy = new Vector(2.0, 2.0, 2.0);
		bias_accuracy = new Vector(0.05, 0.05, 0.05);
		location_fixed = true;
		rotation_fixed = true;
		bias_fixed = true;
	}

	/**
	 *  Fix antenna location and rotation flags.
	 */
	public void setFixed(boolean fixed) {
		this.location_fixed = fixed;
		this.rotation_fixed = fixed;
	}

	/**
	 *  Fix antenna location and rotation flags.
	 */
	public boolean isFixed() {
		return location_fixed && rotation_fixed;
	}

	/**
	 *  Fix antenna location flag.
	 */
	public void setLocationFixed(boolean fixed) {
		this.location_fixed = fixed;
	}

	/**
	 *  Fix antenna location flag.
	 */
	public boolean isLocationFixed() {
		return location_fixed;
	}

	/**
	 *  Fix antenna rotation flag.
	 */
	public void setRotationFixed(boolean fixed) {
		this.rotation_fixed = fixed;
	}

	/**
	 *  Fix antenna rotation flag.
	 */
	public boolean isRotationFixed() {
		return rotation_fixed;
	}

	/**
	 *  Fix GNSS bias flag.
	 */
	public void setBiasFixed(boolean fixed) {
		this.bias_fixed = fixed;
	}

	/**
	 *  Fix GNSS bias flag.
	 */
	public boolean isBiasFixed() {
		return bias_fixed;
	}

	/**
	 *  Antenna coordinates.
	 */
	public void setLocation(Vector location) {
		this.location = location;
	}

	/**
	 *  Antenna coordinates.
	 */
	public Vector getLocation() {
		return location;
	}

	/**
	 *  Antenna rotation angles.
	 */
	public void setRotation(Vector rotation) {
		this.rotation = rotation;
	}

	/**
	 *  Antenna rotation angles.
	 */
	public Vector getRotation() {
		return rotation;
	}

	/**
	 *  GNSS bias.
	 */
	public void setBias(Vector bias) {
		this.bias = bias;
	}

	/**
	 *  GNSS bias.
	 */
	public Vector getBias() {
		return bias;
	}

	/**
	 *  Antenna location reference, may be null.
	 */
	public void setLocationReference(Vector reference) {
		this.location_reference = reference;
	}

	/**
	 *  Antenna location reference.
	 */
	public Optional<Vector> getLocationReference() { return Optional.ofNullable(location_reference); }

	/**
	 *  Antenna rotation reference, may be null.
	 */
	public void setRotationReference(Vector reference) {
		this.rotation_reference = reference;
	}

	/**
	 *  Antenna rotation reference.
	 */
	public Optional<Vector> getRotationReference() { return Optional.ofNullable(rotation_reference); }

	/**
	 *  GNSS bias reference, may be null.
	 */
	public void setBiasReference(Vector reference) {
		this.bias_reference = reference;
	}

	/**
	 *  GNSS bias reference.
	 */
	public Optional<Vector> getBiasReference() { return Optional.ofNullable(bias_reference); }

	/**
	 *  Antenna location accuracy.
	 */
	public void setLocationAccuracy(Vector accuracy) {
		this.location_accuracy = accuracy;
	}

	/**
	 *  Antenna location accuracy.
	 */
	public Vector getLocationAccuracy() { return location_accuracy; }

	/**
	 *  Antenna rotation accuracy.
	 */
	public void setRotationAccuracy(Vector accuracy) {
		this.rotation_accuracy = accuracy;
	}

	/**
	 *  Antenna rotation accuracy.
	 */
	public Vector getRotationAccuracy() { return rotation_accuracy; }

	/**
	 *  GNSS bias accuracy.
	 */
	public void setBiasAccuracy(Vector accuracy) {
		this.bias_accuracy = accuracy;
	}

	/**
	 *  GNSS bias accuracy.
	 */
	public Vector getBiasAccuracy() { return bias_accuracy; }

}
