/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * A Chunk object.<br>
 * <br>
 * - provides access to all chunk components (sensors, cameras, camera groups, markers, scale bars)<br>
 * - contains data inherent to individual frames (tie points, model, etc)<br>
 * - provides access to other chunk attributes (transformation matrix, coordinate system, meta-data, etc..)<br>
 * <br>
 * New components can be created using corresponding addXXX methods (addSensor, addCamera, addCameraGroup, addMarker, addScalebar, addFrame).<br>
 * Removal of components is performed using corresponding removeXXX methods.
 */
public class Chunk implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Chunk(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Chunk obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(Chunk obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_Chunk(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public Chunk(Chunk chunk) {
    this(MetashapeJNI.new_Chunk(Chunk.getCPtr(chunk), chunk), true);
  }

  /**
   *  Returns chunk contents in XML format.
   */
  public String dump() {
    return MetashapeJNI.Chunk_dump(swigCPtr, this);
  }

  /**
   *  Initializes chunk contents from XML format.
   */
  public void load(String text) {
    MetashapeJNI.Chunk_load(swigCPtr, this, text);
  }

  /**
   *  Chunk identifier.
   */
  public int getKey() {
    return MetashapeJNI.Chunk_getKey(swigCPtr, this);
  }

  /**
   *  Frame identifier.
   */
  public int getFrameKey() {
    return MetashapeJNI.Chunk_getFrameKey(swigCPtr, this);
  }

  /**
   *  Document container, may be null.
   */
  public Optional<Document> getDocument() {
    long ptr = MetashapeJNI.Chunk_getDocument(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Document(ptr, true));
  }

  /**
   *  Chunk label.
   */
  public void setLabel(String label) {
    MetashapeJNI.Chunk_setLabel(swigCPtr, this, label);
  }

  /**
   *  Chunk label.
   */
  public String getLabel() {
    return MetashapeJNI.Chunk_getLabel(swigCPtr, this);
  }

  /**
   *  Enables/disables the chunk.
   */
  public void setEnabled(boolean state) {
    MetashapeJNI.Chunk_setEnabled(swigCPtr, this, state);
  }

  /**
   *  Enables/disables the chunk.
   */
  public boolean isEnabled() {
    return MetashapeJNI.Chunk_isEnabled(swigCPtr, this);
  }

  /**
   *  Selects/deselects the chunk.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.Chunk_setSelected(swigCPtr, this, state);
  }

  /**
   *  Selects/deselects the chunk.
   */
  public boolean isSelected() {
    return MetashapeJNI.Chunk_isSelected(swigCPtr, this);
  }

  /**
   *  List of frames in the chunk.
   */
  public Chunk[] getFrames() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getFrames(swigCPtr, this), true, Chunk.class); }

  /**
   *  List of sensors in the chunk.
   */
  public Sensor[] getSensors() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getSensors(swigCPtr, this), true, Sensor.class); }

  /**
   *  List of camera groups in the chunk.
   */
  public CameraGroup[] getCameraGroups() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getCameraGroups(swigCPtr, this), true, CameraGroup.class); }

  /**
   *  List of marker groups in the chunk.
   */
  public MarkerGroup[] getMarkerGroups() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getMarkerGroups(swigCPtr, this), true, MarkerGroup.class); }

  /**
   *  List of scale bar groups in the chunk.
   */
  public ScalebarGroup[] getScalebarGroups() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getScalebarGroups(swigCPtr, this), true, ScalebarGroup.class); }

  /**
   *  List of Regular and Keyframe cameras in the chunk.
   */
  public Camera[] getCameras() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getCameras(swigCPtr, this), true, Camera.class); }

  /**
   *  List of Regular, Vertex and Fiducial markers in the chunk.
   */
  public Marker[] getMarkers() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getMarkers(swigCPtr, this), true, Marker.class); }

  /**
   *  List of scale bars in the chunk.
   */
  public Scalebar[] getScalebars() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getScalebars(swigCPtr, this), true, Scalebar.class); }

  /**
   *  List of camera tracks in the chunk.
   */
  public CameraTrack[] getCameraTracks() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getCameraTracks(swigCPtr, this), true, CameraTrack.class); }

  /**
   *  List of frame keys in the chunk.
   */
  public int[] getFrameKeys() { return MetashapeJNI.Chunk_getFrameKeys(swigCPtr, this); }

  /**
   *  List of sensor keys in the chunk.
   */
  public int[] getSensorKeys() { return MetashapeJNI.Chunk_getSensorKeys(swigCPtr, this); }

  /**
   *  List of camera group keys in the chunk.
   */
  public int[] getCameraGroupKeys() { return MetashapeJNI.Chunk_getCameraGroupKeys(swigCPtr, this); }

  /**
   *  List of marker group keys in the chunk.
   */
  public int[] getMarkerGroupKeys() { return MetashapeJNI.Chunk_getMarkerGroupKeys(swigCPtr, this); }

  /**
   *  List of scale bar group keys in the chunk.
   */
  public int[] getScalebarGroupKeys() { return MetashapeJNI.Chunk_getScalebarGroupKeys(swigCPtr, this); }

  /**
   *  List of camera keys in the chunk.
   */
  public int[] getCameraKeys() { return MetashapeJNI.Chunk_getCameraKeys(swigCPtr, this); }

  /**
   *  List of marker keys in the chunk.
   */
  public int[] getMarkerKeys() { return MetashapeJNI.Chunk_getMarkerKeys(swigCPtr, this); }

  /**
   *  List of scale bar keys in the chunk.
   */
  public int[] getScalebarKeys() { return MetashapeJNI.Chunk_getScalebarKeys(swigCPtr, this); }

  /**
   *  List of camera track keys in the chunk.
   */
  public int[] getCameraTrackKeys() { return MetashapeJNI.Chunk_getCameraTrackKeys(swigCPtr, this); }

  /**
   *  Frame with specified key, may be null.
   */
  public Optional<Chunk> getFrame(int key) {
    long ptr = MetashapeJNI.Chunk_getFrame(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Sensor with specified key, may be null.
   */
  public Optional<Sensor> getSensor(int key) {
    long ptr = MetashapeJNI.Chunk_getSensor(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Sensor(ptr, true));
  }

  /**
   *  Camera group with specified key, may be null.
   */
  public Optional<CameraGroup> getCameraGroup(int key) {
    long ptr = MetashapeJNI.Chunk_getCameraGroup(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CameraGroup(ptr, true));
  }

  /**
   *  Marker group with specified key, may be null.
   */
  public Optional<MarkerGroup> getMarkerGroup(int key) {
    long ptr = MetashapeJNI.Chunk_getMarkerGroup(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new MarkerGroup(ptr, true));
  }

  /**
   *  Scale bar group with specified key, may be null.
   */
  public Optional<ScalebarGroup> getScalebarGroup(int key) {
    long ptr = MetashapeJNI.Chunk_getScalebarGroup(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new ScalebarGroup(ptr, true));
  }

  /**
   *  Camera with specified key, may be null.
   */
  public Optional<Camera> getCamera(int key) {
    long ptr = MetashapeJNI.Chunk_getCamera(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Camera(ptr, true));
  }

  /**
   *  Marker with specified key, may be null.
   */
  public Optional<Marker> getMarker(int key) {
    long ptr = MetashapeJNI.Chunk_getMarker(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Marker(ptr, true));
  }

  /**
   *  Scale bar with specified key, may be null.
   */
  public Optional<Scalebar> getScalebar(int key) {
    long ptr = MetashapeJNI.Chunk_getScalebar(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Scalebar(ptr, true));
  }

  /**
   *  Camera track with specified key, may be null.
   */
  public Optional<CameraTrack> getCameraTrack(int key) {
    long ptr = MetashapeJNI.Chunk_getCameraTrack(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CameraTrack(ptr, true));
  }

  /**
   *  Add new frame to the chunk.
   */
  public Chunk addFrame() {
    return new Chunk(MetashapeJNI.Chunk_addFrame(swigCPtr, this), true);
  }

  /**
   *  Add new sensor to the chunk.
   */
  public Sensor addSensor() {
    return new Sensor(MetashapeJNI.Chunk_addSensor(swigCPtr, this), true);
  }

  /**
   *  Add new camera group to the chunk.
   */
  public CameraGroup addCameraGroup() {
    return new CameraGroup(MetashapeJNI.Chunk_addCameraGroup(swigCPtr, this), true);
  }

  /**
   *  Add new marker group to the chunk.
   */
  public MarkerGroup addMarkerGroup() {
    return new MarkerGroup(MetashapeJNI.Chunk_addMarkerGroup(swigCPtr, this), true);
  }

  /**
   *  Add new scale bar group to the chunk.
   */
  public ScalebarGroup addScalebarGroup() {
    return new ScalebarGroup(MetashapeJNI.Chunk_addScalebarGroup(swigCPtr, this), true);
  }

  /**
   *  Add new camera to the chunk.
   */
  public Camera addCamera() {
    return new Camera(MetashapeJNI.Chunk_addCamera(swigCPtr, this), true);
  }

  /**
   *  Add new marker to the chunk.
   */
  public Marker addMarker() {
    return new Marker(MetashapeJNI.Chunk_addMarker__SWIG_0(swigCPtr, this), true);
  }

  /**
   *  Add new camera track to the chunk.
   */
  public CameraTrack addCameraTrack() {
    return new CameraTrack(MetashapeJNI.Chunk_addCameraTrack(swigCPtr, this), true);
  }

  /**
   * Add new marker to the chunk.<br>
   * @param point Point to initialize marker projections.<br>
   * @param visibility Enables visibility check during projection assignment.<br>
   * @return Created marker.
   */
  public Marker addMarker(Vector point, boolean visibility) {
    return new Marker(MetashapeJNI.Chunk_addMarker__SWIG_1(swigCPtr, this, point, visibility), true);
  }

  /**
   * Add new scale bar to the chunk.<br>
   * @param first First endpoint.<br>
   * @param second Second endpoint.<br>
   * @return Created scale bar.
   */
  public Scalebar addScalebar(Camera first, Camera second) {
    return new Scalebar(MetashapeJNI.Chunk_addScalebar__SWIG_0(swigCPtr, this, Camera.getCPtr(first), first, Camera.getCPtr(second), second), true);
  }

  /**
   * Add new scale bar to the chunk.<br>
   * @param first First endpoint.<br>
   * @param second Second endpoint.<br>
   * @return Created scale bar.
   */
  public Scalebar addScalebar(Marker first, Marker second) {
    return new Scalebar(MetashapeJNI.Chunk_addScalebar__SWIG_1(swigCPtr, this, Marker.getCPtr(first), first, Marker.getCPtr(second), second), true);
  }

  /**
   * Remove frames from the chunk.<br>
   * @param keys List of frame keys to remove.
   */
  public void removeFrames(int[] keys) {
    MetashapeJNI.Chunk_removeFrames(swigCPtr, this, keys);
  }

  /**
   * Remove sensors from the chunk.<br>
   * @param keys List of sensor keys to remove.
   */
  public void removeSensors(int[] keys) {
    MetashapeJNI.Chunk_removeSensors(swigCPtr, this, keys);
  }

  /**
   * Remove camera groups from the chunk.<br>
   * @param keys List of camera group keys to remove.
   */
  public void removeCameraGroups(int[] keys) {
    MetashapeJNI.Chunk_removeCameraGroups(swigCPtr, this, keys);
  }

  /**
   * Remove marker groups from the chunk.<br>
   * @param keys List of marker group keys to remove.
   */
  public void removeMarkerGroups(int[] keys) {
    MetashapeJNI.Chunk_removeMarkerGroups(swigCPtr, this, keys);
  }

  /**
   * Remove scalebars from the chunk.<br>
   * @param keys List of scalebar group keys to remove.
   */
  public void removeScalebarGroups(int[] keys) {
    MetashapeJNI.Chunk_removeScalebarGroups(swigCPtr, this, keys);
  }

  /**
   * Remove cameras from the chunk.<br>
   * @param keys List of camera keys to remove.
   */
  public void removeCameras(int[] keys) {
    MetashapeJNI.Chunk_removeCameras(swigCPtr, this, keys);
  }

  /**
   * Remove markers from the chunk.<br>
   * @param keys List of marker keys to remove.
   */
  public void removeMarkers(int[] keys) {
    MetashapeJNI.Chunk_removeMarkers(swigCPtr, this, keys);
  }

  /**
   * Remove scalebars from the chunk.<br>
   * @param keys List of scalebar keys to remove.
   */
  public void removeScalebars(int[] keys) {
    MetashapeJNI.Chunk_removeScalebars(swigCPtr, this, keys);
  }

  /**
   * Remove camera tracks from the chunk.<br>
   * @param keys List of camera track keys to remove.
   */
  public void removeCameraTracks(int[] keys) {
    MetashapeJNI.Chunk_removeCameraTracks(swigCPtr, this, keys);
  }

  /**
   *  Coordinate system used for reference data.
   */
  public void setCoordinateSystem(CoordinateSystem crs) {
    MetashapeJNI.Chunk_setCoordinateSystem(swigCPtr, this, CoordinateSystem.getCPtr(crs), crs);
  }

  /**
   *  Coordinate system used for reference data.
   */
  public CoordinateSystem getCoordinateSystem() {
    return new CoordinateSystem(MetashapeJNI.Chunk_getCoordinateSystem(swigCPtr, this), true);
  }

  /**
   *  Coordinate system used for camera reference data, may be null.
   */
  public void setCameraCoordinateSystem(CoordinateSystem crs) {
    MetashapeJNI.Chunk_setCameraCoordinateSystem(swigCPtr, this, crs == null ? 0 : CoordinateSystem.getCPtr(crs), crs);
  }

  /**
   *  Coordinate system used for camera reference data, may be null.
   */
  public Optional<CoordinateSystem> getCameraCoordinateSystem() {
    long ptr = MetashapeJNI.Chunk_getCameraCoordinateSystem(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CoordinateSystem(ptr, true));
  }

  /**
   *  Coordinate system used for marker reference data, may be null.
   */
  public void setMarkerCoordinateSystem(CoordinateSystem crs) {
    MetashapeJNI.Chunk_setMarkerCoordinateSystem(swigCPtr, this, crs == null ? 0 : CoordinateSystem.getCPtr(crs), crs);
  }

  /**
   *  Coordinate system used for marker reference data, may be null.
   */
  public Optional<CoordinateSystem> getMarkerCoordinateSystem() {
    long ptr = MetashapeJNI.Chunk_getMarkerCoordinateSystem(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new CoordinateSystem(ptr, true));
  }

  /**
   *  Transformation parameters specifying chunk location in the world coordinate system.
   */
  public void setTransform(Transform transform) {
    MetashapeJNI.Chunk_setTransform(swigCPtr, this, transform);
  }

  /**
   *  Transformation parameters specifying chunk location in the world coordinate system.
   */
  public Transform getTransform() { return MetashapeJNI.Chunk_getTransform(swigCPtr, this); }

  public void resetTransform() {
    MetashapeJNI.Chunk_resetTransform(swigCPtr, this);
  }

  public boolean hasTransform() {
    return MetashapeJNI.Chunk_hasTransform(swigCPtr, this);
  }

  /**
   *  Update chunk transformation based on reference data.
   */
  public void updateTransform() {
    MetashapeJNI.Chunk_updateTransform(swigCPtr, this);
  }

  /**
   *  Reconstruction volume selection.
   */
  public void setRegion(Region region) {
    MetashapeJNI.Chunk_setRegion(swigCPtr, this, region);
  }

  /**
   *  Reconstruction volume selection.
   */
  public Region getRegion() { return MetashapeJNI.Chunk_getRegion(swigCPtr, this); }

  /**
   *  Reset reconstruction volume selector to default position.
   */
  public void resetRegion() {
    MetashapeJNI.Chunk_resetRegion(swigCPtr, this);
  }

  /**
   *  CIR calibration matrix, may be null.
   */
  public void setCirCalibration(Matrix calibration) {
    MetashapeJNI.Chunk_setCirCalibration(swigCPtr, this, calibration);
  }

  /**
   *  CIR calibration matrix, may be null.
   */
  public Optional<Matrix> getCirCalibration() {
	Matrix values = MetashapeJNI.Chunk_getCirCalibration(swigCPtr, this);
	return values == null ? Optional.empty() : Optional.of(values); }

  /**
   *  Estimate CIR calibration matrix.
   */
  public void updateCirCalibration(Progress progress) {
    MetashapeJNI.Chunk_updateCirCalibration(swigCPtr, this, progress);
  }

  /**
   *  Raster transform, may be null.
   */
  public void setRasterTransform(RasterTransform transform) {
    MetashapeJNI.Chunk_setRasterTransform(swigCPtr, this, transform == null ? 0 : RasterTransform.getCPtr(transform), transform);
  }

  /**
   *  Raster transform, may be null.
   */
  public Optional<RasterTransform> getRasterTransform() {
    long ptr = MetashapeJNI.Chunk_getRasterTransform(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new RasterTransform(ptr, true));
  }

  /**
   *  Expected accuracy of camera coordinates in meters.
   */
  public void setCameraLocationAccuracy(Vector accuracy) {
    MetashapeJNI.Chunk_setCameraLocationAccuracy(swigCPtr, this, accuracy);
  }

  /**
   *  Expected accuracy of camera coordinates in meters.
   */
  public Vector getCameraLocationAccuracy() { return MetashapeJNI.Chunk_getCameraLocationAccuracy(swigCPtr, this); }

  /**
   *  Expected accuracy of camera orientation angles in degrees.
   */
  public void setCameraOrientationAccuracy(Vector accuracy) {
    MetashapeJNI.Chunk_setCameraOrientationAccuracy(swigCPtr, this, accuracy);
  }

  /**
   *  Expected accuracy of camera orientation angles in degrees.
   */
  public Vector getCameraOrientationAccuracy() { return MetashapeJNI.Chunk_getCameraOrientationAccuracy(swigCPtr, this); }

  /**
   *  Expected accuracy of marker coordinates in meters.
   */
  public void setMarkerLocationAccuracy(Vector accuracy) {
    MetashapeJNI.Chunk_setMarkerLocationAccuracy(swigCPtr, this, accuracy);
  }

  /**
   *  Expected accuracy of marker coordinates in meters.
   */
  public Vector getMarkerLocationAccuracy() { return MetashapeJNI.Chunk_getMarkerLocationAccuracy(swigCPtr, this); }

  /**
   *  Expected accuracy of marker projections in pixels.
   */
  public void setMarkerProjectionAccuracy(double accuracy) {
    MetashapeJNI.Chunk_setMarkerProjectionAccuracy(swigCPtr, this, accuracy);
  }

  /**
   *  Expected accuracy of marker projections in pixels.
   */
  public double getMarkerProjectionAccuracy() {
    return MetashapeJNI.Chunk_getMarkerProjectionAccuracy(swigCPtr, this);
  }

  /**
   *  Expected tie point accuracy in pixels.
   */
  public void setTiepointProjectionAccuracy(double accuracy) {
    MetashapeJNI.Chunk_setTiepointProjectionAccuracy(swigCPtr, this, accuracy);
  }

  /**
   *  Expected tie point accuracy in pixels.
   */
  public double getTiepointProjectionAccuracy() {
    return MetashapeJNI.Chunk_getTiepointProjectionAccuracy(swigCPtr, this);
  }

  /**
   *  Primary channel index (-1 for default).
   */
  public void setPrimaryChannel(int channel) {
    MetashapeJNI.Chunk_setPrimaryChannel(swigCPtr, this, channel);
  }

  /**
   *  Primary channel index (-1 for default).
   */
  public int getPrimaryChannel() {
    return MetashapeJNI.Chunk_getPrimaryChannel(swigCPtr, this);
  }

  /**
   *  Image brightness as percentage.
   */
  public void setImageBrightness(double brightness) {
    MetashapeJNI.Chunk_setImageBrightness(swigCPtr, this, brightness);
  }

  /**
   *  Image brightness as percentage.
   */
  public double getImageBrightness() {
    return MetashapeJNI.Chunk_getImageBrightness(swigCPtr, this);
  }

  /**
   *  Image contrast as percentage.
   */
  public void setImageContrast(double contrast) {
    MetashapeJNI.Chunk_setImageContrast(swigCPtr, this, contrast);
  }

  /**
   *  Image contrast as percentage.
   */
  public double getImageContrast() {
    return MetashapeJNI.Chunk_getImageContrast(swigCPtr, this);
  }

  public boolean hasTiePoints() {
    return MetashapeJNI.Chunk_hasTiePoints(swigCPtr, this);
  }

  public boolean hasTrajectory() {
    return MetashapeJNI.Chunk_hasTrajectory(swigCPtr, this);
  }

  public boolean hasPointCloud() {
    return MetashapeJNI.Chunk_hasPointCloud(swigCPtr, this);
  }

  public boolean hasMasks() {
    return MetashapeJNI.Chunk_hasMasks(swigCPtr, this);
  }

  public boolean hasDepthMaps() {
    return MetashapeJNI.Chunk_hasDepthMaps(swigCPtr, this);
  }

  public boolean hasModel() {
    return MetashapeJNI.Chunk_hasModel(swigCPtr, this);
  }

  public boolean hasTiledModel() {
    return MetashapeJNI.Chunk_hasTiledModel(swigCPtr, this);
  }

  public boolean hasElevation() {
    return MetashapeJNI.Chunk_hasElevation(swigCPtr, this);
  }

  public boolean hasOrthomosaic() {
    return MetashapeJNI.Chunk_hasOrthomosaic(swigCPtr, this);
  }

  public boolean hasShapes() {
    return MetashapeJNI.Chunk_hasShapes(swigCPtr, this);
  }

  /**
   *  Generated tie point cloud, may be null.
   */
  public void setTiePoints(TiePoints tie_points) {
    MetashapeJNI.Chunk_setTiePoints(swigCPtr, this, tie_points == null ? 0 : TiePoints.getCPtr(tie_points), tie_points);
  }

  /**
   *  Generated tie point cloud, may be null.
   */
  public Optional<TiePoints> getTiePoints() {
    long ptr = MetashapeJNI.Chunk_getTiePoints(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new TiePoints(ptr, true));
  }

  /**
   *  Default trajectory for the current frame, may be null.
   */
  public Optional<Trajectory> getTrajectory() {
    long ptr = MetashapeJNI.Chunk_getTrajectory(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Trajectory(ptr, true));
  }

  /**
   *  Default point cloud for the current frame, may be null.
   */
  public Optional<PointCloud> getPointCloud() {
    long ptr = MetashapeJNI.Chunk_getPointCloud(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new PointCloud(ptr, true));
  }

  /**
   *  Default mask set for the current frame, may be null.
   */
  public Optional<Masks> getMasks() {
    long ptr = MetashapeJNI.Chunk_getMasks(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Masks(ptr, true));
  }

  /**
   *  Default depth maps set for the current frame, may be null.
   */
  public Optional<DepthMaps> getDepthMaps() {
    long ptr = MetashapeJNI.Chunk_getDepthMaps(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new DepthMaps(ptr, true));
  }

  /**
   *  Default model for the current frame, may be null.
   */
  public Optional<Model> getModel() {
    long ptr = MetashapeJNI.Chunk_getModel(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Model(ptr, true));
  }

  /**
   *  Default model group for the current frame, may be null.
   */
  public Optional<ModelGroup> getModelGroup() {
    long ptr = MetashapeJNI.Chunk_getModelGroup(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new ModelGroup(ptr, true));
  }

  /**
   *  Default tiled model for the current frame, may be null.
   */
  public Optional<TiledModel> getTiledModel() {
    long ptr = MetashapeJNI.Chunk_getTiledModel(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new TiledModel(ptr, true));
  }

  /**
   *  Default elevation model for the current frame, may be null.
   */
  public Optional<Elevation> getElevation() {
    long ptr = MetashapeJNI.Chunk_getElevation(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Elevation(ptr, true));
  }

  /**
   *  Default orthomosaic for the current frame, may be null.
   */
  public Optional<Orthomosaic> getOrthomosaic() {
    long ptr = MetashapeJNI.Chunk_getOrthomosaic(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Orthomosaic(ptr, true));
  }

  /**
   *  Shapes for the current frame, may be null.
   */
  public void setShapes(Shapes shapes) {
    MetashapeJNI.Chunk_setShapes(swigCPtr, this, shapes == null ? 0 : Shapes.getCPtr(shapes), shapes);
  }

  /**
   *  Shapes for the current frame, may be null.
   */
  public Optional<Shapes> getShapes() {
    long ptr = MetashapeJNI.Chunk_getShapes(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Shapes(ptr, true));
  }

  public void removeTiePoints() {
    MetashapeJNI.Chunk_removeTiePoints(swigCPtr, this);
  }

  public void removeTrajectory() {
    MetashapeJNI.Chunk_removeTrajectory(swigCPtr, this);
  }

  public void removePointCloud() {
    MetashapeJNI.Chunk_removePointCloud(swigCPtr, this);
  }

  public void removeMasks() {
    MetashapeJNI.Chunk_removeMasks(swigCPtr, this);
  }

  public void removeDepthMaps() {
    MetashapeJNI.Chunk_removeDepthMaps(swigCPtr, this);
  }

  public void removeModel() {
    MetashapeJNI.Chunk_removeModel(swigCPtr, this);
  }

  public void removeTiledModel() {
    MetashapeJNI.Chunk_removeTiledModel(swigCPtr, this);
  }

  public void removeElevation() {
    MetashapeJNI.Chunk_removeElevation(swigCPtr, this);
  }

  public void removeOrthomosaic() {
    MetashapeJNI.Chunk_removeOrthomosaic(swigCPtr, this);
  }

  public void removeShapes() {
    MetashapeJNI.Chunk_removeShapes(swigCPtr, this);
  }

  /**
   *  List of mask sets for the current frame.
   */
  public Masks[] getMaskSets() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getMaskSets(swigCPtr, this), true, Masks.class); }

  /**
   *  List of depth maps sets for the current frame.
   */
  public DepthMaps[] getDepthMapsSets() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getDepthMapsSets(swigCPtr, this), true, DepthMaps.class); }

  /**
   *  List of trajectories for the current frame.
   */
  public Trajectory[] getTrajectories() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getTrajectories(swigCPtr, this), true, Trajectory.class); }

  /**
   *  List of point clouds for the current frame.
   */
  public PointCloud[] getPointClouds() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getPointClouds(swigCPtr, this), true, PointCloud.class); }

  /**
   *  List of point cloud groups for the current frame.
   */
  public PointCloudGroup[] getPointCloudGroups() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getPointCloudGroups(swigCPtr, this), true, PointCloudGroup.class); }

  /**
   *  List of models for the current frame.
   */
  public Model[] getModels() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getModels(swigCPtr, this), true, Model.class); }

  /**
   *  List of model groups for the current frame.
   */
  public ModelGroup[] getModelGroups() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getModelGroups(swigCPtr, this), true, ModelGroup.class); }

  /**
   *  List of tiled models for the current frame.
   */
  public TiledModel[] getTiledModels() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getTiledModels(swigCPtr, this), true, TiledModel.class); }

  /**
   *  List of elevation models for the current frame.
   */
  public Elevation[] getElevations() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getElevations(swigCPtr, this), true, Elevation.class); }

  /**
   *  List of orthomosaics for the current frame.
   */
  public Orthomosaic[] getOrthomosaics() { return SwigHelpers.cArrayWrap(MetashapeJNI.Chunk_getOrthomosaics(swigCPtr, this), true, Orthomosaic.class); }

  public void setMasksKey(int key) {
    MetashapeJNI.Chunk_setMasksKey(swigCPtr, this, key);
  }

  public void setDepthMapsKey(int key) {
    MetashapeJNI.Chunk_setDepthMapsKey(swigCPtr, this, key);
  }

  public void setTrajectoryKey(int key) {
    MetashapeJNI.Chunk_setTrajectoryKey(swigCPtr, this, key);
  }

  public void setPointCloudKey(int key) {
    MetashapeJNI.Chunk_setPointCloudKey(swigCPtr, this, key);
  }

  public void setModelKey(int key) {
    MetashapeJNI.Chunk_setModelKey(swigCPtr, this, key);
  }

  public void setModelGroupKey(int key) {
    MetashapeJNI.Chunk_setModelGroupKey(swigCPtr, this, key);
  }

  public void setTiledModelKey(int key) {
    MetashapeJNI.Chunk_setTiledModelKey(swigCPtr, this, key);
  }

  public void setElevationKey(int key) {
    MetashapeJNI.Chunk_setElevationKey(swigCPtr, this, key);
  }

  public void setOrthomosaicKey(int key) {
    MetashapeJNI.Chunk_setOrthomosaicKey(swigCPtr, this, key);
  }

  /**
   *  Chunk meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.Chunk_setMeta(swigCPtr, this, meta);
  }

  /**
   *  Chunk meta data.
   */
  public Map<String,String> getMeta() { return MetashapeJNI.Chunk_getMeta(swigCPtr, this); }

  /**
   * Import camera locations from EXIF meta data.<br>
   * @param load_rotation Load yaw, pitch and roll orientation angles.<br>
   * @param load_accuracy Load camera location accuracy.
   */
  public boolean loadReferenceExif(boolean load_rotation, boolean load_accuracy) {
    return MetashapeJNI.Chunk_loadReferenceExif(swigCPtr, this, load_rotation, load_accuracy);
  }

  public void addPhotos(String[] paths, Progress progress) {
    MetashapeJNI.Chunk_addPhotos(swigCPtr, this, paths, progress);
  }

  /**
   * Remove excessive tracks from the tie point cloud.<br>
   * @param point_limit Maximum number of points for each photo.
   */
  public void thinTiePoints(int point_limit) {
    MetashapeJNI.Chunk_thinTiePoints(swigCPtr, this, point_limit);
  }

  /**
   * Generate chunk preview image.<br>
   * @param width Preview image width.<br>
   * @param height Preview image height.<br>
   * @param transform 4x4 viewpoint transformation matrix.<br>
   * @param point_size Point size.<br>
   * @return Preview image.
   */
  public Image renderPreview(long width, long height, Matrix transform, int point_size, Progress progress) {
    return new Image(MetashapeJNI.Chunk_renderPreview(swigCPtr, this, width, height, transform, point_size, progress), true);
  }

}
