/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

public class Document implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected Document(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(Document obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(Document obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_Document(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public Document() {
    this(MetashapeJNI.new_Document__SWIG_0(), true);
  }

  public Document(Document document) {
    this(MetashapeJNI.new_Document__SWIG_1(Document.getCPtr(document), document), true);
  }

  /**
   * Return document contents in XML format.
   */
  public String dump() {
    return MetashapeJNI.Document_dump(swigCPtr, this);
  }

  /**
   * Initialize document contents from XML format.
   */
  public void load(String text) {
    MetashapeJNI.Document_load(swigCPtr, this, text);
  }

  /**
   * Remove all chunks from the project.
   */
  public void clear() {
    MetashapeJNI.Document_clear(swigCPtr, this);
  }

  /**
   * Save project.<br>
   * @param path Path to the file.<br>
   * @param progress Progress callback.
   */
  public void save(String path, Progress progress) {
    MetashapeJNI.Document_save__SWIG_0(swigCPtr, this, path, progress);
  }

  /**
   * Save some chunks from the project.<br>
   * @param path Path to the file.<br>
   * @param chunk_keys List of chunks to be saved.<br>
   * @param progress Progress callback.
   */
  public void save(String path, int[] chunk_keys, Progress progress) {
    MetashapeJNI.Document_save__SWIG_1(swigCPtr, this, path, chunk_keys, progress);
  }

  /**
   * Open project.<br>
   * @param path Path to the file.<br>
   * @param read_only Open document in read-only mode.<br>
   * @param progress Progress callback.
   */
  public void open(String path, boolean read_only, Progress progress) {
    MetashapeJNI.Document_open(swigCPtr, this, path, read_only, progress);
  }

  /**
   * @return Path to the document file.
   */
  public String getPath() {
    return MetashapeJNI.Document_getPath(swigCPtr, this);
  }

  /**
   * Read only status.
   */
  public void setReadOnly(boolean read_only) {
    MetashapeJNI.Document_setReadOnly(swigCPtr, this, read_only);
  }

  /**
   * Read only status.
   */
  public boolean isReadOnly() {
    return MetashapeJNI.Document_isReadOnly(swigCPtr, this);
  }

  /**
   * Add a new empty chunk to the document.<br>
   * @return New chunk.
   */
  public Chunk addChunk() {
    return new Chunk(MetashapeJNI.Document_addChunk(swigCPtr, this), true);
  }

  /**
   * @return List of chunks in the document.
   */
  public Chunk[] getChunks() { return SwigHelpers.cArrayWrap(MetashapeJNI.Document_getChunks(swigCPtr, this), true, Chunk.class); }

  /**
   * List of chunk keys in the document.
   */
  public int[] getChunkKeys() { return MetashapeJNI.Document_getChunkKeys(swigCPtr, this); }

  /**
   * Chunk with specified key, may be null.
   */
  public Optional<Chunk> getChunk(int key) {
    long ptr = MetashapeJNI.Document_getChunk(swigCPtr, this, key);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   * Active chunk, may be null.
   */
  public Optional<Chunk> getActiveChunk() {
    long ptr = MetashapeJNI.Document_getActiveChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   * Active chunk.
   */
  public void setActiveChunk(Chunk chunk) {
    MetashapeJNI.Document_setActiveChunk(swigCPtr, this, Chunk.getCPtr(chunk), chunk);
  }

  /**
   * Remove chunk from the project.<br>
   * @param chunk Chunk to remove.
   */
  public void remove(Chunk chunk) {
    MetashapeJNI.Document_remove(swigCPtr, this, Chunk.getCPtr(chunk), chunk);
  }

  /**
   * Append chunks from another document.<br>
   * @param document Document to append.
   */
  public void append(Document document, Progress progress) {
    MetashapeJNI.Document_append(swigCPtr, this, Document.getCPtr(document), document, progress);
  }

  /**
   * Set project meta data.
   */
  public void setMeta(Map<String,String> meta) {
    MetashapeJNI.Document_setMeta(swigCPtr, this, meta);
  }

  /**
   * Get project meta data
   */
  public Map<String,String> getMeta() { return MetashapeJNI.Document_getMeta(swigCPtr, this); }

  /**
   * Add geoid to the document.
   */
  public void addGeoid(String path) {
    MetashapeJNI.Document_addGeoid(swigCPtr, this, path);
  }

  /**
   * Remove geoid from the project.<br>
   * @param geoid Geoid to remove.
   */
  public void removeGeoid(Geoid geoid) {
    MetashapeJNI.Document_removeGeoid(swigCPtr, this, Geoid.getCPtr(geoid), geoid);
  }

  /**
   * Get list of geoids in the document.
   */
  public Geoid[] getGeoids() { return SwigHelpers.cArrayWrap(MetashapeJNI.Document_getGeoids(swigCPtr, this), true, Geoid.class); }

}
