/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.1.1
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package com.agisoft.metashape;

import java.lang.AutoCloseable;
import java.util.Optional;
import java.util.Map;

/**
 * MarkerGroup objects define groups of multiple markers. The grouping is established by<br>
 * assignment of a MarkerGroup instance to the Marker.group attribute of participating markers.
 */
public class MarkerGroup implements AutoCloseable {
  private transient long swigCPtr;
  protected transient boolean swigCMemOwn;

  protected MarkerGroup(long cPtr, boolean cMemoryOwn) {
    swigCMemOwn = cMemoryOwn;
    swigCPtr = cPtr;
  }

  protected static long getCPtr(MarkerGroup obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(MarkerGroup obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings("deprecation")
  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        MetashapeJNI.delete_MarkerGroup(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  @Override
  public void close() {
    delete();
  }

  public MarkerGroup(MarkerGroup marker_group) {
    this(MetashapeJNI.new_MarkerGroup(MarkerGroup.getCPtr(marker_group), marker_group), true);
  }

  /**
   *  Marker group key.
   */
  public int getKey() {
    return MetashapeJNI.MarkerGroup_getKey(swigCPtr, this);
  }

  /**
   *  Chunk container, may be null.
   */
  public Optional<Chunk> getChunk() {
    long ptr = MetashapeJNI.MarkerGroup_getChunk(swigCPtr, this);
    if (ptr == 0)
        return Optional.empty();
    return Optional.of(new Chunk(ptr, true));
  }

  /**
   *  Marker group label.
   */
  public void setLabel(String label) {
    MetashapeJNI.MarkerGroup_setLabel(swigCPtr, this, label);
  }

  /**
   *  Marker group label.
   */
  public String getLabel() {
    return MetashapeJNI.MarkerGroup_getLabel(swigCPtr, this);
  }

  /**
   *  Current selection state.
   */
  public void setSelected(boolean state) {
    MetashapeJNI.MarkerGroup_setSelected(swigCPtr, this, state);
  }

  /**
   *  Current selection state.
   */
  public boolean isSelected() {
    return MetashapeJNI.MarkerGroup_isSelected(swigCPtr, this);
  }

}
