package com.agisoft.metashape.tasks;

import com.agisoft.metashape.*;

/**
 * Task class containing processing parameters.
 */
public class CleanModel extends Task {

	public CleanModel() {
		super("CleanModel");
	}

	/**
	 *  Model filtering criterion. Default: Model.Criterion.ComponentSize
	 */
	public void setCriterion(Model.Criterion value) {
		setParameter("criterion", (Object) value);
	}

	/**
	 *  Model filtering criterion. Default: Model.Criterion.ComponentSize
	 */
	public Model.Criterion getCriterion() {
		return (Model.Criterion) getParameter("criterion");
	}

	/**
	 *  Filtering threshold in percents. Default: 0
	 */
	public void setLevel(int value) {
		setParameter("level", (Object) value);
	}

	/**
	 *  Filtering threshold in percents. Default: 0
	 */
	public int getLevel() {
		return (int) getParameter("level");
	}

	/**
	 *  Model to filter.
	 */
	public void setModel(int value) {
		setParameter("model", (Object) value);
	}

	/**
	 *  Model to filter.
	 */
	public int getModel() {
		return (int) getParameter("model");
	}

}
